/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.assertion.wssapi;

import com.ibm.ws.wssecurity.common.Messages;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.saml11.assertion.utils.SAMLBuilder;
import com.ibm.ws.wssecurity.saml.security.impl.SamlSignatureUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenFactoryImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import org.apache.axiom.om.OMElement;

public class SAMLAssertionBuilder {
    private static final TraceLog log = new TraceLog(SAMLAssertionBuilder.class);
    private static final TraceComponent tc = Tr.register(SAML20TokenFactoryImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAML20TokenFactoryImpl.class.getName();

    public static SAMLAssertion createUnsignedSAMLAssertion(ProviderConfig issuer, RequesterConfig requester, CredentialConfig cred) throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUnsignedSAMLAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SAMLCommonConstants.CREATE_SAMLTOKEN_PERM.toString());
            }
            sm.checkPermission(SAMLCommonConstants.CREATE_SAMLTOKEN_PERM);
        }
        SAMLAssertion saml = null;
        String tokenTyep = requester.getRSTTProperties().get("wstrustClientTokenType");
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equalsIgnoreCase(tokenTyep)) {
            saml = SAMLBuilder.createUnsignedAssertion(issuer, requester, cred);
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equalsIgnoreCase(tokenTyep)) {
            saml = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLBuilder.createUnsignedAssertion(issuer, requester, cred);
        } else {
            throw new SoapSecurityException(tokenTyep + Messages.getString("CWSML2037E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUnsignedSAMLAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        return saml;
    }

    public static SAMLAssertion createSignedSAMLAssertion(ProviderConfig issuer, RequesterConfig requester, CredentialConfig cred) throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSignedSAMLAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SAMLCommonConstants.CREATE_SAMLTOKEN_PERM.toString());
            }
            sm.checkPermission(SAMLCommonConstants.CREATE_SAMLTOKEN_PERM);
        }
        SAMLAssertion saml = null;
        String tokenType = requester.getRSTTProperties().get("wstrustClientTokenType");
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equalsIgnoreCase(tokenType)) {
            saml = SAMLBuilder.createSignedAssertion(issuer, requester, cred);
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equalsIgnoreCase(tokenType)) {
            saml = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLBuilder.createSignedAssertion(issuer, requester, cred);
        } else {
            throw new SoapSecurityException(tokenType + Messages.getString("CWSML2037E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSignedSAMLAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        return saml;
    }

    public static OMElement signedSAMLAssertion(ProviderConfig issuer, RequesterConfig requester, SAMLAssertion unSignedAssertion) throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signedSAMLAssertion(ProviderConfig, RequesterConfig, SAMLAssertion)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SAMLCommonConstants.CREATE_SAMLTOKEN_PERM.toString());
            }
            sm.checkPermission(SAMLCommonConstants.CREATE_SAMLTOKEN_PERM);
        }
        OMElement om = SamlSignatureUtils.getSignedSAML(issuer, requester, unSignedAssertion);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signedSAMLAssertion(ProviderConfig, RequesterConfig, SAMLAssertion)");
        }
        return om;
    }

    public static OMElement signedSAMLAssertion(ProviderConfig issuer, RequesterConfig requester, OMElement unsignedOm, String samlID) throws SoapSecurityException {
        log.entry("signedSAMLAssertion( ProviderConfig, RequesterConfig, OMElement, String)");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SAMLCommonConstants.CREATE_SAMLTOKEN_PERM.toString());
            }
            sm.checkPermission(SAMLCommonConstants.CREATE_SAMLTOKEN_PERM);
        }
        OMElement om = SamlSignatureUtils.getSignedSAML(issuer, requester, unsignedOm, samlID);
        log.exit("signedSAMLAssertion(ProviderConfig, RequesterConfig, OMElement, String)");
        return om;
    }
}

