/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.websphere.token.KRB5TokenImpl;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.WasUsernameTokenImpl;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.WasX509TokenImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAv2TokenImpl;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.token.TokenHolder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class wssTokenPropagationInboundLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(wssTokenPropagationInboundLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String UNT = "security.wssecurity_http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
    private static final String X509T = "security.wssecurity_http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String LTPAT = "security.wssecurity_http://www.ibm.com/websphere/appserver/tokentype/5.0.2#LTPA";
    private static final String LTPAv2T = "security.wssecurity_http://www.ibm.com/websphere/appserver/tokentype#LTPAv2";
    private static final String KRBV5 = "security.wssecurity_http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ";
    private Vector allTokens = null;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map _sharedState;
    private Map options;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this._sharedState = sharedState;
        this.options = options;
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login");
        }
        Callback[] callbacks = new Callback[]{new WSTokenHolderCallback("Authentication Token List: ")};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to handle callbackhandler.", e.getStackTrace());
            }
            return false;
        }
        this.allTokens = new Vector();
        List authTokenList = ((WSTokenHolderCallback)callbacks[0]).getTokenHolderList();
        if (authTokenList != null) {
            for (int i = 0; i < authTokenList.size(); ++i) {
                LTPATokenImpl ltpaT;
                TokenHolder tokenHolder = (TokenHolder)authTokenList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restore authentication token: " + tokenHolder.getName());
                }
                if (tokenHolder.getName().equals(UNT) && tokenHolder.getVersion() == 1) {
                    WasUsernameTokenImpl wUNT = new WasUsernameTokenImpl();
                    wUNT.initialize(tokenHolder.getBytes());
                    this.allTokens.addElement(wUNT);
                    continue;
                }
                if (tokenHolder.getName().equals(X509T) && tokenHolder.getVersion() == 1) {
                    WasX509TokenImpl wX509T = new WasX509TokenImpl();
                    wX509T.initialize(tokenHolder.getBytes());
                    this.allTokens.addElement(wX509T);
                    continue;
                }
                if (tokenHolder.getName().equals(LTPAT) && tokenHolder.getVersion() == 1) {
                    ltpaT = new LTPATokenImpl();
                    ltpaT.initialize(tokenHolder.getBytes());
                    this.allTokens.addElement(ltpaT);
                    continue;
                }
                if (tokenHolder.getName().equals(LTPAv2T) && tokenHolder.getVersion() == 1) {
                    ltpaT = new LTPAv2TokenImpl();
                    ltpaT.initialize(tokenHolder.getBytes());
                    this.allTokens.addElement(ltpaT);
                    continue;
                }
                if (!tokenHolder.getName().equals(KRBV5) || tokenHolder.getVersion() != 1) continue;
                KRB5TokenImpl krbT = new KRB5TokenImpl(tokenHolder.getBytes());
                this.allTokens.addElement(krbT);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        while (this.allTokens != null && !this.allTokens.isEmpty()) {
            Object obj = this.allTokens.lastElement();
            this.allTokens.remove(obj);
            if (obj == null || !(obj instanceof SecurityToken)) continue;
            final SecurityToken token = (SecurityToken)obj;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws LoginException {
                        try {
                            if (!wssTokenPropagationInboundLoginModule.this.subject.getPrivateCredentials().contains(token)) {
                                wssTokenPropagationInboundLoginModule.this.subject.getPrivateCredentials().add(token);
                            }
                        }
                        catch (Exception e) {
                            throw new LoginException(e.getMessage());
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new LoginException(e.getMessage());
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        this.allTokens = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

