/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl;
import com.ibm.wsspi.security.token.AuthenticationToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class WasX509TokenImpl
extends X509TokenImpl
implements AuthenticationToken {
    private static final TraceComponent tc = Tr.register(WasX509TokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = -8134549655249745958L;
    private boolean isForwardable = true;
    private byte[] serializationBytes = null;
    public static final String authenticationTokenName = "security.wssecurity_http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";

    public void initialize(byte[] encodedToken) {
        block2: {
            this.serializationBytes = encodedToken;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(encodedToken);
            try {
                ObjectInputStream inObjStream = new ObjectInputStream(byteStream);
                this.readExternal(inObjStream);
                inObjStream.close();
                byteStream.close();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to deserialize Token. ", e.getStackTrace());
            }
        }
    }

    public boolean isForwardable() {
        return this.isForwardable;
    }

    public void setIsForwardable(boolean forward) {
        if (!this.readOnly) {
            this.isForwardable = forward;
        }
    }

    public String getUniqueID() {
        String uid = null;
        uid = this.getCertificate().getSerialNumber().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUniqueID() = " + uid);
        }
        return uid;
    }

    public byte[] getBytes() {
        block2: {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream outObjStream = new ObjectOutputStream(byteStream);
                this.writeExternal(outObjStream);
                outObjStream.close();
                byteStream.close();
                this.serializationBytes = byteStream.toByteArray();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to serialize Token. ", e.getStackTrace());
            }
        }
        return this.serializationBytes;
    }

    public void setBytes(byte[] sBytes) {
        if (!this.readOnly) {
            this.serializationBytes = sBytes;
        }
    }

    public String getName() {
        return authenticationTokenName;
    }

    public short getVersion() {
        return 1;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String[] getAttributes(String key) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String[] addAttribute(String key, String value) {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public long getExpiration() {
        return -1L;
    }

    public Object clone() {
        return null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isForwardable = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isForwardable);
    }
}

