/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.platform.util.SAMLIssuerConfigData;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class WasSAMLIssuerConfigDataImpl
implements SAMLIssuerConfigData {
    private static final String clsName = WasSAMLIssuerConfigDataImpl.class.getName();
    private static final TraceComponent tc = Tr.register(WasSAMLIssuerConfigDataImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    static final String fileName = "SAMLIssuerConfig.properties";
    private static Properties props = null;

    public String getProperty(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty(String key = \"" + key + "\")");
        }
        String val = null;
        String valDebugString = null;
        if (props != null && key != null && (val = props.getProperty(key)) != null) {
            if (key.endsWith("Password")) {
                val = PasswordUtilFactory.getInstance().passwordDecode(val);
                valDebugString = "###########";
            } else {
                VariableExpander varMap = VariableExpanderFactory.getVariableExpander();
                valDebugString = val = varMap.expand(val);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty(String key = \"" + key + "\") returns " + valDebugString);
        }
        return val;
    }

    static {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String userInstallRoot = System.getProperty("user.install.root");
        String wasCellName = adminService.getCellName();
        String wasNodeName = adminService.getNodeName();
        String wasProcessName = adminService.getProcessName();
        props = new Properties();
        FileInputStream in = null;
        String absoluteServerPath = userInstallRoot + File.separator + "config" + File.separator + "cells" + File.separator + wasCellName + File.separator + "nodes" + File.separator + wasNodeName + File.separator + "servers" + File.separator + wasProcessName + File.separator + fileName;
        try {
            in = new FileInputStream(absoluteServerPath);
            props.load(in);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using file \"" + absoluteServerPath + "\" for SAMLIssuerConfigData.");
            }
        }
        catch (IOException e) {
            String absoluteCellPath = userInstallRoot + File.separator + "config" + File.separator + "cells" + File.separator + wasCellName + File.separator + "sts" + File.separator + fileName;
            try {
                in = new FileInputStream(absoluteCellPath);
                props.load(in);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using file \"" + absoluteCellPath + "\" for SAMLIssuerConfigData.");
                }
            }
            catch (Exception ex) {
                Tr.processException(ex, clsName + ".static", "114");
                Tr.error(tc, "security.wssecurity.CWWSS7535E", new Object[]{ex, absoluteCellPath});
            }
        }
        catch (Exception e2) {
            Tr.processException(e2, clsName + ".static", "118");
            Tr.error(tc, "security.wssecurity.CWWSS7535E", new Object[]{e2, absoluteServerPath});
        }
    }
}

