/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.wssecurity.platform.util.KeyStoreUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.KeyStore;
import java.security.Provider;
import java.util.HashMap;

public class WasKeyStoreUtilImpl
implements KeyStoreUtil {
    private static final TraceComponent tc = Tr.register(WasKeyStoreUtilImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasKeyStoreUtilImpl.class.getName();
    static final String MANAGEMENT_SCOPE_P = " managementScope=";
    static final String KEYSTORE_P = "name=";
    private HashMap wskMap = new HashMap();
    private HashMap keystoreMap = new HashMap();

    public KeyStore getKeyStore(String keyStoreRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore(String keyStoreRef[" + keyStoreRef + "])");
        }
        KeyStore keystore = null;
        if (ConfigUtil.hasValue(keyStoreRef)) {
            keystore = (KeyStore)this.keystoreMap.get(keyStoreRef);
            if (tc.isDebugEnabled()) {
                if (keystore == null) {
                    Tr.exit(tc, keyStoreRef + " does not exist in the keystoreMap.");
                } else {
                    Tr.exit(tc, keyStoreRef + " exists in the keystoreMap.");
                }
            }
            if (keystore == null) {
                StringHolder keyStoreNameString = new StringHolder();
                StringHolder mgmtScopeString = new StringHolder();
                this.parseKeyStore(keyStoreRef, keyStoreNameString, mgmtScopeString);
                try {
                    if (KeyStoreManager.getInstance() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.entry(tc, "KeyStoreManager is null. Cannot retrieve keystore with keyStoreRef[" + keyStoreRef + "]");
                        }
                    } else {
                        keystore = KeyStoreManager.getInstance().getJavaKeyStore(keyStoreNameString.value, mgmtScopeString.value);
                    }
                }
                catch (Exception e) {
                    Tr.processException(e, clsName + ".createKeyStore", "281");
                    Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreRef, e});
                }
                if (keystore != null) {
                    this.keystoreMap.put(keyStoreRef, keystore);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String) returns [" + (keystore == null ? "null" : "non-null") + "]");
        }
        return keystore;
    }

    public boolean isValidWSKeyStore(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidWSKeyStore(String keyStoreName[" + keyStoreName + "])");
        }
        boolean ret = false;
        if (this.getKeyStore(keyStoreName) != null) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidWSKeyStore(String) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public WSKeyStore getWSKeystore(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSKeystore(" + keyStoreName + ")");
        }
        WSKeyStore retVal = null;
        if (ConfigUtil.hasValue(keyStoreName)) {
            retVal = (WSKeyStore)this.wskMap.get(keyStoreName);
            if (tc.isDebugEnabled()) {
                if (retVal == null) {
                    Tr.exit(tc, keyStoreName + " does not exist in the wskMap.");
                } else {
                    Tr.exit(tc, keyStoreName + " exists in the wskMap.");
                }
            }
            if (retVal == null) {
                if (KeyStoreManager.getInstance() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.entry(tc, "KeyStoreManager is null. Cannot retrieve keystore with keyStoreRef[" + keyStoreName + "]");
                    }
                } else {
                    StringHolder keyStoreNameString = new StringHolder();
                    StringHolder mgmtScopeString = new StringHolder();
                    this.parseKeyStore(keyStoreName, keyStoreNameString, mgmtScopeString);
                    try {
                        retVal = KeyStoreManager.getInstance().getWSKeyStore(keyStoreNameString.value, mgmtScopeString.value);
                    }
                    catch (Exception e) {
                        Tr.processException(e, clsName + ".getWSKeyStore", "157");
                        Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreName, e});
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSKeystore returns [" + (retVal == null ? "null" : "non-null") + "]");
        }
        return retVal;
    }

    public boolean isHWKeyStore(String keyStoreName) {
        Object tmp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHWKeyStore(String keyStoreName[" + keyStoreName + "])");
        }
        WSKeyStore wsk = this.getWSKeystore(keyStoreName);
        boolean ret = KeyStoreManager.getInstance().isHWKeyStore(wsk);
        if (ret && (tmp = this.wskMap.get(keyStoreName)) == null) {
            this.wskMap.put(keyStoreName, wsk);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHWKeyStore(String) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public Provider getHWCryptoProviderInstance(String keyStoreName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHWCryptoProviderInstance(String keyStoreName[" + keyStoreName + "])");
        }
        WSKeyStore wsk = this.getWSKeystore(keyStoreName);
        Provider ret = KeyStoreManager.getInstance().getHWCryptoProviderInstance(wsk);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHWCryptoProviderInstance(Provider) returns [" + (ret == null ? "null" : "non-null") + "]");
        }
        return ret;
    }

    public void returnHWCryptoProviderInstance(String keyStoreName, Provider hwProviderInstance) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnHWCryptoProviderInstance(String keyStoreName[" + keyStoreName + "], Provider)");
        }
        WSKeyStore wsk = this.getWSKeystore(keyStoreName);
        KeyStoreManager.getInstance().returnHWCryptoProviderInstance(wsk, hwProviderInstance);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnHWCryptoProviderInstance(String,Provider)");
        }
    }

    public void parseKeyStore(String keyStoreName, StringHolder keyStoreNameString, StringHolder mgmtScopeString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseKeyStore keystoreName=" + keyStoreName);
        }
        if (ConfigUtil.hasValue(keyStoreName)) {
            int msI = keyStoreName.indexOf(MANAGEMENT_SCOPE_P);
            int ksnI = keyStoreName.indexOf(KEYSTORE_P);
            if (msI < 0 && ksnI < 0) {
                keyStoreNameString.value = keyStoreName.substring(0);
            } else {
                if (msI < 0) {
                    keyStoreNameString.value = keyStoreName.substring(ksnI + KEYSTORE_P.length());
                } else {
                    keyStoreNameString.value = keyStoreName.substring(ksnI + KEYSTORE_P.length(), msI);
                    mgmtScopeString.value = keyStoreName.substring(msI + MANAGEMENT_SCOPE_P.length());
                    mgmtScopeString.value = mgmtScopeString.value.trim();
                }
                keyStoreNameString.value = keyStoreNameString.value.trim();
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "keyStoreNameString = " + keyStoreNameString.value);
                Tr.debug(tc, "mgmtScopeString = " + mgmtScopeString.value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseKeyStore");
        }
    }

    public class StringHolder {
        public String value = null;
    }
}

