/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wssecurity.core.CertManagerFactory;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultGeneratorConfig;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.platform.util.ConfigHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class WasConfigHelperThinclientImpl
implements ConfigHelper {
    private static final TraceComponent tc = Tr.register(WasConfigHelperThinclientImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasConfigHelperThinclientImpl.class.getName();

    public boolean loadConfig(VariableExpander varMap, WSSecurityDefaultConfiguration defaultConfig, Object securityDefaultBindings, DefaultBinding defaultBinding) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig(boolean ndEnvironment, VariableExpander vm, WSSecurityDefaultConfiguration securityDefaultConfig, SecurityBindings securityDefaultBindings, DefaultBinding defaultBinding): ", new Object[]{varMap, defaultConfig, securityDefaultBindings, defaultBinding});
        }
        boolean ret = false;
        SoapSecurityException loadException = null;
        long hardwareCacheEntryRefresh = 8L;
        ret = true;
        defaultConfig.setUseConfigCache(true);
        defaultConfig.setNonceCacheTimeout(600);
        defaultConfig.setCertCacheTimeOut(900);
        defaultConfig.setConfigCacheTimeToLive(900);
        defaultConfig.setTokenCacheTimeOut(900);
        defaultConfig.setTokenCacheCushion(600000L);
        defaultConfig.setOffloadRSAPublicKeyCrypto(true);
        defaultConfig.setHardwareCacheSize(1000);
        defaultConfig.setUseConfigCache(true);
        defaultConfig.setUseTokenCache(true);
        defaultConfig.setConfigCacheName("WSSReqGeneratorConfigMap");
        defaultConfig.setTokenCacheName("WSSTokenCache");
        defaultConfig.setConfigCacheSize(128);
        HWKeyCache fHWKeyCache = HWKeyCache.getInstance();
        if (fHWKeyCache != null) {
            fHWKeyCache.setScanParameters(hardwareCacheEntryRefresh);
        }
        if (!NonceManagerFactory.isInitialized()) {
            NonceManagerFactory.init(defaultConfig.getUseNonceCache(), defaultConfig.getNonceCacheName(), defaultConfig.getNonceCacheSize(), defaultConfig.getNonceCacheTimeout(), defaultConfig.getNonceLength(), defaultConfig.getNonceCacheDistributed());
        }
        if (!CertManagerFactory.isInitialized()) {
            CertManagerFactory.init(defaultConfig.getUseCertCache(), defaultConfig.getCertCacheName(), defaultConfig.getCertCacheSize(), defaultConfig.getCertCacheTimeOut());
        }
        if (securityDefaultBindings != null) {
            try {
                WSSBindings wssDefaultBindings = new WSSBindings(securityDefaultBindings);
                defaultConfig.setDefaultConsumerBinding(new WSSecurityDefaultConsumerConfig(wssDefaultBindings));
                defaultConfig.setDefaultGeneratorBinding(new WSSecurityDefaultGeneratorConfig(wssDefaultBindings));
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WasConfigHelperImpl.s01", e.toString());
                Tr.processException((Throwable)e, clsName + ".loadConfig", "%C", this);
                loadException = SoapSecurityException.format("security.wssecurity.WasConfigHelperImpl.s01", e.toString());
            }
            if (loadException != null) {
                defaultConfig.setDefaultBindingsLoadingException(loadException);
            }
            defaultBinding.setDefaultBinding(Constants.WS_SECURITY_DEFAULT_BINDING_KEY, defaultConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig returns boolean[" + ret + "]", new Object[]{defaultConfig});
        }
        return ret;
    }

    public boolean isWebInboundPropagationEnabled() {
        return false;
    }

    public String getApplicationName() {
        return "";
    }
}

