/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

public class WSSPolicySetConfiguratorPlugin
implements PolicySetLoader {
    private static final TraceComponent tc = Tr.register(WSSPolicySetConfiguratorPlugin.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private PolicySetConfiguration psc = null;

    public WSSPolicySetConfiguratorPlugin(PolicySetConfiguration psc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSPolicySetConfiguratorPlugin ctr");
        }
        this.psc = psc;
        if (tc.isDebugEnabled()) {
            if (psc == null) {
                Tr.debug(tc, "PolicySet is null");
            } else {
                Tr.debug(tc, "PolicySet Name[" + psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY") + "]");
                Tr.debug(tc, "Binding Name[" + psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY") + "]");
                Tr.debug(tc, "BindingScope[" + psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY") + "]");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSPolicySetConfiguratorPlugin ctr");
        }
    }

    public void associatePolicySets(ConfigurationContext configContext, Axis2ServiceConfigPluginManager plugins) throws DeploymentException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "associatePolicySets");
        }
        throw new NotImplementedException();
    }

    public void associatePolicySets(AxisService service, Axis2ServiceConfigPluginManager plugins) throws DeploymentException, Exception {
        PolicySetConfiguration pscorg;
        if (service == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service is null. Cannot set psc on AxisService nor on AxisOperations.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isServerSide[" + plugins.isServerSide() + "]");
        }
        if (tc.isDebugEnabled()) {
            if (this.psc == null) {
                Tr.debug(tc, "PolicySet is null");
            } else {
                Tr.debug(tc, "PolicySet Name[" + this.psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY") + "]");
                Tr.debug(tc, "Binding Name[" + this.psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY") + "]");
                Tr.debug(tc, "BindingScope[" + this.psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY") + "]");
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("com.ibm.wsspi.websvcs.AxisServiceKey", service);
        params.put("com.ibm.wsspi.websvcs.ServerSideKey", plugins.isServerSide());
        plugins.runPreAttach(params);
        if (tc.isDebugEnabled() && (pscorg = (PolicySetConfiguration)Axis2Utils.getPolicySet(service)) != null) {
            Tr.debug(tc, "Axis Service already has policy set associated with it! Will overwrite with new psc.");
            Tr.debug(tc, "Org PolicySet Name[" + pscorg.getPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY") + "]");
            Tr.debug(tc, "Org Binding Name[" + pscorg.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY") + "]");
            Tr.debug(tc, "Org BindingScope[" + pscorg.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY") + "]");
        }
        try {
            Iterator operIter = service.getOperations();
            while (operIter.hasNext()) {
                AxisOperation operation = (AxisOperation)operIter.next();
                Axis2Utils.setPolicySet(operation, this.psc);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "PolicySet set on operation[" + operation.getName() + "]");
            }
            Axis2Utils.setPolicySet(service, this.psc);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicySet set on service[" + service.getName() + "]");
            }
            plugins.runPostAttach(params);
            plugins.runConfig(params);
        }
        catch (DeploymentException de) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeploymentException caught: " + de.getMessage());
            }
            throw de;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + e.getMessage());
            }
            throw e;
        }
    }
}

