/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.platform.websphere.util.WSSPolicySetConfiguratorPlugin;
import com.ibm.ws.wssecurity.trust.ext.client.util.WSSPolicySetConfigurator;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoaderMgr;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class WSSContextPolicySetConfigurator
implements WSSPolicySetConfigurator {
    private static final TraceComponent tc = Tr.register(WSSPolicySetConfiguratorPlugin.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public Object setContextPolicySet(PolicySetConfiguration psc) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContextPolicySet");
        }
        Object orgloader = null;
        try {
            if (tc.isDebugEnabled()) {
                if (psc == null) {
                    Tr.debug(tc, "PolicySet is null");
                } else {
                    Tr.debug(tc, "PolicySet Name[" + psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY") + "]");
                    Tr.debug(tc, "Binding Name[" + psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY") + "]");
                    Tr.debug(tc, "BindingScope[" + psc.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY") + "]");
                }
            }
            WSSPolicySetConfiguratorPlugin loader = new WSSPolicySetConfiguratorPlugin(psc);
            orgloader = this.setContextPolicySetLoader(loader);
        }
        catch (SoapSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw SoapSecurityException.format(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContextPolicySet returns loader[" + orgloader + "]");
        }
        return orgloader;
    }

    public Object setContextPolicySetLoader(Object loader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContextPolicySetLoader (loader[" + loader + "]");
        }
        PolicySetLoader orgloader = null;
        try {
            orgloader = PolicySetLoaderMgr.setContextPolicySetLoader((PolicySetLoader)loader);
        }
        catch (Throwable e) {
            throw SoapSecurityException.format(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContextPolicySetLoader returns loader[" + orgloader + "]");
        }
        return orgloader;
    }
}

