/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.trust.server.sts;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSTargetMapLoader;
import com.ibm.ws.wssecurity.platform.websphere.trust.server.sts.STSExtensionMapLoaderImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class STSTargetMapLoaderImpl
implements STSTargetMapLoader {
    private static final TraceComponent tc = Tr.register(STSExtensionMapLoaderImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public STSTargetMap loadSTSTargetMap() {
        String method = "loadSTSTargetMap";
        STSTargetMapLoaderImpl.trEntry(method);
        STSTargetMap stsTargetMap = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        String fileName = "ststargets.xml";
        String packageName = "com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets";
        STSTargetMapLoaderImpl.trDebug("fileNamePlugins: " + fileName);
        STSTargetMapLoaderImpl.trDebug("packageNamePlugins: " + packageName);
        String userInstallRoot = System.getProperty("user.install.root");
        String wasCellName = adminService.getCellName();
        String absolutePath = userInstallRoot + File.separator + "config" + File.separator + "cells" + File.separator + wasCellName + File.separator + "sts" + File.separator + fileName;
        STSTargetMapLoaderImpl.trDebug("absolutePathPlugins: " + absolutePath);
        try {
            JAXBContext jcPlugins = JAXBContext.newInstance((String)packageName);
            Unmarshaller umPlugins = jcPlugins.createUnmarshaller();
            stsTargetMap = (STSTargetMap)umPlugins.unmarshal(new File(absolutePath));
        }
        catch (JAXBException e) {
            FFDCFilter.processException(e, STSTargetMapLoaderImpl.class.getName(), "73");
            STSTargetMapLoaderImpl.trDebug("Error occurred while loading target configuration: " + e.getLocalizedMessage());
        }
        STSTargetMapLoaderImpl.trExit(method);
        return stsTargetMap;
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }

    private static void trDebug(String msg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, msg);
        }
    }
}

