/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.trust.server.sts;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.platform.trust.server.sts.STSExtensionMapLoader;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins.STSExtensionMap;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class STSExtensionMapLoaderImpl
implements STSExtensionMapLoader {
    private static final TraceComponent tc = Tr.register(STSExtensionMapLoaderImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public STSExtensionMap loadSTSExtensionMap() {
        String method = "loadSTSExtensionMap";
        STSExtensionMapLoaderImpl.trEntry(method);
        STSExtensionMap stsExtensionMap = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        String fileName = "stsplugins.xml";
        String packageName = "com.ibm.xmlns.prod.websphere._200608.securitytokenservice.plugins";
        STSExtensionMapLoaderImpl.trDebug("fileNamePlugins: " + fileName);
        STSExtensionMapLoaderImpl.trDebug("packageNamePlugins: " + packageName);
        String userInstallRoot = System.getProperty("user.install.root");
        String wasCellName = adminService.getCellName();
        String absolutePath = userInstallRoot + File.separator + "config" + File.separator + "cells" + File.separator + wasCellName + File.separator + "sts" + File.separator + fileName;
        STSExtensionMapLoaderImpl.trDebug("absolutePathPlugins: " + absolutePath);
        try {
            JAXBContext jcPlugins = JAXBContext.newInstance((String)packageName);
            Unmarshaller umPlugins = jcPlugins.createUnmarshaller();
            stsExtensionMap = (STSExtensionMap)umPlugins.unmarshal(new File(absolutePath));
        }
        catch (JAXBException e) {
            FFDCFilter.processException(e, STSExtensionMapLoaderImpl.class.getName(), "73");
            STSExtensionMapLoaderImpl.trDebug("Error occurred while loading plugin configuration: " + e.getLocalizedMessage());
        }
        STSExtensionMapLoaderImpl.trExit(method);
        return stsExtensionMap;
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }

    private static void trDebug(String msg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, msg);
        }
    }
}

