/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.registry;

import com.ibm.websphere.security.UserMapping;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.cert.X509Certificate;

public class WasUserMapping
implements com.ibm.ws.wssecurity.platform.registry.UserMapping {
    private static UserMapping _userMapping = null;
    private static final String comp = "security.wssecurity";
    private static final String USERMAPPING_IMPL = "com.ibm.ws.security.core.UserMappingImpl";
    private static final TraceComponent tc = Tr.register(WasUserMapping.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    private static UserMapping getUserMapping() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserMapping", _userMapping);
        }
        if (_userMapping == null) {
            try {
                Class<?> clazz = Class.forName(USERMAPPING_IMPL);
                _userMapping = (UserMapping)clazz.newInstance();
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSEC5187E", new Object[]{USERMAPPING_IMPL, e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserMapping", _userMapping);
            }
        }
        return _userMapping;
    }

    public String mapCertificateToName(X509Certificate[] cert) throws SoapSecurityException {
        try {
            return WasUserMapping.getUserMapping().mapCertificateToName(cert);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String mapDNToName(String dn) throws SoapSecurityException {
        try {
            return WasUserMapping.getUserMapping().mapDNToName(dn);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }

    public String mapPrincipalToName(String principalName) throws SoapSecurityException {
        try {
            return WasUserMapping.getUserMapping().mapPrincipalToName(principalName);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
    }
}

