/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelper;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelperFactory;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

public class WasSubjectCacheImpl
implements SubjectCache {
    private static final TraceComponent tc = Tr.register(WasSubjectCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = WasSubjectCacheImpl.class.getName();
    private static WSCredentialTokenMapperInterface wsCredTokenMapper = null;

    public String createUniqueCachekey(Subject contextSubject) {
        String uniqueID;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUniqueIDForAuthCache");
            }
            uniqueID = null;
            try {
                CacheableSubjectHelper subjectHelper = CacheableSubjectHelperFactory.getInstance();
                uniqueID = subjectHelper.getIdentifier(contextSubject);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught exception while getting unique ID from subject.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUniqueIDForAuthCache: " + uniqueID);
        }
        return uniqueID;
    }

    public Subject getSubjectFromAuthCacheByUniqueID(String uniqueID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromAuthCacheByUniqueID with " + uniqueID);
        }
        Subject loginSubject = null;
        SecurityCache cache = ContextManagerFactory.getInstance().getSecurityCache();
        if (cache != null && uniqueID != null && uniqueID.length() > 0) {
            try {
                loginSubject = cache.getSubject(uniqueID);
            }
            catch (CacheException e) {
                Tr.processException(e, clsName + ".getSubjectFromAuthCacheByUniqueID", "53");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception while looking up subject from AuthCache.", new Object[]{e});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not looking Subject in cache because SecurityCache instance is null.");
        }
        loginSubject = this.validateSubject(loginSubject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromAuthCacheByUniqueID with " + uniqueID);
        }
        return loginSubject;
    }

    public Subject getSubjectFromAuthCacheByToken(SecurityToken token) {
        Subject subject;
        block17: {
            subject = null;
            SecurityCache cache = ContextManagerFactory.getInstance().getSecurityCache();
            if (cache != null && token != null) {
                try {
                    if (token instanceof UsernameToken) {
                        UsernameToken unt = (UsernameToken)token;
                        String user = unt.getUsername();
                        if (user != null && user.length() > 0) {
                            char[] pwChr = null;
                            final UsernameToken tokenPriv = unt;
                            pwChr = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return tokenPriv.getPassword();
                                }
                            });
                            String pwd = null;
                            if (pwChr != null) {
                                pwd = new String(pwChr);
                            }
                            subject = pwd == null || pwd.length() == 0 ? cache.getSubject(WSSContextManagerFactory.getInstance().getDefaultRealm(), user) : cache.getSubject(WSSContextManagerFactory.getInstance().getDefaultRealm(), user, pwd);
                        }
                    } else if (token instanceof LTPAPropagationToken) {
                        subject = null;
                    } else if (token instanceof LTPAToken) {
                        final LTPAToken tokenPriv = (LTPAToken)token;
                        byte[] bytes = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return tokenPriv.getBinary();
                            }
                        });
                        if (bytes != null) {
                            subject = cache.getSubject(bytes);
                        }
                    } else if (token instanceof X509Token) {
                        X509Token x509 = (X509Token)token;
                        String securityName = WSSUserRegistryProcessor.mapCertificate(x509.getCertificate());
                        if (securityName == null || securityName.length() == 0) {
                            securityName = x509.getPrincipal();
                        }
                        subject = cache.getSubject(WSSContextManagerFactory.getInstance().getDefaultRealm(), securityName);
                    } else {
                        String principal = token.getPrincipal();
                        if (principal != null) {
                            subject = cache.getSubject(WSSContextManagerFactory.getInstance().getDefaultRealm(), principal);
                        }
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Caught exception looking up Subject from AuthgetSecurityCache(): " + e);
                }
            }
        }
        subject = this.validateSubject(subject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCachedSubjectUsingToken: returning Subject = " + subject);
        }
        return subject;
    }

    public void addSubjectToAuthCache(Subject loginSubject, String cacheKey) {
        SecurityCache cache = ContextManagerFactory.getInstance().getSecurityCache();
        if (loginSubject == null || cache == null) {
            return;
        }
        String uniqueID = this.getWSCredentialTokenMapperInterface().createSubjectUniqueID(loginSubject);
        Object[] keys = this.createCachekeys(uniqueID, cacheKey);
        if (keys == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unique ID is null. Adding Subject to AuthCache");
            }
            cache.insert(loginSubject);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Subject with ID " + uniqueID + " to AuthCache");
            }
            cache.insert(loginSubject, keys);
        }
    }

    private Object[] createCachekeys(String uniqueID, String cachekey) {
        Object[] objs = null;
        if (uniqueID != null && !uniqueID.isEmpty() && cachekey != null && !cachekey.isEmpty()) {
            objs = new Object[]{cachekey, uniqueID};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Subject with ID " + uniqueID + " to AuthCache");
                Tr.debug(tc, "Adding Subject with cachekey " + cachekey + " to AuthCache");
            }
        } else if (uniqueID != null && !uniqueID.isEmpty()) {
            objs = new Object[]{uniqueID};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Subject with ID " + uniqueID + " to AuthCache");
            }
        } else if (cachekey != null && !cachekey.isEmpty()) {
            objs = new Object[]{cachekey};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Subject with ID " + uniqueID + " to AuthCache");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Additional Key . Adding Subject to AuthCache");
        }
        return objs;
    }

    public Subject validateSubject(Subject loginSubject) {
        return this.validateSubject(loginSubject, false);
    }

    public Subject validateSubject(Subject loginSubject, boolean checkCushion) {
        if (loginSubject != null) {
            WSCredential credential = loginSubject.getPublicCredentials(WSCredential.class).iterator().next();
            if (credential != null) {
                boolean is_destroyed = credential.isDestroyed();
                boolean is_forwardable = false;
                try {
                    is_forwardable = credential.isForwardable();
                }
                catch (Exception e) {
                    is_destroyed = true;
                }
                long cushion = 0L;
                if (checkCushion) {
                    cushion = ContextManagerFactory.getInstance().getSecurityCache().getCushion();
                }
                boolean isSubjectValid = this.getWSCredentialTokenMapperInterface().checkCushionValidityOfAllTokens(loginSubject, cushion);
                if (tc.isDebugEnabled()) {
                    if (is_forwardable) {
                        Tr.debug(tc, "credential is forwardable, subject valid = " + isSubjectValid);
                    } else {
                        Tr.debug(tc, "non-forwardable Subject");
                    }
                }
                if (is_destroyed || is_forwardable && !isSubjectValid) {
                    loginSubject = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached subject is valid.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSCredential in Subject, logging in again.");
                }
                loginSubject = null;
            }
        }
        return loginSubject;
    }

    public long getCushion() {
        return ContextManagerFactory.getInstance().getSecurityCache().getCushion();
    }

    public void insert(Subject subject, Object[] additional_lookup_keys) {
        ContextManagerFactory.getInstance().getSecurityCache().insert(subject, additional_lookup_keys);
    }

    public Subject getSubject(Object cacheKey) throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getSecurityCache().getSubject(cacheKey);
        }
        catch (CacheException e) {
            throw new SoapSecurityException(e.getMessage());
        }
    }

    private WSCredentialTokenMapperInterface getWSCredentialTokenMapperInterface() {
        if (wsCredTokenMapper != null) {
            return wsCredTokenMapper;
        }
        wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
        return wsCredTokenMapper;
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> wrapperClass = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object wrapperObj = wrapperClass.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)wrapperObj;
            }
            catch (Exception ex) {
                Tr.processException(ex, clsName + "init", "981");
            }
        }
    }
}

