/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditServiceFactory;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.SubjectCacheFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.registry.UserMapFactory;
import com.ibm.ws.wssecurity.platform.registry.UserMapping;
import com.ibm.ws.wssecurity.platform.registry.UserRegistry;
import com.ibm.ws.wssecurity.platform.registry.UserRegistryFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class WasContextManagerImpl
implements WSSContextManager {
    private static final TraceComponent tc = Tr.register(WasContextManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private UserMapping userMapping = null;
    private UserRegistry userRegistry = null;
    private SubjectCache authCache = null;
    private WSSAuditService auditService = null;
    boolean isAppSecEnabled = false;
    boolean appSecChecked = false;

    public boolean processIsServer() {
        return true;
    }

    public boolean runInWebSphere() {
        return true;
    }

    public String getDefaultRealm() {
        return ContextManagerFactory.getInstance().getDefaultRealm();
    }

    public String getDefaultLoginModule() {
        return null;
    }

    public String getLoginModule(String method) {
        return this.getDefaultLoginModule();
    }

    public String getAuthenticationMethod() {
        return null;
    }

    public UserRegistry getRegistry(String realm) {
        if (this.userRegistry == null) {
            this.userRegistry = UserRegistryFactory.getInstance();
        }
        return this.userRegistry;
    }

    public UserMapping getUserMapping() {
        if (this.userMapping == null) {
            this.userMapping = UserMapFactory.getInstance();
        }
        return this.userMapping;
    }

    public SubjectCache getSubjectCache() {
        if (this.authCache == null) {
            this.authCache = SubjectCacheFactory.getInstance();
        }
        return this.authCache;
    }

    public WSSAuditService getAuditService() {
        if (this.auditService == null) {
            this.auditService = WSSAuditServiceFactory.getInstance();
        }
        return this.auditService;
    }

    public Subject login(String realm, byte[] token) throws LoginException {
        return ContextManagerFactory.getInstance().login(realm, token);
    }

    public Subject login(String realm, String user) throws LoginException {
        return ContextManagerFactory.getInstance().login(realm, user);
    }

    public Subject login(String realm, String user, String password) throws LoginException {
        return ContextManagerFactory.getInstance().login(realm, user, password);
    }

    public Object get(String key) {
        return ContextManagerFactory.getInstance().get(key);
    }

    public Subject getCallerSubject() throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getCallerSubject();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
    }

    public Subject getInvocationSubject() throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getInvocationSubject();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
    }

    public Subject getSubject() throws SoapSecurityException {
        try {
            return ContextManagerFactory.getInstance().getCallerSubject();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
    }

    public String getSecurityName() throws SoapSecurityException {
        return null;
    }

    public void setSecurityName(String name) {
    }

    public Object put(String key, Object value) {
        return ContextManagerFactory.getInstance().put(key, value);
    }

    public void setCallerSubject(Subject subject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject");
        }
        try {
            ContextManagerFactory.getInstance().setCallerSubject(subject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallerSubject");
        }
    }

    public void setInvocationSubject(Subject subject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject");
        }
        try {
            ContextManagerFactory.getInstance().setInvocationSubject(subject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallerSubject");
        }
    }

    public void setSubject(Subject subject) throws SoapSecurityException {
    }

    public Throwable getRootException() {
        return ContextManagerFactory.getInstance().getRootException();
    }

    public void setRootException(Throwable t) {
        ContextManagerFactory.getInstance().setRootException(t);
    }

    public void clearRootException() {
        try {
            ContextManagerFactory.getInstance().clearCallerContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getServerSecurityEnabled() throws SoapSecurityException {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerSecurityEnabled");
            }
            if (!this.appSecChecked) {
                try {
                    this.isAppSecEnabled = ContextManagerFactory.getInstance().isServerSecurityEnabled();
                    this.appSecChecked = true;
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Ignoring exception from isServerSecurityEnabled");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerSecurityEnabled returns " + this.isAppSecEnabled);
        }
        return this.isAppSecEnabled;
    }

    public boolean getSSOInteropModeEnabled() {
        String sso_interop_string = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.ws.security.ssoInteropModeEnabled");
        boolean sso_interop = ConfigUtil.isTrue(sso_interop_string);
        return sso_interop;
    }

    public WSSContext getSerializableContext() throws SoapSecurityException {
        try {
            WSSContext context = WSSContextFactory.getInstance();
            Context ctx = ContextManagerFactory.getInstance().getSerializableContext();
            context.setContextContent(ctx);
            return context;
        }
        catch (WSSecurityException e) {
            throw SoapSecurityException.format(e.getMessage(), e);
        }
    }
}

