/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.cache.DistributedObjectCacheFactory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSSDistributedCache {
    private static DistributedMap distributedMapForClient = null;
    private static DistributedMap distributedMapForServer = null;
    private static DistributedMap distributedMapForNonce = null;
    private static Map<String, CacheableToken> nonDistributedMapForClient = new HashMap<String, CacheableToken>();
    private static Map<String, CacheableToken> nonDistributedMapForService = new HashMap<String, CacheableToken>();
    private static Map<String, CacheableToken> nonDistributedMapForNonce = new HashMap<String, CacheableToken>();
    private static final String _DMAPClient = "com.ibm.ws.wssecurity.sctClientCacheMap";
    private static final String _DMAPServer = "com.ibm.ws.wssecurity.sctServiceCacheMap";
    private static final TraceComponent tc = Tr.register(WSSDistributedCache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static DistributedMap initializeService() {
        block2: {
            distributedMapForServer = null;
            try {
                distributedMapForServer = DistributedObjectCacheFactory.getMap((String)_DMAPServer);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to initialize distributed cache now. Distributed cache will be re-initialized later.");
            }
        }
        return distributedMapForServer;
    }

    public static DistributedMap initializeClient() {
        block2: {
            distributedMapForClient = null;
            try {
                distributedMapForClient = DistributedObjectCacheFactory.getMap((String)_DMAPClient);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to initialize distributed cache now. Distributed cache will be re-initialized later.");
            }
        }
        return distributedMapForClient;
    }

    public static DistributedMap initializeNonce() {
        block2: {
            distributedMapForNonce = null;
            try {
                distributedMapForNonce = DistributedObjectCacheFactory.getMap((String)"NonceDistributionCacheMap");
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to initialize distributed cache now. Distributed cache will be re-initialized later.");
            }
        }
        return distributedMapForNonce;
    }

    public static DistributedMap getDistributedCacheForClient() {
        if (distributedMapForClient != null) {
            return distributedMapForClient;
        }
        return WSSDistributedCache.initializeClient();
    }

    public static DistributedMap getDistributedCacheForService() {
        if (distributedMapForServer != null) {
            return distributedMapForServer;
        }
        return WSSDistributedCache.initializeService();
    }

    public static DistributedMap getDistributedCacheForNonce() {
        if (distributedMapForNonce != null) {
            return distributedMapForNonce;
        }
        return WSSDistributedCache.initializeNonce();
    }

    public static Map<String, CacheableToken> getLocalCacheForClient() {
        return nonDistributedMapForClient;
    }

    public static Map<String, CacheableToken> getLocalCacheForService() {
        return nonDistributedMapForService;
    }

    public static Map<String, CacheableToken> getLocalCacheForNonce() {
        return nonDistributedMapForNonce;
    }
}

