/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.wssecurity.platform.websphere.auth.JDBCCacheableTokenCache;
import com.ibm.ws.wssecurity.platform.websphere.auth.MBeanCacheableTokenCache;
import com.ibm.ws.wssecurity.platform.websphere.auth.WSSDistributedCache;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;

public class CacheableTokenCacheImpl
implements CacheableTokenCache {
    private Boolean preV70InteropMode = null;
    private Map<String, CacheableToken> localMap;
    private DistributedMap distributedMap;
    private boolean distributedEnabled = false;
    private boolean clusterMBeanEnabled = false;
    private boolean jdbcEnabled = false;
    private static Long timeToStayInLocalCache = new Long(10800L);
    private MBeanCacheableTokenCache mbeanCacheableTokenCache = null;
    private static final String CLASS_NAME = CacheableTokenCacheImpl.class.getName();
    private static final TraceComponent tc = Tr.register(CacheableTokenCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public CacheableTokenCacheImpl() {
        String method = "CacheableTokenCacheImpl";
        CacheableTokenCacheImpl.trEntry(method);
        this.distributedEnabled = CacheConfigFactory.getInstance().isDistributedCache();
        this.clusterMBeanEnabled = CacheConfigFactory.getInstance().isSynchronousClusterUpdate();
        this.jdbcEnabled = CacheConfigFactory.getInstance().isJDBCCache();
        this.preV70InteropMode = CacheConfigFactory.getInstance().getPreV70InteropMode();
        if (this.jdbcEnabled) {
            this.distributedEnabled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DataBase is used as distributed cache!!");
            }
        }
        if (!this.distributedEnabled) {
            this.clusterMBeanEnabled = false;
        }
        if (tc.isDebugEnabled() && this.distributedEnabled) {
            Tr.debug(tc, "distributedEnabled = true");
            Tr.debug(tc, "Pre 70 interop mode = " + this.preV70InteropMode);
        }
        CacheableTokenCacheImpl.trExit(method);
    }

    public void setDistributedMap(int type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDistributedMap(boolean " + type + ")");
        }
        if (type == 1) {
            this.distributedMap = WSSDistributedCache.getDistributedCacheForClient();
            if (this.distributedMap != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Distributed Map For Client created!");
            }
            this.localMap = Collections.synchronizedMap(WSSDistributedCache.getLocalCacheForClient());
        } else if (type == 2) {
            this.distributedMap = WSSDistributedCache.getDistributedCacheForNonce();
            if (this.distributedMap != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Distributed Map For Nonce created!");
            }
            this.localMap = Collections.synchronizedMap(WSSDistributedCache.getLocalCacheForNonce());
        } else {
            this.distributedMap = WSSDistributedCache.getDistributedCacheForService();
            if (this.distributedMap != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Distributed Map For Service created!");
            }
            this.localMap = Collections.synchronizedMap(WSSDistributedCache.getLocalCacheForService());
        }
        if (this.distributedMap != null) {
            this.mbeanCacheableTokenCache = new MBeanCacheableTokenCache(this.distributedMap, type);
            this.distributedMap.enableListener(true);
            boolean isInvalidListener = this.distributedMap.addInvalidationListener(new InvalidationListener(){

                public void fireEvent(InvalidationEvent e) {
                    if (e.getCauseOfInvalidation() == 3 || e.getCauseOfInvalidation() == 1 || e.getCauseOfInvalidation() == 5 || e.getCauseOfInvalidation() == 2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fire event, cause: " + e.getCauseOfInvalidation());
                            Tr.debug(tc, "The identifier = " + (String)e.getId());
                        }
                        CacheableTokenCacheImpl.this.removeLocalToken((String)e.getId());
                    }
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Listener  enabled = " + isInvalidListener);
            }
        }
        if (this.distributedEnabled) {
            this.distributedMap.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cacheEntryChanged(ChangeEvent e) {
                    if (e.getCauseOfChange() == 1 || e.getCauseOfChange() == 2) {
                        String identifier = (String)e.getId();
                        Object obj = CacheableTokenCacheImpl.this.distributedMap.get((Object)identifier);
                        CacheableToken token = null;
                        if (obj instanceof byte[]) {
                            SCT sct = null;
                            ByteArrayInputStream byteStream = new ByteArrayInputStream((byte[])obj);
                            try {
                                ObjectInputStream inObjStream = new ObjectInputStream(byteStream);
                                sct = new SCT();
                                sct.readExternal(inObjStream);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                            catch (ClassNotFoundException cnfe) {
                                cnfe.printStackTrace();
                            }
                            token = sct;
                        } else {
                            token = (CacheableToken)obj;
                        }
                        if (token != null) {
                            CacheableTokenCacheImpl.trDebug("Distributed cache entry changed event. Token found in distributed cache, updating the local cache.");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterMBeanEnabled: " + CacheableTokenCacheImpl.this.clusterMBeanEnabled + ", jdbcEnabled: " + CacheableTokenCacheImpl.this.jdbcEnabled + ", preV70InteropMode: " + CacheableTokenCacheImpl.this.getPreV70InteropMode() + ", token: " + token);
                            }
                            if (!CacheableTokenCacheImpl.this.clusterMBeanEnabled && !CacheableTokenCacheImpl.this.jdbcEnabled && token instanceof SCT) {
                                CacheableTokenCacheImpl.this.mergeSCT(token, (String)e.getId());
                            }
                            Map map = CacheableTokenCacheImpl.this.localMap;
                            synchronized (map) {
                                CacheableTokenCacheImpl.this.localMap.put(identifier, token);
                            }
                        }
                    }
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDistributedMap(boolean " + type + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeSCT(CacheableToken ctoken, String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeSCT(CacheableToken ctoken String key) = " + ctoken.getIdentifier() + ": " + key);
        }
        Map<String, CacheableToken> map = this.localMap;
        synchronized (map) {
            SCT token = (SCT)ctoken;
            if (tc.isDebugEnabled() && token != null) {
                for (int i = 0; i < token.getInstances().length; ++i) {
                    Tr.debug(tc, "instances list (before merge) :" + token.getInstances()[i]);
                }
            }
            SCT oldToken = new SCT();
            oldToken = (SCT)this.localMap.get(key);
            if (oldToken != null && oldToken.getInstances() != null && token != null) {
                String[] oldIns = oldToken.getInstances();
                int iLen = oldIns.length;
                for (int i = 0; i < iLen; ++i) {
                    if (token.getKeyHistoryEntry(oldIns[i]) != null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy missing key instance:" + oldIns[i]);
                    }
                    token.setKeyHistoryEntry(oldToken.getKeyHistoryEntry(oldIns[i]));
                }
            }
            if (token != null) {
                this.localMap.put(key, token);
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < token.getInstances().length; ++i) {
                        Tr.debug(tc, "instances list (after merge) : " + token.getInstances()[i]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeSCT(CacheableToken ctoken, String key)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableToken getToken(String identifier) {
        String method = "getToken(identifier=" + identifier + ")";
        CacheableTokenCacheImpl.trEntry(method);
        CacheableToken token = this.getLocalToken(identifier);
        if (token == null) {
            if (this.clusterMBeanEnabled) {
                token = this.mbeanCacheableTokenCache.getToken(identifier);
            }
            if (token == null && this.jdbcEnabled && (token = JDBCCacheableTokenCache.getInstance().getToken(identifier)) != null) {
                long time = JDBCCacheableTokenCache.getInstance().getTokenCacheTimeout(identifier);
                Long timeL = new Long(time / 1000L);
                this.distributedMap.put((Object)identifier, (Object)"NonDistributed", 1, timeL.intValue(), 1, null);
            }
            if (token != null) {
                CacheableTokenCacheImpl.trDebug("Updating the local cache.");
                Map<String, CacheableToken> map = this.localMap;
                synchronized (map) {
                    this.localMap.put(identifier, token);
                }
            }
        }
        CacheableTokenCacheImpl.trExit(method, token);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableToken getTokenFromDatabase(String identifier, long timeout) {
        String method = "getTokenFromDatabase(identifier=" + identifier + ": time to live in local cache=" + timeout + ")";
        CacheableTokenCacheImpl.trEntry(method);
        CacheableToken token = null;
        Long time = new Long(timeout / 1000L);
        token = JDBCCacheableTokenCache.getInstance().getToken(identifier);
        if (token != null) {
            CacheableTokenCacheImpl.trDebug("Updating the local cache.");
            if (time.intValue() == 0) {
                long time0 = JDBCCacheableTokenCache.getInstance().getTokenCacheTimeout(identifier);
                time = new Long(time0 / 1000L);
            }
            this.distributedMap.put((Object)identifier, (Object)"NonDistributed", 1, time.intValue(), 1, null);
            Map<String, CacheableToken> map = this.localMap;
            synchronized (map) {
                this.localMap.put(identifier, token);
            }
        }
        CacheableTokenCacheImpl.trExit(method, token);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableToken getLocalToken(String identifier) {
        CacheableToken token;
        String method = "getLocalToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method, identifier);
        }
        if ((token = this.localMap.get(identifier)) == null && this.distributedEnabled) {
            CacheableTokenCacheImpl.trDebug("Token not found in local cache.");
            Object obj = this.distributedMap.get((Object)identifier);
            if (obj == null) {
                CacheableTokenCacheImpl.trDebug("Token not found in distributed cache.");
            } else if (token == null) {
                if (this.getPreV70InteropMode() && obj instanceof byte[]) {
                    SCT sct = null;
                    ByteArrayInputStream byteStream = new ByteArrayInputStream((byte[])obj);
                    try {
                        ObjectInputStream inObjStream = new ObjectInputStream(byteStream);
                        sct = new SCT();
                        sct.readExternal(inObjStream);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    token = sct;
                } else {
                    token = (CacheableToken)obj;
                }
            }
            if (token != null) {
                CacheableTokenCacheImpl.trDebug("Token found in distributed cache, updating the local cache.");
                Map<String, CacheableToken> map = this.localMap;
                synchronized (map) {
                    this.localMap.put(identifier, token);
                }
            }
        }
        CacheableTokenCacheImpl.trExit(method, token);
        return token;
    }

    public boolean cacheToken(String identifier, CacheableToken token, long cacheTimeout) {
        String method = "cacheToken(identifier=" + identifier + "," + CacheableToken.class.getName() + "," + "cacheTimeout=" + cacheTimeout + ")";
        CacheableTokenCacheImpl.trEntry(method);
        boolean update = true;
        if (identifier == null || token == null) {
            CacheableTokenCacheImpl.trDebug(method + ": Identifier or token argument is null");
            return false;
        }
        this.putToken(identifier, token, cacheTimeout);
        if (this.jdbcEnabled) {
            update = JDBCCacheableTokenCache.getInstance().cacheToken(identifier, token, cacheTimeout);
        }
        CacheableTokenCacheImpl.trExit(method, update);
        return update;
    }

    public boolean containsToken(String identifier) {
        String method = "containsToken(identifier=" + identifier + ")";
        CacheableTokenCacheImpl.trEntry(method);
        boolean exists = this.localMap.containsKey(identifier);
        if (!exists && this.distributedEnabled) {
            CacheableTokenCacheImpl.trDebug("Token not found in local cache.");
            exists = this.distributedMap.containsKey((Object)identifier);
            if (!exists) {
                CacheableTokenCacheImpl.trDebug("Token not found in distributed cache.");
            }
        }
        if (!exists && this.jdbcEnabled && JDBCCacheableTokenCache.getInstance().getToken(identifier) != null) {
            exists = true;
            CacheableTokenCacheImpl.trDebug("Token found in JDBC database");
        }
        CacheableTokenCacheImpl.trExit(method, exists);
        return exists;
    }

    public boolean containsToken(String identifier, CacheableToken token, long cacheTimeout) {
        boolean foundToken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsToken", new Object[]{identifier, token, cacheTimeout});
        }
        if (!(foundToken = this.containsToken(identifier))) {
            boolean cacheSuccess = this.cacheToken(identifier, token, cacheTimeout);
            if (tc.isDebugEnabled()) {
                if (cacheSuccess) {
                    Tr.debug(tc, "Addition of token " + token.toString() + " to cache was succesful");
                } else {
                    Tr.debug(tc, "Addition of token" + token.toString() + " to cache was unsuccesful");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsToken", foundToken);
        }
        return foundToken;
    }

    public CacheableToken removeToken(String identifier) {
        String method = "removeToken(identifier=" + identifier + ")";
        CacheableTokenCacheImpl.trEntry(method);
        CacheableToken token = this.removeLocalToken(identifier);
        if (this.clusterMBeanEnabled || this.jdbcEnabled) {
            this.mbeanCacheableTokenCache.removeTokenFromClusterMembers(identifier);
        }
        if (this.jdbcEnabled) {
            JDBCCacheableTokenCache.getInstance().removeToken(identifier);
        }
        CacheableTokenCacheImpl.trExit(method, token);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableToken removeLocalToken(String identifier) {
        String methodName = "removeLocalToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeLocalToken", identifier);
        }
        CacheableToken token = null;
        Map<String, CacheableToken> map = this.localMap;
        synchronized (map) {
            token = this.localMap.remove(identifier);
        }
        if (this.distributedEnabled) {
            Object obj = this.distributedMap.remove((Object)identifier);
            if (obj != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "distributedMap.remove(" + identifier + ") return null");
                }
                if (this.getPreV70InteropMode() && obj instanceof byte[]) {
                    SCT sct = null;
                    ByteArrayInputStream byteStream = new ByteArrayInputStream((byte[])obj);
                    try {
                        ObjectInputStream inObjStream = new ObjectInputStream(byteStream);
                        sct = new SCT();
                        sct.readExternal(inObjStream);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    token = sct;
                } else {
                    token = (CacheableToken)obj;
                }
            }
        } else if (this.distributedMap != null) {
            this.distributedMap.remove((Object)identifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeLocalToken", token);
        }
        return token;
    }

    public boolean updateToken(String identifier, CacheableToken token, long cacheTimeout) {
        String method = "updateToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateToken", new Object[]{identifier, token, cacheTimeout});
        }
        boolean updateSuccess = false;
        boolean localOnly = false;
        if (identifier == null || token == null) {
            CacheableTokenCacheImpl.trDebug("updateToken: Identifier or token argument is null");
            updateSuccess = false;
        }
        updateSuccess = this.updateLocalToken(identifier, token, cacheTimeout);
        if (this.clusterMBeanEnabled || this.jdbcEnabled) {
            this.mbeanCacheableTokenCache.updateTokenInClusterMembers(identifier, token, cacheTimeout);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateToken", updateSuccess);
        }
        return updateSuccess;
    }

    public boolean updateLocalToken(String identifier, CacheableToken token, long cacheTimeout) {
        String methodName = "updateLocalToken";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateLocalToken", new Object[]{identifier, token, cacheTimeout});
        }
        boolean rc = false;
        if (identifier != null && !(rc = this.cacheToken(identifier, token, cacheTimeout))) {
            this.removeLocalToken(identifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateLocalToken", rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToken(String identifier, CacheableToken token, long cacheTimeout) {
        Long time;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putToken (identifier = " + identifier + ":" + "token, cahcheTimeout = " + cacheTimeout);
        }
        timeToStayInLocalCache = time = new Long(cacheTimeout / 1000L);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Time to live in cache needs to be specified in seconds = " + time);
        }
        if (this.distributedEnabled) {
            if (this.getPreV70InteropMode() && token instanceof SCT) {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream outObjStream = new ObjectOutputStream(byteStream);
                    token.writeExternal(outObjStream);
                    outObjStream.close();
                    byteStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                byte[] tokenBytes = byteStream.toByteArray();
                if (tokenBytes != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Save serialized CacheableToken in distributedMap.");
                    }
                    this.distributedMap.put((Object)identifier, (Object)tokenBytes, 1, time.intValue(), 2, null);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Save serialized CacheableToken in distributedMap.");
                }
                this.distributedMap.put((Object)identifier, (Object)token, 1, time.intValue(), 2, null);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving CacheableToken identifier in distributed Map, so localmap can be altered. Using distributed map as monitor ONLY");
            }
            this.distributedMap.put((Object)identifier, (Object)"NonDistributed", 1, time.intValue(), 1, null);
        }
        Map<String, CacheableToken> map = this.localMap;
        synchronized (map) {
            this.localMap.put(identifier, token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putToken (identifier = " + identifier + ":" + "token, cahcheTimeout = " + cacheTimeout);
        }
    }

    public void setPreV70InteropMode(boolean preV70InteropMode) {
        if (this.preV70InteropMode == null) {
            this.preV70InteropMode = new Boolean(preV70InteropMode);
        } else if (preV70InteropMode != this.preV70InteropMode && tc.isDebugEnabled()) {
            Tr.debug(tc, "preV70InteropMode already set to " + this.preV70InteropMode + ".  Must restart server to change.");
        }
    }

    public boolean getPreV70InteropMode() {
        return this.preV70InteropMode == null ? false : this.preV70InteropMode;
    }

    private static void trEntry(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, msg);
        }
    }

    private static void trExit(String msg) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }

    private static void trExit(String msg, Object returnValue) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg, returnValue);
        }
    }

    private static void trDebug(String msg) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, msg);
        }
    }
}

