/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import javax.security.auth.Subject;

public class CacheableSubjectHelperImpl
implements CacheableSubjectHelper {
    private static long DEFAULT_EXPIRATION = 300000L;
    private static final TraceComponent tc = Tr.register(CacheableSubjectHelperImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public String getIdentifier(Subject subject) {
        String identifier;
        block3: {
            identifier = null;
            try {
                identifier = ContextManagerFactory.getInstance().getWSCredTokenMapper().createSubjectUniqueID(subject);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception caught: " + e.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adjusted subject identifier = " + identifier);
        }
        return identifier;
    }

    public long getExpiration(Subject subject) {
        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        long expiration_time = System.currentTimeMillis();
        try {
            if (wsCred != null && wsCred.isForwardable()) {
                expiration_time = wsCred.getExpiration();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subject expiration in " + (expiration_time - System.currentTimeMillis()) + " ms");
        }
        return expiration_time;
    }
}

