/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.wssecurity.util.CacheConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Configuration;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.ObjectFactory;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.Property;
import com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache.WSSDistributedCacheConfig;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class CacheConfigImpl
implements CacheConfig {
    private static final String WSSConfigFile = "WSSDistributedCache.xml";
    private static final String Package_Namespace = "com.ibm.xmlns.prod.websphere._200711.wssecurity.distributedcache";
    private static final String renewIntervalBeforeTimeoutMinutes = "renewIntervalBeforeTimeoutMinutes";
    private static final String minutesInCacheAfterTimeout = "minutesInCacheAfterTimeout";
    private static final String distributedCache = "distributedCache";
    private static final String syncClusterUpdate = "synchronousClusterUpdate";
    private static final String syncClusterTimeoutMinutes = "synchronousClusterTimeoutMinutes";
    private static final String jdbcCache = "tokenRecovery";
    private static final String jndiName = "Datasource";
    private static final String clockSkewToleranceInMinutes = "clockSkewToleranceInMinutes";
    private static long cacheGraceMilliseconds = 600000L;
    private static long cacheCushionMilliseconds = 600000L;
    private static final long cacheCushionMin = 180000L;
    private static long clockSkewMilliseconds = 180000L;
    private static long maxClockSkewMilliseconds = 600000L;
    private static boolean isDistributedCache = false;
    private static boolean isSynchronousClusterUpdate = false;
    private static long syncClusterTimeoutMilliseconds = 300L;
    private static boolean isJDBCCache = false;
    private static String myJNDIName = null;
    private static boolean isCacheConfigInitialized = false;
    private static final String clsName = CacheConfigImpl.class.getName();
    private static final String comp = "security.wssecurity";
    private Boolean preV70InteropMode = null;
    private static TraceComponent tc = Tr.register(CacheConfigImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public CacheConfigImpl() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
    }

    private static void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        Configuration cfg = null;
        try {
            String absolutePath = CacheConfigImpl.LocateWSSCCacheConfig(WSSConfigFile);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller um = jc.createUnmarshaller();
            WSSDistributedCacheConfig cache = (WSSDistributedCacheConfig)um.unmarshal(new File(absolutePath));
            cfg = cache.getConfiguration().get(0);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, clsName, "001");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load cache configuration. Using default.");
            }
            Tr.warning(tc, "security.wssecurity.SecureConversationCacheConfigImpl.s01");
            return;
        }
        List<Property> listProps = cfg.getProperty();
        for (Property current : listProps) {
            Long val;
            String name = current.getName();
            String value = current.getValue();
            if (renewIntervalBeforeTimeoutMinutes.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                val = new Long(value);
                if (val > 0L) {
                    cacheCushionMilliseconds = val < 3L ? 180000L : val * 60L * 1000L;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "cacheCushionMilliseconds=" + cacheCushionMilliseconds);
                continue;
            }
            if (minutesInCacheAfterTimeout.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                val = new Long(value);
                if (cacheGraceMilliseconds <= val * 60L * 1000L) {
                    cacheGraceMilliseconds = val * 60L * 1000L;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "cacheGraceMilliseconds=" + cacheGraceMilliseconds);
                continue;
            }
            if (distributedCache.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                if ((value = value.trim()).equalsIgnoreCase("true")) {
                    isDistributedCache = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "isDistributedCache = true");
                    continue;
                }
                isDistributedCache = false;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "isDistributedCache = false");
                continue;
            }
            if (syncClusterUpdate.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                if ((value = value.trim()).equalsIgnoreCase("true")) {
                    isSynchronousClusterUpdate = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "isSynchronousClusterUpdate = true");
                    continue;
                }
                isSynchronousClusterUpdate = false;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "isSynchronousClusterUpdate = false");
                continue;
            }
            if (syncClusterTimeoutMinutes.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                val = new Long(value);
                if (syncClusterTimeoutMilliseconds <= val * 60L * 1000L) {
                    syncClusterTimeoutMilliseconds = val * 60L * 1000L;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "syncClusterTimeoutMilliseconds=" + syncClusterTimeoutMilliseconds);
                continue;
            }
            if (jdbcCache.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                if ((value = value.trim()).equalsIgnoreCase("true")) {
                    isJDBCCache = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "isJDBCCache = true");
                    continue;
                }
                isJDBCCache = false;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "isJDBCCache = false");
                continue;
            }
            if (jndiName.equalsIgnoreCase(name) && value != null && value.trim().length() > 0) {
                myJNDIName = value = value.trim();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "myJNDIName = " + myJNDIName);
                continue;
            }
            if (!clockSkewToleranceInMinutes.equalsIgnoreCase(name) || value == null || value.trim().length() <= 0) continue;
            val = new Long(value);
            clockSkewMilliseconds = val * 60L * 1000L <= maxClockSkewMilliseconds ? val * 60L * 1000L : maxClockSkewMilliseconds;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "clockSkewMilliseconds=" + clockSkewMilliseconds);
        }
        isCacheConfigInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public long getCacheCushionMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return cacheCushionMilliseconds;
    }

    public long getCacheGraceTimeMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return cacheGraceMilliseconds;
    }

    public long getClockSkewToleranceMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return clockSkewMilliseconds;
    }

    public boolean isDistributedCache() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return isDistributedCache;
    }

    public String getJNDIName() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return myJNDIName;
    }

    public boolean isJDBCCache() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return isJDBCCache;
    }

    public boolean isSynchronousClusterUpdate() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return isSynchronousClusterUpdate;
    }

    public long synchronousClusterTimeoutMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return syncClusterTimeoutMilliseconds;
    }

    private static String LocateWSSCCacheConfig(String fileName) {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String userInstallRoot = System.getProperty("user.install.root");
        String wasCellName = adminService.getCellName();
        String absolutePath = userInstallRoot + File.separator + "config" + File.separator + "cells" + File.separator + wasCellName + File.separator + fileName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSS Cache config file = " + absolutePath);
        }
        return absolutePath;
    }

    public String getClusterName() {
        String clusterName = null;
        try {
            clusterName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Server server = WsServiceRegistry.getService(this, Server.class);
                    if (server != null) {
                        if (server.getClusterName() != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cluster name from server service=" + server.getClusterName());
                            }
                            return server.getClusterName();
                        }
                        return server.getName();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            Tr.processException(e, clsName, "getSecurityContextTokenFromCacheByContext_1");
            clusterName = null;
        }
        return clusterName;
    }

    public void setPreV70InteropMode(boolean preV70InteropMode) {
        if (this.preV70InteropMode == null) {
            this.preV70InteropMode = new Boolean(preV70InteropMode);
        } else if (preV70InteropMode != this.preV70InteropMode && tc.isDebugEnabled()) {
            Tr.debug(tc, "preV70InteropMode already set to " + this.preV70InteropMode + ".  Must restart server to change.");
        }
    }

    public boolean getPreV70InteropMode() {
        return this.preV70InteropMode == null ? false : this.preV70InteropMode;
    }
}

