/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSRealm;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class WSSRealmImpl
implements WSSRealm {
    @Override
    public boolean isUserFromTrustedRealm(String qualifiedIdentity) throws SoapSecurityException {
        return false;
    }

    @Override
    public String getRealmQualifiedIdentity(Subject subject, boolean sendRealm, boolean trustedRealm) throws SoapSecurityException {
        Iterator<Principal> i;
        Set<Principal> principals;
        String username = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && (i = principals.iterator()).hasNext()) {
            Principal principal = i.next();
            username = principal.getName();
        }
        return username;
    }

    @Override
    public String getRealmQualifiedIdentity(String username, String password, boolean sendRealm, boolean trustedRealm) throws SoapSecurityException {
        return username;
    }

    @Override
    public String getRealmQualifiedRunAsIdentity(MessageContext messageContext, boolean sendRealm, boolean trustedRealm) throws SoapSecurityException {
        try {
            WSSContext secContext = WSSContextFactory.getInstance();
            Subject subject = secContext.getRunAsSubject(messageContext);
            if (subject != null) {
                return this.getRealmQualifiedIdentity(subject, sendRealm, trustedRealm);
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e);
        }
        return null;
    }

    @Override
    public boolean isIdentityRealmQualified(String qualifiedIdentity) {
        int index;
        boolean realmQualified = false;
        if (qualifiedIdentity != null && qualifiedIdentity.length() >= MINIMUM_QUALIFIED_IDENTITY_LENGTH && (index = qualifiedIdentity.indexOf(":realm:")) >= 0 && index < qualifiedIdentity.length() - MINIMUM_QUALIFIED_IDENTITY_LENGTH) {
            realmQualified = true;
        }
        return realmQualified;
    }

    @Override
    public String getIdentity(String qualifiedIdentity) {
        String identity = null;
        if (qualifiedIdentity != null) {
            int index = qualifiedIdentity.indexOf(":realm:");
            identity = index < 0 || index >= qualifiedIdentity.length() ? qualifiedIdentity : qualifiedIdentity.substring(0, index);
        }
        return identity;
    }

    @Override
    public int getNumberOfDelimiters(String qualifiedIdentity) {
        int numberDelimiters = 0;
        if (qualifiedIdentity != null) {
            int index = 0;
            while (index >= 0 && index <= qualifiedIdentity.length() - ":realm:".length()) {
                if ((index = qualifiedIdentity.indexOf(":realm:", index)) <= 0 || index > qualifiedIdentity.length() - ":realm:".length()) continue;
                ++numberDelimiters;
            }
        }
        return numberDelimiters;
    }

    @Override
    public boolean isIdentityLocal(String qualifiedIdentity) {
        return !this.isIdentityRealmQualified(qualifiedIdentity);
    }

    @Override
    public void addIdentityAssertionProperties(String qualifiedIdentity, Map customProperties) {
    }
}

