/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCache;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.Date;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;

public class SecureConversationCacheHelper {
    private static final TraceComponent tc = Tr.register(SecureConversationCacheHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLS_NAME = SecureConversationCacheHelper.class.getName();
    private static final String comp = "security.wssecurity";
    private static String sessionIdentifier = Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER;
    private static CacheableTokenCache _sCache = CacheableTokenCacheFactory.getClientInstance();
    private static long extraTime = CacheConfigFactory.getInstance().getCacheGraceTimeMilliseconds();
    private static boolean jdbcEnabled = CacheConfigFactory.getInstance().isJDBCCache();
    private static String clusterName = null;
    private static final String SERVICE_SCOPE = "SERVICE_SCOPE";
    private static String sctscope = "com.ibm.ws.wssecurity.sc.SCTScope";

    public static Object getSecurityContextTokenFromCacheByUUID(String uuid) {
        if (uuid == null) {
            return null;
        }
        return _sCache.getToken(SecureConversationCacheHelper.convertUUID(uuid));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String computeKey(MessageContext mCtx) throws SoapSecurityException {
        if (mCtx == null) {
            return null;
        }
        if (clusterName == null && (clusterName = CacheConfigFactory.getInstance().getClusterName()) == null) {
            clusterName = "";
        }
        String appName = null;
        String moduleName = null;
        String toAddr = null;
        ConfigurationContext axisConfigCtx = mCtx.getConfigurationContext();
        if (axisConfigCtx == null) throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s02");
        AxisConfiguration axisConfig = axisConfigCtx.getAxisConfiguration();
        if (axisConfig == null) throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s01");
        Parameter p = axisConfig.getParameter(ConstantsRetrieverFactory.getInstance().getApplicationNameKey());
        if (p != null) {
            appName = (String)p.getValue();
        }
        if ((p = axisConfig.getParameter(ConstantsRetrieverFactory.getInstance().getModuleNameKey())) != null) {
            moduleName = (String)p.getValue();
        }
        EndpointReference endPoint = mCtx.getTo();
        if (endPoint == null) {
            throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s03");
        }
        toAddr = endPoint.getAddress();
        if (appName == null) {
            appName = "J2SE_THIN_CLIENT";
        }
        if (moduleName == null) {
            moduleName = "J2SE_THIN_CLIENT_MODULE";
        }
        if (endPoint == null) {
            throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s03");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusterName=" + clusterName);
            Tr.debug(tc, "appName=" + appName);
            Tr.debug(tc, "moduleName=" + moduleName);
            Tr.debug(tc, "endPoint=" + endPoint);
        }
        String key = clusterName + appName + moduleName + toAddr;
        if (!tc.isEntryEnabled()) return key;
        Tr.exit(tc, "computeKey(MessageContext) returns [" + key + "]");
        return key;
    }

    public static Object getSecurityContextTokenFromCacheByContext(MessageContext mCtx) {
        if (mCtx == null) {
            return null;
        }
        CacheableToken o = null;
        String key = null;
        key = SecureConversationCacheHelper.getClientCacheKeyFromMessage(mCtx);
        if (key != null) {
            o = _sCache.getToken(SecureConversationCacheHelper.convertUUID(key));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting it from message context using session key=[" + key + "], lookup result=[" + o + "]");
            }
        }
        if (o == null && !SERVICE_SCOPE.equalsIgnoreCase(SecureConversationCacheHelper.getSCTScope(mCtx))) {
            try {
                key = SecureConversationCacheHelper.computeKey(mCtx);
                if (key != null) {
                    o = _sCache.getToken(SecureConversationCacheHelper.convertUUID(key));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting it from cache using non-session key=[" + key + "], lookup result=[" + o + "]");
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, CLS_NAME, "getSecurityContextTokenFromCacheByContext_1");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getSecurityContextTokenFromCacheByContext(MessageContext) returns [" + o + "]");
        }
        return o;
    }

    public static Object getSecurityContextTokenFromDBCache(String uuid, long time) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityContextTokenFromDBCache(String uuid = " + uuid);
        }
        Object o = null;
        if (uuid == null) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityContextTokenFromDBCache(String uuid = " + uuid);
        }
        return _sCache.getTokenFromDatabase(SecureConversationCacheHelper.convertUUID(uuid), time);
    }

    public static void setPeristentSecurityContextTokenToCache(String uuid, SCT sct, Object other) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPersistentSecurityContextTokenToCache(String uuid = " + uuid);
        }
        if (uuid == null || uuid.trim().length() == 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting cache using uuid as a key = " + uuid);
        }
        _sCache.cacheToken(SecureConversationCacheHelper.convertUUID(uuid), sct, SecureConversationCacheHelper.getSCTExpirationTimeInMillis(sct));
        String key = sct.getClientID();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting cache using non-session key of " + key);
        }
        if (key != null) {
            _sCache.cacheToken(SecureConversationCacheHelper.convertUUID(key), sct, SecureConversationCacheHelper.getSCTExpirationTimeInMillis(sct));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPersistentSecurityContextTokenToCache(String uuid = " + uuid);
        }
    }

    public static void setSecurityContextTokenToCache(String uuid, MessageContext mCtx, SCT sct, Object other) {
        if (uuid == null || uuid.trim().length() == 0) {
            return;
        }
        if (SERVICE_SCOPE.equalsIgnoreCase(SecureConversationCacheHelper.getSCTScope(mCtx))) {
            if (uuid != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting cache using session key of " + uuid);
                }
                _sCache.cacheToken(SecureConversationCacheHelper.convertUUID(uuid), sct, SecureConversationCacheHelper.getSCTExpirationTimeInMillis(sct));
                SecureConversationCacheHelper.addClientCacheKeyToMessage(mCtx, uuid);
            }
        } else {
            try {
                String key = SecureConversationCacheHelper.computeKey(mCtx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting cache using non-session key of " + key);
                }
                if (key != null) {
                    _sCache.cacheToken(SecureConversationCacheHelper.convertUUID(key), sct, SecureConversationCacheHelper.getSCTExpirationTimeInMillis(sct));
                } else if (mCtx == null && (key = sct.getClientID()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting cache using non-session key of " + key);
                    }
                    _sCache.cacheToken(SecureConversationCacheHelper.convertUUID(key), sct, SecureConversationCacheHelper.getSCTExpirationTimeInMillis(sct));
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, CLS_NAME, "getSecurityContextTokenFromCacheByContext_1");
            }
            if (uuid != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting cache using session key of " + uuid);
                }
                _sCache.cacheToken(SecureConversationCacheHelper.convertUUID(uuid), sct, SecureConversationCacheHelper.getSCTExpirationTimeInMillis(sct));
                SecureConversationCacheHelper.addClientCacheKeyToMessage(mCtx, uuid);
            }
        }
    }

    public static void invalidateCache(String id) {
        if (id == null || id.trim().length() == 0) {
            return;
        }
        Object sctObj = SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(id);
        if (sctObj instanceof SCT) {
            String uuid;
            SCT sct = (SCT)sctObj;
            String uid = sct.getClientID();
            if (uid != null) {
                _sCache.removeToken(SecureConversationCacheHelper.convertUUID(uid));
            }
            if ((uuid = sct.getIdentifier()) != null && !uuid.equals(uid)) {
                _sCache.removeToken(SecureConversationCacheHelper.convertUUID(uuid));
            }
        } else {
            _sCache.removeToken(SecureConversationCacheHelper.convertUUID(id));
        }
    }

    public static void cleanupContexts(MessageContext messageContext) {
        Parameter par;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupContexts(MessageContext) " + messageContext);
        }
        String toAddr = "";
        EndpointReference endPoint = messageContext.getTo();
        if (endPoint != null) {
            toAddr = endPoint.getAddress();
        }
        if (toAddr == null) {
            toAddr = "";
        }
        if (messageContext.getProperty(sessionIdentifier + toAddr) != null) {
            messageContext.setProperty(sessionIdentifier + toAddr, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removed session identifier from message context.");
            }
        }
        if (messageContext.getAxisService() != null && (par = messageContext.getAxisService().getParameter(sessionIdentifier + toAddr)) != null) {
            try {
                messageContext.getAxisService().removeParameter(par);
                Parameter par2 = messageContext.getAxisService().getParameter(sessionIdentifier);
                if (par2 != null) {
                    messageContext.getAxisService().removeParameter(par2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed session identifier from service context.");
                }
            }
            catch (AxisFault af) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContexts(MessageContext) " + messageContext);
        }
    }

    public static void invalidateCache(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateCache(MessageContext) " + messageContext);
        }
        if (messageContext == null) {
            return;
        }
        Object sctObj = SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(messageContext);
        if (sctObj instanceof SCT) {
            String uuid;
            SCT sct = (SCT)sctObj;
            String uid = sct.getClientID();
            if (uid != null) {
                _sCache.removeToken(SecureConversationCacheHelper.convertUUID(uid));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed sct from cache using non-session key = " + uid);
                }
            }
            if ((uuid = sct.getIdentifier()) != null && !uuid.equals(uid)) {
                _sCache.removeToken(SecureConversationCacheHelper.convertUUID(uuid));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed sct from cache using session key = " + uuid);
                }
            }
            SecureConversationCacheHelper.cleanupContexts(messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidateCache(MessageContext) " + messageContext);
        }
    }

    private static String getClientCacheKeyFromMessage(MessageContext mCtx) {
        Parameter par;
        String clientId;
        if (mCtx == null) {
            return null;
        }
        String toAddr = "";
        EndpointReference endPoint = mCtx.getTo();
        if (endPoint != null) {
            toAddr = endPoint.getAddress();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Need endPoint as part of the session key = " + toAddr);
        }
        if (toAddr == null) {
            toAddr = "";
        }
        if ((clientId = (String)mCtx.getProperty(sessionIdentifier + toAddr)) != null && clientId.length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning SecureConversation session id is (message context)" + clientId);
            }
            return clientId;
        }
        if (mCtx.getAxisService() != null && (par = mCtx.getAxisService().getParameter(sessionIdentifier + toAddr)) != null) {
            clientId = (String)par.getValue();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecureConversation session id is " + clientId);
        }
        return clientId;
    }

    private static void addClientCacheKeyToMessage(MessageContext mCtx, String uuid) {
        if (uuid != null && uuid.trim().length() > 0 && mCtx != null) {
            String toAddr = "";
            EndpointReference endPoint = mCtx.getTo();
            if (endPoint != null) {
                toAddr = endPoint.getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Adding endPoint to the session key = " + toAddr);
            }
            if (toAddr == null) {
                toAddr = "";
            }
            mCtx.setProperty(sessionIdentifier + toAddr, uuid);
            Parameter par = new Parameter(sessionIdentifier + toAddr, uuid);
            try {
                mCtx.getAxisService().addParameter(par);
                mCtx.getAxisService().addParameter(new Parameter(sessionIdentifier, uuid));
            }
            catch (Exception e) {
                Tr.debug(tc, "Unable to add client sessionId to AxisContext. ", e);
            }
        }
    }

    private static String getSCTScope(MessageContext mCtx) {
        if (mCtx == null) {
            return null;
        }
        return (String)mCtx.getProperty(sctscope);
    }

    private static String convertUUID(String uuid) {
        String methodName = "convertUUID";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertUUID", uuid);
        }
        String newUUID = null;
        if (jdbcEnabled) {
            newUUID = uuid + "C";
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertUUID", newUUID);
            }
            return newUUID;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertUUID", uuid);
        }
        return uuid;
    }

    private static long getSCTExpirationTimeInMillis(SCT token) {
        String[] inst = token.getInstances();
        int expired = 600000;
        if (inst.length > 0) {
            Date exp = token.getExpiration(inst[0]);
            for (int i = 1; i < inst.length; ++i) {
                if (!token.getExpiration(inst[i]).after(exp)) continue;
                exp = token.getExpiration(inst[i]);
            }
            long start = System.currentTimeMillis();
            long end = exp.getTime();
            expired = new Long(end - start).intValue();
        }
        if (expired < 0) {
            expired = 0;
        }
        expired += new Long(extraTime).intValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT will stay in ccahe for " + expired + " milliseconds");
        }
        return expired;
    }
}

