/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.util.CacheConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;

public class CacheConfigImpl
implements CacheConfig {
    private static long cacheGraceMilliseconds = 600000L;
    private static long cacheCushionMilliseconds = 600000L;
    private static final long cacheCushionMin = 180000L;
    private static long clockSkewMilliseconds = 180000L;
    private static long maxClockSkewMilliseconds = 600000L;
    private static boolean isCacheConfigInitialized = false;
    private static final String cacheGraceProp = Constants.WSSECURITY_SECURECONVERSATION_CACHE_CUSHION;
    private static final String cacheCushionProp = Constants.WSSECURITY_SECURECONVERSATION_CACHE_CUSHION;
    private static final String clockSkewProp = Constants.WSSECURITY_SECURECONVERSATION_CLOCK_SKEW_TOLERANCE;
    private static TraceComponent tc = Tr.register(CacheConfigImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public CacheConfigImpl() {
        CacheConfigImpl.init();
    }

    private static void init() {
        String propValue = System.getProperty(cacheCushionProp);
        if (propValue != null && propValue.trim().length() > 0) {
            long cushionInMilliseconds = new Long(propValue) * 60L * 1000L;
            if (cushionInMilliseconds > 0L) {
                cacheCushionMilliseconds = cushionInMilliseconds < 180000L ? 180000L : cushionInMilliseconds;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cacheCushionMilliseconds=" + cacheCushionMilliseconds);
            }
        }
        if ((propValue = System.getProperty(cacheGraceProp)) != null && propValue.trim().length() > 0) {
            cacheGraceMilliseconds = new Long(propValue) * 60L * 1000L;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cacheGraceMilliseconds = " + cacheGraceMilliseconds);
            }
        }
        if ((propValue = System.getProperty(clockSkewProp)) != null && propValue.trim().length() > 0) {
            long clockSkewInMilliseconds = new Long(propValue) * 60L * 1000L;
            clockSkewMilliseconds = clockSkewInMilliseconds <= maxClockSkewMilliseconds ? clockSkewInMilliseconds : maxClockSkewMilliseconds;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clockSkewMilliseconds = " + clockSkewMilliseconds);
            }
        }
        isCacheConfigInitialized = true;
    }

    @Override
    public long getCacheCushionMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return cacheCushionMilliseconds;
    }

    @Override
    public long getCacheGraceTimeMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return cacheGraceMilliseconds;
    }

    @Override
    public long getClockSkewToleranceMilliseconds() {
        if (!isCacheConfigInitialized) {
            CacheConfigImpl.init();
        }
        return clockSkewMilliseconds;
    }

    @Override
    public boolean isDistributedCache() {
        return false;
    }

    @Override
    public String getJNDIName() {
        return null;
    }

    @Override
    public boolean isJDBCCache() {
        return false;
    }

    @Override
    public boolean isSynchronousClusterUpdate() {
        return false;
    }

    @Override
    public long synchronousClusterTimeoutMilliseconds() {
        return 0L;
    }

    @Override
    public String getClusterName() {
        return null;
    }

    @Override
    public void setPreV70InteropMode(boolean preV70InteropMode) {
    }

    @Override
    public boolean getPreV70InteropMode() {
        return false;
    }
}

