/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.KRBToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSRealmFactory;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KRB5TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;
import org.ietf.jgss.GSSCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSWSSLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(WSWSSLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static String comp = "security.wssecurity";
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map<Object, Object> _context = null;
    private SecurityToken _callerIdentityToken = null;
    private Subject _subject = null;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        this._subject = subject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login() throws LoginException {
        SecurityTokenManagerImpl securityTokenManager;
        SecurityTokenWrapper tokenWrapper;
        Map<String, Object> auditContext;
        MessageContext messageContext;
        QName cit_qn;
        Callback[] callbacks;
        String auditTokenId;
        String auditCallerName;
        SecurityToken trustedIdentityToken;
        CallerConfig config2;
        block61: {
            NameCallback namec;
            String realm;
            block65: {
                block64: {
                    WSCredTokenCallbackImpl wscredc;
                    block63: {
                        block62: {
                            block60: {
                                String username;
                                UsernameToken unt;
                                PasswordCallback passwordc;
                                block59: {
                                    Boolean finishProcess;
                                    if (tc.isEntryEnabled()) {
                                        Tr.entry(tc, "login()");
                                    }
                                    if ((finishProcess = (Boolean)this._sharedState.get(Constants.WSSECURITY_CALLER_PROCESS_DONE)) == null || !finishProcess.booleanValue()) {
                                        String errorMes = ConfigUtil.getMessage(comp + ".LoginProcessor.s01");
                                        throw new LoginException(errorMes);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "It seems that caller identification process is successfully done.");
                                    }
                                    config2 = (CallerConfig)this._sharedState.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
                                    this._callerIdentityToken = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY);
                                    trustedIdentityToken = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY);
                                    auditCallerName = null;
                                    auditTokenId = null;
                                    callbacks = (Callback[])this._sharedState.get("Callback");
                                    if (callbacks != null) {
                                        int il = callbacks.length;
                                        for (int i = 0; i < il; ++i) {
                                            if (!(callbacks[i] instanceof PropertyCallback)) continue;
                                            this._context = ((PropertyCallback)callbacks[i]).getProperties();
                                            break;
                                        }
                                    }
                                    if (this._context == null) {
                                        PropertyCallback propertyCallback = new PropertyCallback(null);
                                        callbacks = new Callback[]{propertyCallback};
                                        try {
                                            this._handler.handle(callbacks);
                                        }
                                        catch (Exception e) {
                                            throw new LoginException(ConfigUtil.getMessage(comp + ".BSTokenLoginModule.s01", new String[]{e.toString()}));
                                        }
                                        this._context = propertyCallback.getProperties();
                                    }
                                    String enforceTokenVersionString = (String)this._context.get("com.ibm.ws.wssecurity.ltpa.enforceTokenVersion");
                                    boolean enforceTokenVersion = ConfigUtil.isTrue(enforceTokenVersionString);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "enforceTokenVersion=" + enforceTokenVersionString);
                                    }
                                    QName ci_qn = config2.getCallerIdentity();
                                    cit_qn = this._callerIdentityToken.getValueType();
                                    if (this._callerIdentityToken == null) {
                                        String errorMes = ConfigUtil.getMessage(comp + ".LoginProcessor.s01");
                                        throw new LoginException(errorMes);
                                    }
                                    if (!cit_qn.equals(ci_qn)) {
                                        if ((com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(ci_qn) || com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(ci_qn)) && (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(cit_qn) || com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(cit_qn)) && !enforceTokenVersion) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Found matching callerIdentityToken for ltpa caller with different version.");
                                            }
                                        } else {
                                            String errorMes = ConfigUtil.getMessage(comp + ".PrivateConsumerConfig.s30", new String[]{cit_qn.toString(), ci_qn.toString()});
                                            throw new LoginException(errorMes);
                                        }
                                    }
                                    if (trustedIdentityToken != null) {
                                        QName ti_qn = config2.getTrustedIdentity();
                                        QName tit_qn = trustedIdentityToken.getValueType();
                                        if (!tit_qn.equals(ti_qn)) {
                                            if ((com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(ti_qn) || com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(ti_qn)) && (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tit_qn) || com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(tit_qn)) && !enforceTokenVersion) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Found matching trustedIdentityToken for ltpa caller with different version.");
                                                }
                                            } else {
                                                String errorMes = ConfigUtil.getMessage(comp + ".PrivateConsumerConfig.s30", new String[]{tit_qn.toString(), ti_qn.toString()});
                                                throw new LoginException(errorMes);
                                            }
                                        }
                                    }
                                    if (tc.isDebugEnabled()) {
                                        QName vt = this._callerIdentityToken.getValueType();
                                        Tr.debug(tc, "Caller identity token [" + vt + "].");
                                        vt = trustedIdentityToken == null ? null : trustedIdentityToken.getValueType();
                                        Tr.debug(tc, "Trusted identity token [" + vt + "].");
                                    }
                                    WSSContextManager contextManager = WSSContextManagerFactory.getInstance();
                                    realm = null;
                                    if (contextManager == null) {
                                        Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
                                    } else {
                                        realm = contextManager.getDefaultRealm();
                                    }
                                    callbacks = new Callback[9];
                                    namec = new NameCallback("Username: ");
                                    callbacks[0] = namec;
                                    passwordc = new PasswordCallback("Password: ", false);
                                    callbacks[1] = passwordc;
                                    wscredc = new WSCredTokenCallbackImpl("Credential Token: ");
                                    callbacks[2] = wscredc;
                                    callbacks[3] = new WSServletRequestCallback("HttpServletRequest: ");
                                    callbacks[4] = new WSServletResponseCallback("HttpServletResponse: ");
                                    callbacks[5] = new WSAppContextCallback("ApplicationContextCallback: ");
                                    callbacks[6] = new WSTokenHolderCallback("Authz Token List: ");
                                    callbacks[7] = new WSRealmNameCallbackImpl("Realm Name", realm);
                                    callbacks[8] = new WSX509CertificateChainCallback("X509Certificate[]: ");
                                    if (!(this._callerIdentityToken instanceof UsernameToken)) break block60;
                                    unt = (UsernameToken)this._callerIdentityToken;
                                    username = unt.getUsername();
                                    if (username == null || username.length() == 0) {
                                        Tr.error(tc, comp + ".WSEC6735E", new Object[]{unt.getValueType().toString(), "Login cancelled: username string is null or empty."});
                                        String errorMes = ConfigUtil.getMessage(comp + ".LoginProcessor.s11", new String[]{"Login cancelled: username string is null or empty."});
                                        throw new LoginException(errorMes);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Realm is = " + realm);
                                    }
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Examine if UsernameToken is realm qualified: " + username);
                                        }
                                        if (!WSSRealmFactory.getInstance().isIdentityRealmQualified(username)) break block59;
                                        if (WSSRealmFactory.getInstance().isIdentityLocal(username)) {
                                            username = WSSRealmFactory.getInstance().getIdentity(username);
                                        } else {
                                            if (!WSSRealmFactory.getInstance().isUserFromTrustedRealm(username)) {
                                                String errorMsg = ConfigUtil.getMessage(comp + ".WSWSSLoginModule.s02", new String[]{username});
                                                throw new LoginException(errorMsg);
                                            }
                                            Hashtable customProperties = (Hashtable)this._sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
                                            if (customProperties == null) {
                                                customProperties = new Hashtable();
                                                this._sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", customProperties);
                                            }
                                            WSSRealmFactory.getInstance().addIdentityAssertionProperties(username, customProperties);
                                        }
                                    }
                                    catch (SoapSecurityException e) {
                                        throw new LoginException(e.getMessage());
                                    }
                                }
                                username = WSSUserRegistryProcessor.removeRealm(realm, username);
                                namec.setName(username);
                                auditCallerName = username;
                                auditTokenId = unt.getId();
                                char[] password = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                    @Override
                                    public Object run() {
                                        return unt.getPassword();
                                    }
                                });
                                passwordc.setPassword(password);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "UsernameToken found.");
                                    Tr.debug(tc, "Username [" + username + "], Password [" + (password == null ? "null" : "not null") + "].");
                                }
                                break block61;
                            }
                            if (!(this._callerIdentityToken instanceof X509Token)) break block62;
                            X509Token x509 = (X509Token)this._callerIdentityToken;
                            String securityName = WSSUserRegistryProcessor.mapCertificate(x509.getCertificate());
                            if (securityName == null || securityName.length() == 0) {
                                securityName = x509.getPrincipal();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "User security from X509BSToken.getPrincipal() [" + securityName + "]");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "User security from UserRegistryProcessor.mapCertificate() [" + securityName + "]");
                            }
                            namec.setName(securityName);
                            auditCallerName = securityName;
                            auditTokenId = x509.getId();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "X509BSToken found.");
                                Tr.debug(tc, "Username [" + securityName + "].");
                            }
                            break block61;
                        }
                        if (!(this._callerIdentityToken instanceof KRBToken)) break block63;
                        final KRB5TokenImpl krbtoken = (KRB5TokenImpl)this._callerIdentityToken;
                        String princ = krbtoken.getTokenPrincipal();
                        if (princ != null && princ.length() != 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found an effective kerberos principal from KRBAuthnToken: " + princ);
                            }
                            namec.setName(princ);
                            auditCallerName = princ;
                            auditTokenId = krbtoken.getId();
                            GSSCredential gCred = null;
                            try {
                                gCred = (GSSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws SoapSecurityException {
                                        return krbtoken.getGSSCredential();
                                    }
                                });
                            }
                            catch (PrivilegedActionException pE) {
                                Tr.error(tc, comp + ".WSSConsumer.s34", new Object[]{pE});
                                throw new LoginException(pE.getException().getMessage());
                            }
                            final GSSCredential gssCred = gCred;
                            final Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                            if (gssCred != null) {
                                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                    @Override
                                    public Object run() {
                                        if (!subject.getPrivateCredentials().contains(gssCred)) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Adding GSSCredential to Subject: " + gssCred.toString());
                                            }
                                            subject.getPrivateCredentials().add(gssCred);
                                        } else if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "GSSCredential already in Subject: " + gssCred.toString());
                                        }
                                        return null;
                                    }
                                });
                            }
                            WSWSSLoginModule.addToSubject(this._context, krbtoken);
                            break block61;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No effective kerberos principal is found from Subject.");
                        }
                        break block61;
                    }
                    if (!(this._callerIdentityToken instanceof LTPAToken)) break block64;
                    final LTPAToken ltpa = (LTPAToken)this._callerIdentityToken;
                    byte[] tokenBytes = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return ltpa.getBinary();
                        }
                    });
                    if (tokenBytes == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Null credential value found for the LTPA token to login.");
                        }
                        String errorMes = ConfigUtil.getMessage(comp + ".LoginProcessor.s11", new String[]{"Null credentials for the LTPA token."});
                        throw new LoginException(errorMes);
                    }
                    auditCallerName = ltpa.getPrincipal();
                    auditTokenId = ltpa.getId();
                    wscredc.setCredToken(tokenBytes);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "LTPA Token found.");
                        Tr.debug(tc, "Credential [" + tokenBytes + "].");
                    }
                    break block61;
                }
                if (!(this._callerIdentityToken instanceof LTPAPropagationToken)) break block65;
                final LTPAPropagationToken ltpap = (LTPAPropagationToken)this._callerIdentityToken;
                WSCredential wsCred = (WSCredential)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return ltpap.getWSCredential();
                    }
                });
                WSPrincipal wsPrinc = ltpap.getWSPrincipal();
                auditCallerName = wsPrinc.toString();
                auditTokenId = ltpap.getId();
                if (wsCred != null) {
                    WSWSSLoginModule.addToSubject(this._context, wsCred);
                    WSWSSLoginModule.addToSubject(this._context, wsPrinc);
                    WSWSSLoginModule.addToSubject(this._context, ltpap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "LTPA Propagation Token found.");
                        Tr.debug(tc, "WSCredential [" + wsCred + "].");
                        Tr.debug(tc, "WSPrincipal [" + wsPrinc + "].");
                    }
                    break block61;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No WSCredential found in LTPA Propagation Token.");
                    }
                    String errorMes = ConfigUtil.getMessage(comp + ".WSEC0168E");
                    throw new LoginException(errorMes);
                }
            }
            SecurityToken token = this._callerIdentityToken;
            String principal = token.getPrincipal();
            if (principal == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null principal value found for the custom token to login.");
                }
                String errorMes = ConfigUtil.getMessage(comp + ".LoginProcessor.s11", new String[]{"Null principal for the custom token."});
                throw new LoginException(errorMes);
            }
            principal = WSSUserRegistryProcessor.removeRealm(realm, principal);
            namec.setName(principal);
            auditCallerName = principal;
            auditTokenId = token.getId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token [" + token.getValueType() + "] found.");
                Tr.debug(tc, "Principal [" + principal + "].");
            }
        }
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean isDelegationAuditRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context);
        boolean isAuthnAuditRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context);
        if (isDelegationAuditRequired && config2.useIdentityAssertion()) {
            messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            auditContext = wssAuditEventGenerator.setAuthnDelegationData(this._context, "DelegationType", "IDENTITY_ASSERTION");
            wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", "");
            wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", auditCallerName);
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "CallerIdentityType", cit_qn.toString());
            if (trustedIdentityToken != null) {
                wssAuditEventGenerator.addExtendedAuditData(auditContext, "TrustedIdentity", trustedIdentityToken.getId());
                wssAuditEventGenerator.addExtendedAuditData(auditContext, "TrustedIdentityType", trustedIdentityToken.getValueType().toString());
            }
            wssAuditEventGenerator.setAuditEventContext(this._context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, this._context);
        }
        if (isAuthnAuditRequired && !config2.useIdentityAssertion()) {
            messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            auditContext = wssAuditEventGenerator.setExtendedAuditData(this._context, "Username", auditCallerName);
            wssAuditEventGenerator.addProviderData(auditContext, config2.getJAASConfig(), "SUCCESS");
            wssAuditEventGenerator.addAuthnTypeData(auditContext, this._callerIdentityToken.getValueType().toString());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "TokenId", auditTokenId);
            wssAuditEventGenerator.setAuditEventContext(this._context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, this._context);
        }
        if ((tokenWrapper = (securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager")).getTokenWrapper(this._callerIdentityToken)) != null) {
            tokenWrapper.setUsedToLogin(true);
        }
        this._sharedState.put("Callback", callbacks);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._context.put(Constants.WSSECURITY_TOKEN_LOGININFO, this._callerIdentityToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final void addToSubject(Map<Object, Object> context, final WSCredential wsCred) {
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPublicCredentials().contains(wsCred)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSCredential to Subject: " + wsCred);
                    }
                    subject.getPublicCredentials().add(wsCred);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential already in Subject: " + wsCred);
                }
                return null;
            }
        });
    }

    private static final void addToSubject(Map<Object, Object> context, final SecurityToken token) {
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrivateCredentials().contains(token)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Token to Subject: " + token);
                    }
                    subject.getPrivateCredentials().add(token);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token already in Subject: " + token);
                }
                return null;
            }
        });
    }

    private static final void addToSubject(Map<Object, Object> context, final WSPrincipal princ) {
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrincipals().contains(princ)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSPrincipal to Subject: " + princ);
                    }
                    subject.getPrincipals().add(princ);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSPrincipal already in Subject: " + princ);
                }
                return null;
            }
        });
    }

    private static final String getPrincipalFromSubject(Map<Object, Object> context, final SecurityToken inToken) {
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        String princ = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Set<Object> set = subject.getPrivateCredentials();
                Object stoken = null;
                if (set != null && !set.isEmpty()) {
                    Iterator<Object> it = set.iterator();
                    boolean otherTokenFound = false;
                    if (inToken instanceof KRBToken) {
                        SecurityToken kToken = null;
                        while (it.hasNext()) {
                            stoken = it.next();
                            if (!(stoken instanceof KRBToken)) continue;
                            otherTokenFound = true;
                            kToken = (SecurityToken)stoken;
                            break;
                        }
                        if (otherTokenFound) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found request Kerberos principal: " + kToken.getPrincipal());
                            }
                            return kToken.getPrincipal();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No request Kerberos principal found in the Subject.");
                            Tr.debug(tc, "Use passed-in token principal instead - " + inToken.getPrincipal());
                        }
                        return inToken.getPrincipal();
                    }
                }
                return null;
            }
        });
        return princ;
    }
}

