/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.wssapi.token.SAMLToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.impl.auth.module.UNTCallerLoginModule;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallerConfig;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;

public class SAMLCallerLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(SAMLCallerLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private Map _sharedState = null;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._sharedState = sharedState;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        boolean ret = true;
        Boolean finishProcess = (Boolean)this._sharedState.get(Constants.WSSECURITY_CALLER_PROCESS_DONE);
        if (finishProcess == null || !finishProcess.booleanValue()) {
            QName caller_qn;
            boolean callerIdentityChecking;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller identification process is not done yet. So the process of this login module is continued.");
            }
            CallerConfig config2 = (CallerConfig)this._sharedState.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
            Collection callerIdentityCandidates = (Collection)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY_CANDIDATES);
            Collection trustedIdentityCandidates = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_CANDIDATES);
            Collection trustedIdentityList = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_LIST);
            SecurityToken callerIdentityToken = null;
            Object trustedIdentityToken = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity Assertion IS NOT used.");
            }
            boolean bl = callerIdentityChecking = SAMLCommonConstants._SAML11_QNAME.equals(caller_qn = NamespaceUtil.getExpectedTargetNamespaceForTokenType(config2.getCallerIdentity())) || SAMLCommonConstants._SAML20_QNAME.equals(caller_qn);
            if (callerIdentityChecking) {
                for (SecurityToken token : callerIdentityCandidates) {
                    if (!(token instanceof SAMLToken)) continue;
                    if (callerIdentityToken != null) {
                        String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                        Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                        if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                            wssAuditEventGenerator.addExtendedAuditData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                            wssAuditEventGenerator.addProviderData(auditContext, UNTCallerLoginModule.class.getName(), "SUCCESS");
                            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        throw new LoginException(errorMes);
                    }
                    callerIdentityToken = token;
                }
                if (callerIdentityToken == null) {
                    String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                    WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                    WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                    Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                    if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                        Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                        wssAuditEventGenerator.addExtendedAuditData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                        wssAuditEventGenerator.addProviderData(auditContext, UNTCallerLoginModule.class.getName(), "SUCCESS");
                        wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                    }
                    throw new LoginException(errorMes);
                }
                finishProcess = Boolean.TRUE;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found caller identity.");
                }
            }
            if (finishProcess != null && finishProcess.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Logged that caller identification process is successfully done.");
                }
                this._sharedState.put(Constants.WSSECURITY_CALLER_PROCESS_DONE, finishProcess);
            }
            if (callerIdentityToken != null) {
                Tr.debug(tc, "Stored the caller identity [" + callerIdentityToken + "].");
                this._sharedState.put(Constants.WSSECURITY_CALLER_IDENTITY, callerIdentityToken);
            }
            if (trustedIdentityToken != null) {
                Tr.debug(tc, "Stored the trusted identity [" + trustedIdentityToken + "].");
                this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY, trustedIdentityToken);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Since caller identification process is successfully done, the process of this login module is skipped.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return ret;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

