/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.impl.auth.callback.TrustedIdentityCallback;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallerConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PreCallerLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(PreCallerLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private CallbackHandler _handler;
    private Map _sharedState;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        TrustedIdentityCallback trustedIdentityCallback = new TrustedIdentityCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{trustedIdentityCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            throw new LoginException(ConfigUtil.getMessage(this.comp + ".BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        Set<String> trustedIdentityList = trustedIdentityCallback.getIdentityList();
        Map<Object, Object> context = propertyCallback.getProperties();
        CallerConfig config2 = (CallerConfig)context.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
        Result[] results = ResultPool.get(context, AuthResult.class);
        int resultsLength = results.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The length of auth results = " + resultsLength);
        }
        if (resultsLength == 0) {
            String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
            throw new LoginException(errorMes);
        }
        HashSet<SecurityToken> callerIdentityCandidates = new HashSet<SecurityToken>();
        HashSet<SecurityToken> trustedIdentityCandidates = new HashSet<SecurityToken>();
        if (config2.useIdentityAssertion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity Assertion IS used.");
            }
            if (config2.trustAnyTrustedIdentity()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Any trusted identity is trusted in an unconditional way.");
                    Tr.debug(tc, "Checking caller identity only...");
                }
                for (int i = 0; i < resultsLength; ++i) {
                    AuthResult result = (AuthResult)results[i];
                    if (!result.isCallerIdentityCandidate() || !result.isCallerToken()) continue;
                    SecurityTokenWrapper tokenWrapper = result.getTokenWrapper();
                    SecurityToken token = tokenWrapper.getSecurityToken();
                    if (token == null) {
                        String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                        throw new LoginException(errorMes);
                    }
                    callerIdentityCandidates.add(token);
                }
                if (callerIdentityCandidates.size() == 0) {
                    String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                    throw new LoginException(errorMes);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trusted identity should be also validated.");
                }
                for (int i = 0; i < resultsLength; ++i) {
                    SecurityToken token;
                    SecurityTokenWrapper tokenWrapper;
                    AuthResult result = (AuthResult)results[i];
                    if (result.isCallerIdentityCandidate() && result.isCallerToken()) {
                        tokenWrapper = result.getTokenWrapper();
                        token = tokenWrapper.getSecurityToken();
                        if (token == null) {
                            String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                            throw new LoginException(errorMes);
                        }
                        callerIdentityCandidates.add(token);
                    }
                    if (!result.isTrustedIdentityCandidate() || !result.isCallerToken()) continue;
                    tokenWrapper = result.getTokenWrapper();
                    token = tokenWrapper.getSecurityToken();
                    if (token == null) {
                        String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                        throw new LoginException(errorMes);
                    }
                    trustedIdentityCandidates.add(token);
                }
                if (callerIdentityCandidates.size() == 0) {
                    String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                    throw new LoginException(errorMes);
                }
                if (trustedIdentityCandidates.size() == 0) {
                    String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                    throw new LoginException(errorMes);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity Assertion IS NOT used.");
                Tr.debug(tc, "Checking caller identity only...");
            }
            for (int i = 0; i < resultsLength; ++i) {
                AuthResult result = (AuthResult)results[i];
                if (!result.isCallerIdentityCandidate() || !result.isCallerToken()) continue;
                SecurityTokenWrapper tokenWrapper = result.getTokenWrapper();
                SecurityToken token = tokenWrapper.getSecurityToken();
                if (token == null) {
                    String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                    throw new LoginException(errorMes);
                }
                callerIdentityCandidates.add(token);
            }
            if (callerIdentityCandidates.size() == 0) {
                String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                throw new LoginException(errorMes);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the callbacks [" + callbacks + "].");
        }
        this._sharedState.put(ConstantsRetrieverFactory.getInstance().getSecurityAuthCallBackKey(), callbacks);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the caller configuration [" + config2 + "].");
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey", config2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the caller identity candidates [" + callerIdentityCandidates + "].");
        }
        this._sharedState.put(Constants.WSSECURITY_CALLER_IDENTITY_CANDIDATES, callerIdentityCandidates);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the trusted identity candidates [" + trustedIdentityCandidates + "].");
        }
        this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY_CANDIDATES, trustedIdentityCandidates);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the context in the shared state [" + context + "].");
        }
        this._sharedState.put("com.ibm.ws.wssauditeventgenerator.localcontext", context);
        if (trustedIdentityList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stored the trusted identity list [" + trustedIdentityList + "].");
            }
            this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY_LIST, trustedIdentityList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

