/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQ1510Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQ4120Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_APREQToken;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQ1510Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQ4120Token;
import com.ibm.websphere.wssecurity.wssapi.token.KRB5_GSSAPREQToken;
import com.ibm.websphere.wssecurity.wssapi.token.KRBToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.impl.auth.module.UNTCallerLoginModule;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallerConfig;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;

public class KRBCallerLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(KRBCallerLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private Map _sharedState;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._sharedState = sharedState;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        boolean ret = true;
        Boolean finishProcess = (Boolean)this._sharedState.get(Constants.WSSECURITY_CALLER_PROCESS_DONE);
        if (finishProcess == null || !finishProcess.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller identification process is not done yet. So the process of this login module is continued.");
            }
            CallerConfig config2 = (CallerConfig)this._sharedState.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
            Collection callerIdentityCandidates = (Collection)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY_CANDIDATES);
            Collection trustedIdentityCandidates = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_CANDIDATES);
            Collection trustedIdentityList = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_LIST);
            SecurityToken callerIdentityToken = null;
            SecurityToken trustedIdentityToken = null;
            if (config2.useIdentityAssertion()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identity Assertion IS used.");
                }
                if (config2.trustAnyTrustedIdentity()) {
                    QName caller_qn;
                    boolean callerIdentityChecking;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Any trusted identity is trusted in an unconditional way.");
                        Tr.debug(tc, "Checking caller identity only...");
                    }
                    boolean bl = callerIdentityChecking = KRB5_APREQToken.ValueType.equals(caller_qn = config2.getCallerIdentity()) || KRB5_APREQ1510Token.ValueType.equals(caller_qn) || KRB5_APREQ4120Token.ValueType.equals(caller_qn) || KRB5_GSSAPREQToken.ValueType.equals(caller_qn) || KRB5_GSSAPREQ1510Token.ValueType.equals(caller_qn) || KRB5_GSSAPREQ4120Token.ValueType.equals(caller_qn);
                    if (callerIdentityChecking) {
                        WSSAuditService wssAuditService;
                        String errorMes;
                        for (SecurityToken token : callerIdentityCandidates) {
                            if (!(token instanceof KRBToken)) continue;
                            if (callerIdentityToken != null) {
                                String errorMes2 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                                WSSAuditService wssAuditService2 = WSSContextManagerFactory.getInstance().getAuditService();
                                WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                                Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                                if (wssAuditService2.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                    Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes2);
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                }
                                throw new LoginException(errorMes2);
                            }
                            callerIdentityToken = token;
                        }
                        if (callerIdentityToken == null) {
                            errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                            wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                            Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                            if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                            }
                            throw new LoginException(errorMes);
                        }
                        if (trustedIdentityCandidates.size() == 0) {
                            errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                            wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                            Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                            if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                            }
                            throw new LoginException(errorMes);
                        }
                        finishProcess = Boolean.TRUE;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found caller identity.");
                        }
                    }
                } else {
                    SecurityToken token;
                    QName tidentity_qn;
                    boolean trustedIdentityChecking;
                    QName caller_qn;
                    boolean callerIdentityChecking;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trusted identity should be also validated.");
                    }
                    boolean bl = callerIdentityChecking = KRB5_APREQToken.ValueType.equals(caller_qn = config2.getCallerIdentity()) || KRB5_APREQ1510Token.ValueType.equals(caller_qn) || KRB5_APREQ4120Token.ValueType.equals(caller_qn) || KRB5_GSSAPREQToken.ValueType.equals(caller_qn) || KRB5_GSSAPREQ1510Token.ValueType.equals(caller_qn) || KRB5_GSSAPREQ4120Token.ValueType.equals(caller_qn);
                    if (callerIdentityChecking) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking both caller identity and trusted identity...");
                        }
                        if (trustedIdentityList == null) {
                            String errorMes = ConfigUtil.getMessage(this.comp + ".WSEC6842E");
                            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                            Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                            if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                            }
                            throw new LoginException(errorMes);
                        }
                        for (SecurityToken token2 : callerIdentityCandidates) {
                            if (!(token2 instanceof KRBToken)) continue;
                            if (callerIdentityToken != null) {
                                String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                                WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                                WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                                Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                                if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                    Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                }
                                throw new LoginException(errorMes);
                            }
                            callerIdentityToken = token2;
                        }
                        if (callerIdentityToken == null) {
                            String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                            Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                            if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                            }
                            throw new LoginException(errorMes);
                        }
                    }
                    boolean bl2 = trustedIdentityChecking = KRB5_APREQToken.ValueType.equals(tidentity_qn = config2.getTrustedIdentity()) || KRB5_APREQ1510Token.ValueType.equals(tidentity_qn) || KRB5_APREQ4120Token.ValueType.equals(tidentity_qn) || KRB5_GSSAPREQToken.ValueType.equals(tidentity_qn) || KRB5_GSSAPREQ1510Token.ValueType.equals(tidentity_qn) || KRB5_GSSAPREQ4120Token.ValueType.equals(tidentity_qn);
                    if (trustedIdentityChecking) {
                        for (SecurityToken token3 : trustedIdentityCandidates) {
                            if (!(token3 instanceof KRBToken)) continue;
                            String identity = token3.getPrincipal();
                            if (!trustedIdentityList.contains(identity)) {
                                String errorMes = identity + "is not a trusted id";
                                WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                                WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                                Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                                if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                    Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                }
                                throw new LoginException(errorMes);
                            }
                            if (trustedIdentityToken != null) {
                                String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s04");
                                WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                                WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                                Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                                if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                    MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                    Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                    wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                    wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                }
                                throw new LoginException(errorMes);
                            }
                            trustedIdentityToken = token3;
                        }
                        if (trustedIdentityToken == null) {
                            String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                            Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                            if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "RoleName", config2.getTrustedIdentity().toString());
                                wssAuditEventGenerator.addAuthnDelegationData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                            }
                            throw new LoginException(errorMes);
                        }
                    }
                    if (callerIdentityChecking && trustedIdentityChecking) {
                        finishProcess = Boolean.TRUE;
                    } else if (callerIdentityChecking) {
                        token = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY);
                        if (token != null) {
                            finishProcess = Boolean.TRUE;
                        }
                    } else if (trustedIdentityChecking && (token = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY)) != null) {
                        finishProcess = Boolean.TRUE;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found both caller identity and trusted identity.");
                    }
                }
            } else {
                QName caller_qn;
                boolean callerIdentityChecking;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identity Assertion IS NOT used.");
                }
                boolean bl = callerIdentityChecking = KRB5_APREQToken.ValueType.equals(caller_qn = config2.getCallerIdentity()) || KRB5_APREQ1510Token.ValueType.equals(caller_qn) || KRB5_APREQ4120Token.ValueType.equals(caller_qn) || KRB5_GSSAPREQToken.ValueType.equals(caller_qn) || KRB5_GSSAPREQ1510Token.ValueType.equals(caller_qn) || KRB5_GSSAPREQ4120Token.ValueType.equals(caller_qn);
                if (callerIdentityChecking) {
                    for (SecurityToken token : callerIdentityCandidates) {
                        if (!(token instanceof KRBToken)) continue;
                        if (callerIdentityToken != null) {
                            String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                            Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                            if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                                wssAuditEventGenerator.addExtendedAuditData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                                wssAuditEventGenerator.addProviderData(auditContext, UNTCallerLoginModule.class.getName(), "SUCCESS");
                                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                            }
                            throw new LoginException(errorMes);
                        }
                        callerIdentityToken = token;
                    }
                    if (callerIdentityToken == null) {
                        String errorMes = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
                        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
                        Map context = (Map)this._sharedState.get("com.ibm.ws.wssauditeventgenerator.localcontext");
                        if (wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context)) {
                            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            Map<String, Object> auditContext = wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, errorMes);
                            wssAuditEventGenerator.addExtendedAuditData(auditContext, "IdentityName", config2.getCallerIdentity().toString());
                            wssAuditEventGenerator.addProviderData(auditContext, UNTCallerLoginModule.class.getName(), "SUCCESS");
                            wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                        }
                        throw new LoginException(errorMes);
                    }
                    finishProcess = Boolean.TRUE;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found caller identity.");
                    }
                }
            }
            if (finishProcess != null && finishProcess.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Logged that caller identification process is successfully done.");
                }
                this._sharedState.put(Constants.WSSECURITY_CALLER_PROCESS_DONE, finishProcess);
            }
            if (callerIdentityToken != null) {
                Tr.debug(tc, "Stored the caller identity [" + callerIdentityToken + "].");
                this._sharedState.put(Constants.WSSECURITY_CALLER_IDENTITY, callerIdentityToken);
            }
            if (trustedIdentityToken != null) {
                Tr.debug(tc, "Stored the trusted identity [" + trustedIdentityToken + "].");
                this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY, trustedIdentityToken);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Since caller identification process is successfully done, the process of this login module is skipped.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return ret;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

