/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;

public class X509BSCallback
implements Callback {
    private static final TraceComponent tc = Tr.register(X509BSCallback.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String compName = "security.wssecurity";
    private X509Certificate _cert;
    private byte[] _binary;
    private String _keyStorePath;
    private String _alias;

    public void setCert(X509Certificate cert) {
        this._cert = cert;
    }

    public X509Certificate getCert() {
        return this._cert;
    }

    public void setBinary(byte[] binary) {
        this._binary = binary;
    }

    public byte[] getBinary() {
        if (this._binary == null) {
            try {
                this._binary = this._cert == null ? null : this._cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                Tr.error(tc, "security.wssecurity.WSEC0155E", e);
                this._binary = null;
            }
        }
        return this._binary;
    }

    public void setKeyStorePath(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    public String getKeyStorePath() {
        return this._keyStorePath;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getAlias() {
        return this._alias;
    }
}

