/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;

public class WSX509CertificateChainCallback
implements Callback {
    private X509Certificate[] _certChain;
    private String prompt;
    private static final TraceComponent tc = Tr.register(WSX509CertificateChainCallback.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public WSX509CertificateChainCallback(String prompt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSX509CertificateChainCallback(prompt = \"" + prompt + "\")");
        }
        this.prompt = prompt;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSX509CertificateChainCallback(prompt)");
        }
    }

    public WSX509CertificateChainCallback(String prompt, X509Certificate[] certChain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSX509CertificateChainCallback(prompt = \"" + prompt + "\"");
        }
        this.prompt = prompt;
        this._certChain = certChain;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSX509CertificateChainCallback(prompt, certChain)");
        }
    }

    public void setX509CertificateChain(X509Certificate[] certChain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setX509CertificateChain(chain)");
        }
        this._certChain = certChain;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setX509CertificateChain(chain)");
        }
    }

    public X509Certificate[] getX509CertificateChain() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509CertificateChain()");
            Tr.exit(tc, "getX509CertificateChain()");
        }
        return this._certChain;
    }

    public String getPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrompt()");
            Tr.exit(tc, "getPrompt() -> " + this.prompt);
        }
        return this.prompt;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString()");
            Tr.debug(tc, "Certificate name: " + (this._certChain == null ? "chain is null" : this._certChain[0].getIssuerDN().getName()));
            Tr.exit(tc, "toString() -> " + this.getClass().getName());
        }
        return this.getClass().getName();
    }
}

