/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.common.SCAndTrustConstants;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.client.impl.TrustClientFactory;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSTokenUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSNonceGenerator;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT13;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;

public class WSTrustCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSTrustCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSTrustCallbackHandler.class.getName();
    private static long cushion = CacheConfigFactory.getInstance().getCacheCushionMilliseconds();
    private static boolean jdbcEnabled = CacheConfigFactory.getInstance().isJDBCCache();
    private static long clockSkew = CacheConfigFactory.getInstance().getClockSkewToleranceMilliseconds();
    private CallbackHandlerConfig _config = null;
    private static Map clientIDMap = new HashMap();

    public WSTrustCallbackHandler() {
    }

    public WSTrustCallbackHandler(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSTrustCallbackHandler(Map properties)");
        }
        if (properties == null) {
            Tr.error(tc, "context passed into the callback handler is null.");
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
            if (this._config == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The configuration of callback handler is null.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
            Tr.debug(tc, "JDBC Enabled = " + jdbcEnabled);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSTrustCallbackHandler(Map properties)");
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        boolean isServerSide;
        SCT sctoken;
        boolean isCancel;
        String tokenType;
        SCTWrapper sctWrapper;
        MessageContext msgCtx;
        HashMap<Object, Object> context;
        SCTCallback sctcb;
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(Callback[] callbacks)");
            }
            if (callbacks == null || callbacks.length == 0) {
                throw new UnsupportedCallbackException(null, "There is no callback.");
            }
            sctcb = null;
            context = new HashMap<Object, Object>(45);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, callbacks.length + " callbacks");
            }
            for (int i = 0; i < callbacks.length; ++i) {
                Map<Object, Object> pc;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "callbacks[" + i + "] is " + callbacks[i].getClass().getName());
                }
                if (callbacks[i] instanceof SCTCallback) {
                    sctcb = (SCTCallback)callbacks[i];
                    sctcb.setExist(true);
                    continue;
                }
                if (!(callbacks[i] instanceof PropertyCallback) || (pc = ((PropertyCallback)callbacks[i]).getProperties()) == null) continue;
                context.putAll(pc);
            }
            if (sctcb == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handle(Callback[] callbacks) not required.");
                }
                return;
            }
            msgCtx = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            sctWrapper = null;
            AxisService aService = (AxisService)context.get("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_AXIS_SERVICE");
            TokenGeneratorConfig tconfig = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenGeneratorConfig [" + tconfig + "].");
            }
            tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
            if (tconfig != null) {
                tokenType = tconfig.getType().getLocalPart();
                tokenType = tconfig.getType().getLocalPart();
                if (tokenType != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "SCT version =  [" + tokenType + "].");
                }
            }
            String sctCancel = (String)context.get("com.ibm.ws.wssecurity.sc.SCT.Cancel");
            isCancel = false;
            if (sctCancel != null && sctCancel.equalsIgnoreCase("true")) {
                isCancel = true;
            }
            sctoken = (SCT)context.get("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_SCT");
            if (isCancel) {
                tokenType = sctoken.getValueType().getLocalPart();
                cushion = 0L;
            }
            isServerSide = false;
            try {
                if (msgCtx != null) {
                    isServerSide = Axis2Util.isServiceProvider(msgCtx);
                    break block26;
                }
                if (aService != null) {
                    isServerSide = Axis2Util.isServiceProvider(aService);
                    break block26;
                }
                throw new UnsupportedCallbackException(null, " Unknown Context or Service.");
            }
            catch (Exception e) {
                throw new UnsupportedCallbackException(null, e.getMessage());
            }
        }
        if (!isCancel && (sctWrapper = (SCTWrapper)msgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCTInUse")) != null && sctWrapper.getSCT() != null && context.get("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_SCT") == null) {
            sctWrapper = (SCTWrapper)msgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCTInUse");
            String instanceInUse = sctWrapper.getCurrentInstance();
            sctoken = sctWrapper.getSCT();
            Date now = new Date();
            if (!sctoken.isCancelled() && sctoken.getExpiration(instanceInUse).getTime() - now.getTime() > 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid SCT is already in use by this handler. Use the reference");
                }
                sctcb.setToken(sctWrapper);
                sctcb.setExist(true);
                msgCtx.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, sctoken.getValueType().getLocalPart());
                return;
            }
            sctWrapper = null;
            sctoken = null;
        }
        String sctScope = null;
        String sctValidate = null;
        if (this._config != null && msgCtx != null) {
            sctScope = (String)this._config.getProperties().get("com.ibm.ws.wssecurity.sc.SCTScope");
            sctValidate = (String)this._config.getProperties().get("com.ibm.ws.wssecurity.sc.useSCTValidate");
            msgCtx.setProperty("com.ibm.ws.wssecurity.sc.SCTScope", sctScope);
            msgCtx.setProperty("com.ibm.ws.wssecurity.sc.useSCTValidate", sctValidate);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT Scope property = " + sctScope);
            Tr.debug(tc, "SCT validate property = " + sctValidate);
        }
        context.put(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenType);
        sctWrapper = isServerSide ? this.getServerSideSCT(context, msgCtx) : this.getClientSideSCT(context, msgCtx, sctoken, isCancel);
        if (msgCtx != null) {
            msgCtx.setProperty("com.ibm.ws.wssecurity.sc.SCTInUse", sctWrapper);
            if (msgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCTScope") != null) {
                msgCtx.setProperty("com.ibm.ws.wssecurity.sc.SCTScope", null);
            }
        }
        sctcb.setToken(sctWrapper);
        sctcb.setExist(true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Succeeded to get necessary information through the callbacks.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }

    private SCTWrapper getClientSideSCT(HashMap context, MessageContext msgCtx, SCT sctoken, boolean isCancel) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "client side. Getting SCToken");
        }
        if (sctoken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client side. Getting SCToken from global cache");
            }
            sctoken = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(msgCtx);
        }
        SCTWrapper sctWrapper = null;
        boolean isTokenValid = false;
        boolean isRenew = false;
        boolean isIssue = false;
        boolean isCancelled = false;
        boolean cancelStill = this.isCancelInProgress(msgCtx);
        if (!cancelStill && sctoken != null) {
            isCancelled = sctoken.isCancelled();
        }
        String instanceInUse = null;
        String sctValidate = null;
        boolean sctStatus = true;
        Date now = new Date();
        if (sctoken != null) {
            if (msgCtx != null && (sctValidate = (String)msgCtx.getProperty("com.ibm.ws.wssecurity.sc.useSCTValidate")) != null && "true".equalsIgnoreCase(sctValidate)) {
                try {
                    sctStatus = this.validateSCT(sctoken, context, msgCtx);
                }
                catch (SoapSecurityException sse) {
                    // empty catch block
                }
                if (!sctStatus) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security context token is not valid per Validate call.. issue new token");
                    }
                    isIssue = true;
                }
            }
            if ((instanceInUse = this.searchInstanceList(sctoken)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security context token is expired, try to renew the token");
                }
                if (!sctoken.isRenewableAfterExpiration()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security Context Token is expired and is not renewable after expiration.");
                    }
                    Tr.info(tc, "security.wssecurity.WSTrustCallbackHandler.expiredSCT");
                    isIssue = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security context token is expired, try to renew the token");
                    }
                    isRenew = true;
                }
            } else if (!isCancelled) {
                if (sctoken.isValid(instanceInUse, 0L)) {
                    if (sctoken.getExpiration(instanceInUse).getTime() - now.getTime() > cushion) {
                        isTokenValid = true;
                        sctWrapper = this.createSCTWrapper(sctoken, instanceInUse);
                        sctWrapper.setSCT(sctoken);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client side cache. Security context token is a valid token and instance = " + instanceInUse);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client side cache. Security context token is about to expire. Renew the token");
                        }
                        if (jdbcEnabled) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "JDBC Database Cache enabled....");
                            }
                            long timeout = sctoken.getExpiration(instanceInUse).getTime() - sctoken.getCreation(instanceInUse).getTime();
                            if ((sctoken = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromDBCache(sctoken.getIdentifier(), timeout)) != null) {
                                instanceInUse = this.searchInstanceList(sctoken);
                            }
                            if (instanceInUse != null) {
                                if (sctoken.getExpiration(instanceInUse).getTime() - now.getTime() > cushion) {
                                    isTokenValid = true;
                                    sctWrapper = this.createSCTWrapper(sctoken, instanceInUse);
                                    sctWrapper.setSCT(sctoken);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Client side cache. Security context token is a valid token and instance = " + instanceInUse);
                                    }
                                } else if (sctoken.isRenewable()) {
                                    isRenew = true;
                                } else {
                                    Tr.info(tc, "security.wssecurity.WSEC7235I");
                                    isIssue = true;
                                }
                            } else {
                                Tr.info(tc, "security.wssecurity.WSEC7235I");
                                isIssue = true;
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "JDBC Database Cache is not enabled....");
                            }
                            if (sctoken.isRenewable()) {
                                isRenew = true;
                            } else {
                                Tr.info(tc, "security.wssecurity.WSEC7235I");
                                isIssue = true;
                            }
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security context token is expired, try to renew the token");
                    }
                    if (!sctoken.isRenewableAfterExpiration()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security Context Token is expired and is not renewable after expiration.");
                        }
                        Tr.info(tc, "security.wssecurity.WSTrustCallbackHandler.expiredSCT");
                        isIssue = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security context token is expired, renewing the token");
                        }
                        isRenew = true;
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SCT is cancelled, issuing new SCT");
                }
                isIssue = true;
            }
        } else {
            isIssue = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Security Context Token found in  client side cache, Issue new SCT.");
            }
        }
        if (isIssue && isCancel) {
            Tr.info(tc, "security.wssecurity.WSEC7234I");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified SCT for cancel is either invalidated or could not be renewed. Cancel is not processed.");
            }
            return sctWrapper;
        }
        try {
            if (isIssue || isRenew) {
                String cacheKey = null;
                boolean waitForCache = false;
                String id = null;
                if (!"SERVICE_SCOPE".equalsIgnoreCase((String)msgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCTScope")) && (id = SecureConversationCacheHelper.computeKey(msgCtx)) != null) {
                    waitForCache = WSTrustCallbackHandler.hasBeenRequested(id);
                }
                if (waitForCache) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Other thread already obtain SCT for this client. Getting SCT from cache now.");
                    }
                    sctoken = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(msgCtx);
                    instanceInUse = this.searchInstanceList(sctoken);
                    sctWrapper = this.createSCTWrapper(sctoken, instanceInUse);
                    sctWrapper.setSCT(sctoken);
                } else {
                    try {
                        boolean pre70InteropMode = false;
                        pre70InteropMode = CacheConfigFactory.getInstance().getPreV70InteropMode();
                        sctWrapper = this.obtainSCT(msgCtx, sctoken, context, isIssue, isRenew, isCancel);
                        sctoken = sctWrapper.getSCT();
                        cacheKey = sctoken.getIdentifier() + sctWrapper.getCurrentInstance();
                        SCT sctokenAlreadyIssued = null;
                        if (isIssue) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SCT might have been already issued. Look for it in the cache again!");
                            }
                            if ((sctokenAlreadyIssued = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(msgCtx)) != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SCT is already issued for this client andservice end point.");
                                }
                                if (sctokenAlreadyIssued.isValid(instanceInUse = this.searchInstanceList(sctokenAlreadyIssued), 0L) && sctokenAlreadyIssued.getExpiration(instanceInUse).getTime() - now.getTime() > cushion) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "SCT is already issued for this client and is valid");
                                    }
                                    sctoken = sctokenAlreadyIssued;
                                    sctWrapper = this.createSCTWrapper(sctoken, instanceInUse);
                                    sctWrapper.setSCT(sctoken);
                                }
                            }
                            boolean isTokenCreatedInFuture = false;
                            isTokenCreatedInFuture = this.isSCTCreatedWithFutureTimeStamp(sctWrapper);
                            if (isTokenCreatedInFuture) {
                                throw new SoapSecurityException("Security Context Token is created with future timestamp and is not valid.");
                            }
                        }
                        SecureConversationCacheHelper.setSecurityContextTokenToCache(sctoken.getIdentifier(), msgCtx, sctoken, null);
                        if (isRenew && !pre70InteropMode) {
                            SecureConversationCacheHelper.setSecurityContextTokenToCache(cacheKey, null, sctoken, null);
                        }
                        WSTrustCallbackHandler.wakeupOtherRequests(id);
                    }
                    catch (Exception e) {
                        if (id != null) {
                            WSTrustCallbackHandler.wakeupOtherRequests(id);
                        }
                        throw new SoapSecurityException(e.getMessage());
                    }
                }
            }
            if (isCancel) {
                sctWrapper = this.cancelSCToken(context, sctoken);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getClientSideSCT(Map, MessageContext, SCT, boolean). SCT cancelled.");
                }
                return sctWrapper;
            }
        }
        catch (SoapSecurityException sse) {
            throw new IOException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.issueSCT", new String[]{sse.toString()}));
        }
        if (sctoken != null) {
            if (sctoken.getExpiration(sctWrapper.getCurrentInstance()).getTime() - sctoken.getCreation(sctWrapper.getCurrentInstance()).getTime() < cushion) {
                Tr.error(tc, "security.wssecurity.WSTrustCallbackHandler.clientCushionAndSCT");
                throw new IOException(ConfigUtil.getMessage("security.wssecurity.WSTrustCallbackHandler.clientCushionAndSCT"));
            }
            HashMap<String, String> wssMap = null;
            wssMap = (HashMap<String, String>)msgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (wssMap == null) {
                wssMap = new HashMap<String, String>();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Save the sct uuid and instance in the wss-ramp propertymap");
                }
            }
            wssMap.put("com.ibm.ws.wssecurity.sc.CurrentInstance", sctWrapper.getCurrentInstance());
            wssMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, sctoken.getUUID());
            msgCtx.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssMap);
            String tokenType = sctoken.getValueType().getLocalPart();
            msgCtx.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenType);
        }
        return sctWrapper;
    }

    private SCTWrapper obtainSCT(MessageContext msgCtx, SCT sctoken, HashMap context, boolean isIssue, boolean isRenew, boolean isCancel) throws SoapSecurityException {
        SCTWrapper sctWrapper = null;
        if (isIssue) {
            sctWrapper = this.issueSCToken(msgCtx, context);
        } else if (isRenew) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT is expired or about to expire = " + sctoken.getUUID());
            }
            try {
                sctWrapper = this.renewSCToken(msgCtx, context, sctoken);
            }
            catch (Exception ex) {
                isIssue = true;
                if (isCancel) {
                    Tr.info(tc, "security.wssecurity.WSEC7234I");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified SCT for cancel is either invalidated or could not be renewed. Cancel is not processed.");
                    }
                    return sctWrapper;
                }
                Tr.info(tc, "security.wssecurity.WSEC7235I");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified SCT " + sctoken.getIdentifier() + " could not be renewed. " + "A new SCT will be issued." + ex.toString());
                }
                sctWrapper = this.issueSCToken(msgCtx, context);
            }
        }
        return sctWrapper;
    }

    private SCTWrapper getServerSideSCT(HashMap context, MessageContext msgCtx) throws IOException {
        String uuid = null;
        String instanceInUse = null;
        HashMap wssMap = null;
        SCTWrapper sctWrapper = null;
        SCT sctoken = null;
        String tokenType = null;
        boolean pre70InteropMode = false;
        pre70InteropMode = CacheConfigFactory.getInstance().getPreV70InteropMode();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting SCT from trust service directly.");
        }
        uuid = TokenHolder.getTokenFromContext("com.ibm.ws.wssecurity.sc.InboundSCT", msgCtx);
        instanceInUse = (String)Axis2Util.getProperty(msgCtx, "com.ibm.ws.wssecurity.sc.InstanceFromMessage");
        tokenType = (String)Axis2Util.getProperty(msgCtx, "tokenVTypeFromInboundMessage");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found SCT uuid in inbound message context: " + uuid);
            Tr.debug(tc, "Found Key instance uuid in inbound message context: " + instanceInUse);
            Tr.debug(tc, "Found token type in inbound message context: " + tokenType);
        }
        if (uuid == null && (wssMap = (HashMap)msgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP")) != null) {
            uuid = (String)wssMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
            tokenType = (String)wssMap.get("tokenVTypeFromInboundMessage");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found SCT uuid in WSS_RAMP_PROPERTYMAP:" + uuid);
                Tr.debug(tc, "Found SCT token type in WSS_RAMP_PROPERTYMAP: " + tokenType);
            }
        }
        if (tokenType == null) {
            tokenType = (String)context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
        } else {
            msgCtx.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT version =  [" + tokenType + "].");
        }
        if (uuid != null) {
            String cacheKey = null;
            boolean useCacheKey = false;
            if (instanceInUse != null && !pre70InteropMode) {
                cacheKey = uuid + instanceInUse;
                useCacheKey = true;
            } else {
                cacheKey = uuid;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT cache key =  [" + cacheKey + "].");
            }
            if (SCTHelper.getCache() != null) {
                sctoken = (SCT)SCTHelper.getCache().getToken(cacheKey);
            }
            if (sctoken == null) {
                sctoken = (SCT)STSTokenUtil.getToken(cacheKey, tokenType);
            }
            if (sctoken == null) {
                sctoken = (SCT)SCTHelper.getCache().getToken(uuid);
            }
            Date now = new Date();
            if (instanceInUse == null) {
                instanceInUse = this.searchExistingInstance(sctoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using latest key instance (since we cannot get instance from mc):" + instanceInUse);
                }
            }
            if (!(sctoken == null || sctoken.isValid(instanceInUse, 0L) && sctoken.getExpiration(instanceInUse).getTime() - now.getTime() >= cushion * 3L / 5L)) {
                if (jdbcEnabled) {
                    long timeout = 3600000L;
                    sctoken = (SCT)SCTHelper.getCache().getTokenFromDatabase(uuid, timeout);
                    instanceInUse = this.searchExistingInstance(sctoken);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using latest key instance (must do this for RAMP...):" + instanceInUse);
                    }
                } else if (useCacheKey) {
                    if (SCTHelper.getCache() != null) {
                        sctoken = (SCT)SCTHelper.getCache().getToken(uuid);
                    }
                    if (sctoken == null) {
                        sctoken = (SCT)STSTokenUtil.getToken(uuid, tokenType);
                    }
                    instanceInUse = this.searchExistingInstance(sctoken);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using latest key instance (must do this for RAMP...):" + instanceInUse);
                    }
                }
            }
        }
        if (sctoken == null) {
            Tr.error(tc, "security.wssecurity.SCTConsumeLoginModule.invalidSCT03");
            throw new IOException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server side. Got SCToken from message context and uuid = " + sctoken.getUUID());
            Tr.debug(tc, "Got token from message context and instance = " + instanceInUse);
        }
        if (sctoken.isValid(instanceInUse, 0L) && !sctoken.isCancelled()) {
            sctWrapper = this.createSCTWrapper(sctoken, instanceInUse);
            sctWrapper.setSCT(sctoken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server side. Security context token is a valid token");
            }
        } else {
            throw new IOException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
        }
        return sctWrapper;
    }

    private SCTWrapper issueSCToken(MessageContext mCtx, HashMap context) throws SoapSecurityException {
        ITrustClient trustClient;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "issueSCToken()");
        }
        String trustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
        ConfigurationContext cContext = null;
        String soapLevel = null;
        String serviceEndpointAddress = null;
        String wsa_ns = null;
        SCT sctoken = null;
        SCTWrapper sctWrapper = null;
        boolean isBootstrapRequired = false;
        String renewable = "true";
        String renewableAfterExpiration = "false";
        String tokenVType = null;
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        if (tc.isDebugEnabled() && gconfig == null) {
            Tr.debug(tc, "null WSSGenerator Config object");
        }
        tokenVType = (String)context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
        cContext = mCtx.getConfigurationContext();
        if (tc.isDebugEnabled()) {
            if (!cContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                Iterator ite = cContext.getAxisConfiguration().getEngagedModules().iterator();
                while (ite.hasNext()) {
                    Tr.debug(tc, "Engaged Module = ", ite.next());
                }
            }
            if (gconfig == null) {
                Tr.debug(tc, "Null security generator config to new message context");
            } else {
                Tr.debug(tc, "Valid security generator config to new message context");
            }
        }
        String algorithmSuite = null;
        if (gconfig != null && ((PrivateGeneratorConfig)gconfig).getBootstrapGeneratorConfig() != null && ((PrivateGeneratorConfig)gconfig).getBootstrapConsumerConfig() != null) {
            isBootstrapRequired = true;
            algorithmSuite = ((PolicyOutboundConfig)gconfig).getAlgorithmSuite();
        }
        if (gconfig != null) {
            serviceEndpointAddress = ((PolicyOutboundConfig)gconfig).getSCTIssuer();
            if (tc.isDebugEnabled() && serviceEndpointAddress != null && serviceEndpointAddress.length() > 0) {
                Tr.debug(tc, "SCT Issuer from policy is:" + serviceEndpointAddress);
            }
        }
        if (serviceEndpointAddress == null || serviceEndpointAddress.length() == 0) {
            if (mCtx.getTo() != null) {
                serviceEndpointAddress = mCtx.getTo().getAddress();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The End Point Address (from mc) is: " + serviceEndpointAddress);
                }
            } else {
                Options options = mCtx.getOptions();
                if (options != null) {
                    serviceEndpointAddress = options.getTo().getAddress();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The End Point Address (from options, from mc returns null) is: " + serviceEndpointAddress);
                }
            }
        }
        soapLevel = mCtx.getEnvelope().getNamespace().getName();
        wsa_ns = (String)mCtx.getProperty("WSAddressingVersion");
        if (wsa_ns == null || wsa_ns.length() == 0) {
            wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + wsa_ns);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Namespace for WS-Addressing [" + wsa_ns + "]. This will be set on trust service request");
        }
        TokenGeneratorConfig tconfig = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        String tolerateWSFPTrustRequest = null;
        if (tconfig != null) {
            tolerateWSFPTrustRequest = (String)tconfig.getProperties().get(Constants.TOLERATE_WSFP_TRUST_REQUEST);
        }
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenVType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[0][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[0][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[0][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenVType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[1][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[4][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[4][1];
        }
        try {
            trustClient = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        ITrustRequestSecurityTokenTemplate rstt = trustClient.getSTSRequestSecurityTokenTemplate();
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenVType);
        rstt.addRequestType(reqType);
        String keySizeStr = null;
        int keySize = 0;
        keySizeStr = PolicyConfigUtil.getMinimumSymmetricKeyLength(algorithmSuite);
        keySize = Integer.parseInt(keySizeStr);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key Size (in bits) based on the algorihthm Suite, " + algorithmSuite + " = " + keySize);
        }
        rstt.addAppliesTo(serviceEndpointAddress);
        byte[] clientSecret = WSSNonceGenerator.generateBytes(keySize / 8);
        rstt.addEntropyNonce(Base64.encode(clientSecret));
        rstt.addKeySize(keySizeStr);
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        try {
            String mid = SecurityUIDGenerator.createUID();
            rstt.setMessageID(mid);
            rstt.setTo(serviceEndpointAddress);
            rstt.setAction(msgAction);
            stsConfig.put("MESSAGE_ID", mid);
            stsConfig.put("MESSAGE_TO", serviceEndpointAddress);
            stsConfig.put("MESSAGE_ACTION", msgAction);
            stsConfig.put("SOAP_LEVEL", soapLevel);
            stsConfig.put("ADDRESSING_LEVEL", wsa_ns);
            stsConfig.put("TRUST_LEVEL", trustLevel);
            stsConfig.put("CONTEXT_URI", "http://www.ibm.com/login/");
            stsConfig.put("STS_NAME", "SSI");
            if (tolerateWSFPTrustRequest != null) {
                stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
            }
        }
        catch (Throwable te) {
            throw SoapSecurityException.format("Throwable Exception during the trust client API invocation", te);
        }
        PolicySetConfiguration psc = Axis2Util.getPolicySetConfig(mCtx);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CONFIG_CONTEXT", cContext);
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(true));
        if (isBootstrapRequired) {
            innerMap.put("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig", gconfig);
            if (gconfig instanceof PrivateGeneratorConfig) {
                innerMap.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", ((PrivateGeneratorConfig)gconfig).getBootstrapConsumerConfig());
            }
        }
        this.copySessionAffinityPropertiesToMap(mCtx, innerMap);
        HashMap cookieMap = new HashMap();
        innerMap.put("SC_COOKIE_MAP", cookieMap);
        map.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
        map.put("STSCONFIGURATION", stsConfig);
        map.put("RSTTEMPLATE", rstt);
        try {
            ITrustRequestSecurityToken rst = trustClient.createRequestSecurityToken(rstt, map);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey(), psc));
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            byte[] serverSecret = null;
            String uuid = null;
            String instance = null;
            Object created = null;
            Object expires = null;
            Date createdDate = null;
            Date expiresDate = null;
            Object sctElem = null;
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Issue request.");
            }
            rstrc = trustClient.issue(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Issue is successful.");
            }
            OMElement securityContextTokenElement = null;
            Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
            if (iter.hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iter.next();
                securityContextTokenElement = rstr.getSecurityContextTokenElement();
                uuid = rstr.getUUID();
                instance = rstr.getInstance();
                serverSecret = rstr.getServerSecretBytes();
                createdDate = rstr.getCreatedDate();
                expiresDate = rstr.getExpiresDate();
                Integer size = rstr.getKeySize();
                if (size != null) {
                    keySize = size;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + keySize);
                    }
                }
                renewable = rstr.getRenewable();
                renewableAfterExpiration = rstr.getRenewableAfterExpiration();
            }
            SCT.KeyHistoryEntry token = null;
            if (instance == null || instance.length() == 0) {
                instance = "FirstKey_" + uuid;
            }
            token = new SCT.KeyHistoryEntry(instance, clientSecret, serverSecret, createdDate, expiresDate, SCT.SCTState.ISSUED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + uuid + ", instance = " + instance + ", created = " + createdDate.toString() + ", expires = " + expiresDate.toString() + ", and instance = " + instance);
            }
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenVType)) {
                SCT13 sctoken13 = new SCT13(uuid);
                sctoken = sctoken13;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Value Type = " + sctoken.getValueType().getLocalPart());
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenVType)) {
                sctoken = new SCT(uuid);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Value Type = " + sctoken.getValueType().getLocalPart());
                }
            }
            sctoken.setKeyHistoryEntry(token);
            sctoken.setKeySize(keySize);
            sctoken.setUsedForSigAndEnc(true);
            sctoken.setClientID(SecureConversationCacheHelper.computeKey(mCtx));
            sctoken.setXML(new OMStructure(securityContextTokenElement));
            if (serviceEndpointAddress != null) {
                sctoken.setAppliesTo(serviceEndpointAddress);
            }
            if (renewable != null) {
                sctoken.setRenewable(Boolean.valueOf(renewable));
            }
            if (renewableAfterExpiration != null) {
                sctoken.setRenewableAfterExpiration(Boolean.valueOf(renewableAfterExpiration));
            }
            sctoken.setIssuer(serviceEndpointAddress);
            sctWrapper = this.createSCTWrapper(sctoken, instance);
            sctWrapper.setSCT(sctoken);
            sctWrapper.setXML(new OMStructure(securityContextTokenElement));
            this.copySessionAffinityPropertiesFromMap(mCtx, cookieMap);
        }
        catch (Throwable e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSCToken()");
        }
        return sctWrapper;
    }

    private SCTWrapper renewSCToken(MessageContext mCtx, HashMap context, SCT oldsct) throws SoapSecurityException {
        OMElement sctNode;
        ITrustRequestSecurityTokenTemplate rstt;
        ITrustClient client10;
        String msgAction;
        String tolerateWSFPTrustRequest;
        WSSGeneratorConfig gconfig;
        String tokenVType;
        String algorithmSuite;
        String renewableAfterExpiration;
        String renewable;
        boolean isBootstrapRequired;
        SCTWrapper sctWrapper;
        SCT sctoken;
        String wsa_ns;
        String serviceEndpointAddress;
        String soapLevel;
        ConfigurationContext cContext;
        String trustLevel;
        block59: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "renewSCToken()");
            }
            trustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            cContext = null;
            soapLevel = null;
            serviceEndpointAddress = null;
            wsa_ns = null;
            sctoken = null;
            sctWrapper = null;
            isBootstrapRequired = false;
            renewable = "true";
            renewableAfterExpiration = "false";
            String replyToAddress = "http://www.w3.org/2005/08/addressing/anonymous";
            algorithmSuite = null;
            tokenVType = null;
            gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            tokenVType = (String)context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
            if (gconfig != null && ((PrivateGeneratorConfig)gconfig).getBootstrapGeneratorConfig() != null && ((PrivateGeneratorConfig)gconfig).getBootstrapConsumerConfig() != null) {
                isBootstrapRequired = true;
                algorithmSuite = ((PolicyOutboundConfig)gconfig).getAlgorithmSuite();
            }
            if (mCtx == null) {
                soapLevel = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
                wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
                serviceEndpointAddress = oldsct.getIssuer();
                cContext = this.getConfigurationContext(serviceEndpointAddress);
            } else {
                cContext = mCtx.getConfigurationContext();
                if (tc.isDebugEnabled()) {
                    if (!cContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                        Iterator ite = cContext.getAxisConfiguration().getEngagedModules().iterator();
                        while (ite.hasNext()) {
                            Tr.debug(tc, "Engaged Module = ", ite.next());
                        }
                    }
                    if (gconfig == null) {
                        Tr.debug(tc, "Null security generator config to new message context");
                    }
                }
                if ((serviceEndpointAddress = oldsct.getIssuer()) == null || serviceEndpointAddress == "") {
                    serviceEndpointAddress = oldsct.getAppliesTo(0);
                }
                soapLevel = mCtx.getEnvelope().getNamespace().getName();
                wsa_ns = (String)mCtx.getProperty("WSAddressingVersion");
                if (wsa_ns == null || wsa_ns.length() == 0) {
                    wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                        Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + wsa_ns);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Namespace for WS-Addressing [" + wsa_ns + "]. This will be set on trust service request");
                }
            }
            TokenGeneratorConfig tconfig = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
            tolerateWSFPTrustRequest = null;
            if (tconfig != null) {
                tolerateWSFPTrustRequest = (String)tconfig.getProperties().get(Constants.TOLERATE_WSFP_TRUST_REQUEST);
            }
            String reqType = null;
            msgAction = null;
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenVType)) {
                trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[0][2];
                reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[1][0];
                msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[1][1];
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenVType)) {
                trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[1][2];
                reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[5][0];
                msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[5][1];
            }
            client10 = null;
            try {
                client10 = TrustClientFactory.getTrustClient(trustLevel);
            }
            catch (TrustException e) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
            }
            rstt = client10.getSTSRequestSecurityTokenTemplate();
            rstt.setWSANamespace(wsa_ns);
            rstt.addTokenType(tokenVType);
            rstt.addRequestType(reqType);
            sctNode = null;
            try {
                if (oldsct.getXML() != null) {
                    sctNode = ((OMStructure)oldsct.getXML()).getNode();
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block59;
                Tr.debug(tc, "Cannot get SCT xml element. Exception = " + e.toString());
            }
        }
        if (sctNode == null) {
            String sctId;
            OMFactory factory = null;
            int wssVersion = 0;
            factory = mCtx.getEnvelope().getOMFactory();
            Object obj = mCtx.getProperty("com.ibm.ws.wssecurity.constants.wssVersion");
            wssVersion = 0;
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            if ((sctId = oldsct.getId()) == null) {
                IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(context);
                sctId = "sct_" + idAttrVal.getStringValue();
            }
            sctNode = SCTGenerateLoginModule.createTokenElement(factory, null, oldsct.getValueType(), sctId, oldsct.getUUID(), null, wssVersion);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT xml element = " + ((Object)sctNode).toString());
            }
        }
        try {
            rstt.addRenewTarget(sctNode);
        }
        catch (Exception e) {
            String sctId;
            OMFactory factory = null;
            int wssVersion = 0;
            factory = mCtx.getEnvelope().getOMFactory();
            Object obj = mCtx.getProperty("com.ibm.ws.wssecurity.constants.wssVersion");
            wssVersion = 0;
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            if ((sctId = oldsct.getId()) == null) {
                IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(context);
                sctId = "sct_" + idAttrVal.getStringValue();
            }
            sctNode = SCTGenerateLoginModule.createTokenElement(factory, null, oldsct.getValueType(), sctId, oldsct.getUUID(), null, wssVersion);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT newly created xml element = " + ((Object)sctNode).toString());
            }
            rstt.addRenewTarget(sctNode);
        }
        String keySizeStr = null;
        int keySize = 0;
        keySizeStr = PolicyConfigUtil.getMinimumSymmetricKeyLength(algorithmSuite);
        keySize = Integer.parseInt(keySizeStr);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key Size (in bits) based on the algorihthm Suite, " + algorithmSuite + " = " + keySize);
        }
        rstt.addAppliesTo(serviceEndpointAddress);
        byte[] clientSecret = WSSNonceGenerator.generateBytes(keySize / 8);
        rstt.addEntropyNonce(Base64.encode(clientSecret));
        rstt.addKeySize(keySizeStr);
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        try {
            String mid = SecurityUIDGenerator.createUID();
            rstt.setMessageID(mid);
            rstt.setTo(serviceEndpointAddress);
            rstt.setAction(msgAction);
            stsConfig.put("MESSAGE_ID", mid);
            stsConfig.put("MESSAGE_TO", serviceEndpointAddress);
            stsConfig.put("MESSAGE_ACTION", msgAction);
            stsConfig.put("SOAP_LEVEL", soapLevel);
            stsConfig.put("ADDRESSING_LEVEL", wsa_ns);
            stsConfig.put("TRUST_LEVEL", trustLevel);
            stsConfig.put("CONTEXT_URI", "http://www.ibm.com/login/");
            stsConfig.put("STS_NAME", "SSI");
            if (tolerateWSFPTrustRequest != null) {
                stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
            }
        }
        catch (Throwable te) {
            throw SoapSecurityException.format("Throwable Exception during the trust client API invocation", te);
        }
        PolicySetConfiguration psc = Axis2Util.getPolicySetConfig(mCtx);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CONFIG_CONTEXT", cContext);
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(true));
        if (isBootstrapRequired) {
            innerMap.put("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig", gconfig);
            if (gconfig instanceof PrivateGeneratorConfig) {
                innerMap.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", ((PrivateGeneratorConfig)gconfig).getBootstrapConsumerConfig());
            }
        }
        this.copySessionAffinityPropertiesToMap(mCtx, innerMap);
        HashMap cookieMap = new HashMap();
        innerMap.put("SC_COOKIE_MAP", cookieMap);
        map.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
        map.put("STSCONFIGURATION", stsConfig);
        map.put("RSTTEMPLATE", rstt);
        try {
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, map);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey(), psc));
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            byte[] serverSecret = null;
            String uuid = null;
            String instance = null;
            String id = null;
            Object created = null;
            Object expires = null;
            Date createdDate = null;
            Date expiresDate = null;
            Object lifetimeElem = null;
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Renew request.");
            }
            rstrc = client10.renew(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client renew is successful.");
            }
            OMElement securityContextTokenElement = null;
            Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
            if (iter.hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iter.next();
                serverSecret = rstr.getServerSecretBytes();
                createdDate = rstr.getCreatedDate();
                expiresDate = rstr.getExpiresDate();
                Integer size = rstr.getKeySize();
                if (size != null) {
                    keySize = size;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + keySize);
                    }
                }
                securityContextTokenElement = rstr.getSecurityContextTokenElement();
                uuid = rstr.getUUID();
                instance = rstr.getInstance();
                renewable = rstr.getRenewable();
                renewableAfterExpiration = rstr.getRenewableAfterExpiration();
                uuid = rstr.getUUID();
                instance = rstr.getInstance();
                id = rstr.getID();
                if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenVType)) {
                    SCT13 sctoken13 = new SCT13(uuid);
                    sctoken = sctoken13;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Token Value Type = " + sctoken.getValueType().getLocalPart());
                    }
                } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenVType)) {
                    sctoken = new SCT(uuid);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Token Value Type = " + sctoken.getValueType().getLocalPart());
                    }
                }
                if (oldsct != null) {
                    String[] list = oldsct.getInstances();
                    for (int i = 0; i < list.length; ++i) {
                        sctoken.setKeyHistoryEntry(oldsct.getKeyHistoryEntry(list[i]));
                    }
                }
                SCT.KeyHistoryEntry token = null;
                token = new SCT.KeyHistoryEntry(instance, clientSecret, serverSecret, createdDate, expiresDate, SCT.SCTState.RENEWED);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + uuid + ", id = " + id + ", created = " + createdDate.toString() + ", expires = " + expiresDate.toString() + ", and instance = " + instance);
                }
                sctoken.setKeyHistoryEntry(token);
                sctoken.setKeySize(keySize);
                sctoken.setId(id);
                sctoken.setTokenID(id);
                sctoken.setReferenceURI("#" + id);
                sctoken.setUsedForSigAndEnc(true);
                sctoken.setXML(new OMStructure(securityContextTokenElement));
                if (renewable != null) {
                    sctoken.setRenewable(Boolean.valueOf(renewable));
                }
                if (renewableAfterExpiration != null) {
                    sctoken.setRenewableAfterExpiration(Boolean.valueOf(renewableAfterExpiration));
                }
                sctoken.setIssuer(serviceEndpointAddress);
                if (oldsct.getClientID() != null && !oldsct.getClientID().equals("")) {
                    sctoken.setClientID(oldsct.getClientID());
                } else {
                    sctoken.setClientID(SecureConversationCacheHelper.computeKey(mCtx));
                }
                sctWrapper = this.createSCTWrapper(sctoken, instance);
                sctWrapper.setSCT(sctoken);
                sctWrapper.setXML(new OMStructure(securityContextTokenElement));
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        catch (Throwable t) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{t});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSCToken()");
        }
        return sctWrapper;
    }

    private SCTWrapper cancelSCToken(HashMap context, SCT oldsct) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelSCToken()");
        }
        String trustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
        String soapLevel = null;
        String wsa_ns = null;
        String serviceEndpointAddress = null;
        String tokenVType = null;
        soapLevel = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
        wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
        serviceEndpointAddress = oldsct.getIssuer();
        ConfigurationContext cContext = this.getConfigurationContext(serviceEndpointAddress);
        SCTWrapper sctWrapper = new SCTWrapper();
        boolean isBootstrapRequired = false;
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        tokenVType = (String)context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
        if (tc.isDebugEnabled()) {
            if (!cContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                Iterator ite = cContext.getAxisConfiguration().getEngagedModules().iterator();
                while (ite.hasNext()) {
                    Tr.debug(tc, "Engaged Module = ", ite.next());
                }
            }
            if (gconfig == null) {
                Tr.debug(tc, "Null security generator config to new message context");
            } else {
                Tr.debug(tc, "Valid security generator config to new message context");
            }
        }
        if (gconfig != null && ((PrivateGeneratorConfig)gconfig).getBootstrapGeneratorConfig() != null && ((PrivateGeneratorConfig)gconfig).getBootstrapConsumerConfig() != null) {
            isBootstrapRequired = true;
        }
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenVType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[0][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[2][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[2][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenVType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[1][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[6][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[6][1];
        }
        String replyToAddress = "http://www.w3.org/2005/08/addressing/anonymous";
        TokenGeneratorConfig tconfig = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        String tolerateWSFPTrustRequest = null;
        if (tconfig != null) {
            tolerateWSFPTrustRequest = (String)tconfig.getProperties().get(Constants.TOLERATE_WSFP_TRUST_REQUEST);
        }
        ITrustClient client10 = null;
        try {
            client10 = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        ITrustRequestSecurityTokenTemplate rstt = client10.getSTSRequestSecurityTokenTemplate();
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenVType);
        rstt.addRequestType(reqType);
        rstt.addAppliesTo(serviceEndpointAddress);
        OMElement sctNode = ((OMStructure)oldsct.getXML()).getNode();
        rstt.addCancelTarget(sctNode);
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        try {
            String mid = SecurityUIDGenerator.createUID();
            rstt.setMessageID(mid);
            rstt.setTo(serviceEndpointAddress);
            rstt.setAction(msgAction);
            stsConfig.put("MESSAGE_ID", mid);
            stsConfig.put("MESSAGE_TO", serviceEndpointAddress);
            stsConfig.put("MESSAGE_ACTION", msgAction);
            stsConfig.put("SOAP_LEVEL", soapLevel);
            stsConfig.put("ADDRESSING_LEVEL", wsa_ns);
            stsConfig.put("TRUST_LEVEL", trustLevel);
            stsConfig.put("CONTEXT_URI", "http://www.ibm.com/login/");
            stsConfig.put("STS_NAME", "SSI");
            if (tolerateWSFPTrustRequest != null) {
                stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
            }
        }
        catch (Throwable te) {
            throw SoapSecurityException.format("Throwable Exception during the trust client API invocation", te);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CONFIG_CONTEXT", cContext);
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(true));
        if (isBootstrapRequired) {
            innerMap.put("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig", gconfig);
            if (gconfig instanceof PrivateGeneratorConfig) {
                innerMap.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", ((PrivateGeneratorConfig)gconfig).getBootstrapConsumerConfig());
            }
        }
        innerMap.put("com.ibm.ws.wssecurity.sc.SCT.Cancel", new Boolean(true));
        innerMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, oldsct.getIdentifier());
        HashMap cookieMap = new HashMap();
        innerMap.put("SC_COOKIE_MAP", cookieMap);
        map.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
        map.put("STSCONFIGURATION", stsConfig);
        map.put("RSTTEMPLATE", rstt);
        try {
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, map);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Cancel request.");
            }
            rstrc = client10.cancel(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Cancel is successful.");
            }
            Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
            while (iter.hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iter.next();
                OMElement elem = rstr.getRequestedTokenCancelledElement();
                if (elem != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancel Element:" + ((Object)elem).toString());
                }
                Boolean isCancelled = rstr.isTokenCancelled();
                if (!tc.isDebugEnabled() || !isCancelled.booleanValue()) continue;
                Tr.debug(tc, "Token Successfully Cancelled");
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
        }
        catch (Throwable e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
        }
        oldsct.setCancelState();
        SecureConversationCacheHelper.invalidateCache(oldsct.getUUID());
        SecureConversationCacheHelper.invalidateCache(oldsct.getClientID());
        sctWrapper.setSCT(oldsct);
        return sctWrapper;
    }

    private void copySessionAffinityPropertiesToMap(MessageContext msgCtx, Map innerMap) {
        Object obj = msgCtx.getProperty("Cookie");
        if (obj != null) {
            innerMap.put("Cookie", obj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copied Cookie property to innerMap: " + obj.toString());
            }
        }
        if ((obj = msgCtx.getProperty("Location")) != null) {
            innerMap.put("Location", obj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copied Location property to innerMap: " + obj.toString());
            }
        }
        if ((obj = msgCtx.getProperty("javax.xml.ws.session.maintain")) != null) {
            innerMap.put("javax.xml.ws.session.maintain", obj);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copied javax.xml.ws.session.maintain property to innerMap: " + obj.toString());
            }
        }
    }

    private void copySessionAffinityPropertiesFromMap(MessageContext msgCtx, Map cookieMap) {
        ServiceContext sCtx;
        Object obj = msgCtx.getProperty("Cookie");
        if (obj == null) {
            obj = cookieMap.get("Cookie");
            if (obj != null) {
                msgCtx.setProperty("Cookie", obj);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Copied Cookie property to MessageContext: " + obj.toString());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cookie property already in MessageContext: " + obj.toString());
        }
        if ((obj = msgCtx.getProperty("Location")) == null) {
            obj = cookieMap.get("Location");
            if (obj != null) {
                msgCtx.setProperty("Location", obj);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Copied Location property to MessageContext: " + obj.toString());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Location property already in MessageContext: " + obj.toString());
        }
        if ((sCtx = msgCtx.getServiceContext()) != null) {
            obj = sCtx.getProperty("Cookie");
            if (obj == null) {
                obj = cookieMap.get("Cookie");
                if (obj != null) {
                    sCtx.setProperty("Cookie", obj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copied Cookie property to ServiceContext: " + obj.toString());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cookie property already in ServiceContext: " + obj.toString());
            }
            if ((obj = sCtx.getProperty("Location")) == null) {
                obj = cookieMap.get("Location");
                if (obj != null) {
                    sCtx.setProperty("Location", obj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copied Location property to ServiceContext: " + obj.toString());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Location property already in ServiceContext: " + obj.toString());
            }
        }
    }

    private ConfigurationContext getConfigurationContext(String serviceEndpointAddress) throws SoapSecurityException {
        ConfigurationContext configurationContext = null;
        ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.newInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ClientConfigurationFactory.newInstance(): " + clientConfigurationFactory);
        }
        if (clientConfigurationFactory == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
        }
        configurationContext = clientConfigurationFactory.getClientConfigurationContext();
        if (configurationContext == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
        }
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        if (axisConfiguration == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
        }
        try {
            AxisService aService = axisConfiguration.getService(serviceEndpointAddress);
            if (aService == null) {
                AxisService axisService = new AxisService(serviceEndpointAddress);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AxisService: " + axisService);
                }
                if (axisService == null) {
                    Tr.warning(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{serviceEndpointAddress});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating an empty AxisService.");
                    }
                    if ((axisService = new AxisService()) == null) {
                        Tr.error(tc, "UNABLE TO CREATE EMPTY AxisService");
                    }
                }
                axisConfiguration.addService(axisService);
                clientConfigurationFactory.completeAxis2Configuration(axisService);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Target axisService from AxisConfiguration.");
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration", e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
        }
        return configurationContext;
    }

    public String searchInstanceList(SCT sctoken) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchInstanceList(SCT sctoken)");
        }
        String instance = null;
        Date now = new Date();
        String[] list = sctoken.getInstances();
        if (list == null || list.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchInstanceList(SCT sctoken): no key instance.");
            }
            return null;
        }
        int instanceCnt = list.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Instances in the list = " + instanceCnt);
        }
        Date created = sctoken.getCreation(list[instanceCnt - 1]);
        instance = list[instanceCnt - 1];
        if (instanceCnt == 1) {
            return instance;
        }
        int instancePosition = 0;
        for (i = 0; i < instanceCnt - 1; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "instance:" + list[i] + "  creation time:" + sctoken.getCreation(list[i]));
            }
            if (!sctoken.getCreation(list[i]).after(created) && (!sctoken.getCreation(list[i]).equals(created) || !sctoken.getExpiration(list[i]).after(sctoken.getExpiration(instance)))) continue;
            instance = list[i];
            instancePosition = i;
            created = sctoken.getCreation(list[i]);
        }
        if (created.after(now)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchInstanceList(SCT sctoken):" + instance);
            }
            return instance;
        }
        instance = null;
        instancePosition = list.length + 1;
        for (i = 0; i < list.length; ++i) {
            if (!sctoken.getExpiration(list[i]).after(now)) continue;
            instance = list[i];
            instancePosition = i;
            now = sctoken.getExpiration(list[i]);
        }
        if (instancePosition != list.length + 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning valid instance  = " + instance + "and it is at = " + instancePosition);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning non valid instance  = " + instance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchInstanceList(SCT sctoken)");
        }
        return instance;
    }

    private String searchExistingInstance(SCT sctoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchExistingInstance(SCT sctoken).");
        }
        if (sctoken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchExistingInstance(SCT sctoken): no SCT.");
            }
            return null;
        }
        String lastInstance = this.searchInstanceList(sctoken);
        String[] list = sctoken.getInstances();
        if (list == null || list.length < 2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchExistingInstance(SCT sctoken): no more than 1 key instance.");
            }
            return lastInstance;
        }
        int iLeng = list.length;
        String instance = null;
        Date now = new Date();
        Date issue = new Date();
        long future = now.getTime() + cushion * 3L / 5L;
        String oldInstance = lastInstance;
        issue = sctoken.getCreation(oldInstance);
        for (int i = 0; i < iLeng; ++i) {
            instance = list[i];
            if (sctoken.getExpiration(instance).getTime() > future) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid old Instance:" + instance, "created at " + sctoken.getCreation(instance));
                }
                if (!sctoken.getCreation(instance).before(issue)) continue;
                oldInstance = instance;
                issue = sctoken.getCreation(oldInstance);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Instance expired:" + instance);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchExistingInstance(SCT sctoken) = " + oldInstance);
        }
        return oldInstance;
    }

    public static final Date parseDateTime(String s) {
        if (s == null) {
            return null;
        }
        try {
            Date d = UTC.parse(s);
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isCancelInProgress(MessageContext msgCtx) {
        if (msgCtx == null) {
            return false;
        }
        boolean serverSide = false;
        try {
            serverSide = Axis2Util.isServiceProvider(msgCtx);
        }
        catch (Exception e) {
            return false;
        }
        if (serverSide) {
            String action;
            String actionURI = msgCtx.getWSAAction();
            if (actionURI == null) {
                actionURI = msgCtx.getSoapAction();
            }
            if ((action = STSPolicySetUtil.mapTrustAction(actionURI)) != null && action.equals("cancel")) {
                return true;
            }
        } else {
            Object duringCancelSCT = Axis2Util.getProperty(msgCtx, "com.ibm.ws.wssecurity.sc.SCT.Cancel", false, false);
            if (duringCancelSCT != null && duringCancelSCT instanceof Boolean && ((Boolean)duringCancelSCT).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public SCTWrapper createSCTWrapper(SCT sctoken, String instance) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSCTWrapper(SCT sctoken, String instance)");
        }
        String[] list = sctoken.getInstances();
        SCT.KeyHistoryEntry[] entries = new SCT.KeyHistoryEntry[list.length];
        SCTWrapper sctWrapper = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Instances in the list = " + list.length);
        }
        for (int i = 0; i < list.length; ++i) {
            entries[i] = sctoken.getKeyHistoryEntry(list[i]);
        }
        sctWrapper = new SCTWrapper(sctoken.getUUID(), entries, sctoken.getId(), instance);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSCTWrapper(SCT sctoken, String instance) returns SCTWrapper object, instance = " + sctWrapper != null ? sctWrapper.getCurrentInstance() : null);
        }
        return sctWrapper;
    }

    private static synchronized boolean hasBeenRequested(String id) {
        boolean requested = false;
        if (WSTrustCallbackHandler.getClientIDMap().containsKey(id)) {
            requested = true;
            Vector v1 = (Vector)WSTrustCallbackHandler.getClientIDMap().get(id);
            Thread currThread = Thread.currentThread();
            v1.add(currThread);
            WSTrustCallbackHandler.getClientIDMap().put(id, v1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This client has requested an SCT.");
            }
        } else {
            Vector v2 = new Vector();
            WSTrustCallbackHandler.getClientIDMap().put(id, v2);
        }
        return requested;
    }

    private static synchronized void wakeupOtherRequests(String id) {
        if (WSTrustCallbackHandler.getClientIDMap().containsKey(id)) {
            try {
                final Vector v1 = (Vector)WSTrustCallbackHandler.getClientIDMap().get(id);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            while (!v1.isEmpty()) {
                                Thread th = (Thread)v1.lastElement();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Interrupt sleeping Thread:" + th.getName());
                                }
                                th.interrupt();
                                v1.remove(th);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                WSTrustCallbackHandler.getClientIDMap().remove(id);
            }
            catch (Exception e) {
                WSTrustCallbackHandler.getClientIDMap().remove(id);
            }
        }
    }

    private static synchronized Map getClientIDMap() {
        return clientIDMap;
    }

    public boolean validateSCT(SCT oldsct, HashMap context, MessageContext mCtx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSCT(SCT oldsct, HashMap context, MessageContext mCtx)");
        }
        String trustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
        ConfigurationContext cContext = null;
        String soapLevel = null;
        String serviceEndpointAddress = null;
        String wsa_ns = null;
        Object sctoken = null;
        Object sctWrapper = null;
        boolean isBootstrapRequired = false;
        String renewable = "true";
        String renewableAfterExpiration = "false";
        String replyToAddress = "http://www.w3.org/2005/08/addressing/anonymous";
        Object algorithmSuite = null;
        String[] status = new String[]{"", "", ""};
        boolean sctStatus = true;
        String tokenVType = null;
        tokenVType = (String)context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
        if (mCtx == null) {
            soapLevel = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
            wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
            serviceEndpointAddress = oldsct.getIssuer();
            cContext = this.getConfigurationContext(serviceEndpointAddress);
        } else {
            cContext = mCtx.getConfigurationContext();
            if (tc.isDebugEnabled() && !cContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                Iterator ite = cContext.getAxisConfiguration().getEngagedModules().iterator();
                while (ite.hasNext()) {
                    Tr.debug(tc, "Engaged Module = ", ite.next());
                }
            }
            serviceEndpointAddress = oldsct.getIssuer();
            soapLevel = mCtx.getEnvelope().getNamespace().getName();
            wsa_ns = (String)mCtx.getProperty("WSAddressingVersion");
            if (wsa_ns == null || wsa_ns.length() == 0) {
                wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                    Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + wsa_ns);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace for WS-Addressing [" + wsa_ns + "]. This will be set on trust service request");
            }
        }
        OMFactory factory = null;
        int wssVersion = 0;
        factory = mCtx.getEnvelope().getOMFactory();
        Object obj = mCtx.getProperty("com.ibm.ws.wssecurity.constants.wssVersion");
        wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        TokenGeneratorConfig tconfig = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        String tolerateWSFPTrustRequest = null;
        if (tconfig != null) {
            tolerateWSFPTrustRequest = (String)tconfig.getProperties().get(Constants.TOLERATE_WSFP_TRUST_REQUEST);
        }
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenVType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[0][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[3][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[3][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenVType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[1][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[7][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[7][1];
        }
        ITrustClient client10 = null;
        try {
            client10 = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        ITrustRequestSecurityTokenTemplate rstt = client10.getSTSRequestSecurityTokenTemplate();
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenVType);
        rstt.addRequestType(reqType);
        OMElement sctNode = ((OMStructure)oldsct.getXML()).getNode();
        rstt.addValidateTarget(sctNode);
        rstt.addAppliesTo(serviceEndpointAddress);
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        try {
            String mid = SecurityUIDGenerator.createUID();
            rstt.setMessageID(mid);
            rstt.setTo(serviceEndpointAddress);
            rstt.setAction(msgAction);
            stsConfig.put("MESSAGE_ID", mid);
            stsConfig.put("MESSAGE_TO", serviceEndpointAddress);
            stsConfig.put("MESSAGE_ACTION", msgAction);
            stsConfig.put("SOAP_LEVEL", soapLevel);
            stsConfig.put("ADDRESSING_LEVEL", wsa_ns);
            stsConfig.put("TRUST_LEVEL", trustLevel);
            stsConfig.put("CONTEXT_URI", "http://www.ibm.com/login/");
            stsConfig.put("STS_NAME", "SSI");
            if (tolerateWSFPTrustRequest != null) {
                stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
            }
        }
        catch (Throwable te) {
            throw SoapSecurityException.format("Throwable Exception during the trust client API invocation", te);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CONFIG_CONTEXT", cContext);
        HashMap innerMap = new HashMap();
        map.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
        map.put("STSCONFIGURATION", stsConfig);
        map.put("RSTTEMPLATE", rstt);
        PolicySetConfiguration psc = Axis2Util.getPolicySetConfig(mCtx);
        ServiceClient client = null;
        try {
            Iterator<ITrustRequestSecurityTokenResponse> iterValidate;
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, map);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
                axService.addParameter(new Parameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey(), psc));
            }
            client = rst.getServiceClient();
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Issue request.");
            }
            rstrc = client10.validate(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client validate is successful.");
            }
            if ((iterValidate = rstrc.getRSTRCollection()).hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iterValidate.next();
                status[0] = rstr.getStatusCode();
                status[1] = rstr.getStatusReason();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status Code=" + status[0]);
                    Tr.debug(tc, "Status Reason=" + status[1]);
                }
                if (status[0].equals(trustLevel + "/status/invalid")) {
                    SecureConversationCacheHelper.invalidateCache(oldsct.getUUID());
                    sctStatus = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This sct is removed from cache.");
                    }
                }
            }
        }
        catch (Exception e) {
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        catch (Throwable e) {
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSCT(MessageContext mCtx, SCT oldsct, WSSGeneratorConfig gconfig) returns." + sctStatus);
        }
        return sctStatus;
    }

    private boolean isSCTCreatedWithFutureTimeStamp(SCTWrapper sctwrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSCTCreatedWithFutureTimeStamp(SCTWrapper sctoken)");
        }
        boolean isTokenCreatedInFuture = false;
        SCT sct = sctwrapper.getSCT();
        Date creationTime = sct.getCreation(sctwrapper.getCurrentInstance());
        Date now = new Date();
        if (creationTime != null && creationTime.getTime() > now.getTime() && creationTime.getTime() > now.getTime() + clockSkew) {
            isTokenCreatedInFuture = true;
            Tr.error(tc, "Security Context Token is created with future timestamp and is not valid. Might be due to time difference between client and service systems.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSCTCreatedWithFutureTimeStamp(SCTWrapper sctoken) returns = " + isTokenCreatedInFuture);
        }
        return isTokenCreatedInFuture;
    }
}

