/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.impl.auth.callback.TrustedIdentityCallback;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class TrustedIdentityCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(TrustedIdentityCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private final Set<String> identityList = new HashSet<String>();

    public TrustedIdentityCallbackHandler(Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TrustedIdentityCallbackHandler(Map properties)");
        }
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        Map<Object, Object> p = config2.getProperties();
        for (Object key : p.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith("trustedId_")) continue;
            String value = (String)p.get(key);
            String encoded = KeyInfo.X509Data.encodeDName(value);
            if (encoded == null || encoded.length() == 0) {
                this.identityList.add(value);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added the identity [" + value + "].");
                continue;
            }
            this.identityList.add(encoded);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added the identity [" + encoded + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TrustedIdentityCallbackHandler(Map properties)");
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        if (callbacks == null || callbacks.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (!(callback instanceof TrustedIdentityCallback)) continue;
            TrustedIdentityCallback tidCallback = (TrustedIdentityCallback)callback;
            tidCallback.setIdentityList(this.identityList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[]) returns Set[" + this.identityList + "]");
        }
    }
}

