/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.ws.wssecurity.impl.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NonPromptCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(NonPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private String _username = "";
    private char[] _password = null;
    private CallbackHandlerConfig _config = null;
    private boolean identityAssertion;
    private boolean runAsSubject;
    private boolean sendRealm;
    private boolean nonce;
    private boolean createdTimestamp;
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};

    public NonPromptCallbackHandler() {
    }

    public NonPromptCallbackHandler(Map<Object, Object> properties) {
        CallbackHandlerConfig config2 = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (config2 != null) {
            this._username = config2.getUserId();
            this._password = config2.getUserPassword();
            Object obj = config2.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (obj != null) {
                this.identityAssertion = NonPromptCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_USE_RUNASIDENTITY)) != null) {
                this.runAsSubject = NonPromptCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_SEND_REALM)) != null) {
                this.sendRealm = NonPromptCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_ADD_NONCE)) != null) {
                this.nonce = NonPromptCallbackHandler.isTrue(obj.toString());
            }
            if ((obj = config2.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP)) != null) {
                this.createdTimestamp = NonPromptCallbackHandler.isTrue(obj.toString());
            }
        }
    }

    public static boolean isTrue(String flag) {
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(flag)) continue;
                return true;
            }
        }
        return ret;
    }

    public NonPromptCallbackHandler(String userid, char[] password, Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonPromptCallbackHandler(String, char[], Map)", new Object[]{"Default user: " + userid});
        }
        this._username = userid;
        this._password = password;
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The properties parameter is null.");
            }
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)properties.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonPromptCallbackHandler(String, char[], Map)");
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(Callback[] callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.debug(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this._username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this._password);
                continue;
            }
            if (callbacks[i] instanceof PropertyCallback || c instanceof WSCredTokenCallbackImpl || c instanceof SCTGenerateCallback) continue;
            if (c instanceof UNTGenerateCallback) {
                ((UNTGenerateCallback)c).setUsedIdentityAssertion(this.identityAssertion);
                ((UNTGenerateCallback)c).setUsedRunAsSubject(this.runAsSubject);
                ((UNTGenerateCallback)c).setSentRelm(this.sendRealm);
                ((UNTGenerateCallback)c).setNonce(this.nonce);
                ((UNTGenerateCallback)c).setCreatedTimestamp(this.createdTimestamp);
                continue;
            }
            throw new UnsupportedCallbackException(c, ConfigConstants.getMessage("security.wssecurity.WSEC0153E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

