/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import javax.security.auth.callback.Callback;

public class BinaryTokenCallback
implements Callback {
    private static final TraceComponent tc = Tr.register(BinaryTokenCallback.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private byte[] defaultCredToken;
    private byte[] credToken;
    private String prompt;

    public BinaryTokenCallback(String prompt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "BinaryTokenCallback(prompt = \"" + prompt + "\")");
        }
        this.prompt = prompt;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BinaryTokenCallback(prompt)");
        }
    }

    public BinaryTokenCallback(String prompt, byte[] defaultCredToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCredTokenCallbackImpl(prompt = \"" + prompt + "\", defaultCredToken)");
        }
        this.prompt = prompt;
        this.defaultCredToken = this.copyCredToken(defaultCredToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "BinaryTokenCallback(prompt, defaultCredToken)");
        }
    }

    public void setCredToken(byte[] credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCredToken(credToken)");
        }
        this.credToken = this.copyCredToken(credToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCredToken(credToken)");
        }
    }

    public byte[] getCredToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredToken()");
            Tr.exit(tc, "getCredToken()");
        }
        return this.copyCredToken(this.credToken);
    }

    public byte[] getDefaultCredToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCredToken()");
            Tr.exit(tc, "getDefaultCredToken()");
        }
        return this.copyCredToken(this.defaultCredToken);
    }

    public String getPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrompt()");
            Tr.exit(tc, "getPrompt() -> " + this.prompt);
        }
        return this.prompt;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString()");
            Tr.exit(tc, "toString() -> " + this.getClass().getName());
        }
        return this.getClass().getName();
    }

    private byte[] copyCredToken(byte[] credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyCredToken(credToken)");
        }
        if (credToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "credential token is null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copyCredToken(credToken)");
            }
            return null;
        }
        int LEN = credToken.length;
        if (LEN == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "credential token is zero byte");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copyCredToken(credToken)");
            }
            return new byte[LEN];
        }
        byte[] newCredToken = new byte[LEN];
        System.arraycopy(credToken, 0, newCredToken, 0, LEN);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "credential token copied");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyCredToken(credToken)");
        }
        return newCredToken;
    }
}

