/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.ws.wssecurity.impl.auth.callback.BinaryTokenCallback;
import com.ibm.ws.wssecurity.impl.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.wssecurity.impl.auth.callback.XMLTokenReceiverCallback;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public final class WSDefaultTokenCallbackHandler
implements CallbackHandler {
    private String username = null;
    private char[] password = null;
    private byte[] tokenBytes = null;
    private OMElement xmlToken = null;
    private OMDocument message = null;
    private Map properties = null;
    private static final TraceComponent tc = Tr.register(WSDefaultTokenCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public WSDefaultTokenCallbackHandler(String username, char[] password, byte[] tokenBytes, OMElement xmlToken, OMDocument message, Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDefaultTokenCallbackHandler");
        }
        this.username = username;
        this.password = password;
        this.tokenBytes = tokenBytes;
        this.xmlToken = xmlToken;
        this.message = message;
        this.properties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDefaultTokenCallbackHandler");
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.password);
                continue;
            }
            if (callbacks[i] instanceof BinaryTokenCallback) {
                ((BinaryTokenCallback)callbacks[i]).setCredToken(this.tokenBytes);
                continue;
            }
            if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)callbacks[i]).setCredToken(this.tokenBytes);
                continue;
            }
            if (callbacks[i] instanceof XMLTokenReceiverCallback) {
                XMLTokenReceiverCallback callback = (XMLTokenReceiverCallback)callbacks[i];
                callback.setXMLToken(this.xmlToken);
                callback.setSOAPMessage(this.message);
                continue;
            }
            if (callbacks[i] instanceof PropertyCallback) {
                ((PropertyCallback)callbacks[i]).setProperties(this.properties);
                continue;
            }
            Tr.error(tc, "security.wssecurity.unsupport.callback", new Object[]{this.getClass().getName(), callbacks[i]});
            throw new UnsupportedCallbackException(callbacks[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exit");
        }
    }
}

