/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.CacheEntry;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Cache
implements AlarmListener {
    protected static final TraceComponent tc = Tr.register(Cache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected Hashtable _primaryTable;
    protected Hashtable _secondaryTable;
    protected Hashtable _tertiaryTable;
    protected int _minSize = 0;
    protected boolean _wipeCache;
    protected Alarm _defaultAlarm;
    private int entryLimit = Integer.MAX_VALUE;

    public Cache(String cacheName, int size, long timeout, boolean wipeCache, boolean cacheDistributed) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Cache(String cacheName[" + cacheName + "]," + "int size[" + size + "]," + "int timeout[" + timeout + "]," + "boolean wipeCache[" + wipeCache + "]," + "boolean cacheDistributed[" + cacheDistributed + "]");
        }
        this._defaultAlarm = new Alarm(timeout);
        this._primaryTable = new Hashtable(size);
        this._secondaryTable = new Hashtable(size);
        this._tertiaryTable = new Hashtable(size);
        this._minSize = size;
        this._wipeCache = wipeCache;
        this.addAlarmListener(this, timeout);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Cache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains");
            StringBuffer sb = new StringBuffer("Key = ");
            sb.append(key.toString());
            sb.append(", key class is ");
            sb.append(key.getClass().getName());
            Tr.debug(tc, sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", key);
        }
        Hashtable tableRef = this._primaryTable;
        CacheEntry curEntry = (CacheEntry)this._primaryTable.get(key);
        if (curEntry == null) {
            tableRef = this._secondaryTable;
            curEntry = (CacheEntry)this._secondaryTable.get(key);
            if (curEntry == null) {
                tableRef = this._tertiaryTable;
                curEntry = (CacheEntry)this._tertiaryTable.get(key);
            }
            if (curEntry == null) {
                tableRef = null;
            }
        }
        if (tableRef != null && tableRef != this._primaryTable) {
            this._primaryTable.put(key, curEntry);
            tableRef.remove(key);
        }
        if (tableRef == null) {
            Hashtable hashtable = this._primaryTable;
            synchronized (hashtable) {
                curEntry = (CacheEntry)this._primaryTable.get(key);
                if (curEntry == null) {
                    curEntry = new CacheEntry();
                    this._primaryTable.put(key, curEntry);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", curEntry.getValue());
        }
        return curEntry.getValue();
    }

    public void remove(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", key);
        }
        this._primaryTable.remove(key);
        this._secondaryTable.remove(key);
        this._tertiaryTable.remove(key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    public void insert(Object key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{key, value});
        }
        CacheEntry curEntry = new CacheEntry(key, value);
        this._primaryTable.put(key, curEntry);
        if (this.isEvictionRequired()) {
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    protected boolean isEvictionRequired() {
        int size;
        if (this.entryLimit == 0) {
            return false;
        }
        boolean evictionRequired = false;
        if (this.entryLimit != Integer.MAX_VALUE && (size = this._primaryTable.size() + this._secondaryTable.size() + this._tertiaryTable.size()) > this.entryLimit && this._tertiaryTable.size() > this.entryLimit / 10) {
            evictionRequired = true;
        }
        return evictionRequired;
    }

    protected void evictStaleEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "evictStaleEntries");
        }
        Hashtable victims = this._tertiaryTable;
        this._tertiaryTable = this._secondaryTable;
        this._secondaryTable = this._primaryTable;
        this._primaryTable = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "evictStaleEntries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllEntries");
        }
        Hashtable hashtable = this._primaryTable;
        synchronized (hashtable) {
            this._primaryTable.clear();
            this._secondaryTable.clear();
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllEntries");
        }
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._primaryTable;
        this._primaryTable = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    @Override
    public void alarm(Object alarmCtx) {
        long startTime = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append(" Time elapsed cleaning cache: ");
            sb.append(System.currentTimeMillis() - startTime);
            sb.append(" milliseconds, Primary cache size: ");
            sb.append(this._primaryTable.size());
            sb.append(", Secondary cache size: ");
            sb.append(this._secondaryTable.size());
            sb.append(", Tertiary cache size: ");
            sb.append(this._tertiaryTable.size());
            Tr.debug(tc, sb.toString());
        }
    }

    private void addAlarmListener(AlarmListener al, long to) {
        if (to == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(al);
        } else {
            Alarm alarm = new Alarm(to);
            alarm.addAlarmListener(al);
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener al) {
            this.alarms.addElement(al);
        }

        public Alarm(long to) {
            this.timeout = to / 2L;
            this.alarm(null);
        }

        @Override
        public void alarm(Object alarmCtx) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(alarmCtx);
            }
            AlarmManager.create(this.timeout, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

