/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyFactory;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.Parameter;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyPreferenceResolver;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.WSSecurityAssertionTransform;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityWSPolicyAssertionProcessor
implements WSPolicyAssertionProcessor {
    private static final TraceComponent tc = Tr.register(WSSecurityWSPolicyAssertionProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static WSPolicyFactory _wspFactory = WSPolicyFactory.instance();
    private ArrayList<QName> _allAssertionQNames = null;
    private ArrayList<QName> _assertionQNames = null;
    private ArrayList<QName> _nestedAssertionQNames = null;
    private ArrayList<QName> _algorithmAssertionQNames = null;
    private ArrayList<QName> _layoutAssertionQNames = null;
    private ArrayList<QName> _tokenPropertiesAssertionQNames = null;
    private static final QName NAMESPACEQAME = new QName("", "Namespace");

    public WSSecurityWSPolicyAssertionProcessor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Constructor");
        }
        this._nestedAssertionQNames = new ArrayList();
        this._nestedAssertionQNames.add(PolicyConfigUtil.algorithmSuiteQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.asymmetricBindingQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.bootstrapPolicyQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.encryptionTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.InitiatorTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.InitiatorEncryptionTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.InitiatorSignatureTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.RecipientEncryptionTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.RecipientSignatureTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.KerberosTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.layoutQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.ProtectionTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.RecipientTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.SecureConversationTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.SignatureTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.SignedsupportingTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.SignedEncryptedSupportingTokensQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.EncryptedSupportingTokens);
        this._nestedAssertionQNames.add(PolicyConfigUtil.supportingTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.symmetricBindingQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.MustNotSendAmendQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.trust10QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.trust13QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.usernameTokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.wss10QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.wss11QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.X509TokenQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.WssX509V1Token11QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.WssX509V3Token10QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.WssX509V3Token11QName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.bodyQName12);
        this._nestedAssertionQNames.add(PolicyConfigUtil.headerQName12);
        this._tokenPropertiesAssertionQNames = new ArrayList();
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireDerivedKeysQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireImplicitDerivedKeysQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireExplicitDerivedKeysQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireIssuerSerialReferenceQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireEmbeddedTokenReferenceQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireThumbprintReferenceQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireExternalURIReferenceQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.requireKeyIdentifierReferenceQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssGssKerberosV5ApReqToken11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssKerberosV5ApReqToken11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.wssUsernameToken10QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.wssUsernameToken11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509Pkcs7Token10QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509Pkcs7Token11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509PkiPathV1Token10QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509PkiPathV1Token11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509V1Token11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509V3Token10QName);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.WssX509V3Token11QName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.InitiatorEncryptionTokenQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.InitiatorSignatureTokenQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.RecipientEncryptionTokenQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.RecipientSignatureTokenQName12);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.LTPAToken12QName);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.LTPAPropagationToken12QName);
        this._tokenPropertiesAssertionQNames.add(PolicyConfigUtil.CustomToken12QName);
        this._tokenPropertiesAssertionQNames.add(new QName("http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext", "WssCustomToken"));
        this._layoutAssertionQNames = new ArrayList();
        this._layoutAssertionQNames.add(PolicyConfigUtil.StrictQName12);
        this._layoutAssertionQNames.add(PolicyConfigUtil.LaxQName12);
        this._layoutAssertionQNames.add(PolicyConfigUtil.LaxTsFirstQName12);
        this._layoutAssertionQNames.add(PolicyConfigUtil.LaxTsLastQName12);
        this._algorithmAssertionQNames = new ArrayList();
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic256Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic192Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic128Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.TripleDesRsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic256Sha256QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic192Sha256QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic128Sha256QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.TripleDesSha256QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic256Sha256Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic192Sha256Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic128Sha256Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.TripleDesSha256Rsa15QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic256QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic192QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.Basic128QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.TripleDesQName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.InclusiveC14NQName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.SOAPNormalization10QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.STRTransform10QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.XPathFilter20QName12);
        this._algorithmAssertionQNames.add(PolicyConfigUtil.XPath10QName12);
        this._assertionQNames = new ArrayList();
        this._assertionQNames.add(PolicyConfigUtil.wssEncryptBeforeSigningQName);
        this._assertionQNames.add(PolicyConfigUtil.encryptedElementsQName12);
        this._assertionQNames.add(PolicyConfigUtil.contentEncryptedElementsQName12);
        this._assertionQNames.add(PolicyConfigUtil.encryptedPartsQName12);
        this._assertionQNames.add(PolicyConfigUtil.wssEncryptSignatureQName);
        this._assertionQNames.add(PolicyConfigUtil.wssIncludeTimestampQName12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportClientChallengeQName12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportIssuedTokensQName12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportRefEmbeddedToken12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportRefExternalURI12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportRefIssuerSerialQName12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportRefKeyIdentifierQName12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportRefThumbprintQName12);
        this._assertionQNames.add(PolicyConfigUtil.MustSupportServerChallengeQName12);
        this._assertionQNames.add(PolicyConfigUtil.onlySignEntireHeadersAndBodyQName12);
        this._assertionQNames.add(PolicyConfigUtil.RequireClientEntropyQName12);
        this._assertionQNames.add(PolicyConfigUtil.RequireServerEntropyQName12);
        this._assertionQNames.add(PolicyConfigUtil.RequireSignatureConfirmationQName12);
        this._assertionQNames.add(PolicyConfigUtil.signedElementsQName12);
        this._assertionQNames.add(PolicyConfigUtil.signedPartsQName12);
        this._assertionQNames.add(PolicyConfigUtil.SC13SecurityContextTokenQName);
        this._allAssertionQNames = new ArrayList();
        this._allAssertionQNames.addAll(this._algorithmAssertionQNames);
        this._allAssertionQNames.addAll(this._assertionQNames);
        this._allAssertionQNames.addAll(this._layoutAssertionQNames);
        this._allAssertionQNames.addAll(this._nestedAssertionQNames);
        this._allAssertionQNames.addAll(this._tokenPropertiesAssertionQNames);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Constructor");
        }
    }

    public ArrayList<QName> getSupportedWSPolicyAssertions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicySupportedAssertions", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicySupportedAssertions", this._allAssertionQNames);
        }
        return this._allAssertionQNames;
    }

    public ArrayList<QName> getWSPolicyAssertionsWithSupportBehaviour() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyAssertionsWithSupportBehaviour", this);
        }
        ArrayList<QName> result = new ArrayList<QName>();
        result.add(PolicyConfigUtil.signedElementsQName12);
        result.add(PolicyConfigUtil.signedPartsQName12);
        result.add(PolicyConfigUtil.encryptedElementsQName12);
        result.add(PolicyConfigUtil.encryptedPartsQName12);
        result.addAll(this._tokenPropertiesAssertionQNames);
        result.addAll(this._assertionQNames);
        result.addAll(this._nestedAssertionQNames);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyAssertionsWithSupportBehaviour", result);
        }
        return result;
    }

    public ArrayList<QName> getWSPolicyAssertionsWithCombineBehaviour() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyAssertionsWithCombineBehaviour", this);
        }
        ArrayList<QName> result = new ArrayList<QName>();
        result.add(PolicyConfigUtil.signedElementsQName12);
        result.add(PolicyConfigUtil.signedPartsQName12);
        result.add(PolicyConfigUtil.encryptedElementsQName12);
        result.add(PolicyConfigUtil.encryptedPartsQName12);
        result.add(PolicyConfigUtil.usernameTokenQName12);
        result.add(PolicyConfigUtil.X509TokenQName12);
        result.add(PolicyConfigUtil.KerberosTokenQName12);
        result.add(PolicyConfigUtil.SecureConversationTokenQName12);
        result.add(PolicyConfigUtil.LTPAToken12QName);
        result.add(PolicyConfigUtil.LTPAPropagationToken12QName);
        result.add(PolicyConfigUtil.CustomToken12QName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyAssertionsWithCombineBehaviour", result);
        }
        return result;
    }

    @Override
    public Assertion combine(Assertion a1, Assertion a2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combine", this);
        }
        QName name = a1.getAssertionName();
        Assertion result = null;
        if (name == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "combine", null);
            }
            return null;
        }
        if (name.equals(PolicyConfigUtil.signedPartsQName12)) {
            result = this.mergeParts(a1, a2);
        } else if (name.equals(PolicyConfigUtil.encryptedPartsQName12)) {
            result = this.mergeParts(a1, a2);
        } else if (name.equals(PolicyConfigUtil.signedElementsQName12)) {
            result = this.mergeElements(a1, a2);
        } else if (name.equals(PolicyConfigUtil.encryptedElementsQName12)) {
            result = this.mergeElements(a1, a2);
        } else if (name.equals(PolicyConfigUtil.usernameTokenQName12) || name.equals(PolicyConfigUtil.X509TokenQName12) || name.equals(PolicyConfigUtil.KerberosTokenQName12) || name.equals(PolicyConfigUtil.SecureConversationTokenQName12) || name.equals(PolicyConfigUtil.LTPAToken12QName) || name.equals(PolicyConfigUtil.LTPAPropagationToken12QName) || name.equals(PolicyConfigUtil.CustomToken12QName)) {
            return this.combineTokens(a1, a2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combine", result);
        }
        return result;
    }

    @Override
    public boolean supports(Assertion assertion, Map bindings) throws WSPolicyBindingsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supports", new Object[]{assertion, this});
        }
        boolean result = true;
        if (assertion == null || bindings == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "supports", null);
            }
            return result;
        }
        Object binding = bindings.get(Constants.WS_SECURITY_POLICY_TYPE_NAME);
        if (binding == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No binding. Transformation can not proceed:");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "supports Null binding");
            }
            throw new WSPolicyBindingsException();
        }
        try {
            if (binding instanceof byte[]) {
                String policyPackages = "com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:com.ibm.xmlns.prod.websphere._200608.ws_securitybinding:com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
                binding = WSSecurityAssertionTransform.byteArrayToJAXB((byte[])binding, policyPackages);
                bindings.put(Constants.WS_SECURITY_POLICY_TYPE_NAME, binding);
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "supports could not convert binding byte[] to JAXB", e);
            }
            throw new WSPolicyBindingsException(e);
        }
        QName name = assertion.getAssertionName();
        if (name.equals(PolicyConfigUtil.SC200502SecurityContextTokenQName)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.KerberosTokenQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.SecureConversationTokenQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509V1Token11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509V3Token10QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509V3Token11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssGssKerberosV5ApReqToken11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssKerberosV5ApReqToken11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.wssUsernameToken10QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.wssUsernameToken11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509Pkcs7Token10QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509Pkcs7Token11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509PkiPathV1Token10QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509PkiPathV1Token11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509V1Token11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509V3Token10QName)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.WssX509V3Token11QName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.LTPATokenQName)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.LTPAPropagationTokenQName)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.wssEncryptBeforeSigningQName)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.encryptedElementsQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.contentEncryptedElementsQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.encryptedPartsQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.wssEncryptSignatureQName)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.RequireClientEntropyQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.RequireServerEntropyQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.RequireSignatureConfirmationQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.signedElementsQName12)) {
            result = true;
        } else if (name.equals(PolicyConfigUtil.signedPartsQName12)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supports", result);
        }
        return result;
    }

    private Assertion mergeParts(Assertion assertion1, Assertion assertion2) {
        Parameter newParameter;
        Assertion result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeParts");
        }
        if (!this.mergeInAttributes(assertion1, assertion2, result = _wspFactory.createAssertion(assertion1.getAssertionName()))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeParts", null);
            }
            return null;
        }
        Iterator bodyIterator1 = assertion1.getParameters(PolicyConfigUtil.bodyQName12);
        if (bodyIterator1.hasNext()) {
            Iterator bodyIterator2 = assertion2.getParameters(PolicyConfigUtil.bodyQName12);
            if (bodyIterator2.hasNext()) {
                Parameter p = (Parameter)bodyIterator1.next();
                Parameter newParameter2 = _wspFactory.createParameter(p.getParameterName(), p.getParameterValue());
                result.setParameter(newParameter2);
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mergeParts", null);
                }
                return null;
            }
        }
        ArrayList<String> assertionHeaders1 = new ArrayList<String>();
        Iterator headerIterator1 = assertion1.getParameters(PolicyConfigUtil.headerQName12);
        while (headerIterator1.hasNext()) {
            Parameter p = (Parameter)headerIterator1.next();
            assertionHeaders1.add(p.getAttributeValue(NAMESPACEQAME));
        }
        ArrayList<String> assertionHeaders2 = new ArrayList<String>();
        Iterator headerIterator2 = assertion2.getParameters(PolicyConfigUtil.headerQName12);
        while (headerIterator2.hasNext()) {
            Parameter p = (Parameter)headerIterator2.next();
            String value = p.getAttributeValue(NAMESPACEQAME);
            if (assertionHeaders1.contains(value)) {
                assertionHeaders1.remove(value);
                newParameter = _wspFactory.createParameter(p.getParameterName(), p.getParameterValue());
                newParameter.setAttribute(NAMESPACEQAME, value);
                result.setParameter(newParameter);
                continue;
            }
            assertionHeaders2.add(value);
        }
        if (assertionHeaders1.size() > 0 || assertionHeaders2.size() > 0) {
            for (String value : assertionHeaders1) {
                newParameter = _wspFactory.createParameter(PolicyConfigUtil.headerQName, value);
                result.setParameter(newParameter);
            }
            for (String value : assertionHeaders1) {
                Parameter newParameter3 = _wspFactory.createParameter(PolicyConfigUtil.headerQName, value);
                result.setParameter(newParameter3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeParts", result);
        }
        return result;
    }

    private Assertion mergeElements(Assertion assertion1, Assertion assertion2) {
        Assertion result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeElements");
        }
        if (!this.mergeInAttributes(assertion1, assertion2, result = _wspFactory.createAssertion(assertion1.getAssertionName()))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeElements", null);
            }
            return null;
        }
        QName xPath = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "XPath");
        ArrayList<String> assertionXPath1 = new ArrayList<String>();
        Iterator xPathIterator1 = assertion1.getParameters(xPath);
        while (xPathIterator1.hasNext()) {
            Parameter p = (Parameter)xPathIterator1.next();
            assertionXPath1.add(p.getParameterValue());
        }
        ArrayList<String> assertionXPath2 = new ArrayList<String>();
        Iterator xPathIterator2 = assertion2.getParameters(xPath);
        while (xPathIterator2.hasNext()) {
            Parameter p = (Parameter)xPathIterator2.next();
            String value = p.getParameterValue();
            if (assertionXPath1.contains(value)) {
                assertionXPath1.remove(value);
                Parameter newParameter = _wspFactory.createParameter(p.getParameterName(), p.getParameterValue());
                result.setParameter(newParameter);
                continue;
            }
            assertionXPath2.add(value);
        }
        if (assertionXPath1.size() > 0 || assertionXPath2.size() > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeElements", null);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeElements", result);
        }
        return result;
    }

    private boolean mergeInAttributes(Assertion assertion1, Assertion assertion2, Assertion result) {
        QName attributeName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeInAttributes");
        }
        Iterator ita1 = assertion1.getAttributeNames();
        Iterator ita2 = assertion2.getAttributeNames();
        while (ita1.hasNext()) {
            attributeName = (QName)ita1.next();
            result.setAttribute(attributeName, assertion1.getAttributeValue(attributeName));
        }
        while (ita2.hasNext()) {
            attributeName = (QName)ita2.next();
            String attrValue1 = assertion1.getAttributeValue(attributeName);
            String attrValue2 = assertion2.getAttributeValue(attributeName);
            if (attrValue1 != null) {
                if (!attrValue1.equals(attrValue2)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "mergeInAttributes false");
                    }
                    return false;
                }
                result.setAttribute(attributeName, attrValue2);
                continue;
            }
            result.setAttribute(attributeName, attrValue2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeInAttributes true");
        }
        return true;
    }

    public Assertion combineTokens(Assertion assertion1, Assertion assertion2) {
        QName qn;
        QName qn2;
        Assertion assertion = _wspFactory.createAssertion(assertion1.getAssertionName());
        Iterator it1 = assertion1.getAllParameterNames();
        Vector<QName> v1 = new Vector<QName>();
        Iterator it2 = assertion2.getAllParameterNames();
        while (it1.hasNext()) {
            qn2 = (QName)it1.next();
            v1.add(qn2);
            Iterator itp1 = assertion1.getParameters(qn2);
            Iterator itp2 = assertion2.getParameters(qn2);
            Parameter p = (Parameter)itp1.next();
            Parameter merged = _wspFactory.createParameter(qn2, p.getParameterValue());
            merged = this.mergeParameters(merged, itp1);
            if (merged == null) {
                return null;
            }
            if ((merged = this.mergeParameters(merged, itp2)) == null) {
                return null;
            }
            assertion.setParameter(merged);
        }
        while (it2.hasNext()) {
            qn2 = (QName)it2.next();
            if (v1.contains(qn2)) continue;
            Iterator itp2 = assertion2.getParameters(qn2);
            Parameter p = (Parameter)itp2.next();
            Parameter merged = _wspFactory.createParameter(qn2, p.getParameterValue());
            if ((merged = this.mergeParameters(merged, itp2)) != null) continue;
            return null;
        }
        if (assertion1.getAttributeValue(PolicyConfigUtil.includeTokenQName12) == null) {
            assertion1.setAttribute(PolicyConfigUtil.includeTokenQName12, PolicyConfigUtil.includeTokenDefault12);
        }
        if (assertion2.getAttributeValue(PolicyConfigUtil.includeTokenQName12) == null) {
            assertion2.setAttribute(PolicyConfigUtil.includeTokenQName12, PolicyConfigUtil.includeTokenDefault12);
        }
        Iterator ita1 = assertion1.getAttributeNames();
        Iterator ita2 = assertion2.getAttributeNames();
        while (ita1.hasNext()) {
            qn = (QName)ita1.next();
            assertion.setAttribute(qn, assertion1.getAttributeValue(qn));
        }
        while (ita2.hasNext()) {
            qn = (QName)ita2.next();
            String attrStr1 = assertion1.getAttributeValue(qn);
            String attrStr2 = assertion2.getAttributeValue(qn);
            if (attrStr1 != null) {
                if (attrStr1.equals(attrStr2)) continue;
                return null;
            }
            assertion.setAttribute(qn, attrStr2);
        }
        return assertion;
    }

    private Parameter mergeParameters(Parameter merged, Iterator itp) {
        String mergedValue = merged.getParameterValue();
        QName qn = merged.getParameterName();
        while (itp.hasNext()) {
            boolean nullMergedValue;
            Parameter p = (Parameter)itp.next();
            String value = p.getParameterValue();
            boolean nullValue = value == null || value.equals("");
            boolean bl = nullMergedValue = mergedValue == null || mergedValue.equals("");
            if (nullValue && nullMergedValue) continue;
            if (!nullValue && !nullMergedValue) {
                if (mergedValue.equals(value)) continue;
                return null;
            }
            if (!nullMergedValue) continue;
            merged = _wspFactory.createParameter(qn, value);
            mergedValue = merged.getParameterValue();
        }
        return merged;
    }

    @Override
    public String getType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType()");
        }
        String type = Constants.WS_SECURITY_POLICY_TYPE_NAME;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType() returns \"" + type + "\"");
        }
        return type;
    }

    @Override
    public InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, Map<String, Object> transformOptions) throws TransformationException {
        return WSSecurityAssertionTransform.transformForClientConfiguration(policy, transformOptions);
    }

    @Override
    public PolicyInputStreamHolder transformForPublish(Map<String, Object> transformOptions) throws WSPolicyBindingsException, TransformationException {
        return WSSecurityAssertionTransform.transformForPublish(transformOptions);
    }

    @Override
    public PolicyInputStreamHolder transformForClientIntersection(InputStream policy, Map<String, Object> transformOptions) throws WSPolicyBindingsException, TransformationException {
        return WSSecurityAssertionTransform.transformForClientIntersection(policy, transformOptions);
    }

    @Override
    public List<Integer> getAssertionAttachPoints(QName assertionQName) {
        ArrayList<Integer> attachPoints = new ArrayList<Integer>();
        if (assertionQName != null) {
            if (assertionQName.getLocalPart().equals(PolicyConfigUtil.symmetricBindingQName12.getLocalPart())) {
                attachPoints.add(2);
                attachPoints.add(3);
            } else if (assertionQName.getLocalPart().equals(PolicyConfigUtil.asymmetricBindingQName12.getLocalPart())) {
                attachPoints.add(2);
                attachPoints.add(3);
            } else if (assertionQName.getLocalPart().equals(PolicyConfigUtil.supportingTokenQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.SignedsupportingTokenQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.SignedEncryptedSupportingTokensQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.EncryptedSupportingTokens.getLocalPart())) {
                attachPoints.add(2);
                attachPoints.add(3);
                attachPoints.add(4);
                attachPoints.add(5);
            } else if (assertionQName.getLocalPart().equals(PolicyConfigUtil.trust13QName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.trust10QName12.getLocalPart())) {
                attachPoints.add(2);
            } else if (assertionQName.getLocalPart().equals(PolicyConfigUtil.wss10QName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.wss11QName12.getLocalPart())) {
                attachPoints.add(2);
            } else if (assertionQName.getLocalPart().equals(PolicyConfigUtil.signedPartsQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.signedElementsQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.encryptedPartsQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.encryptedElementsQName12.getLocalPart()) || assertionQName.getLocalPart().equals(PolicyConfigUtil.contentEncryptedElementsQName12.getLocalPart())) {
                attachPoints.add(4);
                attachPoints.add(5);
                attachPoints.add(3);
                attachPoints.add(2);
            }
        }
        return attachPoints;
    }

    @Override
    public WSPolicyPreferenceResolver getWSPolicyPreferenceResolver() {
        return null;
    }

    @Override
    public List<QName> getProviderVocabularyRequired() {
        return null;
    }

    @Override
    public List<QName> getAssertionsWithConditionalClientCapability() {
        return null;
    }

    public String getPreferredPrefix(QName assertionQName) {
        if (assertionQName.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702")) {
            return "sp";
        }
        if (assertionQName.getNamespaceURI().equals("http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext")) {
            return "wsse";
        }
        return null;
    }
}

