/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wssecurity.handler.WSSecurityAssertionTransform;
import com.ibm.ws.wssecurity.handler.WSSecurityWSPolicyAssertionProcessor;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3.ns.ws_policy.Policy;

public class WSSecurityPolicyHolder {
    private static final TraceComponent tc = Tr.register(WSSecurityWSPolicyAssertionProcessor.class, "WS-Policy", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String POLICY_PACKAGES = "org.w3.ns.ws_policy:org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext";
    private Policy _input = null;
    private Policy _output = null;
    private Policy _main = null;
    private Object _bindings = null;

    protected WSSecurityPolicyHolder(PolicyInputStreamHolder pish) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityPolicyHolder");
        }
        this._main = this.inputStreamToPolicy(pish.getMain());
        this._input = this.inputStreamToPolicy(pish.getInput());
        this._output = this.inputStreamToPolicy(pish.getOutput());
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityPolicyHolder");
        }
    }

    protected WSSecurityPolicyHolder() {
    }

    public Policy getInput() {
        return this._input;
    }

    public void setInput(Policy input) {
        this._input = input;
    }

    public Policy getMain() {
        return this._main;
    }

    public void setMain(Policy neutral) {
        this._main = neutral;
    }

    public Policy getOutput() {
        return this._output;
    }

    public void setOutput(Policy output) {
        this._output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy inputStreamToPolicy(final InputStream policy) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "inputStreamToPolicy", policy);
        }
        Policy result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Policy>(){

                @Override
                public Policy run() throws JAXBException {
                    ClassLoader cl = WSSecurityAssertionTransform.class.getClassLoader();
                    JAXBContext context = JAXBContext.newInstance((String)WSSecurityPolicyHolder.POLICY_PACKAGES, (ClassLoader)cl);
                    Unmarshaller umPolicy = context.createUnmarshaller();
                    Object unmarshalled = umPolicy.unmarshal(policy);
                    return unmarshalled instanceof Policy ? (Policy)unmarshalled : null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception unmarshalling policy", e.getCause());
            }
        }
        finally {
            block15: {
                try {
                    policy.close();
                }
                catch (IOException e) {
                    if (!tc.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Exception closing policy stream", e);
                }
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "inputStreamToPolicy", result);
        }
        return result;
    }

    public Object getBindings() {
        return this._bindings;
    }

    public void setBindings(Object bindings) {
        this._bindings = bindings;
    }
}

