/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.platform.util.WSSSelfManagedData;
import com.ibm.ws.wssecurity.platform.util.WSSSelfManagedDataFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SelfManagedDataManager;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public abstract class WSSecurityGlobalHandler
extends AbstractHandler
implements Handler,
SelfManagedDataManager {
    protected boolean inboundHandler;
    private static final TraceComponent tc = Tr.register(WSSecurityGlobalHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static WSSSelfManagedData selfMgrData = WSSSelfManagedDataFactory.getInstance();

    @Override
    public abstract Handler.InvocationResponse invoke(MessageContext var1) throws AxisFault;

    @Override
    public ByteArrayOutputStream serializeSelfManagedData(MessageContext _mc) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSelfManagedData");
        }
        if (!WSSecurityGlobalHandler.isWebSphereServerProcess()) {
            return null;
        }
        HashMap<String, Subject> map = new HashMap<String, Subject>();
        String WSSSubject = Constants.WSSECURITY_TOKEN_WSSSUBJECT;
        Subject storedData = (Subject)_mc.getSelfManagedData(this.getClass(), 1);
        if (storedData != null) {
            map.put(WSSSubject, storedData);
        }
        byte[] byteData = selfMgrData.getSerializedSelfManagedData(map);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream oos = new DataOutputStream(baos);
        int byteData_length = byteData.length;
        oos.write(byteData, 0, byteData_length);
        oos.close();
        baos.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeSelfManagedData");
        }
        return baos;
    }

    @Override
    public void deserializeSelfManagedData(ByteArrayInputStream data, MessageContext _mc) throws IOException {
        byte[] dataByte;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deserializeSelfManagedData");
            }
            if (!WSSecurityGlobalHandler.isWebSphereServerProcess()) {
                return;
            }
            dataByte = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(data);
                dataByte = (byte[])ois.readObject();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "enable to deserialize self managed data", e);
            }
        }
        if (dataByte == null || dataByte.length == 0) {
            return;
        }
        Map map = selfMgrData.getDeserializedSelfManagedData(dataByte);
        if (map == null || map.size() == 0) {
            return;
        }
        Object obj = map.get(Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (obj != null && obj instanceof Subject) {
            _mc.setSelfManagedData(this.getClass(), 1, obj);
            _mc.setProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT, (Subject)obj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeSelfManagedData");
        }
    }

    @Override
    public void restoreTransientData(MessageContext _mc) {
    }

    protected void setSelfManagedData(MessageContext mc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSelfManagedData");
        }
        if (!WSSecurityGlobalHandler.isWebSphereServerProcess()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSelfManagedData. Not an WebSphere Server Process.");
            }
            return;
        }
        Subject subject = (Subject)mc.getProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (subject != null) {
            mc.setSelfManagedData(this.getClass(), 1, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSelfManagedData");
        }
    }

    protected static boolean isWebSphereServerProcess() {
        return PlatformContextUtil.isWebSphereServerProcess();
    }

    protected String getActionURI(MessageContext _mc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActionURI(MessageContext)");
        }
        String actionURI = ConfigUtil.getNonBlankString(_mc.getWSAAction());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actionURI from msgContext.getWSAAction()=" + actionURI);
        }
        if (actionURI == null) {
            actionURI = ConfigUtil.getNonBlankString(_mc.getSoapAction());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "actionURI from msgContext.getSoapAction()=" + actionURI);
            }
        }
        if (actionURI == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "neither WSAAction nor SoapAction included in message context");
            }
            actionURI = Axis2Util.getActionFromMessage(_mc);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STSPolicySetUtil.getActionFromMessage()" + actionURI);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActionURI(MessageContext)");
        }
        return actionURI;
    }
}

