/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.common.SCAndTrustConstants;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.WSSecurityGeneratorBase;
import com.ibm.ws.wssecurity.handler.WSSecurityGlobalHandler;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSGeneratorTransformImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class WSSecurityGeneratorHandler
extends WSSecurityGlobalHandler {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityGeneratorHandler.class.getName();
    private static final long serialVersionUID = 0L;
    private WSSecurityGeneratorBase _gh = null;
    private static final TraceComponent tc = Tr.register(WSSecurityGeneratorHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static boolean logPolicySetOverride = true;

    public WSSecurityGeneratorHandler() {
        this.inboundHandler = false;
    }

    @Override
    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
        this._gh = new WSSecurityGeneratorBase();
        try {
            this._gh.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext msgContext)");
        }
        boolean isServerSide = WSSContextManagerFactory.getInstance().processIsServer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isServerSide=" + isServerSide);
        }
        if (!isServerSide) {
            WSSContext context;
            Object obj2;
            String obj = System.getProperty("com.ibm.websphere.wssecurity.context.management");
            if (obj == null || "true".equalsIgnoreCase(obj)) {
                obj2 = msgContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                try {
                    context = (WSSContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws SoapSecurityException {
                            return WSSContextManagerFactory.getInstance().getSerializableContext();
                        }
                    });
                    if (obj2 == null) {
                        msgContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", context);
                    }
                    msgContext.setProperty("com.ibm.ws.wssecurity.constants.wssLoginPromptContext", context);
                }
                catch (PrivilegedActionException pe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught " + pe.getMessage());
                    }
                    throw AxisFault.makeFault(pe);
                }
            } else {
                obj2 = msgContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                try {
                    context = WSSContextFactory.getInstance();
                    if (obj2 == null) {
                        msgContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", context);
                    } else {
                        msgContext.setProperty("com.ibm.ws.wssecurity.constants.wssLoginPromptContext", context);
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught " + e.getMessage());
                    }
                    throw AxisFault.makeFault(e);
                }
            }
        }
        if (isServerSide) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isServerSide == true");
            }
            try {
                final MessageContext fMsgContext = msgContext;
                final PrivilegedExceptionAction invokeAction = new PrivilegedExceptionAction(){

                    public Object run() throws AxisFault {
                        return WSSecurityGeneratorHandler.this._invoke(fMsgContext);
                    }
                };
                Handler.InvocationResponse ir = (Handler.InvocationResponse)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        return (Handler.InvocationResponse)WSSContextFactory.getInstance().runWith(invokeAction, fMsgContext);
                    }
                });
                if (ir != null) {
                    return ir;
                }
            }
            catch (Exception we) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught " + we.getMessage());
                }
                throw AxisFault.makeFault(we);
            }
        }
        return this._invoke(msgContext);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Handler.InvocationResponse _invoke(MessageContext msgContext) throws AxisFault {
        void var5_16;
        void var5_14;
        boolean isServiceProvider;
        boolean isCancelResponseMessage;
        block82: {
            block85: {
                block86: {
                    SoapSecurityException se;
                    AxisOperation operation;
                    PolicySetConfiguration psc;
                    Parameter aParameter;
                    block83: {
                        block84: {
                            void var5_10;
                            boolean isTrustRequest;
                            Boolean isBootstrapMode;
                            block79: {
                                block80: {
                                    Object temp;
                                    block81: {
                                        block74: {
                                            block75: {
                                                block76: {
                                                    Object obj;
                                                    block77: {
                                                        block78: {
                                                            if (tc.isEntryEnabled()) {
                                                                Tr.entry(tc, "_invoke(MessageContext msgContext)");
                                                            }
                                                            isBootstrapMode = (boolean)Boolean.FALSE;
                                                            isTrustRequest = false;
                                                            isCancelResponseMessage = false;
                                                            Object var5_5 = null;
                                                            aParameter = null;
                                                            isServiceProvider = false;
                                                            try {
                                                                isServiceProvider = Axis2Util.isServiceProvider(msgContext);
                                                            }
                                                            catch (Exception e) {
                                                                throw AxisFault.makeFault(e);
                                                            }
                                                            if (tc.isDebugEnabled()) {
                                                                Tr.debug(tc, "isServiceProvider=" + isServiceProvider);
                                                            }
                                                            if (!isServiceProvider) break block74;
                                                            String actionURI = this.getActionURI(msgContext);
                                                            if (actionURI != null && (actionURI = actionURI.trim()).length() != 0 && (SCAndTrustConstants.NS_TRUST_200502_CANCEL_RSTR_MESSAGE_ACTION.equals(actionURI) || SCAndTrustConstants.NS_TRUST_V13_CANCEL_RSTR_MESSAGE_ACTION.equals(actionURI) || SCAndTrustConstants.NS_TRUST_V13_CANCEL_FINAL_RSTR_MESSAGE_ACTION.equals(actionURI) || SCAndTrustConstants.NS_SC_200502_CANCEL_RSTR_MESSAGE_ACTION.equals(actionURI) || SCAndTrustConstants.NS_SC_V13_CANCEL_RSTR_MESSAGE_ACTION.equals(actionURI))) {
                                                                isCancelResponseMessage = true;
                                                                if (tc.isDebugEnabled()) {
                                                                    Tr.debug(tc, "isCancelResponseMessage = true");
                                                                }
                                                            }
                                                            if (tc.isDebugEnabled()) {
                                                                String action = STSPolicySetUtil.mapTrustAction(actionURI);
                                                                Tr.debug(tc, "action returns from STSPolicySetUtil.mapTrustAction=" + action);
                                                            }
                                                            psc = null;
                                                            OperationContext opCtx = msgContext.getOperationContext();
                                                            if (opCtx == null) {
                                                                opCtx = (OperationContext)msgContext.getProperty("unverifiedOperationContext");
                                                            }
                                                            if (isCancelResponseMessage || opCtx == null) break block75;
                                                            MessageContext origMsgCtx = opCtx.getMessageContext("In");
                                                            if (origMsgCtx == null) break block76;
                                                            obj = origMsgCtx.getProperty("com.ibm.wssecurity.trust.server.policyset");
                                                            if (obj == null || !(obj instanceof PolicySetConfiguration)) break block77;
                                                            psc = (PolicySetConfiguration)obj;
                                                            if (tc.isDebugEnabled()) {
                                                                Tr.debug(tc, "Got PolicySetConfiguration from original MessageContext");
                                                            }
                                                            isTrustRequest = true;
                                                            Object obj2 = psc.getPolicyTypeBinding(PrivateGeneratorConfig.class);
                                                            if (obj2 == null) break block78;
                                                            if (obj2 instanceof PrivateGeneratorConfig) {
                                                                PrivateGeneratorConfig privateGeneratorConfig = (PrivateGeneratorConfig)obj2;
                                                                if (tc.isDebugEnabled()) {
                                                                    Tr.debug(tc, "GeneratorConfig for trust response=" + privateGeneratorConfig);
                                                                }
                                                                break block79;
                                                            } else {
                                                                if (obj2 instanceof Exception) {
                                                                    Exception e = (Exception)obj2;
                                                                    if (tc.isDebugEnabled()) {
                                                                        Tr.debug(tc, "Unable to process outbound SOAP message.  PolicySet not loaded properly.", e);
                                                                    }
                                                                    Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                                                                    if (e instanceof SoapSecurityException) {
                                                                        throw AxisFault.makeFault(e);
                                                                    }
                                                                    Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s01");
                                                                    SoapSecurityException se2 = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s01", e);
                                                                    throw AxisFault.makeFault(se2);
                                                                }
                                                                if (tc.isDebugEnabled()) {
                                                                    Tr.debug(tc, "Unable to process outbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj2);
                                                                }
                                                                Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s02", new Object[]{obj2.getClass().getName()});
                                                                SoapSecurityException se3 = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s02", obj2.getClass().getName());
                                                                throw AxisFault.makeFault(se3);
                                                            }
                                                        }
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "No PolicyType Binding");
                                                        }
                                                        break block79;
                                                    }
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Unable to get PolicySetConfiguration from original MessageContext, obj = " + obj);
                                                    }
                                                    break block79;
                                                }
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "OperationContext.getMessageContext(WSDLConstants.MESSAGE_LABEL_IN_VALUE) was null");
                                                }
                                                break block79;
                                            }
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "MessageContext.OperationContext() was null");
                                            }
                                            break block79;
                                        }
                                        Object tBoolean = msgContext.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty");
                                        Object cancelSCT = msgContext.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel");
                                        boolean bCancelSCT = false;
                                        if (cancelSCT != null && cancelSCT instanceof Boolean && ((Boolean)cancelSCT).booleanValue()) {
                                            bCancelSCT = true;
                                        }
                                        if (tBoolean == null || !(tBoolean instanceof Boolean)) break block79;
                                        isBootstrapMode = (Boolean)tBoolean;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "bootstrap property from message context=" + isBootstrapMode);
                                        }
                                        if (isBootstrapMode == null || !isBootstrapMode.booleanValue()) break block79;
                                        temp = msgContext.getProperty("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig");
                                        if (temp == null) break block80;
                                        if (!bCancelSCT) break block81;
                                        PrivateGeneratorConfig privateGeneratorConfig = (PrivateGeneratorConfig)temp;
                                        break block79;
                                    }
                                    if (temp instanceof PrivateGeneratorConfig) {
                                        PrivateGeneratorConfig privateGeneratorConfig = ((PrivateGeneratorConfig)temp).getBootstrapGeneratorConfig();
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "bootstrap policy=" + privateGeneratorConfig);
                                        }
                                        break block79;
                                    } else {
                                        if (temp instanceof Exception) {
                                            Exception e = (Exception)temp;
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Unable to process outbound SOAP message.  PolicySet not loaded properly.", e);
                                            }
                                            Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                                            if (e instanceof SoapSecurityException) {
                                                throw AxisFault.makeFault(e);
                                            }
                                            Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s01");
                                            SoapSecurityException se4 = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s01", e);
                                            throw AxisFault.makeFault(se4);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unable to process outbound SOAP message. Unexpected object in PolicyTypeBinding: " + temp);
                                        }
                                        Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s02", new Object[]{temp.getClass().getName()});
                                        SoapSecurityException se5 = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s02", temp.getClass().getName());
                                        throw AxisFault.makeFault(se5);
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "No PolicyType Binding");
                                }
                            }
                            if (var5_10 != null || isBootstrapMode.booleanValue() || isTrustRequest || isCancelResponseMessage) break block82;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Get policy for application");
                            }
                            if ((operation = msgContext.getAxisOperation()) == null || (aParameter = operation.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) == null) break block83;
                            Object obj = aParameter.getValue();
                            PolicySetConfiguration psc2 = null;
                            if (obj != null && obj instanceof PolicySetConfiguration) {
                                psc2 = (PolicySetConfiguration)obj;
                            } else {
                                AxisService service = msgContext.getAxisService();
                                obj = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey()).getValue();
                                if (obj != null && obj instanceof PolicySetConfiguration) {
                                    psc2 = (PolicySetConfiguration)obj;
                                }
                            }
                            if (psc2 == null) break block83;
                            obj = psc2.getPolicyTypeBinding(PrivateGeneratorConfig.class);
                            if (obj == null) break block84;
                            if (obj instanceof PrivateGeneratorConfig) {
                                PrivateGeneratorConfig privateGeneratorConfig = (PrivateGeneratorConfig)obj;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "app policy=" + privateGeneratorConfig);
                                }
                                break block83;
                            } else {
                                if (obj instanceof Exception) {
                                    Exception e = (Exception)obj;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unable to process outbound SOAP message.  PolicySet not loaded properly.", e);
                                    }
                                    Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                                    if (e instanceof SoapSecurityException) {
                                        throw AxisFault.makeFault(e);
                                    }
                                    Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s01");
                                    se = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s01", e);
                                    throw AxisFault.makeFault(se);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Unable to process outbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
                                }
                                Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s02", new Object[]{obj.getClass().getName()});
                                SoapSecurityException se6 = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s02", obj.getClass().getName());
                                throw AxisFault.makeFault(se6);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No PolicyType Binding");
                        }
                    }
                    if (operation != null && aParameter != null) break block85;
                    psc = null;
                    AxisService service = msgContext.getAxisService();
                    if (service == null || (aParameter = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) == null) break block85;
                    Object obj = aParameter.getValue();
                    if (obj != null && obj instanceof PolicySetConfiguration) {
                        psc = (PolicySetConfiguration)obj;
                    }
                    if (psc == null) break block85;
                    obj = psc.getPolicyTypeBinding(PrivateGeneratorConfig.class);
                    if (obj == null) break block86;
                    if (obj instanceof PrivateGeneratorConfig) {
                        PrivateGeneratorConfig privateGeneratorConfig = (PrivateGeneratorConfig)obj;
                        if (privateGeneratorConfig != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loaded policy using policy set.");
                        }
                        break block85;
                    } else {
                        if (obj instanceof Exception) {
                            Exception e = (Exception)obj;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unable to process outbound SOAP message.  PolicySet not loaded properly.", e);
                            }
                            Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                            if (e instanceof SoapSecurityException) {
                                throw AxisFault.makeFault(e);
                            }
                            Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s01");
                            SoapSecurityException se7 = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s01", e);
                            throw AxisFault.makeFault(se7);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unable to process outbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
                        }
                        Tr.error(tc, "security.wssecurity.WSSecurityGeneratorHandler.s02", new Object[]{obj.getClass().getName()});
                        se = SoapSecurityException.format("security.wssecurity.WSSecurityGeneratorHandler.s02", obj.getClass().getName());
                        throw AxisFault.makeFault(se);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No PolicyType Binding");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application Generator Policy=" + var5_14);
            }
        }
        if (!isCancelResponseMessage) {
            if (msgContext.getProperty("com.ibm.ws.wssecurity.constants.wssapi.key.generator") != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSAPI enables...");
                    Tr.debug(tc, "WSSAPI logPolicySetOverride = " + logPolicySetOverride);
                }
                if (msgContext.getProperty("com.ibm.ws.wssecurity.constants.wssapi.key.consumer") != null) {
                    WSSConsumingContext consCon = (WSSConsumingContext)msgContext.getProperty("com.ibm.ws.wssecurity.constants.wssapi.key.consumer");
                    HashMap<String, WSSConsumingContext> wssProperties = null;
                    wssProperties = (HashMap<String, WSSConsumingContext>)msgContext.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                    if (wssProperties == null) {
                        wssProperties = new HashMap<String, WSSConsumingContext>();
                    }
                    wssProperties.put("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", consCon);
                    msgContext.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", wssProperties);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSAPI_CONFIG_KEY_CONSUMER property not found in MessageContext. Response message will NOT be processed by web services security.");
                }
                if (var5_14 != null && !isServiceProvider && logPolicySetOverride) {
                    Tr.warning(tc, "security.wssecurity.WSSecurityConsumerHandler.s01");
                }
                if (var5_14 == null) {
                    try {
                        WSSGeneratorConfig wSSGeneratorConfig = WSSGeneratorTransformImpl.getInstance().transform(msgContext);
                    }
                    catch (WSSException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error in WSSAPI:", e);
                        }
                        throw AxisFault.makeFault(e);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSAPI not enabled");
            }
        }
        if (var5_16 != null) {
            try {
                this._gh.invoke(msgContext, (WSSGeneratorConfig)var5_16);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error in security handler:", e);
                }
                Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                throw AxisFault.makeFault(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContext msgContext)");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    static {
        String doNotLogPolicySetOverride = System.getProperty(Constants.SUPPRESS_POLICYSET_OVERRIDE_WARNING);
        if (doNotLogPolicySetOverride != null && doNotLogPolicySetOverride.length() != 0 && doNotLogPolicySetOverride.equalsIgnoreCase("true")) {
            logPolicySetOverride = false;
        }
    }
}

