/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSSecurityGeneratorBase
extends WSSGenerator {
    private static final TraceComponent tc = Tr.register(WSSecurityGeneratorBase.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityGeneratorBase.class.getName();
    private final ThreadLocal _threadStore = new ThreadLocal();
    private static Map _globalObjectCache = new HashMap();
    private boolean _initialized = false;
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.UsernameToken");
    private static TokenFactory _UNTtokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (!this._initialized) {
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            super.init(properties);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(MessageContext mcontext, WSSGeneratorConfig config2) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext mcontext[" + mcontext + "]," + "WSSGeneratorConfig config[" + config2 + "])");
        }
        MessageContext wsmcontext = mcontext;
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(wsmcontext);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>(50);
        context.put("com.ibm.wsspi.wssecurity.core.messageContext", mcontext);
        context.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", config2);
        try {
            super.invoke(null, null, context);
            if (tc.isDebugEnabled()) {
                SOAPEnvelope soapEnv = wsmcontext.getEnvelope();
                OMDocument doc = DOMUtil.getOwnerDocument(soapEnv);
                if (doc != null) {
                    Tr.debug(tc, "The message processed by: " + (isServer ? "server side" : "client side") + " " + this.getClass().getName() + " : ");
                    CommonLogUtils.logDebug(doc.getOMDocumentElement(), tc);
                } else {
                    Tr.debug(tc, "No SOAPEnvelope found!");
                }
            }
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".invoke", "111", this);
            Tr.error(tc, "security.wssecurity.WSSConsumer.s23", e);
            AxisFault af = AxisFault.makeFault(e);
            if (isServer) {
                if (e.getFaultCode() != null) {
                    af.setFaultCode(e.getFaultCode());
                } else {
                    af.setFaultCode(new QName(Constants.NS_SOAP, "Server.securityException"));
                }
            } else {
                af.setFaultCode(new QName(Constants.NS_SOAP, "Client.securityException"));
            }
            throw af;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContext mcontext,WSSGeneratorConfig config)");
        }
    }

    @Override
    public void retrieveCachedInformation(MessageContext context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveCachedInformation(MessageContext context)");
        }
        MessageContext mCtx = context;
        final String initialSenderId = this.getInitialSenderId(context);
        if (initialSenderId != null && initialSenderId.length() > 0) {
            UsernameTokenImpl unt = (UsernameTokenImpl)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UsernameTokenImpl unt1 = (UsernameTokenImpl)_UNTtokenFactory.getToken(true);
                    unt1.setUsername(initialSenderId);
                    return unt1;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved identifier of initial sender found [" + unt + "].");
            }
            context.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderId", unt);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Retrieved identifier of initial sender not found.");
        }
        X509Certificate initialCert = this.getInitialSenderCert(context);
        if (initialCert != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved cert of initial sender found [" + initialCert + "].");
            }
            context.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert", initialCert);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Retrieved cert of initial sender not found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveCachedInformation(MessageContext context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject(Object key[" + key + "])");
        }
        Object ret = null;
        if (key != null && (ret = this.getThreadStore().get(key)) == null) {
            Map map = _globalObjectCache;
            synchronized (map) {
                ret = _globalObjectCache.get(key);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject(Object key) " + (ret == null ? "not found" : "found"));
        }
        return ret;
    }

    private Map getThreadStore() {
        HashMap map = (HashMap)this._threadStore.get();
        if (map == null) {
            map = new HashMap();
            this._threadStore.set(map);
        }
        return map;
    }

    private String getInitialSenderId(MessageContext context) throws SoapSecurityException {
        Iterator<Principal> it;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderId()");
        }
        WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
        Subject subj = null;
        if (ctxMgr != null) {
            subj = (Subject)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
        }
        String id = null;
        if (subj != null && (it = subj.getPrincipals().iterator()).hasNext()) {
            id = it.next().getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderId() returns String[" + id + "]");
        }
        return id;
    }

    private X509Certificate getInitialSenderCert(MessageContext context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderCert()");
        }
        X509Certificate cert = null;
        WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        cert = (X509Certificate)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderCert");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial Sender Cert", cert);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderCert() returns X509Certificate[" + cert + "]");
        }
        return cert;
    }
}

