/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.WSSecurityConsumerBase;
import com.ibm.ws.wssecurity.handler.WSSecurityGeneratorHandler;
import com.ibm.ws.wssecurity.handler.WSSecurityGlobalHandler;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.SAMLTokenCacheHelper;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSConsumerTransformImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityFaultCode;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class WSSecurityConsumerHandler
extends WSSecurityGlobalHandler {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityConsumerHandler.class.getName();
    private static final long serialVersionUID = 0L;
    private static final TraceComponent tc = Tr.register(WSSecurityConsumerHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private WSSecurityConsumerBase _ch = null;

    public WSSecurityConsumerHandler() {
        this.inboundHandler = true;
    }

    @Override
    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
        this._ch = new WSSecurityConsumerBase();
        try {
            this._ch.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext msgContext)");
        }
        if (msgContext != null) {
            SAMLTokenCacheHelper.cacheSAMLToken(msgContext);
            boolean isServerSide = WSSContextManagerFactory.getInstance().processIsServer();
            if (isServerSide) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isServerSide == true");
                }
                try {
                    PrivilegedExceptionAction invokeAction;
                    Handler.InvocationResponse ir;
                    final MessageContext fMsgContext = msgContext;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "runWith MessageContext = " + fMsgContext);
                    }
                    if ((ir = (Handler.InvocationResponse)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(invokeAction = new PrivilegedExceptionAction(){

                        public Object run() throws AxisFault {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "invokeAction, MessageContext");
                            }
                            return WSSecurityConsumerHandler.this._invoke(fMsgContext);
                        }
                    }, fMsgContext){
                        final /* synthetic */ PrivilegedExceptionAction val$invokeAction;
                        final /* synthetic */ MessageContext val$fMsgContext;
                        {
                            this.val$invokeAction = privilegedExceptionAction;
                            this.val$fMsgContext = messageContext;
                        }

                        @Override
                        public Object run() throws SoapSecurityException {
                            return (Handler.InvocationResponse)WSSContextFactory.getInstance().runWith(this.val$invokeAction, this.val$fMsgContext);
                        }
                    })) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "runWith return non-null response");
                        }
                        return ir;
                    }
                }
                catch (PrivilegedActionException pe) {
                    Throwable t;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught " + pe.getMessage());
                    }
                    if ((t = pe.getCause()) instanceof SoapSecurityException) {
                        AxisFault af = AxisFault.makeFault(t);
                        if (((SoapSecurityException)t).getFaultCode() != null) {
                            af.setFaultCode(((SoapSecurityException)t).getFaultCode());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Fault Code =  " + ((SoapSecurityException)t).getFaultCode());
                            }
                        } else if (msgContext.getProperty("com.ibm.ws.wssecurity.sc.FaultCode") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Fault Code =  " + ((QName)msgContext.getProperty("com.ibm.ws.wssecurity.sc.FaultCode")).toString());
                            }
                            af.setFaultCode((QName)msgContext.getProperty("com.ibm.ws.wssecurity.sc.FaultCode"));
                            msgContext.removeProperty("com.ibm.ws.wssecurity.sc.FaultCode");
                        }
                        throw af;
                    }
                    throw AxisFault.makeFault(pe);
                }
            }
        }
        return this._invoke(msgContext);
    }

    private Handler.InvocationResponse _invoke(MessageContext msgContext) throws AxisFault {
        block65: {
            boolean isServerSide;
            boolean isCancelResponseMessage;
            boolean isTrustRequest;
            boolean isBootstrapMode;
            WSSConsumerConfig cCfg;
            block67: {
                OperationContext opCtx;
                block66: {
                    block68: {
                        Object obj;
                        block69: {
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "_invoke(MessageContext msgContext)");
                            }
                            cCfg = null;
                            isBootstrapMode = false;
                            isTrustRequest = false;
                            isCancelResponseMessage = false;
                            if (msgContext == null) break block65;
                            isServerSide = false;
                            try {
                                isServerSide = Axis2Util.isServiceProvider(msgContext);
                            }
                            catch (Exception e) {
                                throw AxisFault.makeFault(e);
                            }
                            if (!isServerSide) break block66;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "isServerSide == true");
                            }
                            String actionURI = this.getActionURI(msgContext);
                            this.setHttpSession(msgContext);
                            boolean trust = STSPolicySetUtil.isTrustRequest(msgContext, actionURI);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "isTrustRequest() returned" + trust);
                            }
                            String action = null;
                            if (trust) {
                                action = STSPolicySetUtil.mapTrustAction(actionURI);
                                if (action == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "action == null");
                                    }
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "action is " + action);
                                }
                            }
                            PolicySetConfiguration psc = null;
                            if (!trust || action == null || action.length() <= 0) break block67;
                            isTrustRequest = true;
                            try {
                                psc = STSPolicySetUtil.getTrustPolicySetConfiguration(msgContext, action, WSSecurityGeneratorHandler.class.getClassLoader());
                            }
                            catch (Exception e) {
                                throw AxisFault.makeFault(e);
                            }
                            if (psc == null) break block67;
                            msgContext.setProperty("com.ibm.wssecurity.trust.server.policyset", psc);
                            obj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class);
                            if (obj == null) break block68;
                            if (!(obj instanceof PrivateConsumerConfig)) break block69;
                            cCfg = (PrivateConsumerConfig)obj;
                            if (cCfg == null || !tc.isDebugEnabled()) break block67;
                            Tr.debug(tc, "Loaded trust policy set.");
                            break block67;
                        }
                        if (obj instanceof Exception) {
                            Exception e = (Exception)obj;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unable to process inbound SOAP message.  PolicySet not loaded properly.", e);
                            }
                            Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                            if (e instanceof SoapSecurityException) {
                                throw AxisFault.makeFault(e);
                            }
                            Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s02");
                            SoapSecurityException se = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s02", e);
                            throw AxisFault.makeFault(se);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unable to process inbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
                        }
                        Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s03", new Object[]{obj.getClass().getName()});
                        SoapSecurityException se = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s03", obj.getClass().getName());
                        throw AxisFault.makeFault(se);
                    }
                    if (!tc.isDebugEnabled()) break block67;
                    Tr.debug(tc, "No PolicyType Binding");
                    break block67;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isServerSide == false");
                }
                if ((opCtx = msgContext.getOperationContext()) == null) {
                    opCtx = (OperationContext)msgContext.getProperty("unverifiedOperationContext");
                }
                if (opCtx != null) {
                    HashMap allMsgCtxs = opCtx.getMessageContexts();
                    Set msgContexts = allMsgCtxs.entrySet();
                    for (Map.Entry singleMsgCtx : msgContexts) {
                        MessageContext tempMsgCtx = (MessageContext)singleMsgCtx.getValue();
                        if ((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel") != null && ((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel")).booleanValue()) {
                            isCancelResponseMessage = true;
                            tempMsgCtx.setProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(false));
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "isCancelResponseMessage = " + (Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel"));
                            break;
                        }
                        if ((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty") == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bootstrap property = " + (Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty"));
                        }
                        if (((Boolean)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty")).booleanValue()) {
                            isBootstrapMode = true;
                        }
                        if (!isBootstrapMode) continue;
                        if ((PrivateGeneratorConfig)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig") != null && (cCfg = ((PrivateGeneratorConfig)tempMsgCtx.getProperty("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig")).getBootstrapConsumerConfig()) != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Valid bootstrap config object");
                        }
                        tempMsgCtx.setProperty("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(false));
                        Object obj = tempMsgCtx.getProperty("SC_COOKIE_MAP");
                        if (obj == null || !(obj instanceof Map)) break;
                        Map cookieMap = (Map)obj;
                        obj = msgContext.getProperty("Cookie");
                        if (obj != null) {
                            cookieMap.put("Cookie", obj);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Added Cookie property to SC_COOKIE_MAP: " + obj);
                            }
                        }
                        if ((obj = msgContext.getProperty("Location")) == null) break;
                        cookieMap.put("Location", obj);
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Added Location property to SC_COOKIE_MAP: " + obj);
                        break;
                    }
                }
            }
            Parameter aParameter = null;
            PolicySetConfiguration psc = null;
            if (cCfg == null && !isBootstrapMode && !isTrustRequest) {
                AxisService service;
                AxisOperation operation = msgContext.getAxisOperation();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AxisOperation is " + (operation == null ? "null" : operation));
                }
                if (operation == null && (service = msgContext.getAxisService()) != null) {
                    operation = this.findAxisOperationForMessageContext(msgContext);
                }
                if (operation != null) {
                    Object obj = Axis2Util.getPolicySet(operation);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Axis2Util.getPolicySet( operation ) = " + (obj == null ? "null" : obj.getClass().getName()));
                    }
                    if (obj != null && obj instanceof PolicySetConfiguration) {
                        psc = (PolicySetConfiguration)obj;
                        cCfg = this.validateBindings(psc);
                    }
                }
                if (psc == null && (service = msgContext.getAxisService()) != null) {
                    try {
                        Object obj;
                        AxisEndpoint axisEndpoint = service.getEndpoint(service.getEndpointName());
                        aParameter = axisEndpoint != null ? axisEndpoint.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey()) : service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey());
                        if (aParameter != null && (obj = aParameter.getValue()) != null && obj instanceof PolicySetConfiguration) {
                            psc = (PolicySetConfiguration)obj;
                        }
                        if (WSSecurityConsumerHandler.hasOperationLevelPolicy(service, psc)) {
                            String description = ConfigUtil.getMessage("security.wssecurity.WSSecurityConsumerHandler.s05", new String[]{service.getName()});
                            throw new AxisFault(description, SoapSecurityFaultCode.FailedCheck);
                        }
                    }
                    catch (SoapSecurityException se) {
                        throw AxisFault.makeFault(se);
                    }
                    if (psc != null) {
                        cCfg = this.validateBindings(psc);
                    }
                }
            }
            if (!isCancelResponseMessage) {
                boolean consumerBindingsFound = false;
                if (msgContext.getProperty("com.ibm.ws.wssecurity.constants.wssapi.key.consumer") != null) {
                    consumerBindingsFound = true;
                } else {
                    HashMap wssProperties;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot find WSSAPI_CONFIG_KEY_CONSUMER on MessageContext. Look in WSS_PROPERTYMAP property map.");
                    }
                    if ((wssProperties = TokenHolder.getWssPropertyMapFromInboundMessageContext(msgContext)) != null) {
                        WSSConsumingContext consCon = (WSSConsumingContext)wssProperties.get("com.ibm.ws.wssecurity.constants.wssapi.key.consumer");
                        if (consCon != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found WSSAPI_CONFIG_KEY_CONSUMER in WSS_PROPERTYMAP map. Putting it on MessageContext Options.");
                            }
                            consumerBindingsFound = true;
                            msgContext.setProperty("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", consCon);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSS_PROPERTYMAP map not found.");
                    }
                }
                if (tc.isDebugEnabled() && consumerBindingsFound) {
                    Tr.debug(tc, "WSSAPI logPolicySetOverride = " + WSSecurityGeneratorHandler.logPolicySetOverride);
                }
                if (cCfg != null && consumerBindingsFound && !isServerSide && WSSecurityGeneratorHandler.logPolicySetOverride) {
                    Tr.warning(tc, "security.wssecurity.WSSecurityConsumerHandler.s01");
                }
                if (cCfg == null) {
                    if (consumerBindingsFound) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WSSAPI enables...");
                        }
                        try {
                            cCfg = WSSConsumerTransformImpl.getInstance().transform(msgContext);
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Error in WSSAPI: " + e.toString());
                            }
                            throw AxisFault.makeFault(e);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSSAPI consumer bindings not found. Response message will not be processed by web services security.");
                    }
                }
            }
            if (cCfg == null) {
                return Handler.InvocationResponse.CONTINUE;
            }
            try {
                this._ch.invoke(msgContext, cCfg);
                this.setSelfManagedData(msgContext);
                if (isBootstrapMode) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting Sandesha2AppProcessingDone to true");
                    }
                    msgContext.setProperty("Sandesha2AppProcessingDone", "true");
                }
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
                throw AxisFault.makeFault(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_invoke(MessageContext msgContext)");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setHttpSession(MessageContext msgContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHttpSession(MessageContext msgContext)");
        }
        boolean enableSession = false;
        if (msgContext != null) {
            Object obj;
            AxisService service;
            Object obj2;
            Parameter aParameter = null;
            PolicySetConfiguration psc = null;
            AxisOperation operation = msgContext.getAxisOperation();
            if (operation != null && (aParameter = operation.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) != null && (obj2 = aParameter.getValue()) != null && obj2 instanceof PolicySetConfiguration) {
                psc = (PolicySetConfiguration)obj2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found PolicySetConfiguration in AxisOperation");
                }
            }
            if (psc == null && (service = msgContext.getAxisService()) != null && (aParameter = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey())) != null && (obj = aParameter.getValue()) != null && obj instanceof PolicySetConfiguration) {
                psc = (PolicySetConfiguration)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found PolicySetConfiguration in AxisService");
                }
            }
            if (psc != null) {
                obj2 = psc.getPolicyTypeConfiguration(ConstantsRetrieverFactory.getInstance().getHTTPPolicyKey());
                if (obj2 != null && obj2 instanceof Properties) {
                    Properties attributes = (Properties)obj2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found http policy");
                    }
                    String sessionEnabled = attributes.getProperty(ConstantsRetrieverFactory.getInstance().getMaintainSessionKey());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Session enabled property = " + sessionEnabled);
                    }
                    if (sessionEnabled != null && "yes".equalsIgnoreCase(sessionEnabled)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting enableSession to true");
                        }
                        enableSession = true;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No http policy found");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No HTTP PolicySetConfiguration object found");
            }
        }
        if (enableSession) {
            Object obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to enabling session");
            }
            if ((obj = msgContext.getProperty("transport.http.servletRequest")) != null && obj instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)obj;
                HttpSession session = req.getSession(true);
                if (tc.isDebugEnabled()) {
                    if (session != null) {
                        Tr.debug(tc, "HTTP session is " + session.getId());
                    } else {
                        Tr.debug(tc, "HTTP session is null");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "transport.http.servletRequest is null or not of type HttpServletRequest");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not enabling session");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHttpSession(MessageContext msgContext)");
        }
    }

    private static boolean hasOperationLevelPolicy(AxisService service, PolicySetConfiguration endpointPsc) throws SoapSecurityException, AxisFault {
        Boolean hasOperationLevelPolicy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasOperationLevelPolicy(" + (service == null ? null : service.getName()) + ", " + endpointPsc + ")");
        }
        boolean has_operation_level = false;
        if (service == null) {
            Tr.error(tc, "security.wssecurity.WSEC6841E", new Object[]{"AxisService is NULL."});
            throw new SoapSecurityException("AxisService is NULL. Service for endpoint address not found.");
        }
        Parameter policySetAtOperation = service.getParameter("com.ibm.ws.wssecurity.handler.policySet.at.operation");
        if (policySetAtOperation != null && (hasOperationLevelPolicy = (Boolean)policySetAtOperation.getValue()) != null) {
            has_operation_level = hasOperationLevelPolicy;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "hasOperationLevelPolicy() return " + has_operation_level);
            }
            return has_operation_level;
        }
        QName serviceQName = Axis2Util.getServiceQName(service);
        String serviceQNameString = "";
        if (serviceQName != null) {
            serviceQNameString = serviceQName.toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy Set Configuration found for endpoint " + serviceQNameString + " is " + endpointPsc);
        }
        String resourceKey = "WebService:/" + serviceQNameString;
        String portName = Axis2Util.getPortName(service);
        resourceKey = resourceKey + "/" + portName + "/";
        Iterator operIter = service.getOperations();
        PolicySetConfiguration psc = null;
        while (operIter.hasNext()) {
            AxisOperation operation = (AxisOperation)operIter.next();
            QName operationName = operation.getName();
            String operResourceKey = resourceKey + operationName.getLocalPart();
            Object obj = null;
            if (operation != null) {
                obj = Axis2Util.getPolicySet(operation);
            }
            if ((psc = obj != null && obj instanceof PolicySetConfiguration ? (PolicySetConfiguration)obj : null) == null || endpointPsc != null && endpointPsc.equals(psc)) continue;
            Object pccObj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class);
            if (pccObj != null && pccObj instanceof PrivateConsumerConfig) {
                PrivateConsumerConfig pcc;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is operation level policySet with WSSSecurity PolicyType");
                }
                if ((pcc = (PrivateConsumerConfig)pccObj).getSkipOperationLevelPolicyCheck()) {
                    Tr.debug(tc, "checkOperationLevelPolicies checking is turned off.  Ignoring result and returning.");
                    break;
                }
                has_operation_level = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Policy Set Configuration for operation " + operationName + " using key '" + operResourceKey + "' is different from endpoint scope Policy Set Configuration");
                }
            }
            if (tc.isDebugEnabled()) {
                if (psc != null) {
                    Tr.debug(tc, "Operation PolicySetConfiguration = " + psc.toString());
                } else {
                    Tr.debug(tc, "operation psc is null");
                }
                if (endpointPsc != null) {
                    Tr.debug(tc, "Endpoint PolicySetConfiguration = " + endpointPsc.toString());
                } else {
                    Tr.debug(tc, "endpointPsc is null");
                }
            }
            if (tc.isDebugEnabled()) continue;
            break;
        }
        Boolean hasOperationLevelPolicy2 = new Boolean(has_operation_level);
        service.addParameter("com.ibm.ws.wssecurity.handler.policySet.at.operation", hasOperationLevelPolicy2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasOperationLevelPolicy() return " + has_operation_level);
        }
        return has_operation_level;
    }

    private AxisOperation findAxisOperationForMessageContext(MessageContext msgContext) {
        QName operationName;
        AxisOperation oper;
        Iterator operIter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAxisOperationForMessageContext(" + msgContext + ")");
        }
        AxisOperation operation = null;
        AxisService service = msgContext.getAxisService();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AxisService " + (service == null ? null : service.getName()));
        }
        if (service == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findAxisOperationForMessageContext() return " + operation);
            }
            return null;
        }
        String action = null;
        if (service != null) {
            action = this.getActionURI(msgContext);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ActionURI = " + action);
        }
        if (action != null) {
            operation = service.getOperationByAction(action);
            if (operation != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOperationByAction(" + action + ") found the axisOperation");
                }
            } else {
                operation = service.getOperationBySOAPAction(action);
                if (operation != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOperationBySOAPAction(" + action + ") found the axisOperation");
                }
            }
        }
        if (operation == null) {
            OperationContext opCtx;
            ConfigurationContext cCtx;
            RelatesTo relatesTo = msgContext.getRelatesTo();
            String relatesToStr = null;
            relatesToStr = relatesTo != null ? relatesTo.getValue() : this.getRelatesToFromMessage(msgContext);
            if (relatesToStr != null && (cCtx = msgContext.getConfigurationContext()) != null && (opCtx = cCtx.getOperationContext(relatesToStr)) != null) {
                operation = opCtx.getAxisOperation();
                if (operation != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOperationContext(" + relatesToStr + ") found the axisOperation " + operation.getName());
                }
                Tr.debug(tc, "about to show properties on operationContext");
                Iterator it = opCtx.getPropertyNames();
                while (it != null && it.hasNext()) {
                    String propName = (String)it.next();
                    Tr.debug(tc, "propertyName " + propName + " propertyValue " + opCtx.getProperty(propName));
                }
                HashMap msgCtxs = opCtx.getMessageContexts();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "msgContext Hashmap is " + msgCtxs);
                }
                Set msgCtxESet = msgCtxs.entrySet();
                for (Map.Entry entry : msgCtxESet) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "messageContext in map has key " + (String)entry.getKey() + " and value " + entry.getValue());
                    }
                    MessageContext eMsgCtx = (MessageContext)entry.getValue();
                    Tr.debug(tc, "about to show properties on operationContext's messageContext");
                    Iterator it2 = eMsgCtx.getPropertyNames();
                    while (it2 != null && it2.hasNext()) {
                        String propName = (String)it2.next();
                        Tr.debug(tc, "propertyName " + propName + " propertyValue " + eMsgCtx.getProperty(propName));
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            operIter = service.getOperations();
            while (operIter != null && operIter.hasNext()) {
                oper = (AxisOperation)operIter.next();
                if (oper == null) continue;
                operationName = oper.getName();
                Tr.debug(tc, "operation name " + operationName);
            }
        }
        if (operation == null && action != null) {
            operIter = service.getOperations();
            while (operIter != null && operIter.hasNext()) {
                oper = (AxisOperation)operIter.next();
                if (oper == null || (operationName = oper.getName()) == null || !action.equals(operationName.getLocalPart())) continue;
                operation = oper;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "operation name local part match to the action found the operation");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAxisOperationForMessageContext() return " + operation);
        }
        return operation;
    }

    private String getRelatesToFromMessage(MessageContext msgContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelatesToFromMessage(MessageContext");
        }
        SOAPEnvelope inEnvelope = msgContext.getEnvelope();
        String relatesTo = null;
        if (inEnvelope == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to get Envelope from the request messageContext");
            }
        } else {
            SOAPHeader header = inEnvelope.getHeader();
            if (header == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to get Header from the request envelope");
                }
            } else {
                OMElement elemActionHeader;
                String addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                ArrayList headerList = header.getHeaderBlocksWithNSURI(addressingNamespace);
                if (headerList == null || headerList.isEmpty()) {
                    addressingNamespace = "http://www.w3.org/2005/08/addressing";
                    headerList = header.getHeaderBlocksWithNSURI(addressingNamespace);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for " + addressingNamespace + ", " + "RelatesTo");
                }
                if (null != (elemActionHeader = header.getFirstChildWithName(new QName(addressingNamespace, "RelatesTo")))) {
                    relatesTo = elemActionHeader.getText();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "relatesTo: " + elemActionHeader.getText());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "relatesTo: <not found>");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelatesToFromMessage(MessageContext msgContext) returns = " + relatesTo);
        }
        return relatesTo;
    }

    /*
     * Enabled aggressive block sorting
     */
    PrivateConsumerConfig validateBindings(PolicySetConfiguration psc) throws AxisFault {
        PrivateConsumerConfig cCfg = null;
        if (psc == null) return cCfg;
        Object obj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class);
        if (obj == null) {
            if (!tc.isDebugEnabled()) return cCfg;
            Tr.debug(tc, "No PolicyType Binding");
            return cCfg;
        }
        if (obj instanceof PrivateConsumerConfig) {
            cCfg = (PrivateConsumerConfig)obj;
            if (cCfg == null) return cCfg;
            if (!tc.isDebugEnabled()) return cCfg;
            Tr.debug(tc, "Loaded policy using policy set.");
            return cCfg;
        }
        if (obj instanceof Exception) {
            Exception e = (Exception)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to process inbound SOAP message.  PolicySet not loaded properly.", e);
            }
            Tr.processException((Throwable)e, clsName + ".invoke", "%C", this);
            if (e instanceof SoapSecurityException) {
                throw AxisFault.makeFault(e);
            }
            Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s02");
            SoapSecurityException se = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s02", e);
            throw AxisFault.makeFault(se);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to process inbound SOAP message. Unexpected object in PolicyTypeBinding: " + obj);
        }
        Tr.error(tc, "security.wssecurity.WSSecurityConsumerHandler.s03", new Object[]{obj.getClass().getName()});
        SoapSecurityException se = SoapSecurityException.format("security.wssecurity.WSSecurityConsumerHandler.s03", obj.getClass().getName());
        throw AxisFault.makeFault(se);
    }
}

