/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSSecurityConsumerBase
extends WSSConsumer {
    private static final TraceComponent tc = Tr.register(WSSecurityConsumerBase.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityConsumerBase.class.getName();
    private boolean _initialized = false;

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (!this._initialized) {
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            super.init(properties);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(MessageContext mcontext, WSSConsumerConfig config2) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext mcontext[" + mcontext + "]," + "WSSConsumerConfig config[" + config2 + "])");
        }
        MessageContext wsmcontext = mcontext;
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(wsmcontext);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>(50);
        context.put("com.ibm.wsspi.wssecurity.core.messageContext", mcontext);
        context.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", config2);
        try {
            super.invoke(null, context);
            if (tc.isDebugEnabled()) {
                SOAPEnvelope soapEnv = wsmcontext.getEnvelope();
                OMDocument doc = DOMUtil.getOwnerDocument(soapEnv);
                if (doc != null) {
                    Tr.debug(tc, "The message processed by: " + (isServer ? "server side" : "client side") + " " + this.getClass().getName() + " : ");
                    CommonLogUtils.logDebug(doc.getOMDocumentElement(), tc);
                } else {
                    Tr.debug(tc, "No SOAPEnvelope found!");
                }
            }
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".invoke", "94", this);
            Tr.error(tc, "security.wssecurity.WSSConsumer.s23", e);
            AxisFault af = AxisFault.makeFault(e);
            if (isServer) {
                QName fault = e.getFaultCode();
                if (fault == null) {
                    fault = (QName)context.get("com.ibm.ws.wssecurity.sc.FaultCode");
                }
                if (fault != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Fault Code = " + fault.toString());
                    }
                    mcontext.setProperty("com.ibm.ws.wssecurity.sc.FaultCode", fault);
                    af.setFaultCode(fault);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Fault Code = NULL");
                    }
                    af.setFaultCode(new QName(Constants.NS_SOAP, "Server.securityException"));
                }
            } else {
                af.setFaultCode(new QName(Constants.NS_SOAP, "Client.securityException"));
            }
            throw af;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(WSSMessageContext mcontext,WSSConsumerConfig config)");
        }
    }
}

