/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wssecurity.admin.NamespacePrefixMapperImpl;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.handler.WSSecurityPolicyHolder;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext.WssCustomToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.EmptyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.QNameAssertionType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SerElementsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.TokenAssertionType;
import org.w3.ns.ws_policy.OperatorContentType;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityAssertionTransform {
    private static final TraceComponent tc = Tr.register(WSSecurityAssertionTransform.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String MESSAGE_FILE = "com.ibm.ws.wssecurity.resources.wssmessages";
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String MSG_KEY = "security.wssecurity.WSSecurityAssertionTransform.";
    protected static final String PACKAGE_SEC_POL12 = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200702";
    protected static final String PACKAGE_SEC_POL12_DRAFT = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200512";
    protected static final String PACKAGE_POL12 = "org.xmlsoap.schemas.ws._2004._09.policy";
    protected static final String PACKAGE_POL15 = "org.w3.ns.ws_policy";
    protected static final String PACKAGE_SEC_EXT10 = "com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext";
    protected static final String PACKAGE_SEC_EXT11 = "com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext";
    protected static final String PACKAGE_SEC_BINDING10 = "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding";
    protected static final String PACKAGE_SEC_BINDING11 = "com.ibm.xmlns.prod.websphere._200710.ws_securitybinding";
    private static final String NAMESPACE_WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String POLICY15_NAMESPACE = "http://www.w3.org/ns/ws-policy";
    private static final String PROPERTY_requireDerivedKey = "com.ibm.websphere.wssecurity.requireDerivedKey";
    private static final String PROPERTY_keyIdentifier = "com.ibm.websphere.wssecurity.keyIdentifier";
    private static final String PROPERTY_generateImpliedDerivedKey = "com.ibm.ws.wssecurity.token.generateImpliedDerivedKey";
    private static final String PROPERTY_NOPASSWORD = "com.ibm.wsspi.wssecurity.token.IDAssertion.isUsed";
    private static final QName exactlyOne15QName = new QName("http://www.w3.org/ns/ws-policy", "ExactlyOne");
    private static final QName all15QName = new QName("http://www.w3.org/ns/ws-policy", "All");
    private static final QName WSU_ID_QNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "id");
    protected static int PROVIDER = 1;
    protected static int CLIENT = 2;
    private static final QName WSP_OPTIONAL = new QName("http://www.w3.org/ns/ws-policy", "Optional");
    private static String LPTA_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='BinarySecurityToken'][(name(namespace::*[.='http://www.ibm.com/websphere/appserver/tokentype/5.0.2'])=substring-before(@ValueType,':')) and  concat((name(namespace::*[.='http://www.ibm.com/websphere/appserver/tokentype/5.0.2'])),':',substring-after(@ValueType,':')) = concat((name(namespace::*[.='http://www.ibm.com/websphere/appserver/tokentype/5.0.2'])),':LTPA')]";
    private static String LPTA_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='BinarySecurityToken'][(name(namespace::*[.='http://www.ibm.com/websphere/appserver/tokentype/5.0.2'])=substring-before(@ValueType,':')) and  concat((name(namespace::*[.='http://www.ibm.com/websphere/appserver/tokentype/5.0.2'])),':',substring-after(@ValueType,':')) = concat((name(namespace::*[.='http://www.ibm.com/websphere/appserver/tokentype/5.0.2'])),':LTPA')]";

    public static InputStream transformForClientConfiguration(PolicyInputStreamHolder policy, Map<String, Object> transformOptions) throws TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientConfiguration");
        }
        if (policy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No policy to transform:");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformForClientIntersection");
            }
            return null;
        }
        WSSecurityPolicyHolder policy15Sec12 = new WSSecurityPolicyHolder(policy);
        WSSecurityAssertionTransform.reverseIncludeTokenAttribute(policy15Sec12);
        WSSecurityAssertionTransform.callerPolicy(policy15Sec12, true);
        WSSecurityAssertionTransform.restoreTimestampSignatureXPath(policy15Sec12);
        WSSecurityAssertionTransform.removeTrust13Assertions(policy15Sec12.getMain());
        WSSecurityAssertionTransform.removeTrust13AssertionsFromBootstrap(policy15Sec12.getMain());
        WSSecurityAssertionTransform.restoreSupportingTokens(policy15Sec12);
        WSSecurityAssertionTransform.addDirectionalAttributesToEncryptSignature(policy15Sec12.getMain());
        Policy policy12Main = WSSecurityAssertionTransform.convertPolicyFrom15To12(policy15Sec12.getMain());
        if (policy12Main == null) {
            policy12Main = new Policy();
        }
        Policy policy12Input = WSSecurityAssertionTransform.convertPolicyFrom15To12(policy15Sec12.getInput());
        Policy policy12Output = WSSecurityAssertionTransform.convertPolicyFrom15To12(policy15Sec12.getOutput());
        Policy restoreAttributes = WSSecurityAssertionTransform.restoreDirectionalAttributes(policy12Main, policy12Input, policy12Output);
        WSSecurityAssertionTransform.nestProtectionTokensInSecureConversationAssertion(restoreAttributes);
        InputStream result = null;
        try {
            String policyPackages = "org.xmlsoap.schemas.ws._2004._09.policy:org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext";
            result = WSSecurityAssertionTransform.policyJAXBObjToStream(restoreAttributes, policyPackages);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to serialize result Policy" + e.toString());
            }
            throw new TransformationException((Object)(nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s01", new Object[0], "CWWSS7501E") + e));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "transformForClientConfiguration");
            Tr.debug(tc, WSSecurityAssertionTransform.streamToString(result));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientConfiguration");
        }
        return result;
    }

    public static PolicyInputStreamHolder transformForPublish(Map<String, Object> transformOptions) throws TransformationException, WSPolicyBindingsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForPublish");
        }
        Object obj = transformOptions.get("com.ibm.ws.wspolicy.PolicySetConfiguration");
        String uri = (String)transformOptions.get("com.ibm.ws.wspolicy.URI");
        PolicySetConfiguration psCfg = (PolicySetConfiguration)obj;
        if (psCfg == null || uri == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformForPublish missing transformOptions", new Object[]{psCfg, uri});
            }
            throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s01", new Object[0], "CWWSS7501E"));
        }
        Policy policyJAXB = WSSecurityAssertionTransform.getPolicyJAXB(psCfg);
        if (policyJAXB == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No policy to transform:");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformForPublish");
            }
            return null;
        }
        PolicyInboundConfig pic = WSSecurityAssertionTransform.getPolicyInboundConfig(psCfg);
        PolicyOutboundConfig poc = WSSecurityAssertionTransform.getPolicyOutboundConfig(psCfg);
        WSSecurityPolicyHolder policy15SecPol12 = WSSecurityAssertionTransform.convertSecuritySchemaTo12(policyJAXB, PROVIDER, uri, pic, poc);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy Schema changed to 1.2");
        }
        WSSecurityAssertionTransform.transformCommon(pic, poc, policy15SecPol12, PROVIDER);
        PolicyInputStreamHolder result = new PolicyInputStreamHolder();
        String packages = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:org.w3.ns.ws_policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext";
        result.setMain(WSSecurityAssertionTransform.policyJAXBObjToStream(policy15SecPol12.getMain(), packages));
        result.setInput(WSSecurityAssertionTransform.policyJAXBObjToStream(policy15SecPol12.getInput(), packages));
        result.setOutput(WSSecurityAssertionTransform.policyJAXBObjToStream(policy15SecPol12.getOutput(), packages));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TransformForClientIntersection");
            Tr.debug(tc, "Main:");
            Tr.debug(tc, WSSecurityAssertionTransform.streamToString(result.getMain()));
            Tr.debug(tc, "Input:");
            Tr.debug(tc, WSSecurityAssertionTransform.streamToString(result.getInput()));
            Tr.debug(tc, "Output");
            Tr.debug(tc, WSSecurityAssertionTransform.streamToString(result.getOutput()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForPublish");
        }
        return result;
    }

    public static PolicyInputStreamHolder transformForClientIntersection(InputStream policy, Map<String, Object> transformOptions) throws TransformationException, WSPolicyBindingsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientIntersection");
        }
        if (policy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No policy to transform:");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformForClientIntersection");
            }
            return null;
        }
        Object obj = transformOptions.get("com.ibm.ws.wspolicy.PolicySetConfiguration");
        PolicySetConfiguration psCfg = (PolicySetConfiguration)obj;
        if (psCfg == null || obj == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformForClientIntersection missing transformOptions", new Object[]{psCfg, null});
            }
            throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s01", new Object[0], "CWWSS7501E"));
        }
        PolicyInboundConfig pic = WSSecurityAssertionTransform.getPolicyInboundConfig(psCfg);
        PolicyOutboundConfig poc = WSSecurityAssertionTransform.getPolicyOutboundConfig(psCfg);
        String policyPackages = "org.xmlsoap.schemas.ws._2004._09.policy:org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext";
        Object object = null;
        try {
            object = WSSecurityAssertionTransform.inputStreamToJAXB(policy, policyPackages);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "transformForClientIntersection could not convert inputStream to JAXB", e);
            }
            throw new TransformationException((Object)(nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s01", new Object[0], "CWWSS7501E") + e));
        }
        Policy policyJAXB = null;
        if (object instanceof Policy) {
            policyJAXB = (Policy)object;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy unmarshalled");
        }
        WSSecurityPolicyHolder policy15SecPol12 = WSSecurityAssertionTransform.convertSecuritySchemaTo12(policyJAXB, CLIENT, null, pic, poc);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy Schema changed to 1.2");
        }
        WSSecurityAssertionTransform.transformCommon(pic, poc, policy15SecPol12, CLIENT);
        PolicyInputStreamHolder result = new PolicyInputStreamHolder();
        String packages = "org.oasis_open.docs.ws_sx.ws_securitypolicy._200702:org.w3.ns.ws_policy:com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext:com.ibm.xmlns.prod.websphere._200710.ws_securitypolicy_ext";
        result.setMain(WSSecurityAssertionTransform.policyJAXBObjToStream(policy15SecPol12.getMain(), packages));
        result.setInput(WSSecurityAssertionTransform.policyJAXBObjToStream(policy15SecPol12.getInput(), packages));
        result.setOutput(WSSecurityAssertionTransform.policyJAXBObjToStream(policy15SecPol12.getOutput(), packages));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientIntersection");
        }
        return result;
    }

    private static void transformCommon(PrivateConsumerConfig pic, PrivateGeneratorConfig poc, WSSecurityPolicyHolder policy, int direction) throws TransformationException, WSPolicyBindingsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformCommon");
        }
        WSSecurityAssertionTransform.signatureAssertions(policy, poc);
        WSSecurityAssertionTransform.algorithmSuiteAssertions(policy, pic.getSignatureConsumers(), poc.getOperationGenerators());
        WSSecurityAssertionTransform.kerberos(direction, policy, pic, poc);
        if (WSSecurityAssertionTransform.isEncryptBeforeSigning(policy.getMain(), poc)) {
            WSSecurityAssertionTransform.addBindingAssertion(PolicyConfigUtil.wssEncryptBeforeSigningQName, policy.getMain());
        }
        WSSecurityAssertionTransform.addMustSupportRefXxx(policy.getMain(), poc.getOperationGenerators(), direction);
        WSSecurityAssertionTransform.removeTimestampSignature(policy);
        WSSecurityAssertionTransform.caller(policy, pic, poc, direction);
        WSSecurityAssertionTransform.SC13SecurityContextToken(policy, poc.getOperationGenerators());
        WSSecurityAssertionTransform.usernameTokens(policy, pic, poc, direction);
        WSSecurityAssertionTransform.supportingTokens(policy);
        if (WSSecurityAssertionTransform.isOnlySignEntireHeadersAndBody(policy, pic, poc)) {
            WSSecurityAssertionTransform.addonlySignEntireHeadersAndBody(policy);
        }
        if (WSSecurityAssertionTransform.isTrust13Required(policy)) {
            WSSecurityAssertionTransform.addTrust13Assertions(policy);
        }
        WSSecurityAssertionTransform.mustNotSendAmend(policy);
        WSSecurityAssertionTransform.removeEmptyProtectionAssertions(policy);
        WSSecurityAssertionTransform.reverseIncludeTokenAttribute(policy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformCommon");
        }
    }

    private static WSSecurityPolicyHolder convertSecuritySchemaTo12(Policy policy, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        List<Object> children;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertSecuritySchemaTo12");
        }
        if ((children = policy.getPolicyOrAllOrExactlyOne()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nothing to convert");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertSecuritySchemaTo12");
            }
            return null;
        }
        WSSecurityPolicyHolder result = new WSSecurityPolicyHolder();
        org.w3.ns.ws_policy.Policy mainPolicy = new org.w3.ns.ws_policy.Policy();
        List<Object> mainChildren = mainPolicy.getPolicyOrAllOrExactlyOne();
        result.setMain(mainPolicy);
        org.w3.ns.ws_policy.Policy inputPolicy = new org.w3.ns.ws_policy.Policy();
        List<Object> inputCchildren = inputPolicy.getPolicyOrAllOrExactlyOne();
        result.setInput(inputPolicy);
        org.w3.ns.ws_policy.Policy outputPolicy = new org.w3.ns.ws_policy.Policy();
        List<Object> outputCchildren = outputPolicy.getPolicyOrAllOrExactlyOne();
        result.setOutput(outputPolicy);
        for (Object obj : children) {
            if (obj instanceof Policy) {
                Policy subPolicy = (Policy)obj;
                String idReference = subPolicy.getId();
                if (WSSecurityAssertionTransform.isDirectionID(idReference)) {
                    WSSecurityAssertionTransform.handleScopedAssertions(obj, inputCchildren, outputCchildren);
                    continue;
                }
                WSSecurityPolicyHolder subPolicyHolder = WSSecurityAssertionTransform.convertSecuritySchemaTo12(subPolicy, direction, uri, pic, poc);
                mainChildren.addAll(subPolicyHolder.getMain().getPolicyOrAllOrExactlyOne());
                inputCchildren.add(subPolicyHolder.getInput().getPolicyOrAllOrExactlyOne());
                outputCchildren.add(subPolicyHolder.getOutput().getPolicyOrAllOrExactlyOne());
                continue;
            }
            if (obj instanceof JAXBElement) {
                mainChildren.add(WSSecurityAssertionTransform.handleAssertion(obj, inputCchildren, outputCchildren, direction, uri, pic, poc));
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{obj});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertSecuritySchemaTo12");
        }
        return result;
    }

    private static JAXBElement handleAssertion(Object assertion, List<Object> input, List<Object> output, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAssertion");
        }
        JAXBElement assertionJAXB = (JAXBElement)assertion;
        QName assertionName = assertionJAXB.getName();
        JAXBElement result = null;
        if (PolicyConfigUtil.asymmetricBindingQName.equals(assertionName)) {
            result = WSSecurityAssertionTransform.binding(assertionJAXB, direction, uri, pic, poc);
        } else if (PolicyConfigUtil.symmetricBindingQName.equals(assertionName)) {
            result = WSSecurityAssertionTransform.binding(assertionJAXB, direction, uri, pic, poc);
        } else if (PolicyConfigUtil.supportingTokenQName.equals(assertionName)) {
            WSSecurityAssertionTransform.supportingToken(assertionJAXB, input, output, direction, uri, pic, poc);
        } else if (PolicyConfigUtil.wss10QName.equals(assertionName)) {
            result = WSSecurityAssertionTransform.wss10(assertionJAXB);
        } else if (PolicyConfigUtil.wss11QName.equals(assertionName)) {
            result = WSSecurityAssertionTransform.wss11(assertionJAXB);
        } else if (PolicyConfigUtil.trust10QName.equals(assertionName)) {
            result = WSSecurityAssertionTransform.trust(assertionJAXB);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JAXBElement not handled yet: " + assertionName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAssertion");
        }
        return result;
    }

    private static void handleScopedAssertions(Object policyObj, List<Object> inputPolicies, List<Object> outputPolicies) {
        Policy policy;
        String idReference;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleScopedAssertions");
        }
        if (WSSecurityAssertionTransform.isDirectionID(idReference = (policy = (Policy)policyObj).getId())) {
            List<Object> policyChildren = policy.getPolicyOrAllOrExactlyOne();
            for (Object obj : policyChildren) {
                if (!(obj instanceof JAXBElement)) continue;
                JAXBElement assertionJAXB = (JAXBElement)obj;
                QName name = assertionJAXB.getName();
                JAXBElement newAssertion = null;
                if (PolicyConfigUtil.signedPartsQName.equals(name)) {
                    org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType sp = WSSecurityAssertionTransform.signedParts(assertionJAXB);
                    newAssertion = new JAXBElement(PolicyConfigUtil.signedPartsQName12, org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType.class, (Object)sp);
                } else if (PolicyConfigUtil.encryptedPartsQName.equals(name)) {
                    org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType ep = WSSecurityAssertionTransform.encryptedParts(assertionJAXB);
                    newAssertion = new JAXBElement(PolicyConfigUtil.encryptedPartsQName12, org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType.class, (Object)ep);
                } else if (PolicyConfigUtil.signedElementsQName.equals(name)) {
                    SerElementsType se = WSSecurityAssertionTransform.signedElements(assertionJAXB);
                    newAssertion = new JAXBElement(PolicyConfigUtil.signedElementsQName12, SerElementsType.class, (Object)se);
                } else if (PolicyConfigUtil.encryptedElementsQName.equals(name)) {
                    SerElementsType ee = WSSecurityAssertionTransform.encryptedElements(assertionJAXB);
                    newAssertion = new JAXBElement(PolicyConfigUtil.encryptedElementsQName12, SerElementsType.class, (Object)ee);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{name});
                }
                if (idReference.startsWith("request:")) {
                    inputPolicies.add(newAssertion);
                    continue;
                }
                if (!idReference.startsWith("response:")) continue;
                outputPolicies.add(newAssertion);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleScopedAssertions");
        }
    }

    private static SerElementsType encryptedElements(JAXBElement jaxbel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptedElements");
        }
        SerElementsType result = new SerElementsType();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType encryptedElementAssertion = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType)jaxbel.getValue();
        List<String> encryptedElements = encryptedElementAssertion.getXPath();
        if (encryptedElements != null) {
            result.getXPath().addAll(encryptedElements);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptedElements");
        }
        return result;
    }

    private static SerElementsType signedElements(JAXBElement jaxbel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signedElements");
        }
        SerElementsType result = new SerElementsType();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType signedElementAssertion = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType)jaxbel.getValue();
        List<String> signedElements = signedElementAssertion.getXPath();
        if (signedElements != null) {
            result.getXPath().addAll(signedElements);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signedElements");
        }
        return result;
    }

    private static org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType encryptedParts(JAXBElement jaxbel) {
        List<HeaderType> headers;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptedParts");
        }
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType result = new org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType();
        SePartsType messageParts = (SePartsType)jaxbel.getValue();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.EmptyType bodyPart = messageParts.getBody();
        if (bodyPart != null) {
            EmptyType newBodyPart = new EmptyType();
            result.setBody(newBodyPart);
        }
        if ((headers = messageParts.getHeader()) != null) {
            for (HeaderType header : headers) {
                String namespace = header.getNamespace();
                QName name = header.getName();
                org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType newHeader = new org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType();
                newHeader.setNamespace(namespace);
                newHeader.setName(name);
                result.getHeader().add(newHeader);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptedParts");
        }
        return result;
    }

    private static org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType signedParts(JAXBElement jaxbel) {
        List<HeaderType> headers;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signedParts");
        }
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType result = new org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType();
        SePartsType messageParts = (SePartsType)jaxbel.getValue();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.EmptyType bodyPart = messageParts.getBody();
        if (bodyPart != null) {
            EmptyType newBodyPart = new EmptyType();
            result.setBody(newBodyPart);
        }
        if ((headers = messageParts.getHeader()) != null) {
            for (HeaderType header : headers) {
                String namespace = header.getNamespace();
                QName name = header.getName();
                org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType newHeader = new org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType();
                newHeader.setNamespace(namespace);
                newHeader.setName(name);
                result.getHeader().add(newHeader);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signedParts");
        }
        return result;
    }

    private static JAXBElement trust(JAXBElement jaxbel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trust");
        }
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.trust10QName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
        List<Object> assertions = nested.getPolicy().getPolicyOrAllOrExactlyOne();
        for (Object potentialAssertion : assertions) {
            if (potentialAssertion instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "JAXBElement not handled yet: ", new Object[]{potentialAssertion});
                continue;
            }
            if (!(potentialAssertion instanceof JAXBElement)) continue;
            JAXBElement assertion = (JAXBElement)potentialAssertion;
            QName assertionName = assertion.getName();
            QName newassertionName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", assertionName.getLocalPart());
            EmptyType newEmptyType = new EmptyType();
            JAXBElement newassertionJAXB = new JAXBElement(newassertionName, EmptyType.class, (Object)newEmptyType);
            newSubAssertions.add(newassertionJAXB);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trust10");
        }
        return result;
    }

    private static JAXBElement wss11(JAXBElement jaxbel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wss11");
        }
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.wss11QName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
        List<Object> assertions = nested.getPolicy().getPolicyOrAllOrExactlyOne();
        for (Object potentialAssertion : assertions) {
            if (potentialAssertion instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{potentialAssertion});
                continue;
            }
            if (!(potentialAssertion instanceof JAXBElement)) continue;
            JAXBElement assertion = (JAXBElement)potentialAssertion;
            QName assertionName = assertion.getName();
            QName newAssertionName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", assertionName.getLocalPart());
            QNameAssertionType newAssertion = new QNameAssertionType();
            JAXBElement newAssertionJAXB = new JAXBElement(newAssertionName, QNameAssertionType.class, (Object)newAssertion);
            newSubAssertions.add(newAssertionJAXB);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wss11");
        }
        return result;
    }

    private static JAXBElement wss10(JAXBElement jaxbel) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wss10");
        }
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.wss10QName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
        List<Object> assertions = nested.getPolicy().getPolicyOrAllOrExactlyOne();
        for (Object potentialAssertion : assertions) {
            if (potentialAssertion instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{potentialAssertion});
                continue;
            }
            if (!(potentialAssertion instanceof JAXBElement)) continue;
            JAXBElement assertion = (JAXBElement)potentialAssertion;
            QName assertionName = assertion.getName();
            QName newAssertionName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", assertionName.getLocalPart());
            QNameAssertionType newQNType = new QNameAssertionType();
            JAXBElement newAssertionJAXB = new JAXBElement(newAssertionName, QNameAssertionType.class, (Object)newQNType);
            newSubAssertions.add(newAssertionJAXB);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wss10");
        }
        return result;
    }

    private static void supportingToken(JAXBElement jaxbel, List<Object> input, List<Object> output, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportingToken");
        }
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)jaxbel.getValue();
        Policy supportingTokenPolicy = nested.getPolicy();
        String idReference = supportingTokenPolicy.getId();
        for (JAXBElement protectionToken : WSSecurityAssertionTransform.getProtectionToken(jaxbel, direction, uri, pic, poc)) {
            if (idReference.startsWith("request:")) {
                input.add(protectionToken);
                continue;
            }
            if (!idReference.startsWith("response:")) continue;
            output.add(protectionToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportingToken");
        }
    }

    private static JAXBElement binding(JAXBElement assertionJAXB, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "binding");
        }
        QName assertionQName = assertionJAXB.getName();
        NestedPolicyType newNested = new NestedPolicyType();
        QName newassertionQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", assertionQName.getLocalPart(), "sp");
        JAXBElement result = new JAXBElement(newassertionQName, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nested = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)assertionJAXB.getValue();
        List<Object> assertions = nested.getPolicy().getPolicyOrAllOrExactlyOne();
        for (Object potentialAssertion : assertions) {
            if (potentialAssertion instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{potentialAssertion});
                continue;
            }
            if (!(potentialAssertion instanceof JAXBElement)) continue;
            JAXBElement assertion = (JAXBElement)potentialAssertion;
            String assertionName = assertion.getName().getLocalPart();
            if (WSSecurityAssertionTransform.isProtectionToken(assertionName)) {
                for (JAXBElement protectionToken : WSSecurityAssertionTransform.getProtectionToken(assertion, direction, uri, pic, poc)) {
                    newSubAssertions.add(protectionToken);
                }
                continue;
            }
            if (PolicyConfigUtil.algorithmSuiteQName.getLocalPart().equals(assertionName)) {
                newSubAssertions.add(WSSecurityAssertionTransform.algorithmSuite(assertion));
                continue;
            }
            if (PolicyConfigUtil.layoutQName.getLocalPart().equals(assertionName)) {
                newSubAssertions.add(WSSecurityAssertionTransform.layout(assertion));
                continue;
            }
            if (PolicyConfigUtil.wssIncludeTimestampQName.getLocalPart().equals(assertionName)) {
                QNameAssertionType emptyType = new QNameAssertionType();
                JAXBElement newTimeStamp = new JAXBElement(PolicyConfigUtil.wssIncludeTimestampQName12, EmptyType.class, (Object)emptyType);
                newSubAssertions.add(newTimeStamp);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{assertionName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "binding");
        }
        return result;
    }

    private static JAXBElement layout(JAXBElement assertion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "layout");
        }
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.layoutQName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        Object layoutAssertion = null;
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType np = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)assertion.getValue();
        Policy tokenPolicy = np.getPolicy();
        List<Object> layoutChildren = tokenPolicy.getPolicyOrAllOrExactlyOne();
        for (Object layoutObj : layoutChildren) {
            if (layoutObj instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{layoutObj});
                continue;
            }
            if (!(layoutObj instanceof JAXBElement)) continue;
            JAXBElement layout = (JAXBElement)layoutObj;
            QName name = layout.getName();
            QName newAssertionQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", name.getLocalPart());
            QNameAssertionType emptyType = new QNameAssertionType();
            JAXBElement newLayout = new JAXBElement(newAssertionQName, EmptyType.class, (Object)emptyType);
            newSubAssertions.add(newLayout);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "layout");
        }
        return result;
    }

    private static JAXBElement algorithmSuite(JAXBElement algSuiteAssertion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "algorithmSuite");
        }
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.algorithmSuiteQName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy newSubPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(newSubPolicy);
        List<Object> newSubAssertions = newSubPolicy.getPolicyOrAllOrExactlyOne();
        Object newAlgorithmSuite = null;
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType np = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)algSuiteAssertion.getValue();
        Policy policy = np.getPolicy();
        List<Object> algSuiteChildren = policy.getPolicyOrAllOrExactlyOne();
        for (Object algorithmObj : algSuiteChildren) {
            if (algorithmObj instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{algorithmObj});
                continue;
            }
            if (!(algorithmObj instanceof JAXBElement)) continue;
            JAXBElement algorithm = (JAXBElement)algorithmObj;
            QName name = algorithm.getName();
            QName newAssertionQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", name.getLocalPart());
            QNameAssertionType emptyType = new QNameAssertionType();
            JAXBElement newLayout = new JAXBElement(newAssertionQName, EmptyType.class, (Object)emptyType);
            newSubAssertions.add(newLayout);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "algorithmSuite");
        }
        return result;
    }

    private static List<JAXBElement> getProtectionToken(JAXBElement tokenWrapper, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType nestedTokenType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProtectionToken");
        }
        ArrayList<JAXBElement> newTokensSameWrapper = new ArrayList<JAXBElement>();
        Object tokenWrapperValue = tokenWrapper.getValue();
        if (tokenWrapperValue instanceof org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType && (nestedTokenType = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)tokenWrapper.getValue()).getPolicy() != null) {
            Policy assertionPolicy = nestedTokenType.getPolicy();
            List<Object> tokens = assertionPolicy.getPolicyOrAllOrExactlyOne();
            if (tokens.size() > 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "More than signature or encryption token was found");
                }
                throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s02", new Object[0], "CWWSS7502E"));
            }
            for (Object token : tokens) {
                JAXBElement tokenJAXB;
                JAXBElement protectionToken;
                if (token instanceof Element) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{token});
                    continue;
                }
                if (!(token instanceof JAXBElement) || (protectionToken = WSSecurityAssertionTransform.getToken(tokenJAXB = (JAXBElement)token, direction, uri, pic, poc)) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found a Token with name : " + protectionToken.getName());
                }
                newTokensSameWrapper.add(protectionToken);
            }
        }
        ArrayList<JAXBElement> results = new ArrayList<JAXBElement>();
        if (!newTokensSameWrapper.isEmpty()) {
            QName tokenWrapperName = tokenWrapper.getName();
            QName newTokenWrapperName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", tokenWrapperName.getLocalPart());
            NestedPolicyType newWrapperAssertion = new NestedPolicyType();
            JAXBElement result = new JAXBElement(newTokenWrapperName, NestedPolicyType.class, (Object)newWrapperAssertion);
            org.w3.ns.ws_policy.Policy wrapperPolicy = new org.w3.ns.ws_policy.Policy();
            newWrapperAssertion.getAny().add(wrapperPolicy);
            List<Object> newTokens = wrapperPolicy.getPolicyOrAllOrExactlyOne();
            newTokens.addAll(newTokensSameWrapper);
            results.add(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProtectionToken");
        }
        return results;
    }

    private static JAXBElement getToken(JAXBElement token, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getToken");
        }
        QName parentTokenQName = token.getName();
        String includeToken = null;
        if (parentTokenQName.equals(PolicyConfigUtil.SecureConversationTokenQName)) {
            org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType scTokenType = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType)token.getValue();
            includeToken = scTokenType.getIncludeToken();
        } else {
            org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType tokenValue = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType)token.getValue();
            includeToken = tokenValue.getIncludeToken();
        }
        JAXBElement result = null;
        String parentTokenName = parentTokenQName.getLocalPart();
        if (parentTokenName.equals("X509Token") || parentTokenName.equals("UsernameToken") || parentTokenName.equals(PolicyConfigUtil.KerberosTokenQName)) {
            result = WSSecurityAssertionTransform.tokenAssertionType(token);
        } else if (parentTokenName.equals("SecureConversationToken")) {
            result = WSSecurityAssertionTransform.secureConversation(token, direction, uri, pic, poc);
        } else if (parentTokenName.equals("LTPAToken")) {
            result = WSSecurityAssertionTransform.ltpaToken(token);
        } else if (parentTokenName.equals("LTPAPropagationToken")) {
            result = WSSecurityAssertionTransform.ltpaPropagationToken(token);
        } else if (parentTokenName.equals("CustomToken")) {
            result = WSSecurityAssertionTransform.customToken(token);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{parentTokenName});
        }
        if (includeToken != "" && includeToken != null) {
            includeToken = WSSecurityAssertionTransform.changeNamespace(includeToken);
            if (parentTokenQName.equals(PolicyConfigUtil.SecureConversationTokenQName)) {
                ((SecureConversationTokenType)result.getValue()).setIncludeToken(includeToken);
            } else {
                ((TokenAssertionType)result.getValue()).setIncludeToken(includeToken);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getToken");
        }
        return result;
    }

    private static String changeNamespace(String includeToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNamespace");
        }
        String result = null;
        if (includeToken != null && includeToken.lastIndexOf(47) != -1) {
            result = includeToken.replaceAll("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNamespace", new Object[]{result});
        }
        return result;
    }

    private static JAXBElement ltpaToken(JAXBElement token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ltpaToken");
        }
        JAXBElement result = null;
        TokenAssertionType newLTPA = new TokenAssertionType();
        result = new JAXBElement(PolicyConfigUtil.LTPAToken12QName, TokenAssertionType.class, (Object)newLTPA);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ltpaToken");
        }
        return result;
    }

    private static JAXBElement ltpaPropagationToken(JAXBElement token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ltpaPropagationToken");
        }
        JAXBElement result = null;
        TokenAssertionType newLTPA = new TokenAssertionType();
        result = new JAXBElement(PolicyConfigUtil.LTPAPropagationToken12QName, TokenAssertionType.class, (Object)newLTPA);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ltpaPropagationToken");
        }
        return result;
    }

    private static JAXBElement customToken(JAXBElement token) {
        Object policy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "customToken");
        }
        JAXBElement result = null;
        TokenAssertionType newNested = new TokenAssertionType();
        QName name = token.getName();
        QName newName = new QName("http://www.ibm.com/xmlns/prod/websphere/200710/ws-securitypolicy-ext", name.getLocalPart());
        result = new JAXBElement(newName, TokenAssertionType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType tokenValue = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType)token.getValue();
        List<Object> policyAssertionList = tokenValue.getAny();
        if (policyAssertionList != null && policyAssertionList.size() > 0 && (policy = policyAssertionList.get(0)) instanceof Policy) {
            Policy assertionPolicy = (Policy)policy;
            List<Object> policyAssertions = assertionPolicy.getPolicyOrAllOrExactlyOne();
            for (Object potentialAssertion : policyAssertions) {
                if (!(potentialAssertion instanceof com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken)) continue;
                com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken wssCustomToken = (com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken)potentialAssertion;
                String localName = wssCustomToken.getLocalname();
                if (localName == null) {
                    localName = wssCustomToken.getUri();
                }
                if (localName != null && localName.startsWith("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1")) {
                    JAXBElement newkerb;
                    QNameAssertionType newAssertion;
                    TokenAssertionType kerberosToken = new TokenAssertionType();
                    JAXBElement kerberosTokenJAXB = new JAXBElement(PolicyConfigUtil.KerberosTokenQName12, TokenAssertionType.class, (Object)kerberosToken);
                    subPolicy = new org.w3.ns.ws_policy.Policy();
                    kerberosToken.getAny().add(subPolicy);
                    kerberosToken.setIncludeToken(WSSecurityAssertionTransform.changeNamespace(tokenValue.getIncludeToken()));
                    result = kerberosTokenJAXB;
                    if (localName.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ")) {
                        newAssertion = new QNameAssertionType();
                        newkerb = new JAXBElement(PolicyConfigUtil.WssGssKerberosV5ApReqToken11QName12, QNameAssertionType.class, (Object)newAssertion);
                        subPolicy.getPolicyOrAllOrExactlyOne().add(newkerb);
                    } else if (localName.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1")) {
                        newAssertion = new QNameAssertionType();
                        newkerb = new JAXBElement(PolicyConfigUtil.WssKerberosV5ApReqToken11QName12, QNameAssertionType.class, (Object)newAssertion);
                        subPolicy.getPolicyOrAllOrExactlyOne().add(newkerb);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Kerberos token found:");
                    continue;
                }
                WssCustomToken newCustom = new WssCustomToken();
                newCustom.setUri(wssCustomToken.getUri());
                newCustom.setLocalname(wssCustomToken.getLocalname());
                subPolicy.getPolicyOrAllOrExactlyOne().add(newCustom);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "customToken");
        }
        return result;
    }

    private static JAXBElement tokenAssertionType(JAXBElement token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "tokenAssertionType");
        }
        QName tokenName = token.getName();
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType tokenValue = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType)token.getValue();
        List<Object> policyAssertionList = tokenValue.getAny();
        Object policyAssertionListObj = policyAssertionList.get(0);
        List<Object> subAssertions = null;
        if (policyAssertionListObj instanceof Policy) {
            subAssertions = ((Policy)policyAssertionListObj).getPolicyOrAllOrExactlyOne();
        }
        TokenAssertionType newNested = new TokenAssertionType();
        QName qname = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", tokenName.getLocalPart());
        JAXBElement result = new JAXBElement(qname, TokenAssertionType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        for (Object obj : subAssertions) {
            if (obj instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{obj});
                continue;
            }
            if (!(obj instanceof JAXBElement)) continue;
            JAXBElement tokenSpecification = (JAXBElement)obj;
            QName name = tokenSpecification.getName();
            QName newQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", name.getLocalPart());
            QNameAssertionType emptyType = new QNameAssertionType();
            JAXBElement newAssertion = new JAXBElement(newQName, EmptyType.class, (Object)emptyType);
            newSubAssertions.add(newAssertion);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "tokenAssertionType");
        }
        return result;
    }

    private static JAXBElement secureConversation(JAXBElement token, int direction, String uri, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "secureConversation");
        }
        org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType scTokenType = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType)token.getValue();
        List<Object> policyAssertionList = scTokenType.getAny();
        SecureConversationTokenType newNested = new SecureConversationTokenType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.SecureConversationTokenQName12, SecureConversationTokenType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        Object policyObj = policyAssertionList.get(0);
        Policy policy = null;
        if (policyObj instanceof Policy) {
            policy = (Policy)policyObj;
            policyAssertionList = policy.getPolicyOrAllOrExactlyOne();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{policyObj});
        }
        for (Object obj : policyAssertionList) {
            JAXBElement newAssertion;
            QNameAssertionType emptyType;
            QName newQName;
            if (obj instanceof Element) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{obj});
                continue;
            }
            if (!(obj instanceof JAXBElement)) continue;
            JAXBElement asserton = (JAXBElement)obj;
            QName name = asserton.getName();
            if (name.equals(PolicyConfigUtil.bootstrapPolicyQName)) {
                org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType tokenValue = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType)asserton.getValue();
                if (direction != CLIENT) continue;
                newSubAssertions.add(WSSecurityAssertionTransform.bootstrap(tokenValue.getPolicy(), pic, poc, direction));
                continue;
            }
            if (name.equals(PolicyConfigUtil.SC200502SecurityContextTokenQName)) {
                newQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", name.getLocalPart());
                emptyType = new QNameAssertionType();
                newAssertion = new JAXBElement(newQName, QNameAssertionType.class, (Object)emptyType);
                newSubAssertions.add(newAssertion);
                continue;
            }
            newQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", name.getLocalPart());
            emptyType = new QNameAssertionType();
            newAssertion = new JAXBElement(newQName, QNameAssertionType.class, (Object)emptyType);
            newSubAssertions.add(newAssertion);
        }
        if (direction == PROVIDER && uri != null) {
            newSubAssertions.add(WSSecurityAssertionTransform.bootstrap(direction, uri));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "secureConversation");
        }
        return result;
    }

    private static JAXBElement bootstrap(Object policyObj, PolicyInboundConfig pic, PolicyOutboundConfig poc, int direction) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bootstrap");
        }
        JAXBElement result = WSSecurityAssertionTransform.bootstrapCommon(direction, policyObj, pic, poc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bootstrap");
        }
        return result;
    }

    private static JAXBElement bootstrap(int direction, String endpoint) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bootstrap", endpoint);
        }
        PolicySetConfiguration psCfg = null;
        try {
            psCfg = STSPolicySetUtil.getTrustPolicySetConfiguration("issue", endpoint, WSSecurityAssertionTransform.class.getClassLoader());
        }
        catch (SoapSecurityException sse) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught SoapSecurityException ", sse);
            }
            throw new TransformationException((Object)sse);
        }
        if (psCfg == null) {
            throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s01", new Object[0], "CWWSS7501E"));
        }
        Object policyObj = psCfg.getPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY);
        PolicyInboundConfig pic = WSSecurityAssertionTransform.getPolicyInboundConfig(psCfg);
        PolicyOutboundConfig poc = WSSecurityAssertionTransform.getPolicyOutboundConfig(psCfg);
        JAXBElement result = WSSecurityAssertionTransform.bootstrapCommon(direction, policyObj, pic, poc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bootstrap");
        }
        return result;
    }

    private static JAXBElement bootstrapCommon(int direction, Object policyObj, PolicyInboundConfig pic, PolicyOutboundConfig poc) throws TransformationException, WSPolicyBindingsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bootstrapCommon");
        }
        Policy policy = null;
        if (!(policyObj instanceof Policy)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unrecognized element found in PolicySet", new Object[]{policyObj});
            }
            throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s03", new Object[0], "CWWSS7503E"));
        }
        policy = (Policy)policyObj;
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(PolicyConfigUtil.bootstrapPolicyQName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        List<Object> newSubAssertions = subPolicy.getPolicyOrAllOrExactlyOne();
        WSSecurityPolicyHolder bootstrapAssertionPolicy = WSSecurityAssertionTransform.convertSecuritySchemaTo12(policy, direction, null, pic, poc);
        if (direction == CLIENT && poc.getBootstrapGeneratorConfig() != null) {
            WSSecurityAssertionTransform.transformCommon(poc.getBootstrapConsumerConfig(), poc.getBootstrapGeneratorConfig(), bootstrapAssertionPolicy, direction);
        } else {
            WSSecurityAssertionTransform.transformCommon(pic, poc, bootstrapAssertionPolicy, direction);
        }
        org.w3.ns.ws_policy.Policy p = bootstrapAssertionPolicy.getMain();
        newSubAssertions.addAll(p.getPolicyOrAllOrExactlyOne());
        if (!WSSecurityAssertionTransform.isProtectionTokensIdentical(bootstrapAssertionPolicy.getInput(), bootstrapAssertionPolicy.getOutput())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request and Response message parts must be the same for trust bootstrap policy");
            }
            throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s04", new Object[0], "CWWSS7504E"));
        }
        p = bootstrapAssertionPolicy.getInput();
        newSubAssertions.addAll(p.getPolicyOrAllOrExactlyOne());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bootstrapCommon");
        }
        return result;
    }

    private static boolean isProtectionTokensIdentical(org.w3.ns.ws_policy.Policy inputPol, org.w3.ns.ws_policy.Policy outputPol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProtectionTokensIdentical");
        }
        boolean result = true;
        if (inputPol == null && outputPol == null) {
            return true;
        }
        if (inputPol == null || outputPol == null) {
            return false;
        }
        List<Object> inputList = inputPol.getPolicyOrAllOrExactlyOne();
        List<Object> outputList = outputPol.getPolicyOrAllOrExactlyOne();
        if (inputList == null && outputList == null) {
            return true;
        }
        if (inputList == null || outputList == null) {
            return false;
        }
        if (inputList.isEmpty() && outputList.isEmpty()) {
            return true;
        }
        if (inputList.isEmpty() || outputList.isEmpty()) {
            return false;
        }
        if (inputList.size() != outputList.size()) {
            return false;
        }
        for (Object obj : inputList) {
            boolean body;
            org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType pt1;
            List<org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType> headers;
            String name = null;
            if (!(obj instanceof JAXBElement)) continue;
            JAXBElement objJaxb = (JAXBElement)obj;
            name = objJaxb.getName().getLocalPart();
            Object assertionObj = objJaxb.getValue();
            if (assertionObj instanceof SerElementsType) {
                SerElementsType el1 = (SerElementsType)assertionObj;
                List<String> xpath = el1.getXPath();
                if (WSSecurityAssertionTransform.isMatchingElement(name, xpath, outputList)) continue;
                result = false;
                break;
            }
            if (!(assertionObj instanceof org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType) || WSSecurityAssertionTransform.isMatchingPart(name, headers = (pt1 = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)assertionObj).getHeader(), body = pt1.getBody() != null, outputList)) continue;
            result = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProtectionTokensIdentical", result);
        }
        return result;
    }

    private static boolean isMatchingElement(String name, List<String> xpath, List<Object> outputList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMatchingElement", new Object[]{name});
        }
        boolean result = true;
        for (Object obj : outputList) {
            JAXBElement objJaxb;
            String matchName = null;
            if (!(obj instanceof JAXBElement) || !name.equals(matchName = (objJaxb = (JAXBElement)obj).getName().getLocalPart())) continue;
            Object assertionObj = objJaxb.getValue();
            if (!(assertionObj instanceof SerElementsType)) break;
            SerElementsType el1 = (SerElementsType)assertionObj;
            List<String> matchXpath = el1.getXPath();
            ArrayList<String> x1 = new ArrayList<String>(matchXpath);
            ArrayList<String> x2 = new ArrayList<String>(xpath);
            x1.removeAll(x2);
            if (x1.size() > 0) {
                result = false;
                break;
            }
            x1 = new ArrayList<String>(xpath);
            x2 = new ArrayList<String>(matchXpath);
            x1.removeAll(x2);
            if (x1.size() <= 0) break;
            result = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchingElement", result);
        }
        return result;
    }

    private static boolean isMatchingPart(String name, List<org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType> headers, boolean body, List<Object> outputList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMatchingPart", new Object[]{name});
        }
        boolean result = true;
        List<String> headersStr = WSSecurityAssertionTransform.headerTypeToString(headers);
        for (Object obj : outputList) {
            JAXBElement objJaxb;
            String matchName = null;
            if (!(obj instanceof JAXBElement) || !name.equals(matchName = (objJaxb = (JAXBElement)obj).getName().getLocalPart())) continue;
            Object assertionObj = objJaxb.getValue();
            if (!(assertionObj instanceof org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)) break;
            org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType el1 = (org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.SePartsType)assertionObj;
            if (el1.getBody() != null && !body) {
                result = false;
                break;
            }
            if (el1.getBody() == null && body) {
                result = false;
                break;
            }
            List<String> matchHeaders = WSSecurityAssertionTransform.headerTypeToString(el1.getHeader());
            ArrayList<String> x1 = new ArrayList<String>(matchHeaders);
            ArrayList<String> x2 = new ArrayList<String>(headersStr);
            x1.removeAll(x2);
            if (x1.size() > 0) {
                result = false;
                break;
            }
            x1 = new ArrayList<String>(headersStr);
            x2 = new ArrayList<String>(matchHeaders);
            x1.removeAll(x2);
            if (x1.size() <= 0) break;
            result = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchingPart", result);
        }
        return result;
    }

    private static List<String> headerTypeToString(List<org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType> headers) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < headers.size(); ++i) {
            org.oasis_open.docs.ws_sx.ws_securitypolicy._200702.HeaderType header = headers.get(i);
            result.add(header.getNamespace());
        }
        return result;
    }

    private static boolean isDirectionID(String id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveAssertions");
        }
        boolean directionID = false;
        if (id == null) {
            directionID = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No wsu:Id for Policy element found; ignoring.");
            }
        } else if (id.startsWith("request:") || id.startsWith("response:")) {
            directionID = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching request or response wsu:Id found: " + id);
            }
        } else {
            directionID = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsu:Id found not applicable for request or response messages: " + id);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveAssertions");
        }
        return directionID;
    }

    private static boolean isProtectionToken(String assertionName) {
        return "InitiatorToken".equals(assertionName) || "RecipientToken".equals(assertionName) || "InitiatorSignatureToken".equals(assertionName) || "RecipientSignatureToken".equals(assertionName) || "InitiatorEncryptionToken".equals(assertionName) || "RecipientEncryptionToken".equals(assertionName) || "EncryptionToken".equals(assertionName) || "SignatureToken".equals(assertionName) || "ProtectionToken".equals(assertionName);
    }

    private static void algorithmSuiteAssertions(WSSecurityPolicyHolder policy, Set<SignatureConsumerConfig> inConfiguration, List<Configuration> outConfiguration) throws TransformationException {
        Object algorithmSuite;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "algorithmSuiteAssertions");
        }
        if (policy == null || policy.getMain() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "algorithmSuiteAssertions");
            }
            return;
        }
        QName searchForQName = PolicyConfigUtil.algorithmSuiteQName12;
        ArrayList<Object> discoveredAssertion = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, discoveredAssertion, false);
        if (discoveredAssertion.size() > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AlgorithmSuite assertion unclear");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "algorithmSuiteAssertions");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "algorithmSuiteAssertions");
            }
            return;
        }
        ArrayList<QName> originalOptionalAssertions = new ArrayList<QName>();
        JAXBElement algorithmSuiteJAXB = null;
        if (discoveredAssertion.size() > 0 && (algorithmSuite = discoveredAssertion.get(0)) instanceof JAXBElement) {
            algorithmSuiteJAXB = (JAXBElement)algorithmSuite;
            List<Object> alreadyThere = WSSecurityAssertionTransform.getSubAssertions(algorithmSuiteJAXB);
            for (Object obj : alreadyThere) {
                QName name;
                if (!(obj instanceof JAXBElement) || !(name = ((JAXBElement)obj).getName()).equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH) && !name.equals("http://www.w3.org/2002/06/xmldsig-filter2") && !name.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) continue;
                originalOptionalAssertions.add(name);
            }
        }
        ArrayList<QName> newOptionalAssertions = new ArrayList<QName>();
        for (Configuration configuration : outConfiguration) {
            if (!(configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl)) continue;
            PrivateGeneratorConfig.SignatureGeneratorConfImpl psc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
            List<SigningReferenceConfig> refs = psc.getReferences();
            WSSecurityAssertionTransform.signatureReference(algorithmSuiteJAXB, refs, newOptionalAssertions);
        }
        for (SignatureConsumerConfig scc : inConfiguration) {
            List<SigningReferenceConfig> refs = scc.getReferences();
            WSSecurityAssertionTransform.signatureReference(algorithmSuiteJAXB, refs, newOptionalAssertions);
        }
        if (!originalOptionalAssertions.isEmpty()) {
            originalOptionalAssertions.remove(newOptionalAssertions);
            if (!originalOptionalAssertions.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Signature transform can not be published");
                }
                throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s05", new Object[0], "CWWSS7505E"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "algorithmSuiteAssertions");
        }
    }

    private static void signatureReference(JAXBElement algorithmSuiteJAXB, List<SigningReferenceConfig> refs, List<QName> newOptionalAssertions) throws TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signatureReference");
        }
        String addAlgorithm = null;
        for (SigningReferenceConfig ref : refs) {
            ArrayList<QName> qNamesForThis = new ArrayList<QName>();
            List<AlgorithmConfig> algs = ref.getTransforms();
            for (AlgorithmConfig algorithmCfg : algs) {
                addAlgorithm = algorithmCfg.getAlgorithm();
                if (addAlgorithm.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                    qNamesForThis.add(new QName("", "http://www.w3.org/2001/10/xml-exc-c14n#"));
                    continue;
                }
                if (addAlgorithm.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH)) {
                    WSSecurityAssertionTransform.addQNameAssertionToNestedType(algorithmSuiteJAXB, PolicyConfigUtil.XPath10QName12, false);
                    qNamesForThis.add(PolicyConfigUtil.XPath10QName12);
                    continue;
                }
                if (addAlgorithm.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                    WSSecurityAssertionTransform.addQNameAssertionToNestedType(algorithmSuiteJAXB, PolicyConfigUtil.XPathFilter20QName12, false);
                    qNamesForThis.add(PolicyConfigUtil.XPathFilter20QName12);
                    continue;
                }
                if (addAlgorithm.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
                    WSSecurityAssertionTransform.addQNameAssertionToNestedType(algorithmSuiteJAXB, new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "STRTransform10"), false);
                    qNamesForThis.add(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "STRTransform10"));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Signature transform can not be published");
                }
                throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s06", new Object[0], "CWWSS7506E"));
            }
            if (newOptionalAssertions.isEmpty() && !qNamesForThis.isEmpty()) {
                newOptionalAssertions.addAll(qNamesForThis);
                continue;
            }
            if (((Object)newOptionalAssertions).equals(qNamesForThis)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signature transform can not be published");
            }
            throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s07", new Object[0], "CWWSS7507E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signatureReference");
        }
    }

    private static void signatureAssertions(WSSecurityPolicyHolder policyHolder, PrivateGeneratorConfig poc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signatureAssertions");
        }
        if (policyHolder.getMain() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "signatureAssertions");
            }
            return;
        }
        boolean encryptSignature = false;
        org.w3.ns.ws_policy.Policy policyInoput = policyHolder.getInput();
        org.w3.ns.ws_policy.Policy policyOutput = policyHolder.getOutput();
        if ((WSSecurityAssertionTransform.isXPathPresent(policyInoput, "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']") || WSSecurityAssertionTransform.isXPathPresent(policyInoput, "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']")) && (WSSecurityAssertionTransform.isXPathPresent(policyOutput, "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']") || WSSecurityAssertionTransform.isXPathPresent(policyOutput, "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']"))) {
            encryptSignature = true;
        }
        if (encryptSignature) {
            encryptSignature = WSSecurityAssertionTransform.checkForAnyEncryption(policyInoput) && WSSecurityAssertionTransform.checkForAnyEncryption(policyOutput);
        }
        if (encryptSignature) {
            WSSecurityAssertionTransform.removeSignatureXPath(policyHolder);
            WSSecurityAssertionTransform.addBindingAssertion(PolicyConfigUtil.wssEncryptSignatureQName, policyHolder.getMain());
        }
        if (!poc.isExplicitlyProtectSignatureConfirmation()) {
            WSSecurityAssertionTransform.removeXPathFromXXXElements(policyHolder.getInput(), "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']", false);
            WSSecurityAssertionTransform.removeXPathFromXXXElements(policyHolder.getInput(), "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']", false);
            WSSecurityAssertionTransform.removeXPathFromXXXElements(policyHolder.getOutput(), "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']", false);
            WSSecurityAssertionTransform.removeXPathFromXXXElements(policyHolder.getOutput(), "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']", false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signatureAssertions");
        }
    }

    private static boolean isXPathPresent(org.w3.ns.ws_policy.Policy policy, String xPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isXPathPresent");
        }
        boolean xPathPresent = false;
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : children) {
            JAXBElement jaxbel;
            QName name;
            if (!(obj instanceof JAXBElement) || !(name = (jaxbel = (JAXBElement)obj).getName()).equals(PolicyConfigUtil.encryptedElementsQName12) && !name.equals(PolicyConfigUtil.signedElementsQName12)) continue;
            SerElementsType elementAssertion = (SerElementsType)jaxbel.getValue();
            List<String> elements = elementAssertion.getXPath();
            for (String xpath : elements) {
                if (!xpath.equals(xPath)) continue;
                xPathPresent = true;
                break;
            }
            if (!xPathPresent) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isXPathPresent", new Object[]{xPathPresent});
        }
        return xPathPresent;
    }

    private static boolean checkForAnyEncryption(org.w3.ns.ws_policy.Policy policy) {
        JAXBElement jaxbel;
        QName name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForEncSigParts");
        }
        boolean someEncryoption = false;
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : children) {
            if (!(obj instanceof JAXBElement) || !PolicyConfigUtil.encryptedPartsQName12.equals(name = (jaxbel = (JAXBElement)obj).getName())) continue;
            someEncryoption = true;
            break;
        }
        if (!someEncryoption) {
            for (Object obj : children) {
                if (!(obj instanceof JAXBElement) || !(name = (jaxbel = (JAXBElement)obj).getName()).equals(PolicyConfigUtil.encryptedElementsQName12) && !name.equals(PolicyConfigUtil.signedElementsQName12)) continue;
                SerElementsType elementAssertion = (SerElementsType)jaxbel.getValue();
                List<String> elements = elementAssertion.getXPath();
                for (String xpath : elements) {
                    if (xpath.equals("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']") || xpath.equals("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']")) continue;
                    someEncryoption = true;
                    break;
                }
                if (!someEncryoption) continue;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForEncSigParts" + someEncryoption);
        }
        return someEncryoption;
    }

    private static void removeSignatureXPath(WSSecurityPolicyHolder Policy2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSignatureXPath");
        }
        WSSecurityAssertionTransform.removeXPathFromXXXElements(Policy2.getInput(), "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']", false);
        WSSecurityAssertionTransform.removeXPathFromXXXElements(Policy2.getInput(), "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']", false);
        WSSecurityAssertionTransform.removeXPathFromXXXElements(Policy2.getOutput(), "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']", false);
        WSSecurityAssertionTransform.removeXPathFromXXXElements(Policy2.getOutput(), "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']", false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSignatureXPath");
        }
    }

    private static void removeXPathFromXXXElements(org.w3.ns.ws_policy.Policy policy, String xPathExpression, boolean isSecureConversation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeXPathFromXXXElements");
        }
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        ArrayList<Object> XXXElements = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(children, PolicyConfigUtil.encryptedElementsQName12, XXXElements, isSecureConversation);
        WSSecurityAssertionTransform.findAssertions(children, PolicyConfigUtil.signedElementsQName12, XXXElements, isSecureConversation);
        if (XXXElements.size() > 0) {
            for (Object e : XXXElements) {
                JAXBElement jaxbel;
                QName name;
                if (!(e instanceof JAXBElement) || !PolicyConfigUtil.encryptedElementsQName12.equals(name = (jaxbel = (JAXBElement)e).getName()) && !PolicyConfigUtil.signedElementsQName12.equals(name)) continue;
                SerElementsType encryptedElementAssertion = (SerElementsType)jaxbel.getValue();
                List<String> encryptedElements = encryptedElementAssertion.getXPath();
                ArrayList<String> newEncryptedElements = new ArrayList<String>();
                if (encryptedElements == null) continue;
                for (int j = 0; j < encryptedElements.size(); ++j) {
                    String xpath = encryptedElements.get(j);
                    if (xpath.equals(xPathExpression)) continue;
                    newEncryptedElements.add(xpath);
                }
                encryptedElements.clear();
                encryptedElements.addAll(newEncryptedElements);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeXPathFromXXXElements");
        }
    }

    private static void removeTimestampSignature(WSSecurityPolicyHolder policyHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTimestampSignature");
        }
        ArrayList<Object> SignedElements = new ArrayList<Object>();
        if (policyHolder.getInput() != null) {
            WSSecurityAssertionTransform.findAssertions(policyHolder.getInput().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.signedElementsQName12, SignedElements, false);
        }
        if (policyHolder.getOutput() != null) {
            WSSecurityAssertionTransform.findAssertions(policyHolder.getOutput().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.signedElementsQName12, SignedElements, false);
        }
        if (policyHolder.getMain() != null) {
            WSSecurityAssertionTransform.findAssertions(policyHolder.getMain().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.signedElementsQName12, SignedElements, true);
        }
        for (Object e : SignedElements) {
            if (!(e instanceof JAXBElement)) continue;
            JAXBElement signedElementJAXB = (JAXBElement)e;
            SerElementsType signedElementAssertion = (SerElementsType)signedElementJAXB.getValue();
            List<String> signedElements = signedElementAssertion.getXPath();
            ArrayList<String> newSignedElements = new ArrayList<String>();
            if (signedElements == null) continue;
            for (int j = 0; j < signedElements.size(); ++j) {
                String xpath = signedElements.get(j);
                if (xpath.equals("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']") || xpath.equals("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']")) continue;
                newSignedElements.add(xpath);
            }
            signedElements.clear();
            signedElements.addAll(newSignedElements);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTimestampSignature");
        }
    }

    private static void restoreTimestampSignatureXPath(WSSecurityPolicyHolder policyHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreTimestampSignatureXPath");
        }
        if (policyHolder.getMain() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "restoreTimestampSignatureXPath");
            }
            return;
        }
        ArrayList<Object> includeTimestamp = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policyHolder.getMain().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.wssIncludeTimestampQName12, includeTimestamp, true);
        if (includeTimestamp.size() > 0) {
            ArrayList<Object> bootstrap2 = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(policyHolder.getMain().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.bootstrapPolicyQName12, bootstrap2, true);
            if (bootstrap2.size() > 0) {
                List<Object> bootstrapAssertions = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)bootstrap2.get(0));
                ArrayList<Object> signedElements = new ArrayList<Object>();
                WSSecurityAssertionTransform.findAssertions(bootstrapAssertions, PolicyConfigUtil.signedElementsQName12, signedElements, false);
                if (signedElements.isEmpty()) {
                    SerElementsType se = new SerElementsType();
                    JAXBElement newAssertion = new JAXBElement(PolicyConfigUtil.signedElementsQName12, SerElementsType.class, (Object)se);
                    se.getXPath().add("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
                    se.getXPath().add("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
                    JAXBElement bootstrapAssertion = (JAXBElement)bootstrap2.get(0);
                    WSSecurityAssertionTransform.getSubAssertions(bootstrapAssertion).add(newAssertion);
                } else {
                    JAXBElement seJAXB = (JAXBElement)signedElements.get(0);
                    SerElementsType se = (SerElementsType)seJAXB.getValue();
                    se.getXPath().add("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
                    se.getXPath().add("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
                }
            }
        }
        includeTimestamp = new ArrayList();
        WSSecurityAssertionTransform.findAssertions(policyHolder.getMain().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.wssIncludeTimestampQName12, includeTimestamp, false);
        if (includeTimestamp.size() > 0) {
            WSSecurityAssertionTransform.addSignTimestampXPath(policyHolder.getInput());
            WSSecurityAssertionTransform.addSignTimestampXPath(policyHolder.getOutput());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreTimestampSignatureXPath");
        }
    }

    private static void addSignTimestampXPath(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignTimestampXPath");
        }
        if (policy == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addSignTimestampXPath");
            }
            return;
        }
        ArrayList<Object> signedElements = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.signedElementsQName12, signedElements, false);
        if (signedElements.isEmpty()) {
            SerElementsType se = new SerElementsType();
            JAXBElement newAssertion = new JAXBElement(PolicyConfigUtil.signedElementsQName12, SerElementsType.class, (Object)se);
            se.getXPath().add("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
            se.getXPath().add("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
            policy.getPolicyOrAllOrExactlyOne().add(newAssertion);
        } else {
            JAXBElement seJAXB = (JAXBElement)signedElements.get(0);
            SerElementsType se = (SerElementsType)seJAXB.getValue();
            se.getXPath().add("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
            se.getXPath().add("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignTimestampXPath");
        }
    }

    private static void addBindingAssertion(QName assertionName, org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addBindingAssertion");
        }
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        for (Object obj : children) {
            JAXBElement jaxbel;
            QName name;
            if (!(obj instanceof JAXBElement) || !PolicyConfigUtil.asymmetricBindingQName12.equals(name = (jaxbel = (JAXBElement)obj).getName()) && !PolicyConfigUtil.symmetricBindingQName12.equals(name)) continue;
            List<Object> bindingAssertions = WSSecurityAssertionTransform.getSubAssertions(jaxbel);
            QNameAssertionType encryptAssertion = new QNameAssertionType();
            JAXBElement newencryptAssertion = new JAXBElement(assertionName, QNameAssertionType.class, (Object)encryptAssertion);
            bindingAssertions.add(newencryptAssertion);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addBindingAssertion");
        }
    }

    private static void kerberos(int direction, WSSecurityPolicyHolder policy, PrivateConsumerConfig pic, PrivateGeneratorConfig poc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "kerberos");
        }
        WSSecurityAssertionTransform.kerberosProcessBindings(pic, poc, direction, policy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "kerberos");
        }
    }

    private static void kerberosProcessBindings(PrivateConsumerConfig pic, PrivateGeneratorConfig poc, int direction, WSSecurityPolicyHolder policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "kerberosProcessBindings");
        }
        String localName = null;
        boolean encryptionFlag = false;
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfo = null;
        List<Configuration> configurations = poc.getOperationGenerators();
        for (Configuration configuration : configurations) {
            Configuration pgc;
            if (configuration instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                encryptionFlag = true;
                pgc = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)configuration;
                keyInfo = pgc._encryptionKeyInfo;
            } else if (configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl) {
                encryptionFlag = false;
                pgc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
                keyInfo = ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)pgc)._signingKeyInfo;
            }
            DerivedKeyInfoConfig dki = keyInfo._contentGenerator._derivedKeyInfo;
            localName = keyInfo._contentGenerator.getTokenGenerator().getType().getLocalPart();
            Map<Object, Object> properties = keyInfo._contentGenerator._tokenGenerator._callbackHandler._properties;
            WSSecurityAssertionTransform.processKerberosTokens(localName, dki, direction, encryptionFlag, policy, properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "kerberosProcessBindings");
        }
    }

    private static void processKerberosTokens(String localName, DerivedKeyInfoConfig dki, int direction, boolean encryptionFlag, WSSecurityPolicyHolder policy, Map<Object, Object> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processKerberosTokens");
        }
        if (policy == null || policy.getMain() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processKerberosTokens");
            }
            return;
        }
        boolean searchInsideSecureConversationToken = false;
        if (localName.equals(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13)) {
            searchInsideSecureConversationToken = true;
        }
        if (searchInsideSecureConversationToken || localName.startsWith("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#")) {
            ArrayList<Object> discoveredTokenAssertions = new ArrayList<Object>();
            QName searchForQName = null;
            searchForQName = PolicyConfigUtil.ProtectionTokenQName12;
            WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, discoveredTokenAssertions, searchInsideSecureConversationToken);
            if (direction == CLIENT) {
                if (encryptionFlag) {
                    searchForQName = PolicyConfigUtil.encryptionTokenQName12;
                    WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, discoveredTokenAssertions, searchInsideSecureConversationToken);
                } else {
                    searchForQName = PolicyConfigUtil.SignatureTokenQName12;
                    WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, discoveredTokenAssertions, searchInsideSecureConversationToken);
                }
            } else if (encryptionFlag) {
                searchForQName = PolicyConfigUtil.encryptionTokenQName12;
                WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, discoveredTokenAssertions, searchInsideSecureConversationToken);
            } else {
                searchForQName = PolicyConfigUtil.SignatureTokenQName12;
                WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, discoveredTokenAssertions, searchInsideSecureConversationToken);
            }
            if (discoveredTokenAssertions.size() > 0) {
                for (Object e : discoveredTokenAssertions) {
                    List<Object> sbAssertions = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)e);
                    if (sbAssertions.isEmpty()) continue;
                    for (Object subAssertion : sbAssertions) {
                        if (!((JAXBElement)subAssertion).getName().equals(PolicyConfigUtil.KerberosTokenQName12)) continue;
                        if (localName.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ")) {
                            WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.WssGssKerberosV5ApReqToken11QName12, false);
                        } else if (localName.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ")) {
                            WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.WssKerberosV5ApReqToken11QName12, false);
                        }
                        if (dki != null) {
                            boolean skipDerivedKeys = false;
                            if (dki.isRequireImpliedDerivedKeys()) {
                                skipDerivedKeys = true;
                                WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.requireImplicitDerivedKeysQName12, false);
                            }
                            if (dki.isRequireExplicitDerivedKeys()) {
                                skipDerivedKeys = true;
                                WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.requireExplicitDerivedKeysQName12, false);
                            }
                            if (!skipDerivedKeys && dki.isRequireDerivedKeys()) {
                                WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.requireDerivedKeysQName12, false);
                            }
                        }
                        if (properties == null) continue;
                        if (properties.containsKey(PROPERTY_keyIdentifier)) {
                            WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.requireKeyIdentifierReferenceQName12, false);
                        }
                        if (!properties.containsKey(PROPERTY_requireDerivedKey)) continue;
                        WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)subAssertion, PolicyConfigUtil.requireDerivedKeysQName12, false);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processKerberosTokens");
        }
    }

    private static boolean isEncryptBeforeSigning(org.w3.ns.ws_policy.Policy policy, PrivateGeneratorConfig poc) throws WSPolicyBindingsException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEncryptBeforeSigning");
        }
        boolean encryptBeforeSigning = false;
        int encMin = Integer.MAX_VALUE;
        int encMax = Integer.MIN_VALUE;
        List<ReferencePartConfig> encParts = poc.getConfidentialParts();
        for (ReferencePartConfig part : encParts) {
            if (part.getOrder() < encMin) {
                encMin = part.getOrder();
            }
            if (part.getOrder() <= encMax) continue;
            encMax = part.getOrder();
        }
        int signLMin = Integer.MAX_VALUE;
        int signMax = Integer.MIN_VALUE;
        List<ReferencePartConfig> signParts1 = poc.getIntegralParts();
        for (ReferencePartConfig part : signParts1) {
            if (part.getOrder() < signLMin) {
                signLMin = part.getOrder();
            }
            if (part.getOrder() <= signMax) continue;
            signMax = part.getOrder();
        }
        if (encMin < signLMin && signLMin != Integer.MAX_VALUE) {
            encryptBeforeSigning = true;
        }
        if (encryptBeforeSigning) {
            if (encMax > signLMin) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Signature and Encryption order conflict");
                }
                throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s07", new Object[0], "CWWSS7507E"));
            }
            ArrayList<Object> Strict = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.StrictQName12, Strict, false);
            if (!Strict.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Strict header processing is not supported with EncryptBeforeSigning");
                }
                throw new TransformationException((Object)nls.getFormattedMessage("security.wssecurity.WSSecurityAssertionTransform.s08", new Object[0], "CWWSS7508E"));
            }
        } else if (signMax > encMin) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signature and Encryption order conflict");
            }
            throw new TransformationException((Object)"There are overlapping signature and encryption order values");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEncryptBeforeSigning");
        }
        return encryptBeforeSigning;
    }

    private static void initiatorRecipientTokens(WSSecurityPolicyHolder policy, List<Configuration> configurations) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initiatorRecipientTokens");
        }
        if (policy == null || policy.getMain() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processPolicyTokens");
            }
            return;
        }
        HashSet<String> enctype = new HashSet<String>();
        HashSet<String> signtype = new HashSet<String>();
        for (Configuration configuration : configurations) {
            PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfo;
            Configuration pgc;
            if (configuration instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                pgc = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)configuration;
                keyInfo = pgc._encryptionKeyInfo;
                enctype.add(keyInfo._contentGenerator._keyInfoType);
                continue;
            }
            if (!(configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl)) continue;
            pgc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
            keyInfo = ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)pgc)._signingKeyInfo;
            signtype.add(keyInfo._contentGenerator._keyInfoType);
        }
        if (((Object)enctype).equals(signtype)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "locateAndProcessActiveTokens");
            }
            return;
        }
        QName searchForQName = PolicyConfigUtil.asymmetricBindingQName12;
        ArrayList<Object> bindingAssertions = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getMain().getPolicyOrAllOrExactlyOne(), searchForQName, bindingAssertions, false);
        if (bindingAssertions.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "locateAndProcessActiveTokens");
            }
            return;
        }
        for (Object e : bindingAssertions) {
            if (!(e instanceof JAXBElement)) continue;
            List<Object> bindingSubAssertions = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)e);
            JAXBElement initiatorAssertion = null;
            JAXBElement recipientAssertion = null;
            for (Object bindingSubAssertionObj : bindingSubAssertions) {
                JAXBElement assertion = (JAXBElement)bindingSubAssertionObj;
                QName assertionName = assertion.getName();
                if (assertionName.equals(PolicyConfigUtil.InitiatorTokenQName12)) {
                    initiatorAssertion = assertion;
                    continue;
                }
                if (!assertionName.equals(PolicyConfigUtil.RecipientTokenQName12)) continue;
                recipientAssertion = assertion;
            }
            if (initiatorAssertion == null || recipientAssertion == null) continue;
            bindingSubAssertions.remove(initiatorAssertion);
            bindingSubAssertions.remove(recipientAssertion);
            JAXBElement initiatorSignature = WSSecurityAssertionTransform.cloneTokenWrapper(PolicyConfigUtil.InitiatorSignatureTokenQName12, initiatorAssertion);
            JAXBElement initiatorEncryption = WSSecurityAssertionTransform.cloneTokenWrapper(PolicyConfigUtil.InitiatorEncryptionTokenQName12, initiatorAssertion);
            JAXBElement recipientSignature = WSSecurityAssertionTransform.cloneTokenWrapper(PolicyConfigUtil.RecipientSignatureTokenQName12, recipientAssertion);
            JAXBElement recipientEncryption = WSSecurityAssertionTransform.cloneTokenWrapper(PolicyConfigUtil.RecipientEncryptionTokenQName12, recipientAssertion);
            bindingSubAssertions.add(initiatorSignature);
            bindingSubAssertions.add(initiatorEncryption);
            bindingSubAssertions.add(recipientSignature);
            bindingSubAssertions.add(recipientEncryption);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initiatorRecipientTokens");
        }
    }

    private static JAXBElement cloneTokenWrapper(QName newName, JAXBElement assertion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cloneTokenWrapper");
        }
        NestedPolicyType resultwNested = new NestedPolicyType();
        JAXBElement result = new JAXBElement(newName, NestedPolicyType.class, (Object)resultwNested);
        org.w3.ns.ws_policy.Policy resultPolicy = new org.w3.ns.ws_policy.Policy();
        resultwNested.getAny().add(resultPolicy);
        List<Object> resultAssertions = resultPolicy.getPolicyOrAllOrExactlyOne();
        List<Object> tokens = WSSecurityAssertionTransform.getSubAssertions(assertion);
        if (tokens != null && tokens.size() == 1) {
            Object tokenObj = tokens.get(0);
            if (tokenObj instanceof JAXBElement) {
                JAXBElement token = (JAXBElement)tokenObj;
                WSSecurityAssertionTransform.cloneToken(resultAssertions, token);
            }
        } else if (tokens == null || tokens.size() > 1) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cloneTokenWrapper");
        }
        return result;
    }

    private static void cloneToken(List<Object> resultAssertions, JAXBElement token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cloneToken");
        }
        if ("X509Token".equals(token.getName().getLocalPart())) {
            WSSecurityAssertionTransform.cloneX509(resultAssertions, token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cloneToken");
        }
    }

    private static void cloneX509(List<Object> resultAssertions, JAXBElement token) {
        if (token.getValue() instanceof TokenAssertionType) {
            TokenAssertionType tokenValue = (TokenAssertionType)token.getValue();
            String includeToken = tokenValue.getIncludeToken();
            List<Object> tokenPolicyList = tokenValue.getAny();
            Object tokenPolicyListObj = tokenPolicyList.get(0);
            org.w3.ns.ws_policy.Policy tokenPolicy = (org.w3.ns.ws_policy.Policy)tokenPolicyListObj;
            TokenAssertionType newTokenType = new TokenAssertionType();
            JAXBElement newToken = new JAXBElement(PolicyConfigUtil.X509TokenQName12, TokenAssertionType.class, (Object)newTokenType);
            org.w3.ns.ws_policy.Policy newPolicy = new org.w3.ns.ws_policy.Policy();
            newTokenType.getAny().add(newPolicy);
            List<Object> newTokenAssertions = newPolicy.getPolicyOrAllOrExactlyOne();
            resultAssertions.add(newToken);
            newTokenType.setIncludeToken(includeToken);
            WSSecurityAssertionTransform.cloneQNameAssertions(tokenPolicy, newTokenAssertions);
        }
    }

    private static void cloneQNameAssertions(org.w3.ns.ws_policy.Policy tokenPolicy, List<Object> newTokenAssertions) {
        for (Object obj : tokenPolicy.getPolicyOrAllOrExactlyOne()) {
            if (!(obj instanceof JAXBElement)) continue;
            JAXBElement subToken = (JAXBElement)obj;
            QName name = subToken.getName();
            QNameAssertionType emptyType = new QNameAssertionType();
            JAXBElement newAssertion = new JAXBElement(name, QNameAssertionType.class, (Object)emptyType);
            newTokenAssertions.add(newAssertion);
        }
    }

    private static void requireXXXReferenceAssertions(int direction, WSSecurityPolicyHolder policy, List<Configuration> configurations) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requireXXXReferenceAssertions");
        }
        if (policy == null || policy.getMain() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processPolicyTokens");
            }
            return;
        }
        for (Configuration configuration : configurations) {
            Configuration pgc;
            String type = null;
            PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfo = null;
            if (configuration instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                pgc = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)configuration;
                keyInfo = ((PrivateGeneratorConfig.EncryptionGeneratorConfImpl)pgc)._encryptionKeyInfo;
            } else {
                if (!(configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl)) continue;
                pgc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
                keyInfo = ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)pgc)._signingKeyInfo;
            }
            if (keyInfo == null || keyInfo._contentGenerator == null) continue;
            pgc = keyInfo._contentGenerator;
            type = ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)pgc)._keyInfoType;
            QName requestKeyTypeQName = WSSecurityAssertionTransform.getQnameForKeyType(type);
            if (requestKeyTypeQName == null || ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)pgc).getTokenGenerator() == null) continue;
            QName locaQlName = keyInfo._contentGenerator.getTokenGenerator().getType();
            String localName = locaQlName.getLocalPart();
            List<Object> searchAssertions = policy.getMain().getPolicyOrAllOrExactlyOne();
            ArrayList<Object> discoveredAssertions = new ArrayList<Object>();
            QName searchForQName = PolicyConfigUtil.ProtectionTokenQName12;
            WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
            if (((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)pgc)._tokenGenerator.isUsedForEncryption()) {
                searchForQName = PolicyConfigUtil.RecipientEncryptionTokenQName12;
                WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                searchForQName = PolicyConfigUtil.InitiatorEncryptionTokenQName12;
                WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                searchForQName = PolicyConfigUtil.encryptionTokenQName12;
                WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                if (direction == PROVIDER) {
                    searchForQName = PolicyConfigUtil.InitiatorTokenQName12;
                    WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                } else {
                    searchForQName = PolicyConfigUtil.RecipientTokenQName12;
                    WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                }
            }
            if (((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)pgc)._tokenGenerator.isUsedForSigning()) {
                searchForQName = PolicyConfigUtil.InitiatorSignatureTokenQName12;
                WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                searchForQName = PolicyConfigUtil.RecipientSignatureTokenQName12;
                WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                searchForQName = PolicyConfigUtil.SignatureTokenQName12;
                WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                if (direction == CLIENT) {
                    searchForQName = PolicyConfigUtil.InitiatorTokenQName12;
                    WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                } else {
                    searchForQName = PolicyConfigUtil.RecipientTokenQName12;
                    WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, discoveredAssertions, false);
                }
            }
            if (discoveredAssertions.size() <= 0) continue;
            for (Object e : discoveredAssertions) {
                if (!(e instanceof JAXBElement)) continue;
                List<Object> tokWrapperSubAssertions = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)e);
                for (Object tokenObj : tokWrapperSubAssertions) {
                    WSSecurityAssertionTransform.addQNameAssertionToNestedType((JAXBElement)tokenObj, requestKeyTypeQName, false);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requireXXXReferenceAssertions");
        }
    }

    private static boolean isRequireXxxReference(QName assertionName, List<Configuration> configurations, int direction) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequireXxxReference");
        }
        boolean result = false;
        String key = WSSecurityAssertionTransform.getKeyTypeForQName(assertionName);
        if (key == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRequireXxxReference", new Object[]{result});
            }
            return result;
        }
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfo = null;
        for (Configuration configuration : configurations) {
            Configuration pgc;
            if (configuration instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                pgc = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)configuration;
                keyInfo = pgc._encryptionKeyInfo;
            } else if (configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl) {
                pgc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
                keyInfo = ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)pgc)._signingKeyInfo;
            }
            if (keyInfo == null || keyInfo._contentGenerator == null || !key.equals(keyInfo._contentGenerator._keyInfoType)) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequireXxxReference", new Object[]{result});
        }
        return result;
    }

    private static void addMustSupportRefXxx(org.w3.ns.ws_policy.Policy policy, List<Configuration> configurations, int direction) {
        JAXBElement newSubAssertionsWssXX;
        boolean requireThumbprint;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMustSupportRefXxx");
        }
        if (requireThumbprint = WSSecurityAssertionTransform.isRequireXxxReference(PolicyConfigUtil.requireThumbprintReferenceQName12, configurations, direction = CLIENT)) {
            JAXBElement newSubAssertionsWss11 = WSSecurityAssertionTransform.findOrCreateWSSXXNestedAssertion(policy, PolicyConfigUtil.wss11QName12, false);
            WSSecurityAssertionTransform.addQNameAssertionToNestedType(newSubAssertionsWss11, PolicyConfigUtil.MustSupportRefThumbprintQName12, false);
        }
        QName searchForQName = PolicyConfigUtil.wss11QName12;
        ArrayList<Object> discoveredAssertion = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), searchForQName, discoveredAssertion, false);
        boolean wss11 = discoveredAssertion.size() > 0 || requireThumbprint;
        QName wssXXQName = PolicyConfigUtil.wss10QName12;
        if (wss11) {
            wssXXQName = PolicyConfigUtil.wss11QName12;
        }
        if (WSSecurityAssertionTransform.isRequireXxxReference(PolicyConfigUtil.requireKeyIdentifierReferenceQName12, configurations, direction)) {
            newSubAssertionsWssXX = WSSecurityAssertionTransform.findOrCreateWSSXXNestedAssertion(policy, wssXXQName, false);
            WSSecurityAssertionTransform.addQNameAssertionToNestedType(newSubAssertionsWssXX, PolicyConfigUtil.MustSupportRefKeyIdentifierQName12, false);
        }
        if (WSSecurityAssertionTransform.isRequireXxxReference(PolicyConfigUtil.requireIssuerSerialReferenceQName12, configurations, direction)) {
            newSubAssertionsWssXX = WSSecurityAssertionTransform.findOrCreateWSSXXNestedAssertion(policy, wssXXQName, false);
            WSSecurityAssertionTransform.addQNameAssertionToNestedType(newSubAssertionsWssXX, PolicyConfigUtil.MustSupportRefIssuerSerialQName12, false);
        }
        if (WSSecurityAssertionTransform.isRequireXxxReference(PolicyConfigUtil.requireEmbeddedTokenReferenceQName12, configurations, direction)) {
            newSubAssertionsWssXX = WSSecurityAssertionTransform.findOrCreateWSSXXNestedAssertion(policy, wssXXQName, false);
            WSSecurityAssertionTransform.addQNameAssertionToNestedType(newSubAssertionsWssXX, PolicyConfigUtil.MustSupportRefEmbeddedToken12, false);
        }
        if (WSSecurityAssertionTransform.isRequireXxxReference(PolicyConfigUtil.requireExternalURIReferenceQName12, configurations, direction)) {
            newSubAssertionsWssXX = WSSecurityAssertionTransform.findOrCreateWSSXXNestedAssertion(policy, wssXXQName, false);
            WSSecurityAssertionTransform.addQNameAssertionToNestedType(newSubAssertionsWssXX, PolicyConfigUtil.requireExternalURIReferenceQName12, false);
        }
        if (WSSecurityAssertionTransform.isMustSupportRefExternalURI(policy, configurations)) {
            newSubAssertionsWssXX = WSSecurityAssertionTransform.findOrCreateWSSXXNestedAssertion(policy, wssXXQName, false);
            WSSecurityAssertionTransform.addQNameAssertionToNestedType(newSubAssertionsWssXX, PolicyConfigUtil.MustSupportRefExternalURI12, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMustSupportRefXxx");
        }
    }

    private static boolean isMustSupportRefExternalURI(org.w3.ns.ws_policy.Policy policy, List<Configuration> configurations) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMustSupportRefExternalURI");
        }
        boolean result = false;
        ArrayList<Object> discoverAssertions = new ArrayList<Object>();
        WSSecurityAssertionTransform.findSubAssertionsInAssertion(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.requireExternalURIReferenceQName12, discoverAssertions, true, false);
        if (discoverAssertions.size() > 0) {
            result = true;
            PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfo = null;
            for (Configuration configuration : configurations) {
                Object obj;
                Configuration pgc;
                if (configuration instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                    pgc = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)configuration;
                    keyInfo = pgc._encryptionKeyInfo;
                } else if (configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl) {
                    pgc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
                    keyInfo = ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)pgc)._signingKeyInfo;
                }
                if (keyInfo._contentGenerator == null || keyInfo._contentGenerator._tokenGenerator == null) continue;
                PrivateGeneratorConfig.TokenGeneratorConfImpl tgc = keyInfo._contentGenerator._tokenGenerator;
                Map<Object, Object> properties = tgc._properties;
                if (properties == null || !properties.containsKey("com.ibm.wsspi.wssecurity.sc.PreV7BehaviorOfIncludingSCTInMessage") || !"true".equals((String)(obj = properties.get("com.ibm.wsspi.wssecurity.sc.PreV7BehaviorOfIncludingSCTInMessage")))) break;
                result = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMustSupportRefExternalURI", new Object[]{result});
        }
        return result;
    }

    private static JAXBElement findOrCreateWSSXXNestedAssertion(org.w3.ns.ws_policy.Policy policy, QName assertionName, boolean securityContextOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOrCreateWSSXXNestedAssertion");
        }
        JAXBElement result = null;
        ArrayList<Object> discoverAssertions = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), assertionName, discoverAssertions, securityContextOnly);
        if (discoverAssertions.isEmpty()) {
            NestedPolicyType newNested = new NestedPolicyType();
            result = new JAXBElement(assertionName, NestedPolicyType.class, (Object)newNested);
            org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
            newNested.getAny().add(subPolicy);
            policy.getPolicyOrAllOrExactlyOne().add(result);
        } else {
            Object resultObj = discoverAssertions.get(0);
            if (resultObj instanceof JAXBElement) {
                result = (JAXBElement)resultObj;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOrCreateWSSXXNestedAssertion");
        }
        return result;
    }

    private static void removeEmptyProtectionAssertions(WSSecurityPolicyHolder newPolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEmptyProtectionAssertions");
        }
        org.w3.ns.ws_policy.Policy policy = newPolicy.getInput();
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        WSSecurityAssertionTransform.removeEmptyAssertionsForSinglePolicy(children);
        policy = newPolicy.getOutput();
        children = policy.getPolicyOrAllOrExactlyOne();
        WSSecurityAssertionTransform.removeEmptyAssertionsForSinglePolicy(children);
        policy = newPolicy.getMain();
        children = policy.getPolicyOrAllOrExactlyOne();
        WSSecurityAssertionTransform.removeEmptyAssertionsForSinglePolicy(children);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEmptyProtectionAssertions");
        }
    }

    private static void reverseIncludeTokenAttribute(WSSecurityPolicyHolder policy) {
        org.w3.ns.ws_policy.Policy p;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reverseIncludeTokenAttribute");
        }
        if ((p = policy.getMain()) == null) {
            return;
        }
        ArrayList<QName> tokenNames = new ArrayList<QName>();
        tokenNames.add(PolicyConfigUtil.InitiatorEncryptionTokenQName12);
        tokenNames.add(PolicyConfigUtil.InitiatorSignatureTokenQName12);
        tokenNames.add(PolicyConfigUtil.InitiatorTokenQName12);
        tokenNames.add(PolicyConfigUtil.RecipientEncryptionTokenQName12);
        tokenNames.add(PolicyConfigUtil.RecipientSignatureTokenQName12);
        tokenNames.add(PolicyConfigUtil.RecipientTokenQName12);
        ArrayList<Object> tokens = new ArrayList<Object>();
        for (QName qName : tokenNames) {
            WSSecurityAssertionTransform.findAssertions(p.getPolicyOrAllOrExactlyOne(), qName, tokens, false);
            WSSecurityAssertionTransform.findAssertions(p.getPolicyOrAllOrExactlyOne(), qName, tokens, true);
        }
        for (Object e : tokens) {
            if (!(e instanceof JAXBElement)) continue;
            String wrapperTokenName = ((JAXBElement)e).getName().getLocalPart();
            List<Object> subAssertion = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)e);
            for (Object subToken : subAssertion) {
                String attribute;
                JAXBElement subTokenJAXB;
                Object subTokenValue;
                if (!(subToken instanceof JAXBElement) || !((subTokenValue = (subTokenJAXB = (JAXBElement)subToken).getValue()) instanceof TokenAssertionType) || (attribute = ((TokenAssertionType)subTokenValue).getIncludeToken()) == null) continue;
                if (wrapperTokenName.startsWith("Initiator")) {
                    if (!attribute.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToInitiator")) continue;
                    ((TokenAssertionType)subTokenValue).setIncludeToken("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToRecipient");
                    continue;
                }
                if (!attribute.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToRecipient")) continue;
                ((TokenAssertionType)subTokenValue).setIncludeToken("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702/IncludeToken/AlwaysToInitiator");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reverseIncludeTokenAttribute");
        }
    }

    private static void addCapabilities(WSSecurityPolicyHolder policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCapabilities");
        }
        if (policy == null || policy.getMain() == null) {
            return;
        }
        ArrayList<QName> assertionsToAdd = new ArrayList<QName>();
        assertionsToAdd.add(PolicyConfigUtil.requireKeyIdentifierReferenceQName12);
        assertionsToAdd.add(PolicyConfigUtil.requireIssuerSerialReferenceQName12);
        assertionsToAdd.add(PolicyConfigUtil.requireThumbprintReferenceQName12);
        assertionsToAdd.add(PolicyConfigUtil.requireEmbeddedTokenReferenceQName12);
        List<Object> searchAssertions = policy.getMain().getPolicyOrAllOrExactlyOne();
        ArrayList<Object> assertions = new ArrayList<Object>();
        QName searchForQName = null;
        searchForQName = PolicyConfigUtil.InitiatorEncryptionTokenQName12;
        WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, assertions, false);
        searchForQName = PolicyConfigUtil.InitiatorSignatureTokenQName12;
        WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, assertions, false);
        searchForQName = PolicyConfigUtil.InitiatorTokenQName12;
        WSSecurityAssertionTransform.findAssertions(searchAssertions, searchForQName, assertions, false);
        if (assertions.isEmpty()) {
            return;
        }
        for (Object e : assertions) {
            List<Object> tokens;
            if (!(e instanceof JAXBElement) || (tokens = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)e)).isEmpty()) continue;
            for (Object subTokenObj : tokens) {
                List<Object> subtokens;
                QName tokenType;
                if (!(subTokenObj instanceof JAXBElement) || !(tokenType = ((JAXBElement)subTokenObj).getName()).equals(PolicyConfigUtil.X509TokenQName12) || (subtokens = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)subTokenObj)).isEmpty()) continue;
                QName presentAssertion = null;
                for (Object subAssertionObj : subtokens) {
                    QName subAssertionQName;
                    if (!(subAssertionObj instanceof JAXBElement) || !assertionsToAdd.contains(subAssertionQName = ((JAXBElement)subAssertionObj).getName())) continue;
                    presentAssertion = subAssertionQName;
                    break;
                }
                OperatorContentType exactlyOne = new OperatorContentType();
                JAXBElement exactlyOneJAXB = new JAXBElement(exactlyOne15QName, OperatorContentType.class, (Object)exactlyOne);
                subtokens.add(exactlyOneJAXB);
                List<Object> exactlyOneAssertions = exactlyOne.getPolicyOrAllOrExactlyOne();
                OperatorContentType all = new OperatorContentType();
                JAXBElement allJAXB = new JAXBElement(all15QName, OperatorContentType.class, (Object)all);
                exactlyOneAssertions.add(allJAXB);
                for (QName newQNameAssertion : assertionsToAdd) {
                    if (newQNameAssertion.equals(presentAssertion)) continue;
                    QNameAssertionType newAssertion = new QNameAssertionType();
                    JAXBElement newAssertionJAXB = new JAXBElement(newQNameAssertion, QNameAssertionType.class, (Object)newAssertion);
                    exactlyOneAssertions.add(newAssertionJAXB);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCapabilities");
        }
    }

    private static void addTrust13Assertions(WSSecurityPolicyHolder policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTrust13Assertions");
        }
        if (policy == null || policy.getMain() == null) {
            return;
        }
        NestedPolicyType newNested = new NestedPolicyType();
        JAXBElement trust13 = new JAXBElement(PolicyConfigUtil.trust13QName12, NestedPolicyType.class, (Object)newNested);
        org.w3.ns.ws_policy.Policy subPolicy = new org.w3.ns.ws_policy.Policy();
        newNested.getAny().add(subPolicy);
        WSSecurityAssertionTransform.addQNameAssertionToNestedType(trust13, PolicyConfigUtil.MustSupportIssuedTokensQName12, false);
        WSSecurityAssertionTransform.addQNameAssertionToNestedType(trust13, PolicyConfigUtil.RequireClientEntropyQName12, false);
        WSSecurityAssertionTransform.addQNameAssertionToNestedType(trust13, PolicyConfigUtil.RequireServerEntropyQName12, false);
        policy.getMain().getPolicyOrAllOrExactlyOne().add(trust13);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTrust13Assertions");
        }
    }

    private static void mustNotSendAmend(WSSecurityPolicyHolder policyHolder) {
        JAXBElement secureConversationTokenJAXB;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityPolicyHolder");
        }
        if ((secureConversationTokenJAXB = WSSecurityAssertionTransform.getSecureConversationToken(policyHolder.getMain())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No SecureConversationToken so no context token to transform");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformSC13SecurityContextToken");
            }
            return;
        }
        WSSecurityAssertionTransform.addQNameAssertionToNestedType(secureConversationTokenJAXB, PolicyConfigUtil.MustNotSendAmendQName12, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityPolicyHolder");
        }
    }

    private static boolean isTrust13Required(WSSecurityPolicyHolder policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrust13Required");
        }
        boolean result = false;
        result = WSSecurityAssertionTransform.isSecureConversation(policy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrust13Required");
        }
        return result;
    }

    private static boolean isSecureConversation(WSSecurityPolicyHolder policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecureConversation");
        }
        boolean result = false;
        List<Object> searchSourceAssertions = policy.getMain().getPolicyOrAllOrExactlyOne();
        ArrayList<Object> assertions = new ArrayList<Object>();
        QName searchForQName = PolicyConfigUtil.SecureConversationTokenQName12;
        WSSecurityAssertionTransform.findAssertions(searchSourceAssertions, searchForQName, assertions, true);
        if (assertions.size() > 0) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecureConversation", new Object[]{result});
        }
        return result;
    }

    private static void removeTrust13Assertions(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTrust13Assertions");
        }
        if (policy == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTrust13Assertions");
            }
            return;
        }
        boolean removed = false;
        for (Object assertionObj : policy.getPolicyOrAllOrExactlyOne()) {
            Object all;
            if (!(assertionObj instanceof JAXBElement)) continue;
            JAXBElement assertionJAXB = (JAXBElement)assertionObj;
            QName name = assertionJAXB.getName();
            if (PolicyConfigUtil.trust13QName12.equals(name)) {
                policy.getPolicyOrAllOrExactlyOne().remove(assertionObj);
                break;
            }
            if (!exactlyOne15QName.equals(name) || !((all = ((OperatorContentType)assertionJAXB.getValue()).getPolicyOrAllOrExactlyOne().get(0)) instanceof JAXBElement)) continue;
            JAXBElement allJAXB = (JAXBElement)all;
            List<Object> assertionList = ((OperatorContentType)allJAXB.getValue()).getPolicyOrAllOrExactlyOne();
            for (Object assertion : assertionList) {
                JAXBElement assertionJAXB2;
                QName name2;
                if (!(assertion instanceof JAXBElement) || !PolicyConfigUtil.trust13QName12.equals(name2 = (assertionJAXB2 = (JAXBElement)assertion).getName())) continue;
                assertionList.remove(assertion);
                removed = true;
                break;
            }
            if (!removed) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTrust13Assertions");
        }
    }

    private static void removeTrust13AssertionsFromBootstrap(org.w3.ns.ws_policy.Policy policy) {
        Object policyObj;
        NestedPolicyType npt;
        JAXBElement bootsrtapJAXB;
        Object bootstrapJAXBObj;
        Object bootsrtapObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTrust13AssertionsFromBootstrap");
        }
        ArrayList<Object> bootstrapPolicy = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.bootstrapPolicyQName12, bootstrapPolicy, true);
        if (bootstrapPolicy.size() > 0 && (bootsrtapObj = bootstrapPolicy.get(0)) instanceof JAXBElement && (bootstrapJAXBObj = (bootsrtapJAXB = (JAXBElement)bootsrtapObj).getValue()) instanceof NestedPolicyType && (npt = (NestedPolicyType)bootstrapJAXBObj).getAny() != null && (policyObj = npt.getAny().get(0)) instanceof org.w3.ns.ws_policy.Policy) {
            WSSecurityAssertionTransform.removeTrust13Assertions((org.w3.ns.ws_policy.Policy)policyObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTrust13Assertions");
        }
    }

    private static void removeEmptyAssertionsForSinglePolicy(List<Object> children) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEmptyAssertionsForSinglePolicy");
        }
        ArrayList<Object> removeList = new ArrayList<Object>();
        for (Object obj : children) {
            SerElementsType encryptedElementAssertion;
            List<String> xPathList;
            JAXBElement jaxbel;
            QName name;
            if (!(obj instanceof JAXBElement) || !PolicyConfigUtil.encryptedElementsQName12.equals(name = (jaxbel = (JAXBElement)obj).getName()) && !PolicyConfigUtil.signedElementsQName12.equals(name) || (xPathList = (encryptedElementAssertion = (SerElementsType)jaxbel.getValue()).getXPath()) != null && !xPathList.isEmpty()) continue;
            removeList.add(obj);
        }
        children.removeAll(removeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEmptyAssertionsForSinglePolicy");
        }
    }

    private static void caller(WSSecurityPolicyHolder policy15SecPol12, PrivateConsumerConfig pic, PrivateGeneratorConfig poc, int direction) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "caller");
        }
        boolean orderSpecified = WSSecurityAssertionTransform.isCallerOrder(pic, poc, direction);
        WSSecurityAssertionTransform.callerPolicy(policy15SecPol12, orderSpecified);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "caller");
        }
    }

    private static boolean isCallerOrder(PrivateConsumerConfig pic, PrivateGeneratorConfig poc, int direction) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerOrder_Client");
        }
        boolean result = false;
        List<CallerConfig> callers = pic.getCallers();
        for (CallerConfig caller : callers) {
            if (caller.getOrder() == 0) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerOrder_Client ", result);
        }
        return result;
    }

    private static void callerPolicy(WSSecurityPolicyHolder policy15SecPol12, boolean orderSpecified) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callerPolicy", new Object[]{orderSpecified});
        }
        ArrayList<JAXBElement> callerTokens = new ArrayList<JAXBElement>();
        org.w3.ns.ws_policy.Policy poliucy = policy15SecPol12.getInput();
        List<Object> assertions = poliucy.getPolicyOrAllOrExactlyOne();
        for (Object obj : assertions) {
            JAXBElement assertion;
            QName name;
            if (!(obj instanceof JAXBElement) || !(name = (assertion = (JAXBElement)obj).getName()).equals(PolicyConfigUtil.supportingTokenQName12)) continue;
            callerTokens.add(assertion);
        }
        if (callerTokens.size() > 0) {
            assertions.removeAll(callerTokens);
            OperatorContentType exactlyOne = new OperatorContentType();
            JAXBElement exactlyOneJAXB = new JAXBElement(exactlyOne15QName, OperatorContentType.class, (Object)exactlyOne);
            assertions.add(exactlyOneJAXB);
            List<Object> subElements = exactlyOne.getPolicyOrAllOrExactlyOne();
            List<Object> newAssertions = exactlyOne.getPolicyOrAllOrExactlyOne();
            if (orderSpecified) {
                OperatorContentType all = new OperatorContentType();
                JAXBElement jAXBElement = new JAXBElement(all15QName, OperatorContentType.class, (Object)all);
                subElements.add(jAXBElement);
                newAssertions = all.getPolicyOrAllOrExactlyOne();
                newAssertions.addAll(callerTokens);
            } else {
                for (Object e : callerTokens) {
                    OperatorContentType all = new OperatorContentType();
                    JAXBElement allJAXB = new JAXBElement(all15QName, OperatorContentType.class, (Object)all);
                    subElements.add(allJAXB);
                    newAssertions = all.getPolicyOrAllOrExactlyOne();
                    newAssertions.add(e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callerPolicy");
        }
    }

    private static void SC13SecurityContextToken(WSSecurityPolicyHolder policyHolder, List<Configuration> configurations) {
        JAXBElement secureConversationTokenJAXB;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SC13SecurityContextToken");
        }
        if ((secureConversationTokenJAXB = WSSecurityAssertionTransform.getSecureConversationToken(policyHolder.getMain())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No SecureConversationToken so no context token to transform");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformSC13SecurityContextToken");
            }
            return;
        }
        boolean impliedKeys = WSSecurityAssertionTransform.isImpliedKeys(configurations);
        Object obj = secureConversationTokenJAXB.getValue();
        if (obj instanceof SecureConversationTokenType) {
            SecureConversationTokenType secureConversationTokenType = (SecureConversationTokenType)obj;
            List<Object> scPolicyList = secureConversationTokenType.getAny();
            org.w3.ns.ws_policy.Policy scPolicy = (org.w3.ns.ws_policy.Policy)scPolicyList.get(0);
            List<Object> scAssertions = scPolicy.getPolicyOrAllOrExactlyOne();
            ArrayList<Object> removeList = new ArrayList<Object>();
            ArrayList<JAXBElement> addList = new ArrayList<JAXBElement>();
            QName SC200502SecurityContextTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "SC200502SecurityContextToken");
            for (Object assertion : scAssertions) {
                if (!(assertion instanceof JAXBElement)) continue;
                QName name = ((JAXBElement)assertion).getName();
                if (SC200502SecurityContextTokenQName.equals(name)) {
                    QNameAssertionType newSCToekn = new QNameAssertionType();
                    JAXBElement newSCToeknJAXB = new JAXBElement(PolicyConfigUtil.SC13SecurityContextTokenQName, QNameAssertionType.class, (Object)newSCToekn);
                    removeList.add(assertion);
                    if (!impliedKeys) continue;
                    QNameAssertionType impliedDrvKey = new QNameAssertionType();
                    JAXBElement impliedDrvKeyJAXB = new JAXBElement(PolicyConfigUtil.requireImpliedDerivedKeysQName12, QNameAssertionType.class, (Object)impliedDrvKey);
                    addList.add(impliedDrvKeyJAXB);
                    continue;
                }
                if (!PolicyConfigUtil.requireDerivedKeysQName12.equals(name) || !impliedKeys) continue;
                removeList.add(assertion);
            }
            if (addList.size() > 0) {
                scAssertions.addAll(addList);
            }
            if (removeList.size() > 0) {
                scAssertions.removeAll(removeList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SC13SecurityContextToken");
        }
    }

    private static JAXBElement getSecureConversationToken(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecureConversationToken");
        }
        if (policy == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecureConversationToken");
            }
            return null;
        }
        JAXBElement result = null;
        ArrayList<Object> assertions = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.SecureConversationTokenQName12, assertions, true);
        if (assertions.size() == 1 && assertions.get(0) instanceof JAXBElement) {
            result = (JAXBElement)assertions.get(0);
        }
        if (assertions.size() > 1) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureConversationToken");
        }
        return result;
    }

    private static boolean isImpliedKeys(List<Configuration> configurations) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isImpliedKeys");
        }
        boolean result = false;
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfo = null;
        for (Configuration configuration : configurations) {
            DerivedKeyInfoConfig dki;
            Configuration pgc;
            if (configuration instanceof PrivateGeneratorConfig.EncryptionGeneratorConfImpl) {
                pgc = (PrivateGeneratorConfig.EncryptionGeneratorConfImpl)configuration;
                keyInfo = pgc._encryptionKeyInfo;
            } else if (configuration instanceof PrivateGeneratorConfig.SignatureGeneratorConfImpl) {
                pgc = (PrivateGeneratorConfig.SignatureGeneratorConfImpl)configuration;
                keyInfo = ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)pgc)._signingKeyInfo;
            }
            if (keyInfo == null || keyInfo._contentGenerator == null || (dki = keyInfo._contentGenerator.getDerivedKeyInfoConfig()) == null || !com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(keyInfo._contentGenerator.getTokenGenerator().getType().getLocalPart())) continue;
            result = dki.isRequireImpliedDerivedKeys();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isImpliedKeys", new Object[]{result});
        }
        return result;
    }

    private static void usernameTokens(WSSecurityPolicyHolder policyHolder, PrivateConsumerConfig pic, PrivateGeneratorConfig poc, int direction) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "usernameTokens");
        }
        if (direction == PROVIDER) {
            Object tokenObj;
            ArrayList<Object> tokens = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(policyHolder.getInput().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.usernameTokenQName12, tokens, false);
            if (tokens != null && tokens.size() > 0 && WSSecurityAssertionTransform.isNoPassword_Provider(pic) && (tokenObj = tokens.get(0)) instanceof JAXBElement) {
                JAXBElement token = (JAXBElement)tokenObj;
                WSSecurityAssertionTransform.addQNameAssertionToNestedType(token, new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "NoPassword"), false);
            }
        } else {
            Object tokenObj;
            ArrayList<Object> tokens = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(policyHolder.getInput().getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.usernameTokenQName12, tokens, false);
            if (tokens != null && tokens.size() > 0 && WSSecurityAssertionTransform.isNoPassword_Client(poc) && (tokenObj = tokens.get(0)) instanceof JAXBElement) {
                JAXBElement token = (JAXBElement)tokenObj;
                WSSecurityAssertionTransform.addQNameAssertionToNestedType(token, new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "NoPassword"), false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "usernameTokens");
        }
    }

    private static boolean isNoPassword_Provider(PrivateConsumerConfig pic) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNoPassword_Provider");
        }
        boolean result = false;
        Set<TokenConsumerConfig> tokenConsumers = pic.getTokenConsumers();
        for (TokenConsumerConfig tokenConsumer : tokenConsumers) {
            Map<Object, Object> props;
            CallbackHandlerConfig callback = tokenConsumer.getCallbackHandler();
            if (callback == null || !(props = callback.getProperties()).containsKey(PROPERTY_NOPASSWORD)) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNoPassword_Provider ", result);
        }
        return result;
    }

    private static boolean isNoPassword_Client(PrivateGeneratorConfig poc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNoPassword_Client");
        }
        boolean result = false;
        Set<TokenGeneratorConfig> tokenGenerators = poc.getTokenGenerators();
        for (TokenGeneratorConfig tokenGenerator : tokenGenerators) {
            Map<Object, Object> props;
            CallbackHandlerConfig callback = tokenGenerator.getCallbackHandler();
            if (callback == null || !(props = callback.getProperties()).containsKey(PROPERTY_NOPASSWORD)) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNoPassword_Client ", result);
        }
        return result;
    }

    private static void supportingTokens(WSSecurityPolicyHolder policyHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportingTokens");
        }
        WSSecurityAssertionTransform.supportingTokensPolicy(policyHolder.getInput());
        WSSecurityAssertionTransform.supportingTokensPolicy(policyHolder.getOutput());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportingTokens");
        }
    }

    private static void supportingTokensPolicy(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "supportingTokensPolicy");
        }
        ArrayList<Object> SignedElements = new ArrayList<Object>();
        if (policy == null) {
            return;
        }
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.signedElementsQName12, SignedElements, false);
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.encryptedElementsQName12, SignedElements, false);
        boolean transformRequired = false;
        boolean sign = false;
        boolean enc = false;
        for (Object e : SignedElements) {
            if (e instanceof JAXBElement) {
                JAXBElement SignEncElementJAXB = (JAXBElement)e;
                SerElementsType signedEncElementAssertion = (SerElementsType)SignEncElementJAXB.getValue();
                QName name = SignEncElementJAXB.getName();
                List<String> signedElements = signedEncElementAssertion.getXPath();
                ArrayList<String> newSignedElements = new ArrayList<String>();
                if (signedElements != null) {
                    for (int j = 0; j < signedElements.size(); ++j) {
                        String xpath = signedElements.get(j);
                        if (xpath.equals("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']") || xpath.equals("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']") || xpath.endsWith("LTPA')]")) {
                            transformRequired = true;
                            if (name.equals(PolicyConfigUtil.signedElementsQName12)) {
                                sign = true;
                                continue;
                            }
                            enc = true;
                            continue;
                        }
                        newSignedElements.add(xpath);
                    }
                    signedElements.clear();
                    signedElements.addAll(newSignedElements);
                }
            }
            if (!transformRequired) continue;
            QName transformedName = WSSecurityAssertionTransform.getNewNameForSupportingTokens(sign, enc);
            for (Object assertionObj : policy.getPolicyOrAllOrExactlyOne()) {
                JAXBElement assertionObjJAXB = (JAXBElement)assertionObj;
                OperatorContentType exOne = null;
                if (!assertionObjJAXB.getName().equals(exactlyOne15QName)) continue;
                exOne = (OperatorContentType)assertionObjJAXB.getValue();
                for (Object subAssertionJAXBObj : exOne.getPolicyOrAllOrExactlyOne()) {
                    JAXBElement subAssertionJAXB = (JAXBElement)subAssertionJAXBObj;
                    OperatorContentType all = null;
                    if (!subAssertionJAXB.getName().equals(all15QName)) continue;
                    all = (OperatorContentType)subAssertionJAXB.getValue();
                    ArrayList<Object> removeList = new ArrayList<Object>();
                    ArrayList<JAXBElement> addList = new ArrayList<JAXBElement>();
                    for (Object SupportingToken : all.getPolicyOrAllOrExactlyOne()) {
                        JAXBElement supportingTokenJAXB = (JAXBElement)SupportingToken;
                        org.w3.ns.ws_policy.Policy subPolicy = (org.w3.ns.ws_policy.Policy)((NestedPolicyType)supportingTokenJAXB.getValue()).getAny().get(0);
                        NestedPolicyType newNested = new NestedPolicyType();
                        JAXBElement newJAXB = new JAXBElement(transformedName, NestedPolicyType.class, (Object)newNested);
                        newNested.getAny().add(subPolicy);
                        removeList.add(SupportingToken);
                        addList.add(newJAXB);
                    }
                    all.getPolicyOrAllOrExactlyOne().removeAll(removeList);
                    all.getPolicyOrAllOrExactlyOne().addAll(addList);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "supportingTokensPolicy");
        }
    }

    private static QName getNewNameForSupportingTokens(boolean sign, boolean enc) {
        QName transformedName = sign ? (enc ? PolicyConfigUtil.SignedEncryptedSupportingTokensQName12 : PolicyConfigUtil.SignedsupportingTokenQName12) : (enc ? PolicyConfigUtil.EncryptedSupportingTokens : PolicyConfigUtil.supportingTokenQName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SupportingTokens new name:", new Object[]{transformedName});
        }
        return transformedName;
    }

    private static void restoreSupportingTokens(WSSecurityPolicyHolder policyHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreSupportingTokens");
        }
        WSSecurityAssertionTransform.restoreSupportingTokensForPolicy(policyHolder.getInput());
        WSSecurityAssertionTransform.restoreSupportingTokensForPolicy(policyHolder.getOutput());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreSupportingTokens");
        }
    }

    private static void restoreSupportingTokensForPolicy(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreSupportingTokensForPolicy");
        }
        if (policy == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "restoreSupportingTokensForPolicy");
            }
            return;
        }
        boolean sign = false;
        boolean encrypt = false;
        ArrayList<Object> signedSupportingTokens = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.SignedsupportingTokenQName12, signedSupportingTokens, false);
        if (signedSupportingTokens.size() > 0) {
            sign = true;
            QName name = PolicyConfigUtil.signedElementsQName12;
            ArrayList<Object> usernametokens = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(signedSupportingTokens, PolicyConfigUtil.usernameTokenQName12, usernametokens, false);
            boolean isUsername = true;
            if (usernametokens.isEmpty()) {
                isUsername = false;
            }
            WSSecurityAssertionTransform.restoreXPathExpressionForSupportingToken(policy, name, isUsername);
        }
        ArrayList<Object> encryptedSupportingTokens = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.EncryptedSupportingTokens, encryptedSupportingTokens, false);
        if (encryptedSupportingTokens.size() > 0) {
            encrypt = true;
            QName name = PolicyConfigUtil.encryptedElementsQName12;
            ArrayList<Object> usernametokens = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(encryptedSupportingTokens, PolicyConfigUtil.usernameTokenQName12, usernametokens, false);
            boolean isUsername = true;
            if (usernametokens.isEmpty()) {
                isUsername = false;
            }
            WSSecurityAssertionTransform.restoreXPathExpressionForSupportingToken(policy, name, isUsername);
        }
        ArrayList<Object> signedEncryptedSupportingTokens = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.SignedEncryptedSupportingTokensQName12, signedEncryptedSupportingTokens, false);
        if (signedEncryptedSupportingTokens.size() > 0) {
            encrypt = true;
            sign = true;
            QName name = PolicyConfigUtil.encryptedElementsQName12;
            ArrayList<Object> usernametokens = new ArrayList<Object>();
            WSSecurityAssertionTransform.findAssertions(signedEncryptedSupportingTokens, PolicyConfigUtil.usernameTokenQName12, usernametokens, false);
            boolean isUsername = true;
            if (usernametokens.isEmpty()) {
                isUsername = false;
            }
            WSSecurityAssertionTransform.restoreXPathExpressionForSupportingToken(policy, name, isUsername);
            name = PolicyConfigUtil.signedElementsQName12;
            WSSecurityAssertionTransform.restoreXPathExpressionForSupportingToken(policy, name, isUsername);
        }
        if (!sign && !encrypt) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "restoreSupportingTokensForPolicy");
            }
            return;
        }
        for (Object assertionObj : policy.getPolicyOrAllOrExactlyOne()) {
            JAXBElement assertionObjJAXB = (JAXBElement)assertionObj;
            OperatorContentType exOne = null;
            if (!assertionObjJAXB.getName().equals(exactlyOne15QName)) continue;
            exOne = (OperatorContentType)assertionObjJAXB.getValue();
            for (Object subAssertionJAXBObj : exOne.getPolicyOrAllOrExactlyOne()) {
                JAXBElement subAssertionJAXB = (JAXBElement)subAssertionJAXBObj;
                OperatorContentType all = null;
                if (!subAssertionJAXB.getName().equals(all15QName)) continue;
                all = (OperatorContentType)subAssertionJAXB.getValue();
                ArrayList<Object> removeList = new ArrayList<Object>();
                ArrayList<JAXBElement> addList = new ArrayList<JAXBElement>();
                for (Object SupportingToken : all.getPolicyOrAllOrExactlyOne()) {
                    JAXBElement supportingTokenJAXB = (JAXBElement)SupportingToken;
                    QName elementName = supportingTokenJAXB.getName();
                    if (!elementName.equals(PolicyConfigUtil.SignedsupportingTokenQName12) && !elementName.equals(PolicyConfigUtil.EncryptedSupportingTokens) && !elementName.equals(PolicyConfigUtil.SignedEncryptedSupportingTokensQName12)) continue;
                    org.w3.ns.ws_policy.Policy subPolicy = (org.w3.ns.ws_policy.Policy)((NestedPolicyType)supportingTokenJAXB.getValue()).getAny().get(0);
                    NestedPolicyType newNested = new NestedPolicyType();
                    JAXBElement newJAXB = new JAXBElement(PolicyConfigUtil.supportingTokenQName12, NestedPolicyType.class, (Object)newNested);
                    newNested.getAny().add(subPolicy);
                    removeList.add(SupportingToken);
                    addList.add(newJAXB);
                }
                all.getPolicyOrAllOrExactlyOne().removeAll(removeList);
                all.getPolicyOrAllOrExactlyOne().addAll(addList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreSupportingTokensForPolicy");
        }
    }

    private static void restoreXPathExpressionForSupportingToken(org.w3.ns.ws_policy.Policy policy, QName name, boolean isUserName) {
        ArrayList<Object> signEncryptEncElements = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(policy.getPolicyOrAllOrExactlyOne(), name, signEncryptEncElements, false);
        if (signEncryptEncElements.size() == 0) {
            SerElementsType signedElementAssertion = new SerElementsType();
            JAXBElement jAXBElement = new JAXBElement(name, SerElementsType.class, (Object)signedElementAssertion);
            signedElementAssertion.getXPath().add("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']");
            signedElementAssertion.getXPath().add("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']");
            policy.getPolicyOrAllOrExactlyOne().add(jAXBElement);
        } else {
            for (Object e : signEncryptEncElements) {
                if (!(e instanceof JAXBElement)) continue;
                JAXBElement signedElementJAXB = (JAXBElement)e;
                SerElementsType signedElementAssertion = (SerElementsType)signedElementJAXB.getValue();
                String xpath = "";
                if (isUserName) {
                    xpath = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']";
                    if (!signedElementAssertion.getXPath().contains(xpath)) {
                        signedElementAssertion.getXPath().add(xpath);
                    }
                    xpath = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']";
                    if (signedElementAssertion.getXPath().contains(xpath)) continue;
                    signedElementAssertion.getXPath().add(xpath);
                    continue;
                }
                xpath = LPTA_XPATH_11;
                if (!signedElementAssertion.getXPath().contains(xpath)) {
                    signedElementAssertion.getXPath().add(xpath);
                }
                xpath = LPTA_XPATH_11;
                if (signedElementAssertion.getXPath().contains(xpath)) continue;
                signedElementAssertion.getXPath().add(xpath);
            }
        }
    }

    private static boolean isOnlySignEntireHeadersAndBody(WSSecurityPolicyHolder policy15SecPol12, PrivateConsumerConfig pic, PrivateGeneratorConfig poc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isOnlySignEntireHeadersAndBody");
        }
        boolean result = false;
        boolean bl = result = pic.isOnlySignEntireHeadersAndBody() || poc.isOnlySignEntireHeadersAndBody();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isOnlySignEntireHeadersAndBody");
        }
        return result;
    }

    private static void addonlySignEntireHeadersAndBody(WSSecurityPolicyHolder policy15SecPol12) {
        org.w3.ns.ws_policy.Policy p;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AddonlySignEntireHeadersAndBody");
        }
        if ((p = policy15SecPol12.getMain()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AddonlySignEntireHeadersAndBody");
            }
            return;
        }
        WSSecurityAssertionTransform.addBindingAssertion(PolicyConfigUtil.onlySignEntireHeadersAndBodyQName12, p);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AddonlySignEntireHeadersAndBody");
        }
    }

    private static Policy convertPolicyFrom15To12(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertPolicyFrom15To12");
        }
        Policy result = new Policy();
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        List<Object> newChildren = result.getPolicyOrAllOrExactlyOne();
        for (Object child : children) {
            if (child instanceof org.w3.ns.ws_policy.Policy) {
                newChildren.add(WSSecurityAssertionTransform.convertPolicyFrom15To12((org.w3.ns.ws_policy.Policy)child));
                continue;
            }
            if (child instanceof JAXBElement) {
                Object value = ((JAXBElement)child).getValue();
                if (value instanceof OperatorContentType) {
                    newChildren.addAll(WSSecurityAssertionTransform.removeOperators(value));
                    continue;
                }
                newChildren.add(WSSecurityAssertionTransform.convertElementSubPoliucyTo12((JAXBElement)child));
                continue;
            }
            newChildren.add(child);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertPolicyFrom15To12");
        }
        return result;
    }

    private static List<Object> removeOperators(Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeOperators");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        OperatorContentType operator = (OperatorContentType)value;
        List<Object> subOperators = operator.getPolicyOrAllOrExactlyOne();
        for (Object obj : subOperators) {
            if (!(obj instanceof JAXBElement)) continue;
            Object objValue = ((JAXBElement)obj).getValue();
            if (objValue instanceof OperatorContentType) {
                result.addAll(WSSecurityAssertionTransform.removeOperators(objValue));
                continue;
            }
            result.add(WSSecurityAssertionTransform.convertElementSubPoliucyTo12((JAXBElement)obj));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeOperators");
        }
        return result;
    }

    private static JAXBElement convertElementSubPoliucyTo12(JAXBElement element) {
        Object nested;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertElementSubPoliucyTo12");
        }
        Object value = element.getValue();
        QName name = element.getName();
        List<Object> children = null;
        JAXBElement result = element;
        if (value instanceof OperatorContentType) {
            OperatorContentType operator = (OperatorContentType)value;
            org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType transformedOperator = new org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType();
            if (name.equals(exactlyOne15QName)) {
                result = new JAXBElement(PolicyConfigUtil.exactlyOneQName, org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType.class, (Object)transformedOperator);
            } else if (name.equals(all15QName)) {
                QName allQName = new QName(PolicyConfigUtil.policyNS, "All");
                result = new JAXBElement(allQName, org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType.class, (Object)transformedOperator);
            }
            children = operator.getPolicyOrAllOrExactlyOne();
            transformedOperator.getPolicyOrAllOrExactlyOne().addAll(children);
            children = transformedOperator.getPolicyOrAllOrExactlyOne();
        } else if (value instanceof NestedPolicyType) {
            nested = (NestedPolicyType)value;
            children = ((NestedPolicyType)nested).getAny();
        } else if (value instanceof TokenAssertionType) {
            nested = (TokenAssertionType)value;
            children = ((TokenAssertionType)nested).getAny();
        } else if (value instanceof SecureConversationTokenType) {
            nested = (SecureConversationTokenType)value;
            children = ((SecureConversationTokenType)nested).getAny();
        } else if (value instanceof TokenAssertionType) {
            nested = (TokenAssertionType)value;
            children = ((TokenAssertionType)nested).getAny();
        }
        if (children != null) {
            ArrayList<Policy> newChildren = new ArrayList<Policy>();
            for (Object child : children) {
                if (child instanceof org.w3.ns.ws_policy.Policy) {
                    newChildren.add(WSSecurityAssertionTransform.convertPolicyFrom15To12((org.w3.ns.ws_policy.Policy)child));
                    continue;
                }
                if (!(child instanceof JAXBElement)) continue;
                newChildren.add((Policy)WSSecurityAssertionTransform.convertElementSubPoliucyTo12((JAXBElement)child));
            }
            children.clear();
            children.addAll(newChildren);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertElementSubPoliucyTo12");
        }
        return result;
    }

    private static Policy restoreDirectionalAttributes(Policy policyMain, Policy policyInput, Policy policyOutput) {
        QName name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreDirectionalAttributes");
        }
        List<Object> children = policyMain.getPolicyOrAllOrExactlyOne();
        Policy policyInputSign = new Policy();
        Policy policyInputEncrypt = new Policy();
        Policy policyOutputSign = new Policy();
        Policy policyOutputEncrypt = new Policy();
        policyInputSign.setId("request:" + new Random().nextInt());
        policyInputEncrypt.setId("request:" + new Random().nextInt());
        policyOutputSign.setId("response:" + new Random().nextInt());
        policyOutputEncrypt.setId("response:" + new Random().nextInt());
        if (policyInput != null) {
            WSSecurityAssertionTransform.restoreDirectionalAttributesInsideAssertions(policyInput.getPolicyOrAllOrExactlyOne(), "request:");
            for (Object assertion : policyInput.getPolicyOrAllOrExactlyOne()) {
                name = ((JAXBElement)assertion).getName();
                if (name.getLocalPart().startsWith("Sig")) {
                    policyInputSign.getPolicyOrAllOrExactlyOne().add(assertion);
                    continue;
                }
                if (name.getLocalPart().startsWith("Enc")) {
                    policyInputEncrypt.getPolicyOrAllOrExactlyOne().add(assertion);
                    continue;
                }
                children.add(assertion);
            }
        }
        if (policyOutput != null) {
            WSSecurityAssertionTransform.restoreDirectionalAttributesInsideAssertions(policyOutput.getPolicyOrAllOrExactlyOne(), "response:");
            for (Object assertion : policyOutput.getPolicyOrAllOrExactlyOne()) {
                name = ((JAXBElement)assertion).getName();
                if (name.getLocalPart().startsWith("Sig")) {
                    policyOutputSign.getPolicyOrAllOrExactlyOne().add(assertion);
                    continue;
                }
                if (name.getLocalPart().startsWith("Enc")) {
                    policyOutputEncrypt.getPolicyOrAllOrExactlyOne().add(assertion);
                    continue;
                }
                children.add(assertion);
            }
        }
        if (policyInputSign.getPolicyOrAllOrExactlyOne().size() > 0) {
            children.add(policyInputSign);
        }
        if (policyInputEncrypt.getPolicyOrAllOrExactlyOne().size() > 0) {
            children.add(policyInputEncrypt);
        }
        if (policyOutputSign.getPolicyOrAllOrExactlyOne().size() > 0) {
            children.add(policyOutputSign);
        }
        if (policyOutputEncrypt.getPolicyOrAllOrExactlyOne().size() > 0) {
            children.add(policyOutputEncrypt);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreDirectionalAttributes");
        }
        return policyMain;
    }

    private static void restoreDirectionalAttributesInsideAssertions(List<Object> assertions, String direction) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreDirectionalAttributesInsideAssertions");
        }
        for (Object obj : assertions) {
            Object operatorObj;
            if (!(obj instanceof JAXBElement)) continue;
            QName name = ((JAXBElement)obj).getName();
            if (PolicyConfigUtil.supportingTokenQName12.equals(name)) {
                WSSecurityAssertionTransform.addDirectionalAttributeToSupportingToken(direction, obj);
                continue;
            }
            if (!(((JAXBElement)obj).getValue() instanceof org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType) || !((operatorObj = ((JAXBElement)obj).getValue()) instanceof org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType)) continue;
            org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType operator = (org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType)operatorObj;
            List<Object> operatorContents = operator.getPolicyOrAllOrExactlyOne();
            WSSecurityAssertionTransform.restoreDirectionalAttributesInsideAssertions(operatorContents, direction);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreDirectionalAttributesInsideAssertions");
        }
    }

    private static void addDirectionalAttributeToSupportingToken(String direction, Object obj) {
        Object policyObj;
        List<Object> nestedList;
        Object value;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDirectionalAttributeToSupportingToken");
        }
        if ((value = ((JAXBElement)obj).getValue()) instanceof NestedPolicyType && (nestedList = ((NestedPolicyType)value).getAny()) != null && nestedList.size() > 0 && (policyObj = nestedList.get(0)) instanceof Policy) {
            String id = direction + "token_" + new Random().nextInt();
            ((Policy)policyObj).setId(id);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting wsu:id" + id);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDirectionalAttributeToSupportingToken");
        }
    }

    private static void addDirectionalAttributesToEncryptSignature(org.w3.ns.ws_policy.Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDirectionalAttributesToEncryptSignature");
        }
        if (policy == null) {
            return;
        }
        List<Object> children = policy.getPolicyOrAllOrExactlyOne();
        for (int i = 0; i < children.size(); ++i) {
            JAXBElement jaxbel;
            QName name;
            Object obj = children.get(i);
            if (!(obj instanceof JAXBElement) || !PolicyConfigUtil.asymmetricBindingQName12.equals(name = (jaxbel = (JAXBElement)obj).getName()) && !PolicyConfigUtil.symmetricBindingQName12.equals(name)) continue;
            NestedPolicyType nested = (NestedPolicyType)jaxbel.getValue();
            List<Object> nestedValue = nested.getAny();
            org.w3.ns.ws_policy.Policy bindingPolicy = (org.w3.ns.ws_policy.Policy)nestedValue.get(0);
            List<Object> bindingAssertions = bindingPolicy.getPolicyOrAllOrExactlyOne();
            boolean assertionFound = false;
            for (int j = 0; j < bindingAssertions.size(); ++j) {
                JAXBElement assertion;
                QName assertionQname;
                Object assertionObj = bindingAssertions.get(j);
                if (!(assertionObj instanceof JAXBElement) || !(assertionQname = (assertion = (JAXBElement)assertionObj).getName()).equals(PolicyConfigUtil.EncryptSignatureQName)) continue;
                QNameAssertionType encryptAssertionReq = (QNameAssertionType)assertion.getValue();
                encryptAssertionReq.getOtherAttributes().put(WSU_ID_QNAME, "request:");
                assertionFound = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Setting directional attributes on EncryptSignature");
                break;
            }
            if (!assertionFound) continue;
            QNameAssertionType encryptAssertionRSP = new QNameAssertionType();
            encryptAssertionRSP.getOtherAttributes().put(WSU_ID_QNAME, "response:");
            JAXBElement newencryptAssertion = new JAXBElement(PolicyConfigUtil.EncryptSignatureQName, QNameAssertionType.class, (Object)encryptAssertionRSP);
            bindingAssertions.add(newencryptAssertion);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDirectionalAttributesToEncryptSignature");
        }
    }

    private static void nestProtectionTokensInSecureConversationAssertion(Policy p) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nestProtectionTokensInSecureConversationAssertion");
        }
        ArrayList<Object> bootstrapList = new ArrayList<Object>();
        WSSecurityAssertionTransform.findAssertions(p.getPolicyOrAllOrExactlyOne(), PolicyConfigUtil.bootstrapPolicyQName12, bootstrapList, true);
        if (bootstrapList.size() > 0) {
            ArrayList<QName> assertionNames = new ArrayList<QName>();
            assertionNames.add(PolicyConfigUtil.signedPartsQName12);
            assertionNames.add(PolicyConfigUtil.signedElementsQName12);
            assertionNames.add(PolicyConfigUtil.encryptedPartsQName12);
            assertionNames.add(PolicyConfigUtil.encryptedElementsQName12);
            ArrayList<JAXBElement> removeList = new ArrayList<JAXBElement>();
            Object firstBootstrap = bootstrapList.get(0);
            if (firstBootstrap instanceof JAXBElement) {
                List<Object> bootstrapAssertions = WSSecurityAssertionTransform.getSubAssertions((JAXBElement)firstBootstrap);
                List<Object> bootstrapPolicy = null;
                ArrayList<Policy> addAssertions = new ArrayList<Policy>();
                for (Object obj : bootstrapAssertions) {
                    Object PolicyObj;
                    NestedPolicyType firstBootstrapNested;
                    List<Object> bootstrapChildrenList;
                    JAXBElement bootstrapAssertionJAXB;
                    QName name;
                    if (!(obj instanceof JAXBElement) || !assertionNames.contains(name = (bootstrapAssertionJAXB = (JAXBElement)obj).getName()) || (bootstrapChildrenList = (firstBootstrapNested = (NestedPolicyType)((JAXBElement)firstBootstrap).getValue()).getAny()).size() <= 0 || !((PolicyObj = bootstrapChildrenList.get(0)) instanceof Policy)) continue;
                    bootstrapPolicy = ((Policy)PolicyObj).getPolicyOrAllOrExactlyOne();
                    Policy newPolicyRequest = new Policy();
                    newPolicyRequest.getPolicyOrAllOrExactlyOne().add(bootstrapAssertionJAXB);
                    newPolicyRequest.setId("request:" + new Random().nextInt());
                    addAssertions.add(newPolicyRequest);
                    Policy newPolicyRResponse = new Policy();
                    newPolicyRResponse.getPolicyOrAllOrExactlyOne().add(bootstrapAssertionJAXB);
                    newPolicyRResponse.setId("response:" + new Random().nextInt());
                    addAssertions.add(newPolicyRResponse);
                    removeList.add(bootstrapAssertionJAXB);
                }
                bootstrapAssertions.removeAll(removeList);
                bootstrapPolicy.addAll(addAssertions);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nestProtectionTokensInSecureConversationAssertion");
        }
    }

    private static void findAssertions(List<Object> assertions, QName assertionName, List<Object> discoveredAssertions, boolean securityContextOnly) {
        WSSecurityAssertionTransform.findSubAssertionsInAssertion(assertions, assertionName, discoveredAssertions, securityContextOnly, false);
    }

    private static void findSubAssertionsInAssertion(List<Object> assertions, QName assertionName, List<Object> discoveredAssertions, boolean securityContextOnly, boolean nowInsideSecureCOnversation) {
        for (Object assertion : assertions) {
            Object nested;
            Object operator;
            if (assertion instanceof org.w3.ns.ws_policy.Policy) {
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((org.w3.ns.ws_policy.Policy)assertion).getPolicyOrAllOrExactlyOne(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (assertion instanceof Policy) {
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((Policy)assertion).getPolicyOrAllOrExactlyOne(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (!(assertion instanceof JAXBElement)) continue;
            if (((JAXBElement)assertion).getName().equals(PolicyConfigUtil.SecureConversationTokenQName12)) {
                nowInsideSecureCOnversation = true;
            }
            if (((JAXBElement)assertion).getName().equals(assertionName)) {
                if (securityContextOnly && nowInsideSecureCOnversation) {
                    discoveredAssertions.add(assertion);
                    continue;
                }
                if (securityContextOnly || nowInsideSecureCOnversation) continue;
                discoveredAssertions.add(assertion);
                continue;
            }
            Object value = ((JAXBElement)assertion).getValue();
            if (value instanceof OperatorContentType) {
                operator = (OperatorContentType)value;
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((OperatorContentType)operator).getPolicyOrAllOrExactlyOne(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (value instanceof org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType) {
                operator = (org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType)value;
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType)operator).getPolicyOrAllOrExactlyOne(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (value instanceof NestedPolicyType) {
                nested = (NestedPolicyType)value;
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((NestedPolicyType)nested).getAny(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (value instanceof TokenAssertionType) {
                nested = (TokenAssertionType)value;
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((TokenAssertionType)nested).getAny(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (value instanceof SecureConversationTokenType) {
                nested = (SecureConversationTokenType)value;
                WSSecurityAssertionTransform.findSubAssertionsInAssertion(((SecureConversationTokenType)nested).getAny(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
                continue;
            }
            if (!(value instanceof TokenAssertionType)) continue;
            nested = (TokenAssertionType)value;
            WSSecurityAssertionTransform.findSubAssertionsInAssertion(((TokenAssertionType)nested).getAny(), assertionName, discoveredAssertions, securityContextOnly, nowInsideSecureCOnversation);
        }
    }

    private static InputStream policyJAXBObjToStream(final Object policy, final String packageStr) throws TransformationException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "policyJAXBObjToStream", new Object[]{policy, packageStr});
        }
        ByteArrayInputStream result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<ByteArrayInputStream>(){

                @Override
                public ByteArrayInputStream run() throws JAXBException {
                    ClassLoader cl = WSSecurityAssertionTransform.class.getClassLoader();
                    JAXBContext jcPolicy = JAXBContext.newInstance((String)packageStr, (ClassLoader)cl);
                    Marshaller marshaller = jcPolicy.createMarshaller();
                    marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                    ByteArrayOutputStream marshalled = new ByteArrayOutputStream();
                    marshaller.marshal(policy, (OutputStream)marshalled);
                    return new ByteArrayInputStream(marshalled.toByteArray());
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception unmarshalling policy", cause);
            }
            throw new TransformationException((Object)cause);
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "policyJAXBObjToStream", result);
        }
        return result;
    }

    protected static Object byteArrayToJAXB(byte[] bytes, final String packages) throws JAXBException, PrivilegedActionException, TransformationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "byteArrayToJAXB");
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Object retVal = null;
        try {
            retVal = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException, PrivilegedActionException {
                    return WSSecurityAssertionTransform.inputStreamToJAXB(bais, packages);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new TransformationException((Object)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "byteArrayToJAXB");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object inputStreamToJAXB(final InputStream stream, String packages) throws JAXBException, PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inputStreamToJAXB");
        }
        Object result = null;
        try {
            ClassLoader cl = WSSecurityAssertionTransform.class.getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)packages, (ClassLoader)cl);
            final Unmarshaller umPolicy = jc.createUnmarshaller();
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    return umPolicy.unmarshal(stream);
                }
            });
        }
        finally {
            block11: {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ioe) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "IOException closing bindingInputStream ", ioe);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inputStreamToJAXB");
        }
        return result;
    }

    private static List<Object> getSubAssertions(JAXBElement nestedToken) {
        SecureConversationTokenType token;
        List<Object> tokenMembers;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubAssertions");
        }
        List<Object> result = new ArrayList<Object>();
        Object obj = nestedToken.getValue();
        if (obj instanceof NestedPolicyType) {
            NestedPolicyType pTokenNested = (NestedPolicyType)obj;
            List<Object> tokenMembers2 = pTokenNested.getAny();
            if (tokenMembers2 != null && tokenMembers2.size() > 0) {
                Object tokenMemberObj = tokenMembers2.get(0);
                if (tokenMemberObj instanceof org.w3.ns.ws_policy.Policy) {
                    org.w3.ns.ws_policy.Policy tokenPolicy = (org.w3.ns.ws_policy.Policy)tokenMemberObj;
                    result = tokenPolicy.getPolicyOrAllOrExactlyOne();
                } else if (tokenMemberObj instanceof Policy) {
                    Policy tokenPolicy = (Policy)tokenMemberObj;
                    result = tokenPolicy.getPolicyOrAllOrExactlyOne();
                }
            }
        } else if (obj instanceof TokenAssertionType) {
            TokenAssertionType token2 = (TokenAssertionType)obj;
            List<Object> tokenMembers3 = token2.getAny();
            if (tokenMembers3 != null && tokenMembers3.size() > 0) {
                Object tokenMemberObj = tokenMembers3.get(0);
                if (tokenMemberObj instanceof org.w3.ns.ws_policy.Policy) {
                    org.w3.ns.ws_policy.Policy tokenPolicy = (org.w3.ns.ws_policy.Policy)tokenMemberObj;
                    result = tokenPolicy.getPolicyOrAllOrExactlyOne();
                } else if (tokenMemberObj instanceof Policy) {
                    Policy tokenPolicy = (Policy)tokenMemberObj;
                    result = tokenPolicy.getPolicyOrAllOrExactlyOne();
                }
            }
        } else if (obj instanceof SecureConversationTokenType && (tokenMembers = (token = (SecureConversationTokenType)obj).getAny()) != null && tokenMembers.size() > 0) {
            Object tokenMemberObj = tokenMembers.get(0);
            if (tokenMemberObj instanceof org.w3.ns.ws_policy.Policy) {
                org.w3.ns.ws_policy.Policy tokenPolicy = (org.w3.ns.ws_policy.Policy)tokenMemberObj;
                result = tokenPolicy.getPolicyOrAllOrExactlyOne();
            } else if (tokenMemberObj instanceof Policy) {
                Policy tokenPolicy = (Policy)tokenMemberObj;
                result = tokenPolicy.getPolicyOrAllOrExactlyOne();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubAssertions");
        }
        return result;
    }

    private static void addQNameAssertionToNestedType(JAXBElement token, QName newAssertionQName, boolean optional) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addQNameAssertionToNestedType");
        }
        List<Object> tokenAssertions = WSSecurityAssertionTransform.getSubAssertions(token);
        boolean found = false;
        for (Object obj : tokenAssertions) {
            if (!(obj instanceof JAXBElement) || !((JAXBElement)obj).getName().equals(newAssertionQName)) continue;
            found = true;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Assertion already in Policy", new Object[]{newAssertionQName});
            break;
        }
        if (!found) {
            QNameAssertionType newAssertion = new QNameAssertionType();
            JAXBElement newAssertionJAXB = new JAXBElement(newAssertionQName, QNameAssertionType.class, (Object)newAssertion);
            if (optional) {
                newAssertion.getOtherAttributes().put(WSP_OPTIONAL, "true");
            }
            tokenAssertions.add(newAssertionJAXB);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addQNameAssertionToNestedType");
        }
    }

    private static QName getQnameForKeyType(String type) {
        if (type == null) {
            return null;
        }
        QName result = null;
        if (type.equals("KEYID")) {
            result = PolicyConfigUtil.requireKeyIdentifierReferenceQName12;
        } else if (type.equals("X509ISSUER")) {
            result = PolicyConfigUtil.requireIssuerSerialReferenceQName12;
        } else if (type.equals("EMB")) {
            result = PolicyConfigUtil.requireEmbeddedTokenReferenceQName12;
        } else if (type.equals("THUMBPRINT")) {
            result = PolicyConfigUtil.requireThumbprintReferenceQName12;
        } else if (type.equals("STRREF")) {
            result = null;
        }
        return result;
    }

    private static String getKeyTypeForQName(QName name) {
        if (name == null) {
            return null;
        }
        String result = null;
        if (name.equals(PolicyConfigUtil.requireKeyIdentifierReferenceQName12)) {
            result = "KEYID";
        } else if (name.equals(PolicyConfigUtil.requireIssuerSerialReferenceQName12)) {
            result = "X509ISSUER";
        } else if (name.equals(PolicyConfigUtil.requireEmbeddedTokenReferenceQName12)) {
            result = "EMB";
        } else if (name.equals(PolicyConfigUtil.requireThumbprintReferenceQName12)) {
            result = "THUMBPRINT";
        }
        return result;
    }

    private static Policy getPolicyJAXB(PolicySetConfiguration psCfg) throws TransformationException {
        Object policyObj = psCfg.getPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY);
        if (policyObj == null) {
            return null;
        }
        if (policyObj instanceof Policy) {
            return (Policy)policyObj;
        }
        if (policyObj instanceof SoapSecurityException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicyJAXB SoapSecurityException", policyObj);
            }
            throw new TransformationException((Object)((SoapSecurityException)policyObj));
        }
        if (policyObj instanceof Exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicyJAXB Exception", policyObj);
            }
            throw new TransformationException((Object)((Exception)policyObj));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyJAXB", policyObj);
        }
        throw new TransformationException((Object)"Unknown error");
    }

    private static PolicyInboundConfig getPolicyInboundConfig(PolicySetConfiguration psCfg) throws WSPolicyBindingsException {
        Object pcc = psCfg.getPolicyTypeBinding(PrivateConsumerConfig.class);
        if (pcc instanceof PolicyInboundConfig) {
            return (PolicyInboundConfig)pcc;
        }
        if (pcc instanceof SoapSecurityException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicyInboundConfig SoapSecurityException", pcc);
            }
            throw new WSPolicyBindingsException((SoapSecurityException)pcc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyInboundConfig", pcc);
        }
        throw new WSPolicyBindingsException();
    }

    private static PolicyOutboundConfig getPolicyOutboundConfig(PolicySetConfiguration psCfg) throws WSPolicyBindingsException {
        Object pcg = psCfg.getPolicyTypeBinding(PrivateGeneratorConfig.class);
        if (pcg instanceof PolicyOutboundConfig) {
            return (PolicyOutboundConfig)pcg;
        }
        if (pcg instanceof SoapSecurityException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicyOutboundConfig SoapSecurityException", pcg);
            }
            throw new WSPolicyBindingsException((SoapSecurityException)pcg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyOutboundConfig", pcg);
        }
        throw new WSPolicyBindingsException("Error obtaining Security binding outbound configuration");
    }

    private static String streamToString(InputStream policy) {
        String result = "";
        if (policy != null && policy instanceof ByteArrayInputStream) {
            try {
                int inBytes = policy.available();
                byte[] inBuf = new byte[inBytes];
                policy.read(inBuf, 0, inBytes);
                result = new String(inBuf);
                policy.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

