/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.CertManagerFactory;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.Protection;
import com.ibm.ws.wssecurity.handler.ProtectionOrSupportingToken;
import com.ibm.ws.wssecurity.handler.WSSBinding;
import com.ibm.ws.wssecurity.handler.WSSBindings;
import com.ibm.ws.wssecurity.handler.WSSInboundBinding;
import com.ibm.ws.wssecurity.handler.WSSPolicy;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class PolicyInboundConfig
extends PrivateConsumerConfig {
    private Map<String, TokenConsumerConfig> nameToken;
    Map<String, KeyInfoContentConsumerConfig> nameKeyInfo = new HashMap<String, KeyInfoContentConsumerConfig>();
    private Map<String, String> encryptionAlgorithms;
    private Map<String, String> keyEncryptionAlgorithms;
    private Map<String, String> asymmetricSignatureAlgorithms;
    private Map<String, String> symmetricSignatureAlgorithms;
    private Map<String, String> canonicalizationAlgorithms;
    private Map<String, String> transformAlgorithms;
    private Map<String, String> digestAlgorithms;
    private String asymmetricSignatureAlgorithm = null;
    private String symmetricSignatureAlgorithm = null;
    private String digestAlgorithm = null;
    private String transformAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String encryptionAlgorithm = null;
    private String keyEncryptionAlgorithm = null;
    private static final TraceComponent tc = Tr.register(PolicyInboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PolicyInboundConfig.class.getName();
    private static WSSBindings securityBindings;
    private WSSBinding securityBinding = null;
    private boolean isTargetBindingUsing10NS = false;
    private static boolean _avoid70BindingsNSCheck;
    private String origin = "non-ws-security";

    public PolicyInboundConfig(WSSBindings appBindings, WSSPolicy appPolicy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "security.wssecurity.PolicyInboundConfig.s01", new Object[]{appBindings, appPolicy, isRequest, appClassLoader, defaultConfiguration});
        }
        WSSInboundBinding binding = null;
        if (appBindings != null) {
            securityBindings = appBindings;
            List<WSSBinding> securityBindingList = securityBindings.getSecurityBindings();
            for (int i = 0; i < securityBindingList.size(); ++i) {
                this.securityBinding = securityBindingList.get(i);
                if (!this.securityBinding.getName().equals("application")) continue;
                binding = this.securityBinding.getSecurityInboundBindingConfig();
            }
        } else {
            if (defaultConfiguration == null) {
                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s02");
            }
            Tr.warning(tc, "No Application Bindings found, will use Default Bindings");
        }
        this.init(binding, appPolicy, isRequest, appClassLoader, defaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "security.wssecurity.PolicyInboundConfig.s01", new Object[]{appBindings, appPolicy, isRequest, appClassLoader});
        }
    }

    public PolicyInboundConfig(WSSInboundBinding binding, WSSPolicy policyDocument, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyInboundConfig(WSSInboundBinding binding, WSSPolicy policyRoot, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{binding, policyDocument, isRequest, appClassLoader});
        }
        if (binding == null && defaultConfiguration == null) {
            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s02");
        }
        this.init(binding, policyDocument, isRequest, appClassLoader, defaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyInboundConfig(WSSInboundBinding binding, WSSPolicy policyRoot, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration)", new Object[]{binding, policyDocument, isRequest, appClassLoader});
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected final void init(WSSInboundBinding binding, WSSPolicy policy, boolean isRequest, ClassLoader appClassLoader, WSSecurityDefaultConfiguration defaultConfiguration) throws SoapSecurityException {
        block492: {
            block493: {
                if (PolicyInboundConfig.tc.isEntryEnabled()) {
                    Tr.entry(PolicyInboundConfig.tc, "init(WSSInboundBinding binding, WSSPolicy policyRoot, boolean isRequest,ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{binding, policy, isRequest, appClassLoader});
                }
                value = null;
                iMax = 0;
                jMax = 0;
                kMax = 0;
                cconfig = null;
                aconfig = null;
                chconfig = null;
                econfig = null;
                ksconfig = null;
                kiconfig = null;
                kicconfig = null;
                kiccconfig = null;
                pconfig = null;
                rpconfig = null;
                sconfig = null;
                srconfig = null;
                tsconfig = null;
                tconfig = null;
                encryptSignaturePartConfig = null;
                unboundNameIntegrity = new HashMap<K, V>();
                unboundNameConfidentiality = new HashMap<K, V>();
                unboundNameToken = new HashMap<String, TokenConsumerConfig>();
                factory = WSSFactory.getInstance("soap");
                type = new HashMap<Object, Object>();
                nameConfidentiality = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
                nameIntegrity = new HashMap<String, PrivateCommonConfig.ReferencePartConfImpl>();
                this.nameToken = new HashMap<String, TokenConsumerConfig>();
                extProperties = null;
                supportingTokens = new HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl>();
                this.encryptionAlgorithms = new HashMap<String, String>();
                this.keyEncryptionAlgorithms = new HashMap<String, String>();
                this.asymmetricSignatureAlgorithms = new HashMap<String, String>();
                this.symmetricSignatureAlgorithms = new HashMap<String, String>();
                this.canonicalizationAlgorithms = new HashMap<String, String>();
                this.transformAlgorithms = new HashMap<String, String>();
                this.digestAlgorithms = new HashMap<String, String>();
                signedElementsAndParts = new ArrayList<String>();
                encryptedElementsAndParts = new ArrayList<String>();
                aTokenAssertion = null;
                this._initiatorTokens = new ArrayList<E>();
                this._initiatorTokenQNames = new ArrayList<E>();
                this._recipientTokens = new ArrayList<E>();
                this._recipientTokenQNames = new ArrayList<E>();
                this._initiatorSignatureTokens = new ArrayList<E>();
                this._initiatorSignatureTokenQNames = new ArrayList<E>();
                this._initiatorEncryptionTokens = new ArrayList<E>();
                this._initiatorEncryptionTokenQNames = new ArrayList<E>();
                this._recipientSignatureTokens = new ArrayList<E>();
                this._recipientSignatureTokenQNames = new ArrayList<E>();
                this._recipientEncryptionTokens = new ArrayList<E>();
                this._recipientEncryptionTokenQNames = new ArrayList<E>();
                signSignatureConfirmationSpecified = false;
                encryptSignatureConfirmationSpecified = false;
                isTargetNamespaceDraft12 = false;
                addedEncryptSignature = false;
                this._useDefault = binding == null;
                this._request = isRequest;
                this._timestampRequired = false;
                this._layout = "Lax";
                varMap = VariableExpanderFactory.getVariableExpander();
                this.processPrivateConfig(DOMUtils.getPrivateConfig());
                if (binding != null) {
                    if ("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding".equals(binding.getTargetNamespace())) {
                        this.isTargetBindingUsing10NS = true;
                    }
                    if (binding.getActor() != null) {
                        tmpActor = binding.getActor().trim();
                        if (tmpActor.length() != 0) {
                            try {
                                new URI(tmpActor);
                            }
                            catch (URISyntaxException uriex) {
                                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s05", uriex);
                            }
                            this._myActor = tmpActor;
                        }
                    } else {
                        this._myActor = null;
                    }
                    v0 = this._onlySignEntireHeadersAndBody = this._onlySignEntireHeadersAndBody != false || binding.onlySignEntireHeadersAndBody != false;
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Processed binding onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
                    }
                }
                if (this._properties == null) {
                    this._properties = new HashMap<K, V>();
                }
                bndParameters = null;
                bndProperties = null;
                if (this.securityBinding != null) {
                    sbp = this.securityBinding.getParameters();
                    if (sbp != null && (bndParameters = ConfigConstants.getProperties(sbp, varMap)) != null) {
                        this._properties.putAll(bndParameters);
                    }
                    if (binding != null && (p = binding.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
                        this._properties.putAll(bndProperties);
                    }
                }
                if (policy == null) break block492;
                this._targetNamespace = policy.getTargetNamespace();
                if (this._targetNamespace.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512")) {
                    isTargetNamespaceDraft12 = true;
                }
                if (isRequest && !isTargetNamespaceDraft12) {
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s02", new String[]{this._targetNamespace}));
                }
                policyBinding = policy.getPolicyBinding();
                if (policyBinding != null && !isTargetNamespaceDraft12 && policyBinding.isEncryptSignature()) {
                    signatureKeyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
                    encryptSignaturePartConfig = new PrivateCommonConfig.PartConfImpl();
                    encryptSignaturePartConfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                    encryptSignaturePartConfig._keyword = signatureKeyword;
                    this._encryptSignature = true;
                }
                children = policy.getProtectionAssertions();
                obj = null;
                if (children == null) break block493;
                for (i = 0; i < children.size(); ++i) {
                    block496: {
                        block494: {
                            block495: {
                                obj = children.get(i);
                                if (!(obj instanceof Protection)) continue;
                                subPolicy = obj;
                                idReference = subPolicy.getId();
                                retrieveAssertions = false;
                                retrieveAssertions = this.retrieveAssertions(idReference, isRequest);
                                if (!retrieveAssertions) continue;
                                if (!subPolicy.isSignatureProtection()) break block494;
                                this._verificationRequired = true;
                                rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                                rpconfig._oneOfIntegralParts = true;
                                if (subPolicy.isBody()) {
                                    pconfig = new PrivateCommonConfig.PartConfImpl();
                                    pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                    pconfig._keyword = "body";
                                    rpconfig._parts.add(pconfig);
                                }
                                if ((headers = subPolicy.getHeaders()) != null) {
                                    for (a = 0; a < headers.size(); ++a) {
                                        header = headers.get(a);
                                        pconfig = new PrivateCommonConfig.PartConfImpl();
                                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER;
                                        localPart = header.getLocalPart();
                                        if (localPart != null && localPart.length() > 0) {
                                            pconfig._headerName = localPart;
                                        }
                                        pconfig._headerNamespace = header.getNamespaceURI();
                                        rpconfig._parts.add(pconfig);
                                    }
                                }
                                if ((signedElements = subPolicy.getXPathExpressions()) == null) break block495;
                                signedElementsXPathExpressions = new HashMap<String, String>();
                                for (x = 0; x < signedElements.size(); ++x) {
                                    pconfig = new PrivateCommonConfig.PartConfImpl();
                                    keyword = null;
                                    xpathExpression = signedElements.get(x);
                                    keyword = PolicyConfigUtil.getKeywordForXPathExpression(xpathExpression, true);
                                    if (keyword == null) ** GOTO lbl164
                                    if (!signedElementsXPathExpressions.containsKey(keyword)) {
                                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "PERF: Using keyword: " + keyword);
                                        }
                                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                        pconfig._keyword = keyword;
                                        signedElementsXPathExpressions.put(keyword, xpathExpression);
                                    } else {
                                        xpathValue = (String)signedElementsXPathExpressions.get(keyword);
                                        if (xpathValue.equals(xpathExpression)) {
                                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyInboundConfig.tc, "Duplicate xpath element in signedElements will be ignored: " + xpathExpression);
                                            }
                                            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s09", new String[]{xpathValue});
                                            continue;
                                        }
                                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                        Tr.debug(PolicyInboundConfig.tc, "xpath elements with values [" + xpathValue + "] and [" + xpathExpression + "] reference the same message part, so the message part will only be signed once.");
                                        continue;
lbl164:
                                        // 1 sources

                                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "PERF: Using XPath: " + xpathExpression);
                                        }
                                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH;
                                        pconfig._keyword = xpathExpression;
                                        if (xpathExpression.equals("/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']") || xpathExpression.equals("/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']")) {
                                            signSignatureConfirmationSpecified = true;
                                        }
                                    }
                                    rpconfig._parts.add(pconfig);
                                }
                            }
                            rpconfig._order = 0;
                            this._requiredIntegralParts.add(rpconfig);
                            if (idReference == null || idReference.length() == 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                            }
                            if (nameIntegrity.containsKey(idReference) && PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "WARNING: required integrity [" + idReference + "] is overwritten.");
                            }
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Adding required integrity: " + idReference);
                            }
                            nameIntegrity.put(idReference, rpconfig);
                            signedElementsAndParts.add(idReference);
                            continue;
                        }
                        this._decryptionRequired = true;
                        rpconfig = new PrivateCommonConfig.ReferencePartConfImpl();
                        rpconfig._oneOfIntegralParts = true;
                        if (subPolicy.isBody()) {
                            pconfig = new PrivateCommonConfig.PartConfImpl();
                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                            pconfig._keyword = "bodycontent";
                            rpconfig._parts.add(pconfig);
                        }
                        if ((headers = subPolicy.getHeaders()) != null) {
                            for (a = 0; a < headers.size(); ++a) {
                                header = headers.get(a);
                                pconfig = new PrivateCommonConfig.PartConfImpl();
                                pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER;
                                localPart = header.getLocalPart();
                                if (localPart != null && localPart.length() > 0) {
                                    pconfig._headerName = localPart;
                                }
                                pconfig._headerNamespace = header.getNamespaceURI();
                                rpconfig._parts.add(pconfig);
                            }
                        }
                        if ((encryptedElements = subPolicy.getXPathExpressions()) == null) break block496;
                        encryptedElementsXPathExpressions = new HashMap<String, String>();
                        if (this._encryptSignature) {
                            encryptedElementsXPathExpressions.put("signature", "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']");
                        }
                        for (x = 0; x < encryptedElements.size(); ++x) {
                            pconfig = new PrivateCommonConfig.PartConfImpl();
                            keyword = null;
                            xpathExpression = encryptedElements.get(x);
                            keyword = PolicyConfigUtil.getKeywordForXPathExpression(xpathExpression, false);
                            if (keyword == null) ** GOTO lbl240
                            if (!encryptedElementsXPathExpressions.containsKey(keyword)) {
                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "PERF: Using keyword: " + keyword);
                                }
                                pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                                pconfig._keyword = keyword;
                                encryptedElementsXPathExpressions.put(keyword, xpathExpression);
                                if (keyword.equals(ConfidentialDialectElementSelector.WASDIALECTS[6])) {
                                    encryptSignatureConfirmationSpecified = true;
                                }
                            } else {
                                xpathValue = (String)encryptedElementsXPathExpressions.get(keyword);
                                if (xpathValue.equals(xpathExpression)) {
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "Duplicate xpath element in encryptedElements will be ignored: " + xpathExpression);
                                    }
                                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s10", new String[]{xpathValue});
                                    continue;
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "xpath elements with values [" + xpathValue + "] and [" + xpathExpression + "] reference the same message part, so the message part will only be encrypted once.");
                                continue;
lbl240:
                                // 1 sources

                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "PERF: Using XPath: " + xpathExpression);
                                }
                                pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH;
                                pconfig._keyword = xpathExpression;
                            }
                            rpconfig._parts.add(pconfig);
                        }
                    }
                    if ((contentEncryptedElements = subPolicy.getXPathExpressionsForContent()) != null) {
                        encryptedElementsXPathExpressions = new HashSet<String>();
                        for (x = 0; x < contentEncryptedElements.size(); ++x) {
                            finalxpathExpression = xpathExpression = contentEncryptedElements.get(x);
                            if (!xpathExpression.endsWith("/node()")) {
                                finalxpathExpression = finalxpathExpression + "/node()";
                            }
                            if (!encryptedElementsXPathExpressions.contains(finalxpathExpression)) {
                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "Processing ContentEncryptedElement for xpath: " + finalxpathExpression);
                                }
                                pconfig = new PrivateCommonConfig.PartConfImpl();
                                pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH;
                                pconfig._keyword = finalxpathExpression;
                                rpconfig._parts.add(pconfig);
                                encryptedElementsXPathExpressions.add(finalxpathExpression);
                                continue;
                            }
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Duplicate xpath element in encryptedElements will be ignored: " + finalxpathExpression);
                            }
                            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s10", new String[]{finalxpathExpression});
                        }
                    }
                    rpconfig._order = 0;
                    this._requiredConfidentialParts.add(rpconfig);
                    if (idReference == null || idReference.length() == 0) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21");
                    }
                    if (nameConfidentiality.containsKey(value) && PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "WARNING: required confidentiality [" + idReference + "] is overwritten.");
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Adding required confidentiality: " + idReference);
                    }
                    nameConfidentiality.put(idReference, rpconfig);
                    encryptedElementsAndParts.add(idReference);
                    if (addedEncryptSignature || isTargetNamespaceDraft12 || !this._encryptSignature || rpconfig._parts.isEmpty()) continue;
                    rpconfig._parts.add(encryptSignaturePartConfig);
                    addedEncryptSignature = true;
                }
            }
            if ((policyBinding = policy.getPolicyBinding()) != null) {
                this._symmetricBinding = policyBinding.isSymmetricBinding();
                assertions = policyBinding.getProtectionTokens();
                for (j = 0; j < assertions.size(); ++j) {
                    potentialAssertion = assertions.get(j);
                    if (!(potentialAssertion instanceof ProtectionOrSupportingToken)) continue;
                    anAssertion = potentialAssertion;
                    assertionName = anAssertion.getName();
                    if ("InitiatorToken".equals(assertionName)) {
                        if (!this._initiatorEncryptionTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "Initiator Token assertion found when an Initiator Encryption Token assertion was already defined.");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s08");
                        }
                        if (!this._initiatorSignatureTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s09");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s09");
                        }
                        aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (aTokenAssertion != null) {
                            if (!this._initiatorTokenQNames.contains(aTokenAssertion._tokenType)) {
                                this._initiatorTokens.add(aTokenAssertion);
                                this._initiatorTokenQNames.add(aTokenAssertion._tokenType);
                            } else {
                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                            }
                        }
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the InitiatorToken");
                        continue;
                    }
                    if ("RecipientToken".equals(assertionName)) {
                        if (!this._recipientEncryptionTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s10");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s10");
                        }
                        if (!this._recipientSignatureTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s11");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s11");
                        }
                        aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (aTokenAssertion != null) {
                            if (!this._recipientTokenQNames.contains(aTokenAssertion._tokenType)) {
                                this._recipientTokens.add(aTokenAssertion);
                                this._recipientTokenQNames.add(aTokenAssertion._tokenType);
                            } else {
                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                            }
                        }
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the RecipientToken");
                        continue;
                    }
                    if ("InitiatorSignatureToken".equals(assertionName)) {
                        if (!this._initiatorTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s12");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s12");
                        }
                        aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (aTokenAssertion != null) {
                            if (!this._initiatorSignatureTokenQNames.contains(aTokenAssertion._tokenType)) {
                                this._initiatorSignatureTokens.add(aTokenAssertion);
                                this._initiatorSignatureTokenQNames.add(aTokenAssertion._tokenType);
                            } else {
                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                            }
                        }
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the InitiatorSignatureToken");
                        continue;
                    }
                    if ("RecipientSignatureToken".equals(assertionName)) {
                        if (!this._recipientTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s13");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s13");
                        }
                        aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (aTokenAssertion != null) {
                            if (!this._recipientSignatureTokenQNames.contains(aTokenAssertion._tokenType)) {
                                this._recipientSignatureTokens.add(aTokenAssertion);
                                this._recipientSignatureTokenQNames.add(aTokenAssertion._tokenType);
                            } else {
                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                            }
                        }
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the RecipientSignatureToken");
                        continue;
                    }
                    if ("InitiatorEncryptionToken".equals(assertionName)) {
                        if (!this._initiatorTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s14");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s14");
                        }
                        aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (aTokenAssertion != null) {
                            if (!this._initiatorEncryptionTokenQNames.contains(aTokenAssertion._tokenType)) {
                                this._initiatorEncryptionTokens.add(aTokenAssertion);
                                this._initiatorEncryptionTokenQNames.add(aTokenAssertion._tokenType);
                            } else {
                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                            }
                        }
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the InitiatorEncryptionToken");
                        continue;
                    }
                    if ("RecipientEncryptionToken".equals(assertionName)) {
                        if (!this._recipientTokens.isEmpty()) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInboundConfig.s15");
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s15");
                        }
                        aTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (aTokenAssertion != null) {
                            if (!this._recipientEncryptionTokenQNames.contains(aTokenAssertion._tokenType)) {
                                this._recipientEncryptionTokens.add(aTokenAssertion);
                                this._recipientEncryptionTokenQNames.add(aTokenAssertion._tokenType);
                            } else {
                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()});
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s21", new String[]{aTokenAssertion._tokenType.toString()}));
                            }
                        }
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the RecipientEncryptionToken");
                        continue;
                    }
                    if ("EncryptionToken".equals(assertionName)) {
                        if (this._symmetricProtectionTokenAssertion != null) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s11");
                            throw new SoapSecurityException("security.wssecurity.PolicyInOutboundConfig.s11");
                        }
                        this._symmetricEncryptionTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the EncryptionToken");
                        continue;
                    }
                    if ("SignatureToken".equals(assertionName)) {
                        if (this._symmetricProtectionTokenAssertion != null) {
                            Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s12");
                            throw new SoapSecurityException("security.wssecurity.PolicyInOutboundConfig.s12");
                        }
                        this._symmetricSignatureTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the SignatureToken");
                        continue;
                    }
                    if (!"ProtectionToken".equals(assertionName)) continue;
                    if (this._symmetricEncryptionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null) {
                        Tr.error(PolicyInboundConfig.tc, "security.wssecurity.PolicyInOutboundConfig.s13");
                        throw new SoapSecurityException("security.wssecurity.PolicyInOutboundConfig.s13");
                    }
                    this._symmetricProtectionTokenAssertion = this.getTokenTypeAssertion(anAssertion);
                    if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                    Tr.debug(PolicyInboundConfig.tc, "The policy has processed the ProtectionToken");
                }
                layout = policyBinding.getLayout();
                if (layout != null) {
                    this._layout = this.layoutAssertion(layout);
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the Layout");
                    }
                }
                algorithmSuiteAssertions = policyBinding.getAlgorithmSuites();
                for (j = 0; j < algorithmSuiteAssertions.size(); ++j) {
                    potentialAssertion = algorithmSuiteAssertions.get(j);
                    if (potentialAssertion instanceof String) {
                        this.algorithmSuiteAssertion(potentialAssertion);
                    }
                    if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                    Tr.debug(PolicyInboundConfig.tc, "The policy has processed the AlgorithmSuite");
                }
                if (policyBinding.isIncludeTimestamp()) {
                    this._timestampRequired = true;
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the IncludeTimestamp");
                    }
                }
                v1 = this._onlySignEntireHeadersAndBody = this._onlySignEntireHeadersAndBody != false || policyBinding.isOnlySignEntireHeadersAndBody() != false;
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "processed policyBinding onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
                }
            }
            children = policy.getSupportingTokens();
            obj = null;
            if (children != null) {
                for (i = 0; i < children.size(); ++i) {
                    obj = children.get(i);
                    if (!(obj instanceof ProtectionOrSupportingToken)) continue;
                    supportingTokenPolicy = (ProtectionOrSupportingToken)obj;
                    idReference = supportingTokenPolicy.getName();
                    retrieveAssertions = false;
                    retrieveAssertions = this.retrieveAssertions(idReference, isRequest);
                    if (!retrieveAssertions) continue;
                    this._tokenRequired = true;
                    tconfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    aTokenAssertion = this.getTokenTypeAssertion(supportingTokenPolicy);
                    if (aTokenAssertion != null) {
                        tconfig._type = aTokenAssertion._tokenType;
                        tconfig._aTokenAssertion = aTokenAssertion;
                    }
                    this._requiredSecurityTokens.add(tconfig);
                    if (idReference == null || idReference.length() == 0) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                    }
                    if (this.nameToken.containsKey(idReference) && PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "WARNING: required security token [" + idReference + "] is overwritten.");
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Adding required security token: " + idReference);
                    }
                    supportingTokens.put(idReference, tconfig);
                    this.nameToken.put(idReference, tconfig);
                }
            }
            children = policy.getWss10Assertions();
            obj = null;
            if (children != null) {
                for (i = 0; i < children.size(); ++i) {
                    obj = children.get(i);
                    if (!(obj instanceof String)) continue;
                    assertionName = (String)obj;
                    if ("MustSupportRefKeyIdentifier".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefKeyIdentifier");
                        continue;
                    }
                    if ("MustSupportRefIssuerSerial".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefIssuerSerial");
                        continue;
                    }
                    if ("MustSupportRefExternalURI".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefExternalURI");
                        continue;
                    }
                    if ("MustSupportRefEmbeddedToken".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefEmbeddedToken");
                        continue;
                    }
                    if ("MustSupportRefEncryptedKey".equals(assertionName)) {
                        if (isTargetNamespaceDraft12) continue;
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s03", new String[]{assertionName}));
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s18", new String[]{assertionName}));
                }
            }
            children = policy.getWss11Assertions();
            obj = null;
            if (children != null) {
                for (i = 0; i < children.size(); ++i) {
                    obj = children.get(i);
                    if (!(obj instanceof String)) continue;
                    assertionName = (String)obj;
                    if ("RequireSignatureConfirmation".equals(assertionName)) {
                        this._signatureConfirmationRequired = true;
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed RequireSignatureConfirmation");
                        continue;
                    }
                    if ("MustSupportRefKeyIdentifier".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefKeyIdentifier");
                        continue;
                    }
                    if ("MustSupportRefIssuerSerial".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefIssuerSerial");
                        continue;
                    }
                    if ("MustSupportRefExternalURI".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefExternalURI");
                        continue;
                    }
                    if ("MustSupportRefEmbeddedToken".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefEmbeddedToken");
                        continue;
                    }
                    if ("MustSupportRefThumbprint".equals(assertionName)) {
                        if (isTargetNamespaceDraft12 || !PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "The policy has processed the MustSupportRefThumbprint");
                        continue;
                    }
                    if ("MustSupportRefEncryptedKey".equals(assertionName)) {
                        if (isTargetNamespaceDraft12) continue;
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s04", new String[]{assertionName}));
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s19", new String[]{assertionName}));
                }
            }
            children = policy.getTrust10Assertions();
            obj = null;
            if (children != null) {
                for (i = 0; i < children.size(); ++i) {
                    obj = children.get(i);
                    if (!(obj instanceof String) || "MustSupportClientChallenge".equals(assertionName = (String)obj) || "MustSupportServerChallenge".equals(assertionName) || "MustSupportRefExternalURI".equals(assertionName) || "RequireClientEntropy".equals(assertionName) || "RequireServerEntropy".equals(assertionName) || "MustSupportIssuedTokens".equals(assertionName)) continue;
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{assertionName}));
                }
            }
            children = policy.getTrust13Assertions();
            obj = null;
            if (children != null) {
                for (i = 0; i < children.size(); ++i) {
                    obj = children.get(i);
                    if (!(obj instanceof String)) continue;
                    assertionName = (String)obj;
                    if ("MustSupportClientChallenge".equals(assertionName)) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                    }
                    if ("MustSupportServerChallenge".equals(assertionName)) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                    }
                    if ("RequireClientEntropy".equals(assertionName) || "RequireServerEntropy".equals(assertionName)) continue;
                    if ("MustSupportIssuedTokens".equals(assertionName)) {
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                    }
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s14", new String[]{assertionName}));
                }
            }
            for (x = 0; x < encryptedElementsAndParts.size(); ++x) {
                part = (String)encryptedElementsAndParts.get(x);
                this.encryptionAlgorithms.put(part, this.encryptionAlgorithm);
                this.keyEncryptionAlgorithms.put(part, this.keyEncryptionAlgorithm);
                this.digestAlgorithms.put(part, this.digestAlgorithm);
                this.transformAlgorithms.put(part, this.transformAlgorithm);
                this.canonicalizationAlgorithms.put(part, this.canonicalizationAlgorithm);
            }
            for (x = 0; x < signedElementsAndParts.size(); ++x) {
                part = (String)signedElementsAndParts.get(x);
                if (this._symmetricBinding) {
                    this.symmetricSignatureAlgorithms.put(part, this.symmetricSignatureAlgorithm);
                } else {
                    this.asymmetricSignatureAlgorithms.put(part, this.asymmetricSignatureAlgorithm);
                }
                this.digestAlgorithms.put(part, this.digestAlgorithm);
                this.transformAlgorithms.put(part, this.transformAlgorithm);
                this.canonicalizationAlgorithms.put(part, this.canonicalizationAlgorithm);
            }
        }
        if (this._timestampRequired) {
            tsconfig = new PrivateConsumerConfig.TimestampConsumerConfImpl();
            tsconfig._actor = this._myActor != null ? this._myActor : null;
            if (this._layout.equals("LaxTsFirst")) {
                tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_DIALECT, com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS);
                tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_KEYWORD, "SecurityFirst");
            }
            if (this._layout.equals("LaxTsLast")) {
                tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_DIALECT, com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS);
                tsconfig._properties.put(Constants.WSSECURITY_TIMESTAMP_KEYWORD, "SecurityLast");
            }
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Adding timestamp: " + this._timestampRequired);
            }
            this._timestampConsumer = tsconfig;
        }
        try {
            this._nonceManager = (NonceManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    return NonceManagerFactory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException pac) {
            th = pac.getCause();
            if (th instanceof SoapSecurityException) {
                throw (SoapSecurityException)th;
            }
            throw new SoapSecurityException(th.getMessage());
        }
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "NonceManager = " + this._nonceManager);
        }
        try {
            this._certManager = (CertCacheManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    return CertManagerFactory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException pac) {
            th = pac.getCause();
            if (th instanceof SoapSecurityException) {
                throw (SoapSecurityException)th;
            }
            throw new SoapSecurityException(th.getMessage());
        }
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "CertManager = " + this._certManager);
        }
        this._allowedSignatureMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(1));
        this._allowedDigestMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(2));
        this._allowedDataEncryptionMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(3));
        this._allowedKeyEncryptionMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(7));
        if (defaultConfiguration != null && (hwConfigName = defaultConfiguration.getHardwareConfigName()) != null && hwConfigName.length() != 0) {
            this._properties.put("HWCONFIG", hwConfigName);
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Hardware Acceleration is Enabled " + hwConfigName);
            }
            this._properties.put("com.ibm.ws.wssecurity.handler.OffloadAllCryptography", defaultConfiguration.getUseOffloadAllCrypto());
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Hardware Acceleration is Enabled :" + hwConfigName + ", OFFLOAD_ALL_CRYPTO is: " + defaultConfiguration.getUseOffloadAllCrypto());
            }
            this._properties.put("com.ibm.ws.wssecurity.handler.hardwareCacheSize", new Integer(defaultConfiguration.getHardwareCacheSize()));
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Hardware cache size = " + defaultConfiguration.getHardwareCacheSize());
            }
            this._properties.put("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography", new Boolean(defaultConfiguration.getOffloadRSAPublicKeyCrypto()));
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Offload RSA Public Key crypto = " + defaultConfiguration.getOffloadRSAPublicKeyCrypto());
            }
        }
        if (!this._useDefault && (gref = binding.getBindingReference()) != null && "DEFAULT".equals(gref)) {
            this._useDefault = true;
        }
        if (this._useDefault) {
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Using default binding...");
            }
            if (defaultConfiguration == null) {
                Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.PrivateGeneratorConfig.s25");
            } else {
                dgconfig = defaultConfiguration.getDefaultConsumerBinding();
                if (dgconfig != null) {
                    this.initDefaultConfig(dgconfig, isRequest, signSignatureConfirmationSpecified, encryptSignatureConfirmationSpecified);
                } else {
                    if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                        se = defaultConfiguration.getDefaultBindingsLoadingException();
                        throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s33", se.toString());
                    }
                    se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03");
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s33", se.toString());
                }
            }
            this.mapPolicyAssertionsToProperties(isTargetNamespaceDraft12, isRequest);
            this.validate(true, this.nameToken);
            if (PolicyInboundConfig.tc.isEntryEnabled()) {
                Tr.exit(PolicyInboundConfig.tc, "init(SecurityInboundBindingConfig binding, Policy policyRoot, String actorURI, boolean isRequest,ClassLoader appClassLoader)");
            }
            return;
        }
        collectionCertStores = binding.getCollectionCertStores();
        encryptionInfos = binding.getEncryptionInfos();
        keyInfos = binding.getKeyInfos();
        signingInfos = binding.getSigningInfos();
        tokenConsumers = binding.getTokens();
        callers = binding.getCallers();
        trustAnchors = binding.getTrustAnchors();
        p = binding.getProperties();
        timestampAndNonceParts = new ArrayList<PrivateCommonConfig.PartConfImpl>();
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            bndparam = bndParameters == null ? "null" : bndParameters.toString();
            bndprop = bndProperties == null ? "null" : bndProperties.toString();
            Tr.debug(PolicyInboundConfig.tc, "Policy Inbound Binding (CollectionCertStores, EncryptionInfos, KeyInfos,  SigningInfos, TokenConsumers, TrustAnchors, Property):", new Object[]{collectionCertStores, encryptionInfos, keyInfos, signingInfos, tokenConsumers, trustAnchors, bndparam, bndprop});
        }
        this._skipOperationLevelPolicyCheck = ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_CHECK_OPERATION_LEVEL_POLICIES) == false;
        checkHMACOutputLength = ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_CHECK_HMAC_OUTPUT_LENGTH);
        this._algorithmFactory.setCheckHMACOutputLength(checkHMACOutputLength);
        this._bypassHeader = ConfigUtil.getIsTrueProperty(this._properties, Constants.BYPASS_HEADER);
        if (!isRequest) {
            disableImplicitProtectionForSignatureConfirmation = false;
            if (binding.isExplicitlyProtectSignatureConfirmation()) {
                if (this.isTargetBindingUsing10NS && !PolicyInboundConfig._avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "ExplicitlyProtectSignatureConfirmation");
                }
                disableImplicitProtectionForSignatureConfirmation = true;
            }
            if (this._signatureConfirmationRequired && !this.isTargetBindingUsing10NS && !disableImplicitProtectionForSignatureConfirmation) {
                if (!signSignatureConfirmationSpecified) {
                    if (signedElementsAndParts.size() > 0) {
                        idRef = (String)signedElementsAndParts.get(0);
                        rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(idRef);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                        pconfig._keyword = IntegralDialectElementSelector.WASDIALECTS[14];
                        rpconfig._parts.add(pconfig);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Adding SignatureConfirmation to required integrity:" + idRef);
                        }
                    } else {
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Cannot sign SignatureConfirmation element since nothing else on the message is signed");
                        }
                        Tr.warning(PolicyInboundConfig.tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s23"));
                    }
                }
                if (!encryptSignatureConfirmationSpecified) {
                    if (encryptedElementsAndParts.size() > 0) {
                        idRef = (String)encryptedElementsAndParts.get(0);
                        rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(idRef);
                        pconfig = new PrivateCommonConfig.PartConfImpl();
                        pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                        pconfig._keyword = ConfidentialDialectElementSelector.WASDIALECTS[6];
                        rpconfig._parts.add(pconfig);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Adding SignatureConfirmation to required confidentiality:" + idRef);
                        }
                    } else {
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Cannot encrypt SignatureConfirmation element since nothing else on the message is encrypted");
                        }
                        Tr.warning(PolicyInboundConfig.tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s22"));
                    }
                }
            }
        }
        timeout = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_TIMESTAMP_TIMEOUT);
        if (v != null) {
            if ((v = v.trim()).length() != 0) {
                try {
                    l = Integer.parseInt(v);
                    timeout = ConfigConstants.validTimestampTimeout(l);
                }
                catch (NumberFormatException e) {
                    Tr.processException((Throwable)e, this.getClass().getName() + ".init", "1321", this);
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSEC0144W", new Object[]{v, new Integer(600)});
                    timeout = 600;
                }
            }
        } else {
            timeout = 600;
        }
        maxAge = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_TIMESTAMP_MAX_AGE);
        maxAge = v != null ? ConfigConstants.processTimestampMaxAge(v, timeout) : 300;
        this._timestampMaxAge = maxAge;
        clockSkew = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_TIMESTAMP_CLOCK_SKEW);
        clockSkew = v != null ? ConfigConstants.processTimestampClockSkew(v, this._timestampMaxAge) : 180;
        this._timestampClockSkew = clockSkew;
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "timestamp.maxAge = " + this._timestampMaxAge * 1000 + " ms, " + "timestamp.clockSkew = " + this._timestampClockSkew * 1000 + " ms");
        }
        if (this._timestampRequired && this._timestampConsumer != null) {
            tsconfig = this._timestampConsumer;
            tsconfig._timestampMaxAge = this._timestampMaxAge;
            tsconfig._timestampClockSkew = this._timestampClockSkew;
        }
        if ((v = (String)this._properties.get(Constants.WSSECURITY_NONCE_CACHE_TIMEOUT)) != null) {
            if ((v = v.trim()).length() != 0) {
                try {
                    l = Integer.parseInt(v);
                    timeout = ConfigConstants.validNonceCacheTimeout(l);
                }
                catch (NumberFormatException e) {
                    Tr.processException((Throwable)e, this.getClass().getName() + ".init", "1383", this);
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSEC0115W", new Object[]{v, new Integer(600)});
                    timeout = 600;
                }
            }
        } else {
            timeout = 600;
        }
        maxAge = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_NONCE_MAX_AGE);
        maxAge = v != null ? ConfigConstants.processNonceMaxAge(v, timeout) : 300;
        clockSkew = 0;
        v = (String)this._properties.get(Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        clockSkew = v != null ? ConfigConstants.processNonceClockSkew(v, maxAge) : 0;
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "nonce.maxAge = " + maxAge * 1000 + " ms, " + "nonce.clockSkew = " + clockSkew * 1000 + " ms");
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (i = 0; i < iMax; ++i) {
                encryptionInfo = encryptionInfos.get(i);
                encryptioninfoPropsList = encryptionInfo.getProperties();
                encryptionInfoProperties = ConfigConstants.getProperties(encryptioninfoPropsList, varMap);
                this._properties.putAll(encryptionInfoProperties);
                pref = encryptionInfo.getEncryptionPartReference();
                if (pref == null || (value = pref.getReference()) == null || value.length() <= 0) continue;
                aConfig = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(value);
                if (aConfig == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                }
                if (pref.isIncludeTimestamp()) {
                    partsList = aConfig.getParts();
                    for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                        timestampPartConfig = new PrivateCommonConfig.PartConfImpl();
                        timestampPartConfig.copyAttributesForTimestamp(aPart);
                        timestampAndNonceParts.add(timestampPartConfig);
                    }
                }
                if (pref.isIncludeNonce()) {
                    partsList = aConfig.getParts();
                    for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                        noncePartConfig = new PrivateCommonConfig.PartConfImpl();
                        noncePartConfig.copyAttributesForNonce(aPart);
                        timestampAndNonceParts.add(noncePartConfig);
                    }
                }
                for (b = 0; b < timestampAndNonceParts.size(); ++b) {
                    aConfig._parts.add((ReferencePartConfig.PartConfig)timestampAndNonceParts.get(b));
                }
                timestampAndNonceParts.clear();
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (i = 0; i < iMax; ++i) {
                signingInfo = signingInfos.get(i);
                signinfoPropsList = signingInfo.getProperties();
                signingInfoProperties = ConfigConstants.getProperties(signinfoPropsList, varMap);
                this._properties.putAll(signingInfoProperties);
                prefs = signingInfo.getSigningPartReferences();
                if (prefs == null) continue;
                jMax = prefs.size();
                for (j = 0; j < jMax; ++j) {
                    pref = prefs.get(j);
                    value = pref.getReference();
                    if (value == null || value.length() <= 0) continue;
                    aConfig = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(value);
                    if (aConfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + value);
                    }
                    if (pref.isIncludeTimestamp()) {
                        partsList = aConfig.getParts();
                        for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                            timestampPartConfig = new PrivateCommonConfig.PartConfImpl();
                            timestampPartConfig.copyAttributesForTimestamp(aPart);
                            timestampAndNonceParts.add(timestampPartConfig);
                        }
                    }
                    if (pref.isIncludeNonce()) {
                        partsList = aConfig.getParts();
                        for (PrivateCommonConfig.PartConfImpl aPart : partsList) {
                            noncePartConfig = new PrivateCommonConfig.PartConfImpl();
                            noncePartConfig.copyAttributesForNonce(aPart);
                            timestampAndNonceParts.add(noncePartConfig);
                        }
                    }
                    for (b = 0; b < timestampAndNonceParts.size(); ++b) {
                        aConfig._parts.add((ReferencePartConfig.PartConfig)timestampAndNonceParts.get(b));
                    }
                    timestampAndNonceParts.clear();
                }
            }
        }
        nameToken2 = new HashMap<String, TokenConsumerConfig>(this.nameToken);
        unboundNameToken.putAll(nameToken2);
        if (tokenConsumers != null) {
            reference = null;
            iMax = tokenConsumers.size();
            for (i = 0; i < iMax; ++i) {
                tokenConsumer = tokenConsumers.get(i);
                qn = tokenConsumer.getValueType();
                if (qn == null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s19", tokenConsumer.getName());
                }
                if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(qn.getLocalPart())) {
                    if (this.isTargetBindingUsing10NS && !PolicyInboundConfig._avoid70BindingsNSCheck) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", qn.getLocalPart());
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Token Value Type from Config is different from the policy");
                    }
                    if (this._symmetricProtectionTokenAssertion != null) {
                        this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                    } else {
                        if (this._symmetricSignatureTokenAssertion != null) {
                            this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                        }
                        if (this._symmetricEncryptionTokenAssertion != null) {
                            this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                        }
                    }
                }
                pref = tokenConsumer.getSecurityTokenReference();
                tconfig = null;
                reference = null;
                if (pref != null && (reference = pref) != null && reference.length() > 0) {
                    tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)nameToken2.get(reference);
                    if (tconfig == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", reference);
                    }
                    if (!tconfig.getType().equals(qn)) {
                        if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(qn) && com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(tconfig.getType())) {
                            if (this.isTargetBindingUsing10NS && !PolicyInboundConfig._avoid70BindingsNSCheck) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", qn.getLocalPart());
                            }
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "LTPA Token Value Type from Config is different from the policy");
                            }
                            tconfig._type = qn = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                        } else {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s30", tconfig.getType().toString(), qn.toString());
                        }
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + reference);
                    }
                }
                if (tconfig == null) {
                    tconfig = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    tconfig._type = qn;
                }
                tconfig._className = tokenConsumer.getClassname();
                if (!this._defaultTokenConsumers.contains(tconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                if (tokenConsumer.isEnforceTokenVersion()) {
                    tconfig._enforceTokenVersion = true;
                }
                foundTA = false;
                callbackHandler = tokenConsumer.getCallbackHandler();
                if (callbackHandler != null) {
                    chconfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    chconfig._className = callbackHandler.getClassname();
                    if (!this._defaultCallbackHandlers.contains(chconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    if ((keystore = callbackHandler.getKeyStore()) != null) {
                        ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                        ksconfig._type = keystore.getType();
                        ksconfig._path = varMap.expand(keystore.getPath());
                        ksconfig._password = PasswordUtilFactory.getInstance().passwordDecode(keystore.getStorepass());
                        ksconfig._ksRef = keystore.getKeyStoreRef();
                        chconfig._keyStore = ksconfig;
                        if (ksconfig._ksRef != null && ksconfig._ksRef.length() != 0) {
                            tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", ksconfig._ksRef);
                        }
                    }
                    if ((key = callbackHandler.getKey()) != null) {
                        kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                        kiconfig._alias = key.getAlias();
                        kiconfig._keypass = PasswordUtilFactory.getInstance().passwordDecode(key.getKeypass());
                        kiconfig._name = key.getName();
                        chconfig._keyInformation = kiconfig;
                    }
                    if ((certPathSettings = callbackHandler.getCertPathSettings()) != null) {
                        if (certPathSettings.isTrustAnyCertificate()) {
                            chconfig._trustAnyCertificate = true;
                        } else {
                            trustAnchorRef = certPathSettings.getTrustAnchorRef();
                            certStoreRef = certPathSettings.getCertStoreRef();
                            if (trustAnchorRef != null || certStoreRef != null) {
                                if (trustAnchorRef != null) {
                                    value = trustAnchorRef;
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "TrustAnchorRef = " + value);
                                    }
                                    for (j = 0; j < trustAnchors.size(); ++j) {
                                        trustAnchor = trustAnchors.get(j);
                                        if (value == null || !value.equals(trustAnchor.getName())) continue;
                                        keystore = trustAnchor.getKeyStore();
                                        if (keystore != null) {
                                            ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                                            ksconfig._type = keystore.getType();
                                            ksconfig._path = varMap.expand(keystore.getPath());
                                            ksconfig._password = PasswordUtilFactory.getInstance().passwordDecode(keystore.getStorepass());
                                            ksconfig._ksRef = keystore.getKeyStoreRef();
                                            chconfig._trustAnchor = ksconfig;
                                        }
                                        foundTA = true;
                                        break;
                                    }
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "(from application binding) Keystore for TrustAnchor: " + value + " = " + chconfig._trustAnchor + ": Found = " + foundTA);
                                    }
                                    if (!foundTA) {
                                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                                    }
                                }
                                if (chconfig._trustAnchor == null) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s32");
                                }
                                keystoreManager = KeyStoreManager.getInstance();
                                ksconfig = chconfig._trustAnchor;
                                password = ksconfig._password == null ? null : ksconfig._password.toCharArray();
                                kstore = keystoreManager.getKeyStore(ksconfig._path, ksconfig._type, password, ksconfig._ksRef);
                                if (ksconfig._ksRef != null && ksconfig._ksRef.length() != 0) {
                                    tconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", ksconfig._ksRef);
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "Added key store name to token config = " + ksconfig._ksRef);
                                    }
                                }
                                pkixBuilderParams = null;
                                provider = null;
                                try {
                                    selector = new X509CertSelector();
                                    pkixBuilderParams = new PKIXBuilderParameters(kstore, (CertSelector)selector);
                                    pkixBuilderParams.setDate(null);
                                }
                                catch (InvalidAlgorithmParameterException e) {
                                    msgKey = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                    Tr.error(PolicyInboundConfig.tc, msgKey, new Object[]{pkixBuilderParams.toString() == null ? "" : pkixBuilderParams.toString()});
                                    throw SoapSecurityException.format(msgKey, pkixBuilderParams.toString() == null ? "" : pkixBuilderParams.toString(), (Throwable)e);
                                }
                                catch (KeyStoreException e) {
                                    msgKey = "security.wssecurity.WSSecurityDefaultConsumerConfig.s01";
                                    Tr.processException((Throwable)e, PolicyInboundConfig.clsName + ".init", "1750", this);
                                    Tr.error(PolicyInboundConfig.tc, msgKey, e.toString());
                                    throw SoapSecurityException.format(msgKey, e);
                                }
                                if (certStoreRef != null) {
                                    value = certStoreRef;
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "CertStoreRef = " + value);
                                    }
                                    if (collectionCertStores != null && (jMax = collectionCertStores.size()) > 0) {
                                        for (j = 0; j < jMax; ++j) {
                                            collectionStore = collectionCertStores.get(j);
                                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyInboundConfig.tc, "collectionCertStores.get(" + j + ") = " + collectionStore.getName());
                                            }
                                            if (value == null || !value.equals(collectionStore.getName())) continue;
                                            provider = Security.getProvider(collectionStore.getProvider());
                                            cache = new HashMap<String, CertificateFactory>();
                                            eeCerts = new HashSet<X509Extension>();
                                            x509Paths = collectionStore.getX509Paths();
                                            kMax = x509Paths.size();
                                            if (kMax > 0) {
                                                for (k = 0; k < kMax; ++k) {
                                                    x509Path = x509Paths.get(k);
                                                    path = null;
                                                    path = varMap.expand(x509Path);
                                                    provider2 = "";
                                                    cfac = (CertificateFactory)cache.get(provider2);
                                                    if (cfac == null) {
                                                        cfac = ConfigUtil.createCertificateFactory(provider2);
                                                        cache.put(provider2, cfac);
                                                    }
                                                    f = new File(path);
                                                    cert = null;
                                                    certFactory = cfac;
                                                    try {
                                                        cert = (X509Certificate)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                                            @Override
                                                            public Object run() throws SoapSecurityException {
                                                                return ConfigUtil.getX509Certificate(f, certFactory);
                                                            }
                                                        });
                                                    }
                                                    catch (PrivilegedActionException pac) {
                                                        th = pac.getCause();
                                                        if (th instanceof SoapSecurityException) {
                                                            throw (SoapSecurityException)th;
                                                        }
                                                        throw new SoapSecurityException(th.getMessage());
                                                    }
                                                    eeCerts.add(cert);
                                                    if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                                    Tr.debug(PolicyInboundConfig.tc, "Adding the X509 Certificate: " + path);
                                                }
                                            }
                                            if ((kMax = (crlPaths = collectionStore.getCRLPaths()).size()) > 0) {
                                                for (k = 0; k < kMax; ++k) {
                                                    crlPath = crlPaths.get(k);
                                                    path = null;
                                                    path = varMap.expand(crlPath);
                                                    provider2 = "";
                                                    cfac = (CertificateFactory)cache.get(provider2);
                                                    if (cfac == null) {
                                                        cfac = ConfigUtil.createCertificateFactory(provider2);
                                                        cache.put(provider2, cfac);
                                                    }
                                                    f = new File(path);
                                                    eeCerts.add(ConfigUtil.getX509CRL(f, cfac));
                                                    if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                                    Tr.debug(PolicyInboundConfig.tc, "Adding the X509 CRL: " + path);
                                                }
                                            }
                                            algorithm = "Collection";
                                            cparams = null;
                                            try {
                                                cparams = new CollectionCertStoreParameters(eeCerts);
                                                certStore = null;
                                                certStore = provider == null ? CertStore.getInstance(algorithm, cparams) : CertStore.getInstance(algorithm, (CertStoreParameters)cparams, provider);
                                                pkixBuilderParams.addCertStore(certStore);
                                                if (!PolicyInboundConfig.tc.isDebugEnabled()) break;
                                                Tr.debug(PolicyInboundConfig.tc, "Found CertStore for " + value);
                                                break;
                                            }
                                            catch (NoSuchAlgorithmException e) {
                                                Tr.error(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityDefaultConsumerConfig.s02", new Object[]{algorithm, e});
                                                throw SoapSecurityException.format("security.wssecurity.WSSecurityDefaultConsumerConfig.s02", algorithm, e.toString());
                                            }
                                            catch (InvalidAlgorithmParameterException e) {
                                                msgKey = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                                Tr.error(PolicyInboundConfig.tc, msgKey, new Object[]{cparams.toString() == null ? "" : cparams.toString()});
                                                throw SoapSecurityException.format(msgKey, cparams.toString() == null ? "" : cparams.toString(), (Throwable)e);
                                            }
                                            catch (Throwable e) {
                                                msgKey = "security.wssecurity.load.collectioncertstore.failed";
                                                Tr.error(PolicyInboundConfig.tc, msgKey, new String[]{collectionStore.getName(), e.getMessage()});
                                                throw SoapSecurityException.format(msgKey, new String[]{collectionStore.getName(), e.getMessage()}, e);
                                            }
                                        }
                                    }
                                }
                                chconfig._provider = provider;
                                chconfig._pkixBuilderParams = pkixBuilderParams;
                            }
                        }
                    }
                    if (isRequest && (basicAuth = callbackHandler.getBasicAuth()) != null) {
                        value = basicAuth.getUserid();
                        if (value != null && value.length() > 0) {
                            chconfig._userId = value;
                        }
                        if ((value = PasswordUtilFactory.getInstance().passwordDecode(basicAuth.getPassword())) != null && value.length() > 0) {
                            chconfig._userPassword = value.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(chconfig._properties, callbackHandler.getProperties(), varMap);
                    tconfig._callbackHandler = chconfig;
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Adding the callback handler: " + chconfig.getClassName());
                    }
                }
                if ((jaasConfig = tokenConsumer.getJaasConfig()) == null) {
                    throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s20", new String[]{qn.toString()}));
                }
                tconfig._jaasConfig = jaasConfig.getConfigName();
                if (tconfig._jaasConfig.contains("wss.consume.KRB5BST") && this.isTargetBindingUsing10NS && !PolicyInboundConfig._avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1");
                }
                if (!this._defaultJAASConfigs.contains(tconfig._jaasConfig)) {
                    this._userDefinedComponentsUsed = true;
                }
                ConfigConstants.getProperties(tconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                ConfigConstants.getProperties(tconfig._properties, tokenConsumer.getProperties(), varMap);
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "init(): Storing the following, maxAge = " + maxAge + ", clockSkew = " + clockSkew);
                }
                tconfig._properties.put(Constants.WSSECURITY_NONCE_MAX_AGE, new Integer(maxAge));
                tconfig._properties.put(Constants.WSSECURITY_NONCE_CLOCK_SKEW, new Integer(clockSkew));
                type.clear();
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tconfig._className);
                if (appClassLoader != null) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                }
                properties = new HashMap<Object, Object>();
                try {
                    tconfig._instance = (TokenConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.processException((Throwable)sse, PolicyInboundConfig.clsName + ".init", "%C", this);
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.Instantiate", new Object[]{tconfig._className});
                }
                this._tokenConsumers.add(tconfig);
                unboundNameToken.remove(reference);
                value = tokenConsumer.getName();
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (this.nameToken.containsKey(value) && PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: token consumer [" + value + "] is overwritten.");
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "Adding token consumer: " + value);
                }
                this.nameToken.put(value, tconfig);
                tconfig._name = value;
            }
        }
        kicontentList = new ArrayList<KeyInfoContentConsumerConfig>();
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (i = 0; i < iMax; ++i) {
                keyInfo = keyInfos.get(i);
                kiccconfig = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                kiccconfig._className = keyInfo.getClassname();
                if (!this._defaultKeyInfoContentConsumers.contains(kiccconfig._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                if ((tokenReference = keyInfo.getTokenReference()) != null && (value = tokenReference) != null && value.length() > 0) {
                    kiccconfig._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)this.nameToken.get(value);
                    if (kiccconfig._tokenConsumer == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the token reference: " + value);
                    }
                    tconfig = kiccconfig._tokenConsumer;
                    ksRef = (String)tconfig._properties.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                    if (ksRef != null && ConfigUtil.isHWKeyStore(ksRef)) {
                        kiccconfig._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", ksRef);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Hardware KeyStore is selected: " + ksRef);
                        }
                    }
                }
                if (keyInfo.getDerivedKeyInfo() != null) {
                    wssDerivedKeyInfo = keyInfo.getDerivedKeyInfo();
                    derivedKeyInfo = new DerivedKeyInfoConfig();
                    derivedKeyInfo.setClientLabel(wssDerivedKeyInfo.getClientLabel());
                    derivedKeyInfo.setServiceLabel(wssDerivedKeyInfo.getServiceLabel());
                    derivedKeyInfo.setKeyLength(wssDerivedKeyInfo.getKeyLength());
                    derivedKeyInfo.setNonceLength(wssDerivedKeyInfo.getNonceLength());
                    derivedKeyInfo.setRequireDerivedKeys(wssDerivedKeyInfo.isRequireDerivedKeys());
                    derivedKeyInfo.setRequireExplicitDerivedKeys(wssDerivedKeyInfo.isRequireExplicitDerivedKeys());
                    derivedKeyInfo.setRequireImpliedDerivedKeys(wssDerivedKeyInfo.isRequireImpliedDerivedKeys());
                    kiccconfig._derivedKeyInfo = derivedKeyInfo;
                } else {
                    props = kiccconfig.getTokenConsumer().getProperties();
                    keyLength = (String)props.get(Constants.DERIVED_KEY_LENGTH);
                    serviceLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
                    clientLabel = (String)props.get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
                    requireImpliedDerivedKeys = (String)props.get("RequiredImpliedDerivedKeys");
                    oldSC = com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(kiccconfig._tokenConsumer._type);
                    if (oldSC) {
                        derivedKeyInfo = new DerivedKeyInfoConfig();
                        derivedKeyInfo.setRequireDerivedKeys(true);
                        derivedKeyInfo.setRequireExplicitDerivedKeys(true);
                        if (keyLength != null && keyLength.length() > 0) {
                            derivedKeyInfo.setKeyLength(keyLength);
                        }
                        if (serviceLabel != null && serviceLabel.length() > 0) {
                            derivedKeyInfo.setServiceLabel(serviceLabel);
                        }
                        if (clientLabel != null && clientLabel.length() > 0) {
                            derivedKeyInfo.setClientLabel(clientLabel);
                        }
                        if ("true".equals(requireImpliedDerivedKeys)) {
                            derivedKeyInfo.setRequireImpliedDerivedKeys(true);
                        }
                        kiccconfig._derivedKeyInfo = derivedKeyInfo;
                    }
                }
                ConfigConstants.getProperties(kiccconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", kiccconfig._className);
                if (kiccconfig._className == null || kiccconfig._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "KeyInfoContentConsumer classname = " + kiccconfig._className);
                }
                if (this._defaultKeyInfoContentConsumers.contains(kiccconfig._className)) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (appClassLoader != null) {
                    type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", appClassLoader);
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "ClassLoader used = " + type.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader"));
                }
                properties = new HashMap<Object, Object>();
                try {
                    kiccconfig._instance = (KeyInfoContentConsumerComponent)factory.createConsumer(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.processException((Throwable)sse, PolicyInboundConfig.clsName + ".init", "%C", this);
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.Instantiate", new Object[]{kiccconfig._className});
                }
                kicontentList.add(kiccconfig);
                value = keyInfo.getName();
                if (value == null || value.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (this.nameKeyInfo.containsKey(value) && PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: key info [" + value + "] is overwritten.");
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "Adding key info: " + value);
                }
                kiccconfig._keyName = value;
                this.nameKeyInfo.put(value, kiccconfig);
            }
        }
        unboundNameConfidentiality.putAll(nameConfidentiality);
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            reference = null;
            for (i = 0; i < iMax; ++i) {
                encryptionInfo = encryptionInfos.get(i);
                econfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                dataEncryptionMethod = null;
                keyEncryptionMethod = null;
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                foundDataEncryptionKeyRef = false;
                pref = encryptionInfo.getEncryptionPartReference();
                if (pref != null) {
                    reference = pref.getReference();
                    if (reference != null && reference.length() > 0) {
                        econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameConfidentiality.get(reference);
                        kicconfig._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                        if (econfig._reference == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", reference);
                        }
                        econfig._reference.getBindings().add(econfig);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + reference);
                        }
                        if (this.encryptionAlgorithms.containsKey(reference)) {
                            dataEncryptionMethod = this.encryptionAlgorithms.get(reference);
                            keyEncryptionMethod = this.keyEncryptionAlgorithms.get(reference);
                        } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference part [" + reference + "] on EncryptionInfo does not match a label on EncryptedParts from Policy. Cannot retrieve encryption algorithms from Policy.");
                        }
                    } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference part on EncryptionInfo is null or empty. Cannot retrieve encryption algorithms from Policy.");
                    }
                    dataEncKeyInfo = pref.getDataEncryptionKeyInfo();
                    if (dataEncKeyInfo != null && (value = dataEncKeyInfo) != null && value.length() > 0) {
                        foundDataEncryptionKeyRef = true;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)this.nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForDecryption = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Got the key info reference: " + value);
                        }
                    }
                } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference not found on EncryptionInfo. PartReference is required in order to retrieve the encryption algorithms from Policy.");
                }
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = dataEncryptionMethod;
                econfig._dataEncryptionMethod = aconfig;
                encryptionKeys = encryptionInfo.getKeyEncryptionKeyInfos();
                if (encryptionKeys == null || encryptionKeys.size() == 0) {
                    if (!foundDataEncryptionKeyRef) {
                        kicconfig._contentConsumers = kicontentList;
                        jMax = kicontentList.size();
                        for (j = 0; j < jMax; ++j) {
                            kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)kicontentList.get(j);
                            tconfig = kiccconfig._tokenConsumer;
                            if (tconfig == null) continue;
                            tconfig._usedForDecryption = true;
                        }
                    }
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = keyEncryptionMethod;
                    econfig._keyEncryptionMethod = aconfig;
                    kicconfig._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                    jMax = encryptionKeys.size();
                    for (j = 0; j < jMax; ++j) {
                        encryptionKey = encryptionKeys.get(j);
                        value = encryptionKey;
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)this.nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForDecryption = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "Got the key info reference: " + value);
                    }
                }
                econfig._encryptionKeyInfo = kicconfig;
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                this._encryptionConsumers.add(econfig);
                unboundNameConfidentiality.remove(reference);
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Adding encryption consumer.");
            }
        }
        unboundNameIntegrity.putAll(nameIntegrity);
        if (signingInfos != null) {
            iMax = signingInfos.size();
            reference = null;
            for (i = 0; i < iMax; ++i) {
                signingInfo = signingInfos.get(i);
                sconfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                digestMethod = null;
                canonicalizationMethod = null;
                signatureMethod = null;
                prefs = signingInfo.getSigningPartReferences();
                if (prefs != null) {
                    jMax = prefs.size();
                    for (j = 0; j < jMax; ++j) {
                        pref = prefs.get(j);
                        srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        reference = pref.getReference();
                        if (reference != null && reference.length() > 0) {
                            srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(reference);
                            if (srconfig._reference == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", reference);
                            }
                            srconfig._reference.getBindings().add(sconfig);
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + reference);
                            }
                        }
                        if (this.digestAlgorithms.containsKey(reference)) {
                            digestMethod = this.digestAlgorithms.get(reference);
                            canonicalizationMethod = this.canonicalizationAlgorithms.get(reference);
                            signatureMethod = this._symmetricBinding ? this.symmetricSignatureAlgorithms.get(reference) : this.asymmetricSignatureAlgorithms.get(reference);
                        } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference part [" + reference + "] on SigningInfo does not match a label on SignedParts from Policy. Cannot retrieve signature algorithms from Policy.");
                        }
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = digestMethod;
                        srconfig._digestMethod = aconfig;
                        transforms = pref.getTransforms();
                        if (transforms != null) {
                            kMax = transforms.size();
                            for (k = 0; k < kMax; ++k) {
                                transform = transforms.get(k);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = transform.getAlgorithm();
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                        unboundNameIntegrity.remove(reference);
                    }
                } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference not found on SigningInfo. PartReference is required in order to retrieve the signature algorithms from Policy.");
                }
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = canonicalizationMethod;
                sconfig._canonicalizationMethod = aconfig;
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = signatureMethod;
                sconfig._signatureMethod = aconfig;
                kicconfig = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                signingKeys = signingInfo.getSigningKeyInfos();
                if (signingKeys == null || signingKeys.size() == 0) {
                    kicconfig._contentConsumers = kicontentList;
                    jMax = kicontentList.size();
                    for (j = 0; j < jMax; ++j) {
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)kicontentList.get(j);
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig == null) continue;
                        tconfig._usedForVerification = true;
                    }
                } else {
                    kicconfig._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                    jMax = signingKeys.size();
                    for (j = 0; j < jMax; ++j) {
                        signingKey = signingKeys.get(j);
                        value = signingKey;
                        if (value == null || value.length() <= 0) continue;
                        kiccconfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)this.nameKeyInfo.get(value);
                        if (kiccconfig == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", value);
                        }
                        tconfig = kiccconfig._tokenConsumer;
                        if (tconfig != null) {
                            tconfig._usedForVerification = true;
                        }
                        kicconfig._contentConsumers.add(kiccconfig);
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "Got the key info reference: " + value);
                    }
                }
                sconfig._signingKeyInfo = kicconfig;
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                this._signatureConsumers.add(sconfig);
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Adding signature consumer.");
            }
        }
        if (!unboundNameConfidentiality.isEmpty() && defaultConfiguration != null) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Missing encryption information in custom bindings is being filled in with encryption information from default bindings.");
            }
            protectionTokenConsumers = new HashMap<Integer, TokenConsumerConfig>();
            tokenSet = unboundNameConfidentiality.keySet();
            references = tokenSet.iterator();
            consumerIterator = null;
            defaultEncryptionConsumer = null;
            dcconfig = defaultConfiguration.getDefaultConsumerBinding();
            if (dcconfig == null) {
                if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                    se = defaultConfiguration.getDefaultBindingsLoadingException();
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s30", se.toString());
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s30", se.toString());
            }
            while (references.hasNext()) {
                reference = (String)references.next();
                aPart = (PrivateCommonConfig.ReferencePartConfImpl)unboundNameConfidentiality.get(reference);
                set = dcconfig.getEncryptionConsumers();
                for (PrivateConsumerConfig.EncryptionConsumerConfImpl defaultEncryptionConsumer : set) {
                    if (!this.encryptionConsumerTokenMatch(defaultEncryptionConsumer, isRequest)) continue;
                    econfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                    econfig._reference = aPart;
                    econfig._reference.getBindings().add(econfig);
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = this.encryptionAlgorithm;
                    econfig._dataEncryptionMethod = aconfig;
                    if (defaultEncryptionConsumer._isKeyDecryption) {
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this.keyEncryptionAlgorithm;
                        econfig._keyEncryptionMethod = aconfig;
                    }
                    econfig._encryptionKeyInfo = defaultEncryptionConsumer._encryptionKeyInfo;
                    econfig._properties.putAll(defaultEncryptionConsumer.getProperties());
                    this._encryptionConsumers.add(econfig);
                    contentConsumerList = econfig._encryptionKeyInfo.getContentConsumers();
                    if (contentConsumerList == null) continue;
                    for (KeyInfoContentConsumerConfig obj : contentConsumerList) {
                        if (!(obj instanceof PrivateConsumerConfig.KeyInfoContentConsumerConfImpl) || (tconfig2 = (PrivateConsumerConfig.TokenConsumerConfImpl)(keyInfoConsumer = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)obj).getTokenConsumer()) == null) continue;
                        if (com.ibm.ws.wssecurity.common.Constants.SCT_13.equals(tconfig2._type)) {
                            if (this._symmetricProtectionTokenAssertion != null) {
                                this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                            } else {
                                if (this._symmetricSignatureTokenAssertion != null) {
                                    this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                }
                                if (this._symmetricEncryptionTokenAssertion != null) {
                                    this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                }
                            }
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Replaced sct token Type with [" + com.ibm.ws.wssecurity.common.Constants.SCT_13 + "].");
                            }
                        }
                        if (protectionTokenConsumers.get(hash = Integer.valueOf(tconfig2.hashCode())) == null) {
                            this._tokenConsumers.add(tconfig2);
                            protectionTokenConsumers.put(hash, tconfig2);
                        }
                        references.remove();
                    }
                }
                if (!unboundNameConfidentiality.containsKey(reference)) continue;
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s26", reference);
            }
        }
        if (!unboundNameIntegrity.isEmpty() && defaultConfiguration != null) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Missing signature information in custom bindings is being filled in with signature information from default bindings.");
            }
            protectionTokenConsumers = new HashMap<Integer, PrivateConsumerConfig.TokenConsumerConfImpl>();
            tokenSet = unboundNameIntegrity.keySet();
            references = tokenSet.iterator();
            consumerIterator = null;
            signatureReferenceIterator = null;
            defaultSignatureConsumer = null;
            defaultSignatureReference = null;
            dcconfig = defaultConfiguration.getDefaultConsumerBinding();
            if (dcconfig == null) {
                if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                    se = defaultConfiguration.getDefaultBindingsLoadingException();
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s31", se.toString());
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s31", se.toString());
            }
            v2 = this._onlySignEntireHeadersAndBody = this._onlySignEntireHeadersAndBody != false || dcconfig.isOnlySignEntireHeadersAndBody() != false;
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "processed default config onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
            }
            while (references.hasNext()) {
                reference = (String)references.next();
                aPart = (PrivateCommonConfig.ReferencePartConfImpl)unboundNameIntegrity.get(reference);
                set = dcconfig.getSignatureConsumers();
                for (PrivateConsumerConfig.SignatureConsumerConfImpl defaultSignatureConsumer : set) {
                    if (!this.signatureConsumerTokenMatch(defaultSignatureConsumer, isRequest)) continue;
                    sconfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                    for (PrivateCommonConfig.SigningReferenceConfImpl defaultSignatureReference : defaultSignatureConsumer._references) {
                        if (aPart != null) {
                            srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                            srconfig._reference = aPart;
                            srconfig._reference.getBindings().add(sconfig);
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = this.digestAlgorithm;
                            srconfig._digestMethod = aconfig;
                            srconfig._transforms.addAll(defaultSignatureReference._transforms);
                            sconfig._references.add(srconfig);
                        }
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this.canonicalizationAlgorithm;
                        sconfig._canonicalizationMethod = aconfig;
                        aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                        aconfig._algorithm = this._symmetricBinding != false ? this.symmetricSignatureAlgorithm : this.asymmetricSignatureAlgorithm;
                        sconfig._signatureMethod = aconfig;
                        sconfig._signingKeyInfo = defaultSignatureConsumer._signingKeyInfo;
                        sconfig._properties.putAll(defaultSignatureConsumer._properties);
                        this._signatureConsumers.add(sconfig);
                        contentConsumerList = sconfig._signingKeyInfo.getContentConsumers();
                        if (contentConsumerList == null) continue;
                        for (KeyInfoContentConsumerConfig obj : contentConsumerList) {
                            if (!(obj instanceof PrivateConsumerConfig.KeyInfoContentConsumerConfImpl) || (tconfig2 = (PrivateConsumerConfig.TokenConsumerConfImpl)(keyInfoConsumer = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)obj).getTokenConsumer()) == null) continue;
                            if (com.ibm.ws.wssecurity.common.Constants.SCT_13.equals(tconfig2._type)) {
                                if (this._symmetricProtectionTokenAssertion != null) {
                                    this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                } else {
                                    if (this._symmetricSignatureTokenAssertion != null) {
                                        this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                    }
                                    if (this._symmetricEncryptionTokenAssertion != null) {
                                        this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                                    }
                                }
                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "Replaced sct token Type with [" + com.ibm.ws.wssecurity.common.Constants.SCT_13 + "].");
                                }
                            }
                            if (protectionTokenConsumers.get(hash = Integer.valueOf(tconfig2.hashCode())) == null) {
                                this._tokenConsumers.add(tconfig2);
                                protectionTokenConsumers.put(hash, tconfig2);
                            }
                            references.remove();
                        }
                    }
                }
                if (!unboundNameIntegrity.containsKey(reference)) continue;
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s27", reference);
            }
        }
        useDefaultTokenConsumer = false;
        if (!unboundNameToken.isEmpty() && defaultConfiguration != null) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Missing supporting tokens in custom bindings is being filled in with supporting tokens information from default bindings.");
            }
            if ((dcconfig = defaultConfiguration.getDefaultConsumerBinding()) == null) {
                if (defaultConfiguration.getDefaultBindingsLoadingException() != null) {
                    se = defaultConfiguration.getDefaultBindingsLoadingException();
                    throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s32", se.toString());
                }
                se = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03", value);
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s32", se.toString());
            }
            set = null;
            standAloneTokenConsumerTypes = new HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl>();
            foundLTPAv2TokenConsumer = false;
            set = dcconfig.getTokenConsumers();
            for (PrivateConsumerConfig.TokenConsumerConfImpl tconfig2 : set) {
                aType = tconfig2.getType().toString();
                if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(tconfig2._type)) {
                    foundLTPAv2TokenConsumer = true;
                } else if ((com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(tconfig2._type) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(tconfig2._type)) && tconfig2._callbackHandler != null) {
                    idAssertion = (String)tconfig2._callbackHandler._properties.get(Constants.WSSECURITY_USE_IDASSERTION);
                    if (idAssertion != null) {
                        if (idAssertion.equals("true")) {
                            if (standAloneTokenConsumerTypes.get(aType = aType + Constants.WSSECURITY_USE_IDASSERTION) != null) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s30");
                            }
                        } else if (standAloneTokenConsumerTypes.get(aType) != null) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s29");
                        }
                    } else if (standAloneTokenConsumerTypes.get(aType) != null) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s29");
                    }
                }
                if (tconfig2._usedForDecryption || tconfig2._usedForVerification) continue;
                if (standAloneTokenConsumerTypes.get(aType) == null) {
                    standAloneTokenConsumerTypes.put(aType, tconfig2);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s31", aType.toString());
            }
            tokenSet = unboundNameToken.keySet();
            j = tokenSet.iterator();
            numberOfSupportingTokenPerType = new HashMap<QName, Integer>();
            supportingTokenTypes = new HashSet<String>();
            while (j.hasNext()) {
                reference = (String)j.next();
                tokConfig = this.nameToken.get(reference);
                aType = tokConfig.getType();
                aTypeToString = aType.toString();
                if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(aType) && foundLTPAv2TokenConsumer) {
                    tconfig2 = (PrivateConsumerConfig.TokenConsumerConfImpl)tokConfig;
                    tconfig2._type = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                    aType = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                    aTypeToString = aType.toString();
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Replaced ltpa token Type with [" + com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN + "].");
                    }
                } else if (com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(aType) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(aType)) {
                    if (standAloneTokenConsumerTypes.containsKey(aTypeToString) && standAloneTokenConsumerTypes.containsKey(aTypeToString + Constants.WSSECURITY_USE_IDASSERTION)) {
                        if (supportingTokenTypes.contains(aTypeToString) && !supportingTokenTypes.contains(aTypeToString + Constants.WSSECURITY_USE_IDASSERTION)) {
                            aTypeToString = aTypeToString + Constants.WSSECURITY_USE_IDASSERTION;
                        } else if (supportingTokenTypes.contains(aTypeToString) && supportingTokenTypes.contains(aTypeToString + Constants.WSSECURITY_USE_IDASSERTION)) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s24", aType.toString());
                        }
                    } else if (standAloneTokenConsumerTypes.containsKey(aType + Constants.WSSECURITY_USE_IDASSERTION)) {
                        aTypeToString = aTypeToString + Constants.WSSECURITY_USE_IDASSERTION;
                    }
                }
                if (!supportingTokenTypes.contains(aTypeToString)) {
                    supportingTokenTypes.add(aTypeToString);
                    numberOfSupportingTokenPerType = this.updateTokenTypeList(numberOfSupportingTokenPerType, (QName)aType);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s25", aType.toString());
            }
            numUNTokens = null;
            numUNTokens = (Integer)numberOfSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN);
            if (numUNTokens != null && numUNTokens == 1 && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString()) && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s35", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
            }
            numUNTokens = (Integer)numberOfSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11);
            if (numUNTokens != null && numUNTokens == 1 && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString()) && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s35", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
            }
            for (Object aType : supportingTokenTypes) {
                tconfig2 = (TokenConsumerConfig)standAloneTokenConsumerTypes.get(aType);
                if (tconfig2 != null) {
                    useDefaultTokenConsumer = true;
                    this._tokenConsumers.add(tconfig2);
                    continue;
                }
                if (aType.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString())) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s36", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
                }
                if (aType.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString())) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s36", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
                }
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s36", (String)aType);
            }
        }
        if (callers != null) {
            iMax = callers.size();
            for (i = 0; i < iMax; ++i) {
                trustedIdIsSupporting = true;
                callerIdIsSupporting = true;
                this._loginRequired = true;
                caller = callers.get(i);
                if (caller == null) continue;
                cconfig = new PrivateConsumerConfig.CallerConfImpl();
                if (caller.getOrder() != null && !this.isTargetBindingUsing10NS) {
                    cconfig._order = Integer.parseInt(caller.getOrder());
                }
                if ((callerIdentity = caller.getCallerIdentity()) != null) {
                    cconfig._callerIdentity = callerIdentity;
                }
                if (caller.isAnyTrustedIdentity()) {
                    cconfig._anyTrustedIdentity = true;
                } else {
                    trustedIdentity = caller.getTrustedIdentity();
                    if (trustedIdentity != null) {
                        cconfig._identityAssertion = true;
                        cconfig._trustedIdentity = trustedIdentity;
                    }
                }
                requiredSigningPartReference = caller.getRequiredSigningPartReference();
                if (requiredSigningPartReference != null && requiredSigningPartReference.length() > 0) {
                    cconfig._requiredSigningPartReference = (PrivateCommonConfig.ReferencePartConfImpl)nameIntegrity.get(requiredSigningPartReference);
                    if (cconfig._requiredSigningPartReference == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", requiredSigningPartReference);
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the signing part reference: " + requiredSigningPartReference);
                    }
                }
                if ((jaasConfig = caller.getJaasConfig()) == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC6834E", cconfig.toString());
                }
                cconfig._jaasConfig = jaasConfig.getConfigName();
                ConfigConstants.getProperties(cconfig._jaasConfigProperties, jaasConfig.getProperties(), varMap);
                callbackHandler = caller.getCallbackHandler();
                if (callbackHandler != null) {
                    chconfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    chconfig._className = callbackHandler.getClassname();
                    if (!this._defaultCallbackHandlers.contains(chconfig._className)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    ConfigConstants.getProperties(chconfig._properties, callbackHandler.getProperties(), varMap);
                    cconfig._callbackHandler = chconfig;
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Adding the callback handler: " + chconfig.getClassName());
                    }
                }
                numberOfCallerSupportingTokenPerType = new HashMap<QName, Integer>();
                numberOfCallerProtectionTokenPerType = new HashMap<QName, Integer>();
                tokenSet = supportingTokens.keySet();
                it = tokenSet.iterator();
                callerTokenTypes = new ArrayList<QName>();
                while (it.hasNext()) {
                    reference = (String)it.next();
                    tokConfig = (TokenConsumerConfig)supportingTokens.get(reference);
                    aType = tokConfig.getType();
                    callerTokenTypes.add(aType);
                    numberOfCallerSupportingTokenPerType = this.updateTokenTypeList(numberOfCallerSupportingTokenPerType, aType);
                }
                if (this._symmetricBinding) {
                    if (this._symmetricProtectionTokenAssertion != null) {
                        callerTokenTypes.add(this._symmetricProtectionTokenAssertion._tokenType);
                        numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, this._symmetricProtectionTokenAssertion._tokenType);
                    } else if (this._symmetricSignatureTokenAssertion != null) {
                        callerTokenTypes.add(this._symmetricSignatureTokenAssertion._tokenType);
                        numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, this._symmetricSignatureTokenAssertion._tokenType);
                    }
                } else if (isRequest) {
                    if (!this._initiatorTokens.isEmpty()) {
                        for (QName aType : this._initiatorTokenQNames) {
                            callerTokenTypes.add(aType);
                            numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aType);
                        }
                    } else if (!this._initiatorSignatureTokens.isEmpty()) {
                        for (QName aType : this._initiatorSignatureTokenQNames) {
                            callerTokenTypes.add(aType);
                            numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aType);
                        }
                    }
                } else if (!this._recipientTokens.isEmpty()) {
                    for (QName aQName : this._recipientTokenQNames) {
                        callerTokenTypes.add(aQName);
                        numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aQName);
                    }
                } else if (!this._recipientSignatureTokens.isEmpty()) {
                    for (QName aType : this._recipientSignatureTokenQNames) {
                        callerTokenTypes.add(aType);
                        numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aType);
                    }
                }
                matchFound = false;
                isIdAssertion = null;
                if (cconfig._trustedIdentity != null) {
                    if ((cconfig._trustedIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || cconfig._trustedIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) && (cconfig._callerIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || cconfig._callbackHandler.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11))) {
                        if (cconfig._trustedIdentity.equals(cconfig._callerIdentity)) {
                            numUNTokens = numberOfCallerSupportingTokenPerType.get(cconfig._trustedIdentity);
                            if (numUNTokens == null) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s27", "0");
                            }
                            if (numUNTokens != 2) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s27", numUNTokens.toString());
                            }
                        } else {
                            numOfTrustedUNTokens = numberOfCallerSupportingTokenPerType.get(cconfig._trustedIdentity);
                            numOfAssertionUNTokens = numberOfCallerSupportingTokenPerType.get(cconfig._callerIdentity);
                            if (numOfTrustedUNTokens == null) {
                                numOfTrustedUNTokens = new Integer(0);
                            }
                            if (numOfAssertionUNTokens == null) {
                                numOfAssertionUNTokens = new Integer(0);
                            }
                            if (numOfTrustedUNTokens != 1 || numOfAssertionUNTokens != 1) {
                                totalUNTokens = numOfTrustedUNTokens + numOfAssertionUNTokens;
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s27", totalUNTokens.toString());
                            }
                        }
                    } else {
                        numOfTrustedTokens = numberOfCallerSupportingTokenPerType.get(cconfig._trustedIdentity);
                        numOfAssertionTokens = numberOfCallerSupportingTokenPerType.get(cconfig._callerIdentity);
                        if (numOfTrustedTokens == null) {
                            numOfTrustedTokens = numberOfCallerProtectionTokenPerType.get(cconfig._trustedIdentity);
                            if (numOfTrustedTokens == null) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s22", cconfig.toString());
                            }
                            trustedIdIsSupporting = false;
                            if (numOfTrustedTokens != 1) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s43", numOfTrustedTokens.toString(), cconfig._trustedIdentity.toString());
                            }
                        } else if (numOfTrustedTokens != 1) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s28", numOfTrustedTokens.toString(), cconfig._trustedIdentity.toString());
                        }
                        if (numOfAssertionTokens == null) {
                            numOfAssertionTokens = numberOfCallerProtectionTokenPerType.get(cconfig._callerIdentity);
                            if (numOfAssertionTokens == null) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s22", cconfig.toString());
                            }
                            callerIdIsSupporting = false;
                            if (numOfAssertionTokens != 1) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s43", numOfAssertionTokens.toString(), cconfig._callerIdentity.toString());
                            }
                        } else if (numOfAssertionTokens != 1) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s28", numOfAssertionTokens.toString(), cconfig._callerIdentity.toString());
                        }
                    }
                    listIterator = callerTokenTypes.iterator();
                    foundCallerIdentity = false;
                    foundTrustedIdentity = false;
                    while (listIterator.hasNext() && !matchFound) {
                        aType = (QName)listIterator.next();
                        if (aType.equals(cconfig._callerIdentity) && !foundCallerIdentity) {
                            j = this._tokenConsumers.iterator();
                            while (j.hasNext() && !foundCallerIdentity) {
                                tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)j.next();
                                if (!tconfig._type.equals(aType) || (!callerIdIsSupporting || tconfig.isUsedForDecryption() || tconfig.isUsedForVerification()) && (callerIdIsSupporting || !tconfig.isUsedForVerification()) || (isIdAssertion = (String)tconfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION)) == null || !isIdAssertion.equals("true")) continue;
                                foundCallerIdentity = true;
                            }
                        } else if (aType.equals(cconfig._trustedIdentity) && !foundTrustedIdentity) {
                            j = this._tokenConsumers.iterator();
                            while (j.hasNext() && !foundTrustedIdentity) {
                                tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)j.next();
                                if (!tconfig._type.equals(aType) || (!trustedIdIsSupporting || tconfig.isUsedForDecryption() || tconfig.isUsedForVerification()) && (trustedIdIsSupporting || !tconfig.isUsedForVerification())) continue;
                                isIdAssertion = (String)tconfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
                                if (isIdAssertion == null) {
                                    foundTrustedIdentity = true;
                                    continue;
                                }
                                if (isIdAssertion.equals("true")) continue;
                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "Found TrustedIdentity match of type " + aType.toString());
                                }
                                foundTrustedIdentity = true;
                            }
                        } else if (cconfig._anyTrustedIdentity && !foundTrustedIdentity) {
                            foundTrustedIdentity = true;
                        }
                        if (!foundCallerIdentity || !foundTrustedIdentity) continue;
                        matchFound = true;
                    }
                } else {
                    numOfCallerIdTokens = numberOfCallerSupportingTokenPerType.get(cconfig._callerIdentity);
                    if (numOfCallerIdTokens == null) {
                        numOfCallerIdTokens = numberOfCallerProtectionTokenPerType.get(cconfig._callerIdentity);
                        if (numOfCallerIdTokens == null) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s22", cconfig.toString());
                        }
                        callerIdIsSupporting = false;
                        if (numOfCallerIdTokens != 1) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s43", numOfCallerIdTokens.toString(), cconfig._callerIdentity.toString());
                        }
                    } else if (numOfCallerIdTokens != 1) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s28", numOfCallerIdTokens.toString(), cconfig._callerIdentity.toString());
                    }
                    listIterator = callerTokenTypes.iterator();
                    block80: while (listIterator.hasNext() && !matchFound) {
                        aType = (QName)listIterator.next();
                        if (!aType.equals(cconfig._callerIdentity)) continue;
                        j = this._tokenConsumers.iterator();
                        while (j.hasNext() && !matchFound) {
                            tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)j.next();
                            if (!tconfig._type.equals(aType) || (!callerIdIsSupporting || tconfig.isUsedForDecryption() || tconfig.isUsedForVerification()) && (callerIdIsSupporting || !tconfig.isUsedForVerification())) continue;
                            isIdAssertion = (String)tconfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
                            if (isIdAssertion == null) {
                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "Found TrustedIdentity match of type " + aType.toString());
                                }
                                matchFound = true;
                                continue;
                            }
                            if (!isIdAssertion.equals("true")) {
                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                    Tr.debug(PolicyInboundConfig.tc, "Found TrustedIdentity match of type " + aType.toString());
                                }
                                matchFound = true;
                                continue;
                            }
                            if (!cconfig._anyTrustedIdentity || !isIdAssertion.equals("true")) continue;
                            matchFound = true;
                            cconfig._identityAssertion = true;
                            if (!PolicyInboundConfig.tc.isDebugEnabled()) continue block80;
                            Tr.debug(PolicyInboundConfig.tc, "Found CallerIdentity match of type " + aType.toString());
                            continue block80;
                        }
                    }
                }
                if (matchFound) {
                    this._callers.add(cconfig);
                    continue;
                }
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s22", cconfig.toString());
            }
            if (!this.isTargetBindingUsing10NS) {
                this.setOrderedCallerList();
                this._isOrderEnforced = true;
            }
        }
        this.mapPolicyAssertionsToProperties(isTargetNamespaceDraft12, isRequest);
        this.validate(false, useDefaultTokenConsumer, null);
        if (PolicyInboundConfig.tc.isEntryEnabled()) {
            Tr.exit(PolicyInboundConfig.tc, "init(SecurityInboundBindingConfig binding, Policy policyRoot, String actorURI, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration)");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initDefaultConfig(WSSConsumerConfig dcconfig, boolean isRequest, boolean signSignatureConfirmationSpecified, boolean encryptSignatureConfirmationSpecified) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSConsumerConfig, Map):", new Object[]{dcconfig, this.nameToken});
        }
        HashSet<Object> callerTokenTypes = new HashSet<Object>();
        HashSet<String> supportingTokenTypes = new HashSet<String>();
        HashMap<Integer, TokenConsumerConfig> protectionTokenConsumers = new HashMap<Integer, TokenConsumerConfig>();
        HashMap<QName, Integer> numberOfCallerSupportingTokenPerType = new HashMap<QName, Integer>();
        HashMap<QName, Integer> numberOfCallerProtectionTokenPerType = new HashMap<QName, Integer>();
        HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl> standAloneTokenConsumerTypes = new HashMap<String, PrivateConsumerConfig.TokenConsumerConfImpl>();
        PrivateConsumerConfig.EncryptionConsumerConfImpl defaultEncryptionConsumer = null;
        PrivateConsumerConfig.SignatureConsumerConfImpl defaultSignatureConsumer = null;
        Object var15_13 = null;
        PrivateConsumerConfig.EncryptionConsumerConfImpl econfig = null;
        PrivateConsumerConfig.SignatureConsumerConfImpl sconfig = null;
        PrivateCommonConfig.SigningReferenceConfImpl srconfig = null;
        PrivateCommonConfig.AlgorithmConfImpl aconfig = null;
        boolean isDefaultBindingUsing10NS = false;
        this._skipOperationLevelPolicyCheck = !ConfigUtil.getIsFalseProperty(this._properties, Constants.WSSECURITY_CHECK_OPERATION_LEVEL_POLICIES);
        boolean checkHMACOutputLength = ConfigUtil.getIsFalseProperty(dcconfig.getProperties(), Constants.WSSECURITY_CHECK_HMAC_OUTPUT_LENGTH);
        this._algorithmFactory.setCheckHMACOutputLength(checkHMACOutputLength);
        this._bypassHeader = ConfigUtil.getIsTrueProperty(this._properties, Constants.BYPASS_HEADER);
        if ("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding".equals(dcconfig.getDefaultBindingNamespace())) {
            isDefaultBindingUsing10NS = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target default bindings name space = " + dcconfig.getDefaultBindingNamespace());
        }
        boolean foundLTPAv2TokenConsumer = false;
        Set<Configuration> set = dcconfig.getTokenConsumers();
        for (PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl : set) {
            String aType = tokenConsumerConfImpl.getType().toString();
            if (tokenConsumerConfImpl._jaasConfig.contains("wss.consume.KRB5BST") && isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1");
            }
            if (com.ibm.ws.wssecurity.common.Constants.SCT_13.equals(tokenConsumerConfImpl._type)) {
                if (isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", tokenConsumerConfImpl.getType().getLocalPart());
                }
                if (this._symmetricProtectionTokenAssertion != null && com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(this._symmetricProtectionTokenAssertion._tokenType)) {
                    this._symmetricProtectionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                } else {
                    if (this._symmetricSignatureTokenAssertion != null && com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(this._symmetricSignatureTokenAssertion._tokenType)) {
                        this._symmetricSignatureTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                    }
                    if (this._symmetricEncryptionTokenAssertion != null && com.ibm.ws.wssecurity.common.Constants.SC_200502.equals(this._symmetricEncryptionTokenAssertion._tokenType)) {
                        this._symmetricEncryptionTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replaced sct token Type with [" + com.ibm.ws.wssecurity.common.Constants.SCT_13 + "].");
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(tokenConsumerConfImpl._type)) {
                foundLTPAv2TokenConsumer = true;
            } else if ((com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(tokenConsumerConfImpl._type) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(tokenConsumerConfImpl._type)) && tokenConsumerConfImpl._callbackHandler != null) {
                String idAssertion = (String)tokenConsumerConfImpl._callbackHandler._properties.get(Constants.WSSECURITY_USE_IDASSERTION);
                if (idAssertion != null) {
                    if (idAssertion.equals("true")) {
                        if (standAloneTokenConsumerTypes.get(aType = aType + Constants.WSSECURITY_USE_IDASSERTION) != null) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s30");
                        }
                    } else if (standAloneTokenConsumerTypes.get(aType) != null) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s29");
                    }
                } else if (standAloneTokenConsumerTypes.get(aType) != null) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s29");
                }
            }
            if (tokenConsumerConfImpl._usedForDecryption || tokenConsumerConfImpl._usedForVerification) continue;
            if (standAloneTokenConsumerTypes.get(aType) == null) {
                standAloneTokenConsumerTypes.put(aType, tokenConsumerConfImpl);
                continue;
            }
            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s31", aType.toString());
        }
        Set<String> set2 = this.nameToken.keySet();
        for (String reference : set2) {
            void var26_29;
            TokenConsumerConfig tokConfig = this.nameToken.get(reference);
            QName qName = tokConfig.getType();
            String aTypeToString = qName.toString();
            if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(qName) && foundLTPAv2TokenConsumer) {
                if (isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.getLocalPart());
                }
                PrivateConsumerConfig.TokenConsumerConfImpl tconfig2 = (PrivateConsumerConfig.TokenConsumerConfImpl)tokConfig;
                tconfig2._type = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                QName qName2 = com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN;
                aTypeToString = qName2.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replaced ltpa token Type with [" + com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN + "].");
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName)) {
                if (standAloneTokenConsumerTypes.containsKey(aTypeToString) && standAloneTokenConsumerTypes.containsKey(aTypeToString + Constants.WSSECURITY_USE_IDASSERTION)) {
                    if (supportingTokenTypes.contains(aTypeToString) && !supportingTokenTypes.contains(aTypeToString + Constants.WSSECURITY_USE_IDASSERTION)) {
                        aTypeToString = aTypeToString + Constants.WSSECURITY_USE_IDASSERTION;
                    } else if (supportingTokenTypes.contains(aTypeToString) && supportingTokenTypes.contains(aTypeToString + Constants.WSSECURITY_USE_IDASSERTION)) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s24", qName.toString());
                    }
                } else if (standAloneTokenConsumerTypes.containsKey(qName + Constants.WSSECURITY_USE_IDASSERTION)) {
                    aTypeToString = aTypeToString + Constants.WSSECURITY_USE_IDASSERTION;
                }
            }
            if (!supportingTokenTypes.contains(aTypeToString)) {
                supportingTokenTypes.add(aTypeToString);
                callerTokenTypes.add(var26_29);
                numberOfCallerSupportingTokenPerType = this.updateTokenTypeList(numberOfCallerSupportingTokenPerType, (QName)var26_29);
                continue;
            }
            throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s25", var26_29.toString());
        }
        if (this._symmetricBinding) {
            if (this._symmetricProtectionTokenAssertion != null) {
                callerTokenTypes.add(this._symmetricProtectionTokenAssertion._tokenType);
                numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, this._symmetricProtectionTokenAssertion._tokenType);
            } else if (this._symmetricSignatureTokenAssertion != null) {
                callerTokenTypes.add(this._symmetricSignatureTokenAssertion._tokenType);
                numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, this._symmetricSignatureTokenAssertion._tokenType);
            }
        } else if (isRequest) {
            if (!this._initiatorTokens.isEmpty()) {
                for (QName aType : this._initiatorTokenQNames) {
                    callerTokenTypes.add(aType);
                    numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aType);
                }
            } else if (!this._initiatorSignatureTokens.isEmpty()) {
                for (QName aType : this._initiatorSignatureTokenQNames) {
                    callerTokenTypes.add(aType);
                    numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aType);
                }
            }
        } else if (!this._recipientTokens.isEmpty()) {
            for (QName aQName : this._recipientTokenQNames) {
                callerTokenTypes.add(aQName);
                numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aQName);
            }
        } else if (!this._recipientSignatureTokens.isEmpty()) {
            for (QName aType : this._recipientSignatureTokenQNames) {
                callerTokenTypes.add(aType);
                numberOfCallerProtectionTokenPerType = this.updateTokenTypeList(numberOfCallerProtectionTokenPerType, aType);
            }
        }
        Integer numUNTokens = null;
        numUNTokens = (Integer)numberOfCallerSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN);
        if (numUNTokens != null && numUNTokens == 1 && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString()) && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s35", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
        }
        numUNTokens = (Integer)numberOfCallerSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11);
        if (numUNTokens != null && numUNTokens == 1 && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString()) && standAloneTokenConsumerTypes.containsKey(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString() + Constants.WSSECURITY_USE_IDASSERTION)) {
            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s35", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
        }
        for (String string : supportingTokenTypes) {
            TokenConsumerConfig tconfig2 = (TokenConsumerConfig)standAloneTokenConsumerTypes.get(string);
            if (tconfig2 != null) {
                this._tokenConsumers.add(tconfig2);
                continue;
            }
            if (string.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString())) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s36", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
            }
            if (string.startsWith(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString())) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s36", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
            }
            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s36", string);
        }
        if (!isRequest) {
            boolean bl;
            boolean bl2 = false;
            if (dcconfig.isExplicitlyProtectSignatureConfirmation()) {
                if (isDefaultBindingUsing10NS && !_avoid70BindingsNSCheck) {
                    throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s42", "com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", "ExplicitlyProtectSignatureConfirmation");
                }
                bl = true;
            }
            if (this._signatureConfirmationRequired && !isDefaultBindingUsing10NS && !bl) {
                Iterator j;
                PrivateCommonConfig.ReferencePartConfImpl rpconfig = null;
                PrivateCommonConfig.PartConfImpl pconfig = null;
                if (!signSignatureConfirmationSpecified) {
                    if (this._requiredIntegralParts.size() > 0) {
                        j = this._requiredIntegralParts.iterator();
                        if (j.hasNext()) {
                            rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)j.next();
                            pconfig = new PrivateCommonConfig.PartConfImpl();
                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                            pconfig._keyword = IntegralDialectElementSelector.WASDIALECTS[14];
                            rpconfig._parts.add(pconfig);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding SignatureConfirmation to required integrity for default binding");
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot sign SignatureConfirmation element since nothing else on the message is signed");
                        }
                        Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s23"));
                    }
                }
                if (!encryptSignatureConfirmationSpecified) {
                    if (this._requiredConfidentialParts.size() > 0) {
                        j = this._requiredConfidentialParts.iterator();
                        if (j.hasNext()) {
                            rpconfig = (PrivateCommonConfig.ReferencePartConfImpl)j.next();
                            pconfig = new PrivateCommonConfig.PartConfImpl();
                            pconfig._dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
                            pconfig._keyword = ConfidentialDialectElementSelector.WASDIALECTS[6];
                            rpconfig._parts.add(pconfig);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding SignatureConfirmation to required confidentiality for default binding");
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot encrypt SignatureConfirmation element since nothing else on the message is encrypted");
                        }
                        Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s22"));
                    }
                }
            }
        }
        set = dcconfig.getEncryptionConsumers();
        Iterator<Object> i = set.iterator();
        if (tc.isDebugEnabled() && i.hasNext()) {
            Tr.debug(tc, "Setting up encryption consumption information from default bindings.");
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(this._requiredConfidentialParts);
        while (i.hasNext()) {
            defaultEncryptionConsumer = (PrivateConsumerConfig.EncryptionConsumerConfImpl)i.next();
            if (!this.encryptionConsumerTokenMatch(defaultEncryptionConsumer, isRequest)) continue;
            Iterator j = hashSet.iterator();
            while (j.hasNext()) {
                PrivateCommonConfig.ReferencePartConfImpl refPart = (PrivateCommonConfig.ReferencePartConfImpl)j.next();
                j.remove();
                econfig = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                econfig._reference = refPart;
                econfig._reference.getBindings().add(econfig);
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = this.encryptionAlgorithm;
                econfig._dataEncryptionMethod = aconfig;
                if (defaultEncryptionConsumer._isKeyDecryption) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = this.keyEncryptionAlgorithm;
                    econfig._keyEncryptionMethod = aconfig;
                }
                econfig._encryptionKeyInfo = defaultEncryptionConsumer._encryptionKeyInfo;
                econfig._properties.putAll(defaultEncryptionConsumer.getProperties());
                boolean foundTokenConsumerMatch = false;
                List<KeyInfoContentConsumerConfig> aList = econfig.getEncryptionKeyInfo().getContentConsumers();
                if (aList != null) {
                    for (KeyInfoContentConsumerConfig aConfig : aList) {
                        TokenConsumerConfig tokConfig = aConfig.getTokenConsumer();
                        if (tokConfig == null) continue;
                        foundTokenConsumerMatch = true;
                        Integer hash = tokConfig.hashCode();
                        if (protectionTokenConsumers.get(hash) != null) continue;
                        this._tokenConsumers.add(tokConfig);
                        protectionTokenConsumers.put(hash, tokConfig);
                    }
                }
                this._encryptionConsumers.add(econfig);
                if (foundTokenConsumerMatch) continue;
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s40");
            }
        }
        if (!hashSet.isEmpty()) {
            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s41");
        }
        set = dcconfig.getSignatureConsumers();
        i = set.iterator();
        HashSet unboundIntegrities = new HashSet();
        unboundIntegrities.addAll(this._requiredIntegralParts);
        if (tc.isDebugEnabled() && i.hasNext()) {
            Tr.debug(tc, "Settting up signature consumption information from default bindings.");
        }
        while (i.hasNext()) {
            defaultSignatureConsumer = (PrivateConsumerConfig.SignatureConsumerConfImpl)i.next();
            if (!this.signatureConsumerTokenMatch(defaultSignatureConsumer, isRequest)) continue;
            sconfig = new PrivateConsumerConfig.SignatureConsumerConfImpl();
            for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : defaultSignatureConsumer._references) {
                if (unboundIntegrities.isEmpty()) continue;
                boolean foundTokenConsumerMatch = false;
                Iterator k = unboundIntegrities.iterator();
                while (k.hasNext()) {
                    PrivateCommonConfig.ReferencePartConfImpl refPart = (PrivateCommonConfig.ReferencePartConfImpl)k.next();
                    k.remove();
                    srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                    srconfig._reference = refPart;
                    srconfig._reference.getBindings().add(sconfig);
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = this.digestAlgorithm;
                    srconfig._digestMethod = aconfig;
                    srconfig._transforms.addAll(signingReferenceConfImpl._transforms);
                    sconfig._references.add(srconfig);
                }
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = this.canonicalizationAlgorithm;
                sconfig._canonicalizationMethod = aconfig;
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = this._symmetricBinding ? this.symmetricSignatureAlgorithm : this.asymmetricSignatureAlgorithm;
                sconfig._signatureMethod = aconfig;
                sconfig._signingKeyInfo = defaultSignatureConsumer._signingKeyInfo;
                sconfig._properties.putAll(defaultSignatureConsumer._properties);
                List<KeyInfoContentConsumerConfig> aList = sconfig.getSigningKeyInfo().getContentConsumers();
                if (aList != null) {
                    for (KeyInfoContentConsumerConfig aConfig : aList) {
                        TokenConsumerConfig tokConfig = aConfig.getTokenConsumer();
                        if (tokConfig == null) continue;
                        Integer hash = tokConfig.hashCode();
                        if (protectionTokenConsumers.get(hash) == null) {
                            this._tokenConsumers.add(tokConfig);
                            protectionTokenConsumers.put(hash, tokConfig);
                        }
                        foundTokenConsumerMatch = true;
                    }
                }
                this._signatureConsumers.add(sconfig);
                if (foundTokenConsumerMatch) continue;
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s38");
            }
        }
        if (!unboundIntegrities.isEmpty()) {
            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s39");
        }
        boolean bl = this._onlySignEntireHeadersAndBody = this._onlySignEntireHeadersAndBody || dcconfig.isOnlySignEntireHeadersAndBody();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processed default config onlySignEntireHeadersAndBody, currently " + this._onlySignEntireHeadersAndBody);
        }
        Iterator<CallerConfig> i1 = dcconfig.getCallers().iterator();
        HashSet<String> callerUNTTokenTypes = new HashSet<String>();
        while (i1.hasNext()) {
            PrivateConsumerConfig.CallerConfImpl cconfig = (PrivateConsumerConfig.CallerConfImpl)i1.next();
            boolean matchFound = false;
            boolean searchForCallerMatch = true;
            String isIdAssertion = null;
            boolean trustedIdIsSupporting = true;
            boolean callerIdIsSupporting = true;
            if (cconfig._trustedIdentity != null) {
                if ((cconfig._trustedIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || cconfig._trustedIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) && (cconfig._callerIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || cconfig._callbackHandler.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11))) {
                    if (cconfig._trustedIdentity.equals(cconfig._callerIdentity)) {
                        numUNTokens = numberOfCallerSupportingTokenPerType.get(cconfig._trustedIdentity);
                        if (numUNTokens == null) {
                            numUNTokens = new Integer(0);
                        }
                        if (numUNTokens < 2) {
                            searchForCallerMatch = false;
                        } else if (numUNTokens > 2) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s27", numUNTokens.toString());
                        }
                    } else {
                        Integer numOfTrustedUNTokens = numberOfCallerSupportingTokenPerType.get(cconfig._trustedIdentity);
                        Integer numOfAssertionUNTokens = numberOfCallerSupportingTokenPerType.get(cconfig._callerIdentity);
                        if (numOfTrustedUNTokens == null) {
                            numOfTrustedUNTokens = new Integer(0);
                            searchForCallerMatch = false;
                        }
                        if (numOfAssertionUNTokens == null) {
                            numOfAssertionUNTokens = new Integer(0);
                            searchForCallerMatch = false;
                        }
                        if (searchForCallerMatch && (numOfTrustedUNTokens != 1 || numOfAssertionUNTokens != 1)) {
                            Integer n = numOfTrustedUNTokens + numOfAssertionUNTokens;
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s27", n.toString());
                        }
                    }
                } else {
                    Integer numOfTrustedTokens = numberOfCallerSupportingTokenPerType.get(cconfig._trustedIdentity);
                    Integer numOfAssertionTokens = numberOfCallerSupportingTokenPerType.get(cconfig._callerIdentity);
                    if (numOfTrustedTokens == null) {
                        numOfTrustedTokens = numberOfCallerProtectionTokenPerType.get(cconfig._trustedIdentity);
                        if (numOfTrustedTokens == null) {
                            numOfTrustedTokens = new Integer(0);
                            searchForCallerMatch = false;
                        } else {
                            trustedIdIsSupporting = false;
                            if (numOfTrustedTokens != 1) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s43", numOfTrustedTokens.toString(), cconfig._trustedIdentity.toString());
                            }
                        }
                    }
                    if (numOfAssertionTokens == null) {
                        numOfAssertionTokens = numberOfCallerProtectionTokenPerType.get(cconfig._callerIdentity);
                        if (numOfAssertionTokens == null) {
                            numOfAssertionTokens = new Integer(0);
                            searchForCallerMatch = false;
                        } else {
                            callerIdIsSupporting = false;
                            if (numOfAssertionTokens != 1) {
                                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s43", numOfAssertionTokens.toString(), cconfig._callerIdentity.toString());
                            }
                        }
                    }
                    if (searchForCallerMatch && numOfTrustedTokens != 1) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s28", numOfTrustedTokens.toString(), cconfig._trustedIdentity.toString());
                    }
                    if (searchForCallerMatch && numOfAssertionTokens != 1) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s28", numOfAssertionTokens.toString(), cconfig._callerIdentity.toString());
                    }
                }
                if (searchForCallerMatch) {
                    Iterator listIterator = callerTokenTypes.iterator();
                    boolean foundCallerIdentity = false;
                    boolean bl3 = false;
                    while (listIterator.hasNext() && !matchFound) {
                        boolean bl4;
                        PrivateConsumerConfig.TokenConsumerConfImpl tconfig;
                        Iterator j;
                        QName aType = (QName)listIterator.next();
                        if (aType.equals(cconfig._callerIdentity)) {
                            j = this._tokenConsumers.iterator();
                            while (j.hasNext() && !foundCallerIdentity) {
                                tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)j.next();
                                if (!tconfig._type.equals(aType) || (!callerIdIsSupporting || tconfig.isUsedForDecryption() || tconfig.isUsedForVerification()) && (callerIdIsSupporting || !tconfig.isUsedForVerification()) || (isIdAssertion = (String)tconfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION)) == null || !isIdAssertion.equals("true")) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CallerIdentity match of type " + aType.toString());
                                }
                                foundCallerIdentity = true;
                            }
                        }
                        if (aType.equals(cconfig._trustedIdentity)) {
                            j = this._tokenConsumers.iterator();
                            while (j.hasNext() && !bl4) {
                                tconfig = (PrivateConsumerConfig.TokenConsumerConfImpl)j.next();
                                if (!tconfig._type.equals(aType) || (!trustedIdIsSupporting || tconfig.isUsedForDecryption() || tconfig.isUsedForVerification()) && (trustedIdIsSupporting || !tconfig.isUsedForVerification())) continue;
                                isIdAssertion = (String)tconfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
                                if (isIdAssertion == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found TrustedIdentity match of type " + aType.toString());
                                    }
                                    bl4 = true;
                                    continue;
                                }
                                if (isIdAssertion.equals("true")) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found TrustedIdentity match of type " + aType.toString());
                                }
                                bl4 = true;
                            }
                        } else if (cconfig._anyTrustedIdentity && !bl4) {
                            bl4 = true;
                        }
                        if (!foundCallerIdentity || !bl4) continue;
                        matchFound = true;
                    }
                }
            } else {
                Integer numOfCallerIdTokens = numberOfCallerSupportingTokenPerType.get(cconfig._callerIdentity);
                if (numOfCallerIdTokens == null) {
                    numOfCallerIdTokens = numberOfCallerProtectionTokenPerType.get(cconfig._callerIdentity);
                    if (numOfCallerIdTokens == null) {
                        numOfCallerIdTokens = new Integer(0);
                        searchForCallerMatch = false;
                    } else {
                        callerIdIsSupporting = false;
                        if (numOfCallerIdTokens != 1) {
                            throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s43", numOfCallerIdTokens.toString(), cconfig._callerIdentity.toString());
                        }
                    }
                }
                if (searchForCallerMatch) {
                    if (numOfCallerIdTokens != 1) {
                        throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s28", numOfCallerIdTokens.toString(), cconfig._callerIdentity.toString());
                    }
                    block18: for (QName qName : callerTokenTypes) {
                        if (!qName.equals(cconfig._callerIdentity)) continue;
                        for (PrivateConsumerConfig.TokenConsumerConfImpl tconfig : this._tokenConsumers) {
                            if (!tconfig._type.equals(qName) || (!callerIdIsSupporting || tconfig.isUsedForDecryption() || tconfig.isUsedForVerification()) && (callerIdIsSupporting || !tconfig.isUsedForVerification())) continue;
                            isIdAssertion = (String)tconfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
                            if (isIdAssertion == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found CallerIdentity match of type " + qName.toString());
                                }
                                matchFound = true;
                                continue block18;
                            }
                            if (!isIdAssertion.equals("true")) {
                                matchFound = true;
                                if (!tc.isDebugEnabled()) continue block18;
                                Tr.debug(tc, "Found CallerIdentity match of type " + qName.toString());
                                continue block18;
                            }
                            if (!cconfig._anyTrustedIdentity || !isIdAssertion.equals("true")) continue;
                            matchFound = true;
                            cconfig._identityAssertion = true;
                            if (!tc.isDebugEnabled()) continue block18;
                            Tr.debug(tc, "Found CallerIdentity match of type " + qName.toString());
                            continue block18;
                        }
                    }
                }
            }
            if (!matchFound) continue;
            this._callers.add(cconfig);
            this._loginRequired = true;
            this._isOrderEnforced = dcconfig.isCallerOrderEnforced();
            if (cconfig._callerIdentity != null && (cconfig._callerIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || cconfig._callerIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11))) {
                callerUNTTokenTypes.add(cconfig._callerIdentity.toString() + Constants.WSSECURITY_USE_IDASSERTION);
            }
            if (cconfig._trustedIdentity != null && (cconfig._trustedIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN) || cconfig._trustedIdentity.equals(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11))) {
                callerUNTTokenTypes.add(cconfig._trustedIdentity.toString());
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added caller " + cconfig.toString() + " to configuration.");
        }
        numUNTokens = numberOfCallerSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN);
        if (numUNTokens != null && numUNTokens == 2) {
            boolean trustedIdPresent = callerUNTTokenTypes.contains(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
            boolean callerIdPresent = callerUNTTokenTypes.contains(com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + Constants.WSSECURITY_USE_IDASSERTION);
            if (!trustedIdPresent && !callerIdPresent) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s37", com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString());
            }
        }
        if ((numUNTokens = numberOfCallerSupportingTokenPerType.get(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11)) != null && numUNTokens == 2) {
            boolean trustedIdPresent = callerUNTTokenTypes.contains(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
            boolean callerIdPresent = callerUNTTokenTypes.contains(com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString() + Constants.WSSECURITY_USE_IDASSERTION);
            if (!trustedIdPresent && !callerIdPresent) {
                throw SoapSecurityException.format("security.wssecurity.PolicyInboundConfig.s37", com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDefaultConfig(WSSConsumerConfig, Map)");
        }
    }

    private HashMap<QName, Integer> updateTokenTypeList(HashMap<QName, Integer> tokenTypeList, QName aType) {
        Integer numOfOcurrences = tokenTypeList.get(aType);
        if (numOfOcurrences == null) {
            numOfOcurrences = new Integer(1);
            tokenTypeList.put(aType, numOfOcurrences);
        } else {
            Integer n = numOfOcurrences;
            Integer n2 = numOfOcurrences = Integer.valueOf(numOfOcurrences + 1);
            tokenTypeList.put(aType, numOfOcurrences);
        }
        return tokenTypeList;
    }

    final String getOrigin() {
        return this.origin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean encryptionConsumerTokenMatch(PrivateConsumerConfig.EncryptionConsumerConfImpl anEncryptionConsumerConfig, boolean isRequest) throws SoapSecurityException {
        QName aType = null;
        boolean isMatch = false;
        if (anEncryptionConsumerConfig.getEncryptionKeyInfo() != null) {
            List<KeyInfoContentConsumerConfig> contentConsumers = anEncryptionConsumerConfig.getEncryptionKeyInfo().getContentConsumers();
            if (contentConsumers != null) {
                Iterator<KeyInfoContentConsumerConfig> contentConsumerIterator = contentConsumers.iterator();
                if (contentConsumerIterator.hasNext()) {
                    PrivateConsumerConfig.KeyInfoContentConsumerConfImpl aConfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)contentConsumerIterator.next();
                    aType = aConfig.getTokenConsumer().getType();
                }
                if (aType == null) return isMatch;
                if (this._symmetricBinding) {
                    if (this._symmetricProtectionTokenAssertion != null) {
                        if (!this._symmetricProtectionTokenAssertion.getTokenType().equals(aType)) return false;
                        return true;
                    }
                    if (this._symmetricEncryptionTokenAssertion == null) return isMatch;
                    if (!this._symmetricEncryptionTokenAssertion.getTokenType().equals(aType)) return false;
                    return true;
                }
                if (isRequest) {
                    if (!this._recipientTokens.isEmpty()) {
                        if (this._recipientTokenQNames.indexOf(aType) < 0) return false;
                        return true;
                    }
                    if (this._recipientEncryptionTokens.isEmpty()) return isMatch;
                    if (this._recipientEncryptionTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (!this._initiatorTokens.isEmpty()) {
                    if (this._initiatorTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (this._initiatorEncryptionTokens.isEmpty()) return isMatch;
                if (this._initiatorEncryptionTokenQNames.indexOf(aType) < 0) return false;
                return true;
            }
            if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
            Tr.debug(tc, "No contentConsumers found in EncryptionKeyInfo = " + anEncryptionConsumerConfig.getEncryptionKeyInfo());
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        }
        if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        Tr.debug(tc, "No EncryptionKeyInfo found in encryptionConsumerConfig = " + anEncryptionConsumerConfig);
        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean signatureConsumerTokenMatch(PrivateConsumerConfig.SignatureConsumerConfImpl aSignatureConsumerConfig, boolean isRequest) throws SoapSecurityException {
        QName aType = null;
        boolean isMatch = false;
        if (aSignatureConsumerConfig.getSigningKeyInfo() != null) {
            List<KeyInfoContentConsumerConfig> contentConsumers = aSignatureConsumerConfig.getSigningKeyInfo().getContentConsumers();
            if (contentConsumers != null) {
                Iterator<KeyInfoContentConsumerConfig> contentConsumerIterator = contentConsumers.iterator();
                if (contentConsumerIterator.hasNext()) {
                    PrivateConsumerConfig.KeyInfoContentConsumerConfImpl aConfig = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)contentConsumerIterator.next();
                    aType = aConfig.getTokenConsumer().getType();
                }
                if (aType == null) return isMatch;
                if (this._symmetricBinding) {
                    if (this._symmetricProtectionTokenAssertion != null) {
                        if (!this._symmetricProtectionTokenAssertion.getTokenType().equals(aType)) return false;
                        return true;
                    }
                    if (this._symmetricSignatureTokenAssertion == null) return isMatch;
                    if (!this._symmetricSignatureTokenAssertion.getTokenType().equals(aType)) return false;
                    return true;
                }
                if (isRequest) {
                    if (!this._initiatorTokens.isEmpty()) {
                        if (this._initiatorTokenQNames.indexOf(aType) < 0) return false;
                        return true;
                    }
                    if (this._initiatorSignatureTokens.isEmpty()) return isMatch;
                    if (this._initiatorSignatureTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (!this._recipientTokens.isEmpty()) {
                    if (this._recipientTokenQNames.indexOf(aType) < 0) return false;
                    return true;
                }
                if (this._recipientSignatureTokens.isEmpty()) return isMatch;
                if (this._recipientSignatureTokenQNames.indexOf(aType) < 0) return false;
                return true;
            }
            if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
            Tr.debug(tc, "No contentConsumers found in SigningKeyInfo = " + aSignatureConsumerConfig.getSigningKeyInfo());
            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        }
        if (!tc.isDebugEnabled()) throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
        Tr.debug(tc, "No SigningKeyInfo found in signatureConsumerConfig = " + aSignatureConsumerConfig);
        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.KeyInfoGenerator.getKey01"));
    }

    private PrivateCommonConfig.TokenAssertion tokenAssertion(String tokenName, List<?> policyAssertionList) throws SoapSecurityException {
        PrivateCommonConfig.TokenAssertion aTokenAssertion = null;
        if (tokenName != null) {
            if (tokenName.equals("X509Token")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireDerivedKeys");
                            continue;
                        }
                        if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireImplicitDerivedKeys");
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireExplicitDerivedKeys");
                            continue;
                        }
                        if ("WssX509V3Token10".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.X509V3_OLD;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V3Token10");
                            continue;
                        }
                        if ("WssX509Pkcs7Token10".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKCS7;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509Pkcs7Token10");
                            continue;
                        }
                        if ("WssX509PkiPathV1Token10".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKI_PATH;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WSS_X509_PKI_PATH_V1_TOKEN10");
                            continue;
                        }
                        if ("WssX509V1Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.X509V3_11_V1;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V1Token11");
                            continue;
                        }
                        if ("WssX509V3Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.X509V3_11_V3;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V3Token11");
                            continue;
                        }
                        if ("WssX509Pkcs7Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKCS711;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509Pkcs7Token11");
                            continue;
                        }
                        if ("WssX509PkiPathV1Token11".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.PKI_PATH11;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509PkiPathV1Token11");
                            continue;
                        }
                        if ("RequireKeyIdentifierReference".equals(tokenSpecificationName)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireKeyIdentifierReference");
                            continue;
                        }
                        if ("RequireIssuerSerialReference".equals(tokenSpecificationName)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireIssuerSerialReference");
                            continue;
                        }
                        if ("RequireEmbeddedTokenReference".equals(tokenSpecificationName)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireEmbeddedTokenReference");
                            continue;
                        }
                        if (!"RequireThumbprintReference".equals(tokenSpecificationName) || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireThumbprintReference");
                    }
                }
            } else if (tokenName.equals("UsernameToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireDerivedKeys");
                            continue;
                        }
                        if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireImplicitDerivedKeys");
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireExplicitDerivedKeys");
                            continue;
                        }
                        if ("WssUsernameToken10".equals(tokenSpecificationName)) {
                            if (aTokenAssertion._tokenType != null) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s18", new String[]{aTokenAssertion._tokenType.toString(), tokenSpecificationName}));
                            }
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.UNTOKEN;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added WssUsernameToken10");
                            continue;
                        }
                        if (!"WssUsernameToken11".equals(tokenSpecificationName)) continue;
                        if (aTokenAssertion._tokenType != null) {
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s18", new String[]{aTokenAssertion._tokenType.toString(), tokenSpecificationName}));
                        }
                        aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WssUsernameToken11");
                    }
                }
            } else if (tokenName.equals("KerberosToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireDerivedKeys");
                            continue;
                        }
                        if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireImplicitDerivedKeys");
                            }
                            Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            continue;
                        }
                        if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireExplicitDerivedKeys");
                            }
                            Tr.warning(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s05", new String[]{tokenSpecificationName}));
                            continue;
                        }
                        if ("RequireKeyIdentifierReference".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireKeyIdentifierReference = true;
                            aTokenAssertion._requireSTRReference = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the policy assertion for KERBEROS_TOKEN has added RequireExplicitDerivedKeys");
                            continue;
                        }
                        if ("WssKerberosV5ApReqToken11".equals(tokenSpecificationName)) {
                            if (aTokenAssertion._tokenType != null) {
                                Tr.error(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s06"));
                                throw new SoapSecurityException(comp + ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s06"));
                            }
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.KERBEROSV5;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "WssKerberosV5ApReqToken11");
                            continue;
                        }
                        if (!"WssGssKerberosV5ApReqToken11".equals(tokenSpecificationName)) continue;
                        if (aTokenAssertion._tokenType != null) {
                            Tr.error(tc, ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s07"));
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInOutboundConfig.s07"));
                        }
                        aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.KERBEROSV5_GSS;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "WssGssKerberosV5ApReqToken11");
                    }
                }
            } else if (tokenName.equals("SecureConversationToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SC_200502;
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof String)) continue;
                        String tokenSpecificationName = (String)objN;
                        if ("RequireDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                            }
                        } else if ("RequireImplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireImplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                            }
                        } else if ("RequireExplicitDerivedKeys".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExplicitDerivedKeys = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                            }
                        } else if ("RequireExternalUriReference".equals(tokenSpecificationName)) {
                            aTokenAssertion._requireExternalUriReference = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireExternalUriReference");
                            }
                        } else if ("SC200502SecurityContextToken".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SC_200502;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added SC200502SecurityContextToken");
                            }
                        } else if ("SC13SecurityContextToken".equals(tokenSpecificationName)) {
                            aTokenAssertion._tokenType = com.ibm.ws.wssecurity.common.Constants.SCT_13;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added SC13SecurityContextToken");
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN ");
                    }
                }
            } else if (tokenName.equals("LTPAToken") || tokenName.equals("LTPAPropagationToken") || tokenName.equals("CustomToken")) {
                aTokenAssertion = new PrivateCommonConfig.TokenAssertion();
                if (policyAssertionList != null && policyAssertionList.size() != 0) {
                    for (int a = 0; a < policyAssertionList.size(); ++a) {
                        Object objN = policyAssertionList.get(a);
                        if (!(objN instanceof QName)) continue;
                        aTokenAssertion._tokenType = (QName)objN;
                    }
                }
            } else {
                throw SoapSecurityException.format("security.wssecurity.PolicyInOutboundConfig.s01", new String[]{tokenName});
            }
        }
        return aTokenAssertion;
    }

    private PrivateCommonConfig.TokenAssertion getTokenTypeAssertion(ProtectionOrSupportingToken anAssertion) throws SoapSecurityException {
        List<QName> wssTokenAssertions;
        String requiredTokenName = anAssertion.getType();
        PrivateCommonConfig.TokenAssertion aTokenAssertion = null;
        List<String> tokenAssertions = anAssertion.getTokenAssertions();
        if (tokenAssertions != null && tokenAssertions.size() > 0) {
            aTokenAssertion = this.tokenAssertion(requiredTokenName, tokenAssertions);
        }
        if ((wssTokenAssertions = anAssertion.getWssTokenAssertions()) != null && wssTokenAssertions.size() > 0) {
            aTokenAssertion = this.tokenAssertion(requiredTokenName, wssTokenAssertions);
        }
        return aTokenAssertion;
    }

    private void algorithmSuiteAssertion(String algorithmSuiteElement) {
        if (PolicyConfigUtil.isValidAlgorithmSuite(algorithmSuiteElement)) {
            if (this._symmetricBinding) {
                this.algorithmSuite = algorithmSuiteElement;
                this.symmetricSignatureAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 0);
            } else {
                this.asymmetricSignatureAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 1);
            }
            this.digestAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 2);
            this.encryptionAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 3);
            this.keyEncryptionAlgorithm = PolicyConfigUtil.getAlgorithm(algorithmSuiteElement, 5);
        } else if ("InclusiveC14N".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found C14N inclusive");
            }
            this.transformAlgorithm = "http://www.w3.org/2001/10/xml-c14n#";
            this.canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-c14n#";
        } else if ("SOAPNormalization10".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found SOAPNormalization10");
            }
        } else if ("STRTransform10".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found STRT10");
            }
        } else if ("XPath10".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found XPATH10");
            }
        } else if ("XPath20".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found STRT10");
            }
        } else if ("AbsXPath".equals(algorithmSuiteElement)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found ABSXPATH");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: invalid algorithm suite [" + algorithmSuiteElement + "] specified on EncryptedParts .");
        }
    }

    private String layoutAssertion(String layoutElement) {
        String layoutAssertion = null;
        if ("Strict".equals(layoutElement)) {
            layoutAssertion = "Strict";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Strict");
            }
        } else if ("Lax".equals(layoutElement)) {
            layoutAssertion = "Lax";
            if (tc.isDebugEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Lax");
            }
        } else if ("LaxTsFirst".equals(layoutElement)) {
            layoutAssertion = "LaxTsFirst";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found LaxTsFirst");
            }
        } else if ("LaxTsLast".equals(layoutElement)) {
            layoutAssertion = "LaxTsLast";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found LaxTsLast");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: invalid algorithm suite [" + layoutElement + "] specified on EncryptedParts .");
        }
        return layoutAssertion;
    }

    private boolean retrieveAssertions(String id, boolean isRequest) {
        boolean retrieveAssertion = false;
        if (id == null) {
            retrieveAssertion = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No wsu:Id for Policy element found; ignoring.");
            }
        } else if (id.startsWith("request:") && isRequest) {
            retrieveAssertion = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching inbound request wsu:Id found: " + id);
            }
        } else if (id.startsWith("response:") && !isRequest) {
            retrieveAssertion = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching inbound response wsu:Id found: " + id);
            }
        } else {
            retrieveAssertion = false;
            if (tc.isDebugEnabled()) {
                if (isRequest) {
                    Tr.debug(tc, "wsu:Id found not applicable for inbound request messages: " + id);
                } else {
                    Tr.debug(tc, "wsu:Id found not applicable for inbound response messages: " + id);
                }
            }
        }
        return retrieveAssertion;
    }

    public String getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    private void mapPolicyAssertionsToProperties(boolean isTargetNamespaceDraft12, boolean isRequest) {
        for (PrivateConsumerConfig.TokenConsumerConfImpl tconfig : this._tokenConsumers) {
            PrivateCommonConfig.TokenAssertion anAssertion = null;
            if (!isTargetNamespaceDraft12 && (tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.KERBEROSV5) || tconfig._type.equals(com.ibm.ws.wssecurity.common.Constants.KERBEROSV5_GSS))) {
                if ((this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) && tconfig._usedForDecryption) {
                    anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
                }
                if (this._symmetricProtectionTokenAssertion == null && this._symmetricSignatureTokenAssertion == null || !tconfig._usedForVerification) continue;
                if (this._symmetricProtectionTokenAssertion != null) {
                    anAssertion = this._symmetricProtectionTokenAssertion;
                    continue;
                }
                anAssertion = this._symmetricSignatureTokenAssertion;
                continue;
            }
            if ((this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) && tconfig._usedForDecryption) {
                anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
            }
            if ((this._symmetricProtectionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null) && tconfig._usedForVerification) {
                anAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricSignatureTokenAssertion;
            }
            if (anAssertion == null || !anAssertion._requireImplicitDerivedKeys) continue;
            tconfig.getProperties().put("RequiredImpliedDerivedKeys", anAssertion._requireImplicitDerivedKeys);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added token config property for implicit derived keys");
        }
        if (!isTargetNamespaceDraft12) {
            for (String key : this.nameKeyInfo.keySet()) {
                List initiatorTokenList;
                int index;
                List recipientTokenList;
                PrivateConsumerConfig.KeyInfoContentConsumerConfImpl aKeyInfo = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)this.nameKeyInfo.get(key);
                PrivateConsumerConfig.TokenConsumerConfImpl aTokenCon = aKeyInfo._tokenConsumer;
                PrivateCommonConfig.TokenAssertion aTokenAssertion = null;
                if (this._symmetricBinding) {
                    if (aTokenCon._usedForDecryption) {
                        if (this._symmetricProtectionTokenAssertion != null || this._symmetricEncryptionTokenAssertion != null) {
                            aTokenAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricEncryptionTokenAssertion;
                        }
                    } else if (aTokenCon._usedForVerification && (this._symmetricProtectionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null)) {
                        aTokenAssertion = this._symmetricProtectionTokenAssertion != null ? this._symmetricProtectionTokenAssertion : this._symmetricSignatureTokenAssertion;
                    }
                } else if (aTokenCon._usedForDecryption) {
                    if (isRequest) {
                        if (!this._recipientTokens.isEmpty() || !this._recipientEncryptionTokens.isEmpty()) {
                            recipientTokenList = null;
                            index = 0;
                            if (!this._recipientTokens.isEmpty()) {
                                recipientTokenList = this._recipientTokens;
                                index = this._recipientTokenQNames.indexOf(aTokenCon._type);
                            } else {
                                recipientTokenList = this._recipientEncryptionTokens;
                                index = this._recipientEncryptionTokenQNames.indexOf(aTokenCon._type);
                            }
                            if (index >= 0) {
                                aTokenAssertion = (PrivateCommonConfig.TokenAssertion)recipientTokenList.get(index);
                            }
                        }
                    } else if (!this._initiatorTokens.isEmpty() || !this._initiatorEncryptionTokens.isEmpty()) {
                        initiatorTokenList = null;
                        index = 0;
                        if (!this._initiatorTokens.isEmpty()) {
                            initiatorTokenList = this._initiatorTokens;
                            index = this._initiatorTokenQNames.indexOf(aTokenCon._type);
                        } else {
                            initiatorTokenList = this._initiatorEncryptionTokens;
                            index = this._initiatorEncryptionTokenQNames.indexOf(aTokenCon._type);
                        }
                        if (index >= 0) {
                            aTokenAssertion = (PrivateCommonConfig.TokenAssertion)initiatorTokenList.get(index);
                        }
                    }
                } else if (aTokenCon._usedForVerification) {
                    if (isRequest) {
                        if (!this._initiatorTokens.isEmpty() || !this._initiatorSignatureTokens.isEmpty()) {
                            initiatorTokenList = null;
                            index = 0;
                            if (!this._initiatorTokens.isEmpty()) {
                                initiatorTokenList = this._initiatorTokens;
                                index = this._initiatorTokenQNames.indexOf(aTokenCon._type);
                            } else {
                                initiatorTokenList = this._initiatorSignatureTokens;
                                index = this._initiatorSignatureTokenQNames.indexOf(aTokenCon._type);
                            }
                            if (index >= 0) {
                                aTokenAssertion = (PrivateCommonConfig.TokenAssertion)initiatorTokenList.get(index);
                            }
                        }
                    } else if (!this._recipientTokens.isEmpty() || !this._recipientSignatureTokens.isEmpty()) {
                        recipientTokenList = null;
                        index = 0;
                        if (!this._recipientTokens.isEmpty()) {
                            recipientTokenList = this._recipientTokens;
                            index = this._recipientTokenQNames.indexOf(aTokenCon._type);
                        } else {
                            recipientTokenList = this._recipientSignatureTokens;
                            index = this._recipientSignatureTokenQNames.indexOf(aTokenCon._type);
                        }
                        if (index >= 0) {
                            aTokenAssertion = (PrivateCommonConfig.TokenAssertion)recipientTokenList.get(index);
                        }
                    }
                }
                if (aTokenAssertion == null) continue;
                if (aKeyInfo._derivedKeyInfo == null) {
                    aKeyInfo._derivedKeyInfo = new DerivedKeyInfoConfig();
                }
                if (aKeyInfo._derivedKeyInfo != null) {
                    aKeyInfo._derivedKeyInfo.setRequireDerivedKeys(aTokenAssertion._requireDerivedKeys);
                    aKeyInfo._derivedKeyInfo.setRequireExplicitDerivedKeys(aTokenAssertion._requireExplicitDerivedKeys);
                    aKeyInfo._derivedKeyInfo.setRequireImpliedDerivedKeys(aTokenAssertion._requireImplicitDerivedKeys);
                }
                if (aTokenAssertion._requireKeyIdentifierReference) {
                    // empty if block
                }
                aKeyInfo._isRequireExternalUriReference = aTokenAssertion._requireExternalUriReference;
            }
        }
    }

    static {
        _avoid70BindingsNSCheck = false;
        String prop = System.getProperty("com.ibm.wsspi.wssecurity.avoid70BindingsNSCheck");
        if (prop != null && ("true".equalsIgnoreCase(prop) || "yes".equalsIgnoreCase(prop) || "1".equalsIgnoreCase(prop) || "on".equalsIgnoreCase(prop))) {
            _avoid70BindingsNSCheck = true;
        }
    }
}

