/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class NamespaceStack {
    private static final TraceComponent tc = Tr.register(NamespaceStack.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static final int INITIAL_CAPACITY = 10;
    protected static final int CONTEXT_INITIAL_CAPACITY = 10;
    protected static final int INITIAL_SIZE = 3;
    protected int size = 3;
    protected String[] pre = new String[10];
    protected String[] uri = new String[10];
    protected int contextSize = 0;
    protected int[] context = new int[10];

    public NamespaceStack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NamespaceStack");
        }
        this.pre[0] = "xml";
        this.uri[0] = "http://www.w3.org/XML/1998/namespace";
        this.pre[1] = "xmlns";
        this.uri[1] = "http://www.w3.org/2000/xmlns/";
        this.pre[2] = "";
        this.uri[2] = "";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NamespaceStack", this);
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this.size = 3;
        this.contextSize = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clear", this);
        }
        for (int i = 3; i < this.size; ++i) {
            this.pre[i] = null;
            this.uri[i] = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public void pushContext() {
        this.context[this.contextSize] = this.size;
        ++this.contextSize;
        if (this.contextSize == this.context.length) {
            int nextContextCapacity = this.context.length * 2;
            int[] tmpContext = new int[nextContextCapacity];
            System.arraycopy(this.context, 0, tmpContext, 0, this.contextSize);
            this.context = tmpContext;
        }
    }

    public void popContext() {
        --this.contextSize;
        if (this.contextSize < 0) {
            this.contextSize = 0;
        }
        this.size = this.context[this.contextSize];
    }

    public boolean declarePrefix(String prefix, String uri) {
        this.pre[this.size] = prefix;
        this.uri[this.size] = uri;
        ++this.size;
        if (this.size == this.pre.length) {
            int nextCapacity = this.pre.length * 2;
            String[] tmpPre = new String[nextCapacity];
            System.arraycopy(this.pre, 0, tmpPre, 0, this.size);
            this.pre = tmpPre;
            String[] tmpUri = new String[nextCapacity];
            System.arraycopy(this.uri, 0, tmpUri, 0, this.size);
            this.uri = tmpUri;
        }
        return true;
    }

    public final int size() {
        return this.size;
    }

    public final String getPrefix(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.pre[index];
    }

    public final String getURI(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.uri[index];
    }

    public final String getURI(String prefix) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.pre[i].equals(prefix)) continue;
            return this.uri[i];
        }
        return null;
    }

    public Iterator<String> getPrefixes() {
        HashSet<String> set = new HashSet<String>();
        for (int i = this.size - 1; i >= 0; --i) {
            set.add(this.pre[i]);
        }
        return set.iterator();
    }

    public HashMap<String, String> getMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMap", this);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.size; ++i) {
            map.put(this.pre[i], this.uri[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMap", map);
        }
        return map;
    }

    public HashMap<String, String> getCurrentActiveDeclMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentActiveDeclMap", this);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        boolean defaultNamespaceIsOverDeclarated = false;
        for (int i = this.size - 1; i > 2; --i) {
            if ("".equals(this.pre[i])) {
                if (defaultNamespaceIsOverDeclarated) continue;
                defaultNamespaceIsOverDeclarated = true;
                if ("".equals(this.uri[i])) continue;
                map.put(this.pre[i], this.uri[i]);
            }
            if (map.containsKey(this.pre[i])) continue;
            map.put(this.pre[i], this.uri[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentActiveDeclMap", map);
        }
        return map;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        int contextPos = 0;
        strBuilder.append("-----\n");
        for (int i = 0; i < this.size; ++i) {
            if (i == this.context[contextPos]) {
                strBuilder.append("-----\n");
                ++contextPos;
            }
            strBuilder.append("\"");
            strBuilder.append(this.pre[i]);
            strBuilder.append("\"");
            strBuilder.append("=");
            strBuilder.append("\"");
            strBuilder.append(this.uri[i]);
            strBuilder.append("\"");
            strBuilder.append("\n");
        }
        strBuilder.append("-----\n");
        return strBuilder.toString();
    }
}

