/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultiByteArrayInputStream
extends InputStream {
    private static final TraceComponent tc = Tr.register(MultiByteArrayInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final byte[] EMPTYBYTEARRAY = new byte[0];
    protected byte[] currentBuf;
    protected byte[][] multiBuf;
    protected int bufPos;
    protected int currentPos;
    protected int currentCount;
    protected int totalCount;
    protected int passedCount;
    protected boolean isClosed;
    protected int mark = 0;
    protected byte[] markBuf;

    public MultiByteArrayInputStream(byte[][] buf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiByteArrayInputStream", buf);
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (buf.length == 0) {
            this.isClosed = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MultiByteArrayInputStream, but.length==0");
            }
            return;
        }
        this.passedCount = 0;
        this.totalCount = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == null) {
                buf[i] = EMPTYBYTEARRAY;
            }
            this.totalCount += buf[i].length;
        }
        if (this.totalCount == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MultiByteArrayInputStream, totalCount == 0");
            }
            return;
        }
        this.bufPos = 0;
        this.multiBuf = buf;
        this.currentBuf = buf[0];
        this.currentPos = 0;
        this.currentCount = buf[0].length;
        this.isClosed = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiByteArrayInputStream", this);
        }
    }

    public MultiByteArrayInputStream(byte[] buf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiByteArrayInputStream", buf);
        }
        this.currentBuf = buf;
        this.currentPos = 0;
        this.currentCount = buf.length;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiByteArrayInputStream", this);
        }
    }

    public MultiByteArrayInputStream(byte[] buf, int offset, int length) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiByteArrayInputStream", new Object[]{buf, new Integer(offset), new Integer(length)});
        }
        this.currentBuf = buf;
        this.currentPos = offset;
        this.currentCount = Math.min(offset + length, buf.length);
        this.mark = offset;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiByteArrayInputStream", this);
        }
    }

    @Override
    public synchronized int read() {
        if (this.currentPos < this.currentCount) {
            return this.currentBuf[this.currentPos++] & 0xFF;
        }
        if (this.bufPos + 1 < this.multiBuf.length) {
            this.nextBuf();
            return this.read();
        }
        return -1;
    }

    private void nextBuf() {
        this.passedCount += this.currentBuf.length;
        ++this.bufPos;
        if (this.bufPos >= this.multiBuf.length) {
            return;
        }
        this.currentBuf = this.multiBuf[this.bufPos];
        this.currentPos = 0;
        this.currentCount = this.currentBuf.length;
        if (this.multiBuf[this.bufPos].length == 0) {
            this.nextBuf();
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        if (this.isClosed) {
            return -1;
        }
        int remain = this.totalCount - this.passedCount - this.currentPos;
        if (remain <= 0) {
            this.isClosed = true;
            return -1;
        }
        if (remain < len) {
            len = remain;
        }
        remain = len;
        while (this.bufPos < this.multiBuf.length) {
            if (this.currentCount == 0) {
                this.nextBuf();
                continue;
            }
            if (this.currentPos + len <= this.currentCount) {
                System.arraycopy(this.currentBuf, this.currentPos, b, off, len);
                this.currentPos += len;
                break;
            }
            int currentRemain = this.currentCount - this.currentPos;
            System.arraycopy(this.currentBuf, this.currentPos, b, off, currentRemain);
            off += currentRemain;
            len -= currentRemain;
            if (this.bufPos + 1 < this.multiBuf.length) {
                this.nextBuf();
                continue;
            }
            ++this.bufPos;
        }
        return remain;
    }

    @Override
    public synchronized long skip(long n) {
        if ((long)this.currentPos + n > (long)this.currentCount) {
            n = this.currentCount - this.currentPos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.currentPos = (int)((long)this.currentPos + n);
        return n;
    }

    @Override
    public synchronized int available() {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.currentPos;
    }

    @Override
    public synchronized void reset() {
        this.bufPos = 0;
        this.passedCount = 0;
        this.currentBuf = this.multiBuf[0];
        this.currentPos = 0;
        this.currentCount = this.currentBuf.length;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    public static void main(String[] args) {
        byte[] ba = new byte[10];
        for (int i = 0; i < 10; ++i) {
            ba[i] = (byte)(i + 11);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        byte[] tmp = new byte[10];
        bais.read();
        bais.read(tmp, 0, 5);
        for (int i = 0; i < 5; ++i) {
            System.out.println(" " + tmp[i]);
        }
    }
}

