/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class C14NWriter {
    private static final TraceComponent tc = Tr.register(C14NWriter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String C14NBUFFERSIZE_KEY = "c14nbuffersize";
    private static final byte SP = 32;
    private static final byte QUOT = 34;
    private static final byte SLASH = 47;
    private static final byte COLON = 58;
    private static final byte LT = 60;
    private static final byte EQ = 61;
    private static final byte GT = 62;
    private static final byte QM = 63;
    private static final byte[] SP_XMLNS = new byte[]{32, 120, 109, 108, 110, 115};
    private static final byte[] ESC_TAB = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] ESC_LF = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] ESC_CR = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] ESC_QUOT = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] ESC_AMP = new byte[]{38, 97, 109, 112, 59};
    private static final byte[] ESC_LT = new byte[]{38, 108, 116, 59};
    private static final byte[] ESC_GT = new byte[]{38, 103, 116, 59};
    private static final byte[][] textTab = new byte[][]{null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_CR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_AMP, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_LT, null, ESC_GT, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final byte[][] attrTab = new byte[][]{null, null, null, null, null, null, null, null, null, ESC_TAB, ESC_LF, null, null, ESC_CR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_QUOT, null, null, null, ESC_AMP, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_LT, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    protected static int INIT_SIZE = 2048;
    protected static final int INIT_STACK_SIZE = 64;
    protected static final int INIT_CHAR_BUF_SIZE = 512;
    protected static final int LIMIT_BUFFER_SIZE = 10240;
    public static final boolean MODE_DIGEST = true;
    public static final boolean MODE_BYTEARRAY = false;
    protected boolean mode = true;
    protected byte[] out = new byte[INIT_SIZE];
    protected int size = 0;
    protected int max = INIT_SIZE;
    protected MessageDigest digester;
    protected byte[] digestValue = null;
    protected int depth = 0;
    protected int stackMax = 64;
    protected int[] stackStartTagOpenPos = new int[64];
    protected int[] stackQNameLength = new int[64];
    protected byte[][] stackQNameByteArray = new byte[64][];
    protected char[] charbuf = new char[512];

    public static void setINIT_SIZE(int size) {
        if (size > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set initial c14n buffer size = " + size);
            }
            INIT_SIZE = size;
        }
    }

    public C14NWriter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "C14NWriter");
        }
        try {
            this.digester = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "C14NWriter", this);
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this.digester.reset();
        this.digestValue = null;
        this.size = 0;
        this.mode = true;
        this.depth = 0;
        if (this.out.length > 10240) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resetting out[]:");
                Tr.debug(tc, "    out.length was " + this.out.length);
                Tr.debug(tc, "    max was " + this.max);
                Tr.debug(tc, "    resetting to " + INIT_SIZE);
            }
            this.max = INIT_SIZE;
            this.out = new byte[INIT_SIZE];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void writeStartTagOpen(String elemPrefix, String elemLocal) throws IOException {
        int elemLocalLength;
        int elemPrefixLength;
        int requiredSize;
        if (this.depth + 1 >= this.stackMax) {
            this.expandStack();
        }
        if ((requiredSize = this.size + (elemPrefixLength = elemPrefix.length()) + (elemLocalLength = elemLocal.length()) + 3) >= this.max) {
            this.expandArray(requiredSize);
        }
        ++this.depth;
        this.out[this.size++] = 60;
        this.stackStartTagOpenPos[this.depth] = this.size;
        if (elemPrefixLength != 0) {
            this.write(elemPrefix, elemPrefixLength);
            this.out[this.size++] = 58;
        }
        this.write(elemLocal, elemLocalLength);
        this.stackQNameLength[this.depth] = this.size - this.stackStartTagOpenPos[this.depth];
    }

    public void writeNamespaceDeclaration(String prefix, String uri) throws IOException {
        int uriLength;
        int prefixLength = prefix.length();
        int requiredSize = this.size + prefixLength + (uriLength = uri.length()) + 11;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        System.arraycopy(SP_XMLNS, 0, this.out, this.size, SP_XMLNS.length);
        this.size += SP_XMLNS.length;
        if (prefixLength != 0) {
            this.out[this.size++] = 58;
            this.write(prefix, prefixLength);
        }
        this.out[this.size++] = 61;
        this.out[this.size++] = 34;
        this.write(uri, uriLength);
        this.out[this.size++] = 34;
    }

    public void writeAttribute(String prefix, String local, String value) throws IOException {
        int valueLength;
        int localLength;
        int prefixLength;
        int requiredSize;
        if (prefix == null) {
            prefix = "";
        }
        if ((requiredSize = this.size + (prefixLength = prefix.length()) + (localLength = local.length()) + (valueLength = value.length()) + 6) >= this.max) {
            this.expandArray(requiredSize);
        }
        this.out[this.size++] = 32;
        if (prefixLength != 0) {
            this.write(prefix, prefixLength);
            this.out[this.size++] = 58;
        }
        this.write(local, localLength);
        this.out[this.size++] = 61;
        this.out[this.size++] = 34;
        this.writeWithCharEsc(value, valueLength, attrTab);
        this.out[this.size++] = 34;
    }

    public void writeStartTagClose() throws IOException {
        int requiredSize = this.size + 1;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        this.out[this.size++] = 62;
    }

    public void writeText(String str) throws IOException {
        int length = str.length();
        int requiredSize = this.size + length;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        this.writeWithCharEsc(str, length, textTab);
    }

    public boolean writeEndTagByUsingCache() throws IOException {
        int length = this.stackQNameLength[this.depth];
        int requiredSize = this.size + length + 3;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        int pos = this.stackStartTagOpenPos[this.depth];
        byte[] qnamecache = null;
        if (pos >= 0) {
            qnamecache = this.out;
            this.stackStartTagOpenPos[this.depth] = -1;
        } else if (this.stackQNameByteArray[this.depth] != null) {
            qnamecache = this.stackQNameByteArray[this.depth];
            pos = 0;
            length = qnamecache.length;
            this.stackQNameByteArray[this.depth] = null;
            this.stackStartTagOpenPos[this.depth] = -1;
        } else {
            return false;
        }
        this.out[this.size++] = 60;
        this.out[this.size++] = 47;
        System.arraycopy(qnamecache, pos, this.out, this.size, length);
        this.size += length;
        this.out[this.size++] = 62;
        --this.depth;
        return true;
    }

    public void writeEndTag(String elemPrefix, String elemLocalName) throws IOException {
        int localLength;
        int prefixLength = elemPrefix.length();
        int requiredSize = this.size + prefixLength + (localLength = elemLocalName.length()) + 4;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        this.out[this.size++] = 60;
        this.out[this.size++] = 47;
        if (prefixLength != 0) {
            this.write(elemPrefix, prefixLength);
            this.out[this.size++] = 58;
        }
        this.write(elemLocalName, localLength);
        this.out[this.size++] = 62;
        --this.depth;
    }

    public void writePI(String piTarget, String piData) throws IOException {
        int requiredSize;
        int piTargetLength = piTarget.length();
        int piDataLength = 0;
        if (piData != null) {
            piData = piData.trim();
            piDataLength = piData.length();
        }
        if ((requiredSize = this.size + piTargetLength + piDataLength + 5) > this.max) {
            this.expandArray(requiredSize);
        }
        this.out[this.size++] = 60;
        this.out[this.size++] = 63;
        this.write(piTarget, piTargetLength);
        if (piDataLength > 0) {
            this.out[this.size++] = 32;
            this.write(piData, piDataLength);
        }
        this.out[this.size++] = 63;
        this.out[this.size++] = 62;
    }

    private void write(String str, int length) throws IOException {
        int count;
        for (int totalCount = 0; totalCount < length; totalCount += count) {
            int end = totalCount + this.charbuf.length;
            if (end > length) {
                end = length;
            }
            str.getChars(totalCount, end, this.charbuf, 0);
            count = end - totalCount;
            for (int i = 0; i < count; ++i) {
                char c = this.charbuf[i];
                if ('\u0000' > c || c >= '\u0080') {
                    this.writeUTF8(str, totalCount + i);
                    return;
                }
                this.out[this.size++] = (byte)c;
            }
        }
    }

    private void writeUTF8(String str, int start) throws IOException {
        byte[] utf8bytes = str.substring(start).getBytes("UTF8");
        int requiredSize = this.size + utf8bytes.length;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        System.arraycopy(utf8bytes, 0, this.out, this.size, utf8bytes.length);
        this.size += utf8bytes.length;
    }

    private void writeWithCharEsc(String str, int length, byte[][] characterTab) throws IOException {
        int count;
        int start_size = this.size;
        for (int totalCount = 0; totalCount < length; totalCount += count) {
            int end = totalCount + this.charbuf.length;
            if (end > length) {
                end = length;
            }
            str.getChars(totalCount, end, this.charbuf, 0);
            count = end - totalCount;
            for (int i = 0; i < count; ++i) {
                char c = this.charbuf[i];
                if ('\u0000' <= c && c < characterTab.length) {
                    byte[] b = characterTab[c];
                    if (b == null) {
                        if (this.size >= this.out.length && tc.isDebugEnabled()) {
                            Tr.debug(tc, "str                 = " + str);
                            Tr.debug(tc, "str.length()        = " + str.length());
                            Tr.debug(tc, "i                   = " + i);
                            Tr.debug(tc, "length              = " + length);
                            Tr.debug(tc, "c                   = " + c);
                            Tr.debug(tc, "characterTab.length = " + characterTab.length);
                            Tr.debug(tc, "charbuf.length      = " + this.charbuf.length);
                            Tr.debug(tc, "out.length          = " + this.out.length);
                            Tr.debug(tc, "max                 = " + this.max);
                            Tr.debug(tc, "start_size          = " + start_size);
                            Tr.debug(tc, "size                = " + this.size);
                            Tr.debug(tc, "count               = " + count);
                            Tr.debug(tc, "totalCount          = " + totalCount);
                            Tr.debug(tc, "end                 = " + end);
                            Tr.debug(tc, "mode                = " + this.mode);
                        }
                        this.out[this.size++] = (byte)c;
                        continue;
                    }
                    int requiredSize = this.size + b.length;
                    if (requiredSize >= this.max) {
                        this.expandArray(requiredSize);
                    }
                    System.arraycopy(b, 0, this.out, this.size, b.length);
                    this.size += b.length;
                    continue;
                }
                this.writeUTF8WithCharEsc(str, totalCount + i, characterTab);
                return;
            }
        }
    }

    private void writeUTF8WithCharEsc(String str, int start, byte[][] characterTab) throws IOException {
        byte[] utf8bytes = str.substring(start).getBytes("UTF8");
        int requiredSize = this.size + utf8bytes.length;
        if (requiredSize >= this.max) {
            this.expandArray(requiredSize);
        }
        for (int i = 0; i < utf8bytes.length; ++i) {
            if (utf8bytes[i] > 0) {
                byte[] b = characterTab[utf8bytes[i]];
                if (b == null) {
                    this.out[this.size++] = utf8bytes[i];
                    continue;
                }
                System.arraycopy(b, 0, this.out, this.size, b.length);
                this.size += b.length;
                continue;
            }
            this.out[this.size++] = utf8bytes[i];
        }
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public boolean getMode() {
        return this.mode;
    }

    public byte[] toByteArray() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toByteArray", this);
        }
        byte[] ret = new byte[this.size];
        System.arraycopy(this.out, 0, ret, 0, this.size);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toByteArray", ret);
        }
        return ret;
    }

    public byte[] toDigestByteArray() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toDigestByteArray", this);
        }
        if (this.digestValue == null) {
            this.digester.update(this.out, 0, this.size);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ResourceShower logs [C14N] from C14NWriter:");
                Tr.debug(tc, new String(this.out, 0, this.size));
            }
            this.digestValue = this.digester.digest();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toDigestByteArray", this.digestValue);
        }
        return this.digestValue;
    }

    private void expandArray(int length) {
        if (this.mode) {
            length -= this.size;
            for (int i = 1; i <= this.depth; ++i) {
                int pos = this.stackStartTagOpenPos[i];
                if (this.stackQNameByteArray[i] == null && pos >= 0) {
                    int length2 = this.stackQNameLength[i];
                    this.stackQNameByteArray[i] = Arrays.copyOfRange(this.out, pos, pos + length2);
                }
                this.stackStartTagOpenPos[i] = -1;
            }
            this.digester.update(this.out, 0, this.size);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ResourceShower logs [C14N] from C14NWriter:");
                Tr.debug(tc, new String(this.out, 0, this.size));
            }
            this.size = 0;
            if (length > this.out.length) {
                this.expandArray0(length);
            }
        } else {
            this.expandArray0(length);
        }
    }

    private void expandArray0(int length) {
        this.max = this.max * 2 > length ? this.max * 2 : length * 2;
        byte[] tmpOut = new byte[this.max];
        System.arraycopy(this.out, 0, tmpOut, 0, this.size);
        this.out = tmpOut;
    }

    private void expandStack() {
        int newStackMaxSize = this.stackMax * 2;
        int[] tmp1 = new int[newStackMaxSize];
        int[] tmp2 = new int[newStackMaxSize];
        byte[][] tmp3 = new byte[newStackMaxSize][];
        System.arraycopy(this.stackStartTagOpenPos, 0, tmp1, 0, this.stackMax);
        System.arraycopy(this.stackQNameLength, 0, tmp2, 0, this.stackMax);
        System.arraycopy(this.stackQNameByteArray, 0, tmp3, 0, this.stackMax);
        this.stackStartTagOpenPos = tmp1;
        this.stackQNameLength = tmp2;
        this.stackQNameByteArray = tmp3;
        this.stackMax = newStackMaxSize;
    }
}

