/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;

public class AttributeSortedSet {
    private static final TraceComponent tc = Tr.register(AttributeSortedSet.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static final int INIT = 10;
    protected int[] attrIndex = new int[10];
    protected String[] attrNsUri = new String[10];
    protected String[] attrLocal = new String[10];
    protected String[] attrPrefix = new String[10];
    protected String[] attrValue = new String[10];
    protected int size = 0;

    public void reset() {
        this.size = 0;
    }

    public void reset(int initSize) {
        this.reset();
        if (initSize > this.attrIndex.length) {
            this.expandArray(initSize);
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.attrNsUri[i] = null;
            this.attrLocal[i] = null;
            this.attrPrefix[i] = null;
            this.attrValue[i] = null;
        }
    }

    private void expandArray(int initSize) {
        int nextCapacity = this.attrIndex.length * 2;
        if (initSize > nextCapacity) {
            nextCapacity = initSize;
        }
        int[] tmpIndex = new int[nextCapacity];
        String[] tmpNsUri = new String[nextCapacity];
        String[] tmpLocal = new String[nextCapacity];
        String[] tmpPrefix = new String[nextCapacity];
        String[] tmpValue = new String[nextCapacity];
        System.arraycopy(this.attrIndex, 0, tmpIndex, 0, this.size);
        System.arraycopy(this.attrNsUri, 0, tmpNsUri, 0, this.size);
        System.arraycopy(this.attrLocal, 0, tmpLocal, 0, this.size);
        System.arraycopy(this.attrPrefix, 0, tmpPrefix, 0, this.size);
        System.arraycopy(this.attrValue, 0, tmpValue, 0, this.size);
        this.attrIndex = tmpIndex;
        this.attrNsUri = tmpNsUri;
        this.attrLocal = tmpLocal;
        this.attrPrefix = tmpPrefix;
        this.attrValue = tmpValue;
    }

    public void add(int index, String nsUri, String local, String prefix, String value) {
        int comp;
        int i;
        if (index >= this.attrIndex.length) {
            this.expandArray(index);
        }
        for (i = 0; i < this.size && (comp = this.attrNsUri[i].compareTo(nsUri)) <= 0 && (comp != 0 || this.attrLocal[i].compareTo(local) <= 0); ++i) {
        }
        for (int j = this.size; j > i; --j) {
            this.attrIndex[j] = this.attrIndex[j - 1];
            this.attrNsUri[j] = this.attrNsUri[j - 1];
            this.attrLocal[j] = this.attrLocal[j - 1];
            this.attrPrefix[j] = this.attrPrefix[j - 1];
            this.attrValue[j] = this.attrValue[j - 1];
        }
        this.attrIndex[i] = index;
        this.attrNsUri[i] = nsUri;
        this.attrLocal[i] = local;
        this.attrPrefix[i] = prefix;
        this.attrValue[i] = value;
        ++this.size;
        if (this.size >= this.attrIndex.length) {
            this.expandArray(this.attrIndex.length * 2);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getSortedIndex(int index) {
        if (index >= this.size) {
            return -1;
        }
        return this.attrIndex[index];
    }

    public String getNsUri(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.attrNsUri[index];
    }

    public String getLocal(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.attrLocal[index];
    }

    public String getPrefix(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.attrPrefix[index];
    }

    public String getValue(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.attrValue[index];
    }
}

