/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.filter.XMLStreamReaderFilterImpl;
import com.ibm.ws.wssecurity.filter.util.DecryptionFilterResultSet;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.AsciiStringInputStream;
import com.ibm.ws.wssecurity.util.io.Base64DecodeInputStream;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import com.ibm.ws.wssecurity.util.io.MultipleInputStream;
import com.ibm.ws.wssecurity.wssapi.CommonContentConsumer;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.BufferedEncryptionInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionInputStream;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xml.xlxp2.api.util.ParsedEntityStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.StAXUtils;

public class DecryptionFilter
extends XMLStreamReaderFilterImpl {
    private static final boolean DEBUG = false;
    private static final TraceComponent tc = Tr.register(DecryptionFilter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final String ENCODING = "UTF-8";
    public static final byte[] DUMMY_END_TAG = new byte[]{60, 47, 100, 117, 109, 109, 121, 62};
    private static final int STATE_WAITING_TARGET = 1;
    private static final int STATE_READING = 2;
    private static final int STATE_PRODUCING = 3;
    private static final int STATE_PRODUCING_DUMMY_END_ELEMENT = 4;
    private static final int STATE_PRODUCING_DECRYPTED_FIRST_EVENT = 5;
    private static final int STATE_PRODUCING_DECRYPTED_SECOND_EVENT = 6;
    protected int fState;
    protected boolean fWithEmptyEncryptedDataMode;
    protected boolean fWithEmptyCipherValueMode;
    protected String fTargetId;
    protected AlgorithmFactory fAlgorithmFactory;
    protected EncryptionEngine fEncryptionEngine;
    protected Key fDecryptionKey;
    protected EncryptedData fEncryptedData = new EncryptedData();
    protected KeyInfoConsumerConfig fKeyInfoConsumerConfig;
    protected Map<Object, Object> fKeyRequestTemporalMap = new HashMap<Object, Object>();
    protected Map<Object, Object> fKeyRequestProperties;
    protected Map<Object, Object> fContext;
    protected int fDummyEndElementCount;
    protected XMLStreamReader fOriginalReader;
    protected HashMap<String, String> fParentDecls = new HashMap();
    protected int fDecryptedDepth;
    protected int fFirstDecryptedEventType;
    protected DecryptionFilterResultSet.DecryptionFilterResult fDecryptionFilterResult;
    protected InputStream fInputStreamToBeClosed;

    public DecryptionFilter() {
        this.reset();
    }

    public DecryptionFilter(XMLStreamReader reader) {
        this();
        this.reader = reader;
    }

    @Override
    public void reset() {
        super.reset();
        this.fState = 1;
        this.fWithEmptyEncryptedDataMode = false;
        this.fWithEmptyCipherValueMode = false;
        this.fTargetId = null;
        this.fAlgorithmFactory = null;
        this.fEncryptionEngine = null;
        this.fDecryptionKey = null;
        this.fEncryptedData = new EncryptedData();
        this.fKeyInfoConsumerConfig = null;
        this.fKeyRequestTemporalMap.clear();
        this.fKeyRequestProperties = null;
        this.fContext = null;
        this.fDummyEndElementCount = 0;
        this.fOriginalReader = null;
        this.fParentDecls.clear();
        this.fDecryptedDepth = 0;
        this.fFirstDecryptedEventType = 8;
        this.fDecryptionFilterResult = null;
        this.fInputStreamToBeClosed = null;
    }

    public void setTargetId(String targetId) {
        this.fTargetId = targetId;
        this.fEncryptedData.id = targetId;
    }

    public void setDecryptionInfo(AlgorithmFactory algorithmFactory, KeyInfoConsumerConfig keyInfoConsumer, Map<Object, Object> properties, Map<Object, Object> context, Key key) {
        this.fAlgorithmFactory = algorithmFactory;
        this.fKeyInfoConsumerConfig = keyInfoConsumer;
        this.fKeyRequestProperties = properties;
        this.fContext = context;
        this.fDecryptionKey = key;
    }

    public CommonContentConsumer.ResolvedKeyInfo getResolvedKeyInfo() {
        return this.fEncryptedData.kinfo;
    }

    public DecryptionFilterResultSet.DecryptionFilterResult getDecryptionFilterResult() {
        return this.fDecryptionFilterResult;
    }

    @Override
    public int next() throws XMLStreamException {
        switch (this.fState) {
            case 4: {
                --this.fDummyEndElementCount;
                if (this.fDummyEndElementCount <= 0) {
                    this.fState = 5;
                }
                return 2;
            }
            case 5: {
                this.fState = 6;
                return this.fFirstDecryptedEventType;
            }
            case 6: {
                this.fState = 3;
                OMNode decryptedTopNode = this.builder.getLastNode();
                this.fDecryptionFilterResult = new DecryptionFilterResultSet.DecryptionFilterResult(decryptedTopNode, this.fEncryptedData, this.fTargetId);
                if (this.messageContext == null) break;
                DecryptionFilterResultSet decryptionFilterResultSet = (DecryptionFilterResultSet)this.messageContext.getProperty(DecryptionFilterResultSet.class.getName());
                if (decryptionFilterResultSet == null) {
                    decryptionFilterResultSet = new DecryptionFilterResultSet();
                    this.messageContext.setProperty(DecryptionFilterResultSet.class.getName(), decryptionFilterResultSet);
                }
                decryptionFilterResultSet.addDecryptionFilterResult(this.fDecryptionFilterResult);
            }
        }
        int eventType = super.next();
        switch (this.fState) {
            case 1: {
                boolean findTarget = this.waitingTarget(eventType);
                if (!findTarget) {
                    return eventType;
                }
                eventType = this.processEncryptedData(eventType);
                break;
            }
            case 3: {
                eventType = this.checkEndElementOfDummy(eventType);
                break;
            }
            default: {
                throw new XMLStreamException("not implemented yet");
            }
        }
        return eventType;
    }

    private boolean waitingTarget(int eventType) throws XMLStreamException {
        if (eventType != 1) {
            return false;
        }
        String id = super.getAttributeValue("", "Id");
        if (id == null) {
            return false;
        }
        return id.equals(this.fTargetId);
    }

    private int processEncryptedData(int eventType) throws XMLStreamException {
        this.readEncryptedDataStartTag();
        eventType = this.skipEventsTo(1);
        eventType = this.readEncryptionMethod(eventType);
        eventType = this.readKeyInfo(eventType);
        this.getDecryptionKey();
        this.initEncryptionEngine();
        eventType = this.readCipherData(eventType);
        this.fState = 6;
        return eventType;
    }

    public void processEncryptedDataWithCreatingEmptyEncryptedData() throws XMLStreamException {
        this.fWithEmptyEncryptedDataMode = true;
        this.fFirstDecryptedEventType = this.processEncryptedData(1);
        this.fState = 4;
        this.fDummyEndElementCount = 1;
    }

    public void processCipherValueWithCreatingEmptyCipherValue(EncryptedData encryptedData, Key key, InputStream cipherValueInputStream) throws XMLStreamException {
        if (encryptedData.getEncryptionMethod() == null) {
            throw new NullPointerException("encryption method is null");
        }
        if (key == null) {
            throw new NullPointerException("decryption key is null");
        }
        if (cipherValueInputStream == null) {
            throw new NullPointerException("cipherValueInputStream is null");
        }
        this.fWithEmptyCipherValueMode = true;
        this.fEncryptedData = encryptedData;
        this.fDecryptionKey = key;
        this.getDecryptionKey();
        this.initEncryptionEngine();
        this.fFirstDecryptedEventType = this.createXMLStreamReaderForDecryptedData(cipherValueInputStream);
        this.fState = 4;
        this.fDummyEndElementCount = 3;
    }

    private int skipEventsTo(int targetEvent) throws XMLStreamException {
        int eventType = 0;
        while (super.hasNext()) {
            eventType = super.next();
            if (eventType != targetEvent) continue;
            return eventType;
        }
        return eventType;
    }

    private void readEncryptedDataStartTag() throws XMLStreamException {
        String elemLocalName = super.getLocalName();
        if (!LocalNameConstants.LocalNamesXENC.LN_ENCRYPTED_DATA.equals(elemLocalName)) {
            throw new XMLStreamException("DecryptionFilter: Target element of id " + this.fTargetId + " is not EncryptedData.");
        }
        String elemNamespaceUri = super.getNamespaceURI();
        if (!Constants.NS_ENC.equals(elemNamespaceUri)) {
            throw new XMLStreamException("DecryptionFilter: Target element of id " + this.fTargetId + " does not belongs to XENC.");
        }
        this.fEncryptedData.type = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_TYPE);
        this.fEncryptedData.mimeType = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_MIME_TYPE);
        this.fEncryptedData.encoding = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_ENCODING);
    }

    private int readEncryptionMethod(int eventType) throws XMLStreamException {
        if (LocalNameConstants.LocalNamesXENC.LN_ENCRYPTION_METHOD.equals(super.getLocalName()) && Constants.NS_ENC.equals(super.getNamespaceURI())) {
            this.fEncryptedData.encryptionMethod = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_ALGORITHM);
            eventType = this.skipEventsTo(1);
            if (LocalNameConstants.LocalNamesXENC.LN_KEY_SIZE.equals(super.getLocalName()) && Constants.NS_ENC.equals(super.getNamespaceURI())) {
                Object keySize = null;
                eventType = super.next();
                if (eventType == 4) {
                    this.fEncryptedData.keySize = super.getText();
                }
                eventType = this.skipEventsTo(1);
            }
            if (LocalNameConstants.LocalNamesXENC.LN_OAEP_PARAMS.equals(super.getLocalName()) && Constants.NS_ENC.equals(super.getNamespaceURI())) {
                String oaepParams = null;
                eventType = super.next();
                if (eventType == 4) {
                    oaepParams = super.getText();
                }
                eventType = this.skipEventsTo(1);
                if (LocalNameConstants.LocalNamesDSIG.LN_DIGEST_METHOD.equals(super.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(super.getNamespaceURI())) {
                    this.fEncryptedData.oaepParamDigestMethodAlgorithm = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_ALGORITHM);
                    eventType = this.skipEventsTo(1);
                    byte[] paramBytes = Base64Table.decode(oaepParams, 0, oaepParams.length());
                    try {
                        this.fEncryptedData.spec = this.fAlgorithmFactory.getOAEPParameterSpec(this.fEncryptedData.oaepParamDigestMethodAlgorithm, paramBytes);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new XMLStreamException(e);
                    }
                }
            }
        }
        return eventType;
    }

    private int readKeyInfo(int eventType) throws XMLStreamException {
        CommonContentConsumer.ResolvedKeyInfo kinfo = null;
        if (LocalNameConstants.LocalNamesDSIG.LN_KEY_INFO.equals(super.getLocalName()) && Constants.NS_DSIG.equals(super.getNamespaceURI())) {
            eventType = this.skipEventsTo(1);
            if (LocalNameConstants.LocalNamesDSIG.LN_KEY_NAME.equals(super.getLocalName()) && Constants.NS_DSIG.equals(super.getNamespaceURI())) {
                String keyName = null;
                eventType = super.next();
                if (eventType == 4) {
                    keyName = super.getText();
                }
                if (keyName == null) {
                    throw new XMLStreamException(SoapSecurityException.format("security.wssecurity.KeyNameContentConsumer.getKeyName01"));
                }
                kinfo = new CommonContentConsumer.ResolvedKeyInfo("KEYNAME");
                kinfo.setTokenName(keyName);
                this.fEncryptedData.kinfo = kinfo;
                eventType = this.skipEventsTo(1);
            } else if (LocalNameConstants.LocalNamesWSSE10.LN_SECURITY_TOKEN_REFERENCE.equals(super.getLocalName()) && Constants.NS_WSSE.equals(super.getNamespaceURI())) {
                String nonce = super.getAttributeValue(Constants.NS_WSC_SC, LocalNameConstants.LocalNamesWSC.LN_NONCE);
                String length = super.getAttributeValue(Constants.NS_WSC_SC, LocalNameConstants.LocalNamesWSC.LN_LENGTH);
                eventType = this.skipEventsTo(1);
                if ("KeyIdentifier".equals(super.getLocalName()) && Constants.NS_WSSE.equals(super.getNamespaceURI())) {
                    String valueType = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_VALUE_TYPE);
                    if (valueType == null) {
                        throw new XMLStreamException(SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token16"));
                    }
                    QName vtype = new QName("", valueType);
                    String encodingType = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_ENCODING_TYPE);
                    QName etype = encodingType != null ? new QName("", encodingType) : Constants.BASE64_BINARY;
                    String identifierType = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.lN_IDENTIFIER_TYPE);
                    QName itype = identifierType != null ? new QName("", identifierType) : Constants.ITSHA1;
                    String identifier = null;
                    eventType = super.next();
                    if (eventType == 4) {
                        identifier = super.getText();
                    }
                    kinfo = Constants.THUMBPRINTSHA1.equals(vtype) ? new CommonContentConsumer.ResolvedKeyInfo("THUMBPRINT") : new CommonContentConsumer.ResolvedKeyInfo("KEYID");
                    kinfo.setTokenId(identifier);
                    kinfo.setKidValueType(vtype);
                    kinfo.setKidEncodingType(etype);
                    kinfo.setKidIdentifierType(itype);
                    this.fEncryptedData.kinfo = kinfo;
                    eventType = this.skipEventsTo(1);
                } else if (LocalNameConstants.LocalNamesWSSE10.LN_REFERENCE.equals(super.getLocalName()) && Constants.NS_WSSE.equals(super.getNamespaceURI())) {
                    String ref;
                    String valueType = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_VALUE_TYPE);
                    if (valueType != null) {
                        QName vtype = new QName("", valueType);
                    }
                    if ((ref = super.getAttributeValue("", LocalNameConstants.LocalNameAttrDefaultNS.LN_URI)) == null) {
                        // empty if block
                    }
                    kinfo = new CommonContentConsumer.ResolvedKeyInfo("STRREF");
                    kinfo.setTokenReference(ref);
                    this.fEncryptedData.kinfo = kinfo;
                    eventType = this.skipEventsTo(1);
                } else {
                    if (LocalNameConstants.LocalNamesWSSE10.LN_EMBEDDED.equals(super.getLocalName()) && Constants.NS_WSSE.equals(super.getNamespaceURI())) {
                        throw new XMLStreamException("DecryptionFiler: DecryptionFiler can not handle Embedded key info");
                    }
                    if (LocalNameConstants.LocalNamesDSIG.LN_X509_DATA.equals(super.getLocalName()) && Constants.NS_DSIG.equals(super.getNamespaceURI())) {
                        String in;
                        eventType = this.skipEventsTo(1);
                        String x509IssuerName = null;
                        String x509SerialNumber = null;
                        if (LocalNameConstants.LocalNamesDSIG.LN_X509_ISSUER_SERIAL.equals(super.getLocalName()) && Constants.NS_DSIG.equals(super.getNamespaceURI())) {
                            eventType = this.skipEventsTo(1);
                            if (LocalNameConstants.LocalNamesDSIG.LN_X509_ISSUER_NAME.equals(super.getLocalName()) && Constants.NS_DSIG.equals(super.getNamespaceURI())) {
                                eventType = super.next();
                                if (eventType == 4) {
                                    x509IssuerName = super.getText();
                                }
                                eventType = this.skipEventsTo(1);
                            }
                            if (x509IssuerName == null) {
                                // empty if block
                            }
                            if (LocalNameConstants.LocalNamesDSIG.LN_X509_SERIAL_NUMBER.equals(super.getLocalName()) && Constants.NS_DSIG.equals(super.getNamespaceURI())) {
                                eventType = super.next();
                                if (eventType == 4) {
                                    x509SerialNumber = super.getText();
                                }
                                eventType = this.skipEventsTo(1);
                            }
                            if (x509SerialNumber == null) {
                                // empty if block
                            }
                        }
                        if ((in = KeyInfo.X509Data.encodeDName(x509IssuerName)) != null) {
                            x509IssuerName = in;
                        }
                        if (x509SerialNumber != null) {
                            try {
                                new BigInteger(x509SerialNumber);
                            }
                            catch (NumberFormatException nfee) {
                                try {
                                    BigInteger bint = CertificateUtil.convertSerialNumber(x509SerialNumber);
                                    x509SerialNumber = bint.toString();
                                }
                                catch (ParseException pe) {
                                    throw new XMLStreamException(".X509LoginModule.s04 " + x509SerialNumber);
                                }
                            }
                        }
                        kinfo = new CommonContentConsumer.ResolvedKeyInfo("X509ISSUER");
                        kinfo.setX509issuerName(x509IssuerName);
                        kinfo.setX509issuerSerial(x509SerialNumber);
                        this.fEncryptedData.kinfo = kinfo;
                    } else if (tc.isDebugEnabled()) {
                        Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{super.getLocalName()});
                    }
                }
                if (kinfo != null) {
                    kinfo.setImpliedDKNonce(nonce);
                    kinfo.setImpliedDKLength(length);
                }
            }
        }
        return eventType;
    }

    private void getDecryptionKey() throws XMLStreamException {
        if (this.fDecryptionKey != null) {
            return;
        }
        if (this.fEncryptedData.kinfo == null) {
            throw new XMLStreamException("Both ResolvedKeyInfo and decryption key are null");
        }
        try {
            this.fDecryptionKey = SignatureConsumer.callKeyInfoConsumer(this.fKeyInfoConsumerConfig, "DecryptingKey", this.fKeyRequestTemporalMap, this.fKeyRequestProperties, this.fEncryptedData.kinfo, this.fContext);
        }
        catch (SoapSecurityException e) {
            throw new XMLStreamException(e);
        }
    }

    private void initEncryptionEngine() throws XMLStreamException {
        try {
            this.fEncryptionEngine = this.fAlgorithmFactory.getEncryptionEngine(this.fEncryptedData.encryptionMethod);
            this.fEncryptionEngine.init(2, this.fDecryptionKey, this.fEncryptedData.spec);
        }
        catch (InvalidKeyException e) {
            throw new XMLStreamException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XMLStreamException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XMLStreamException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readCipherData(int eventType) throws XMLStreamException {
        void var2_5;
        Object var2_2 = null;
        if (!LocalNameConstants.LocalNamesXENC.LN_CIPHER_DATA.equals(super.getLocalName())) throw new XMLStreamException("There is no <CipherData>");
        if (!Constants.NS_ENC.equals(super.getNamespaceURI())) throw new XMLStreamException("There is no <CipherData>");
        eventType = this.skipEventsTo(1);
        if (LocalNameConstants.LocalNamesXENC.LN_CIPHER_VALUE.equals(super.getLocalName()) && Constants.NS_ENC.equals(super.getNamespaceURI())) {
            ParsedEntityStream parsedEntityStream = (ParsedEntityStream)this.reader.getProperty(ParsedEntityStream.class.getName());
            if (parsedEntityStream == null) {
                eventType = this.skipEventsTo(4);
                String text = this.getText();
                AsciiStringInputStream asciiStringInputStream = new AsciiStringInputStream(text);
            }
        } else {
            if (!LocalNameConstants.LocalNamesXENC.LN_CIPHER_REFERENCE.equals(super.getLocalName())) throw new XMLStreamException("There is no <CipherValue> or <CipherReference>");
            if (!Constants.NS_ENC.equals(super.getNamespaceURI())) throw new XMLStreamException("There is no <CipherValue> or <CipherReference>");
            throw new XMLStreamException("Not implemented yet.");
        }
        if (var2_5 != null) return this.createXMLStreamReaderForDecryptedData((InputStream)var2_5);
        throw new XMLStreamException("InputStream for <xenc:CipherValue> is null");
    }

    private int createXMLStreamReaderForDecryptedData(InputStream cipherValueInputStream) throws XMLStreamException {
        Base64DecodeInputStream b64dis = new Base64DecodeInputStream(cipherValueInputStream);
        if (this.fEncryptionEngine instanceof EncryptionEngineExtended) {
            BufferedEncryptionInputStream beis = (BufferedEncryptionInputStream)BufferedEncryptionInputStream.getFactory().getObject();
            beis.init(b64dis, (EncryptionEngineExtended)this.fEncryptionEngine, this.fAlgorithmFactory);
            this.fInputStreamToBeClosed = beis;
        } else {
            EncryptionInputStream eis = new EncryptionInputStream(b64dis, this.fEncryptionEngine, this.fAlgorithmFactory);
            this.fInputStreamToBeClosed = eis;
        }
        InputStream is = this.wrapEisByDummyElement(this.fInputStreamToBeClosed);
        XMLStreamReader decReader = StAXUtils.createXMLStreamReader(is, ENCODING);
        int eventTypeDecReader = 1;
        while (decReader.hasNext() && (eventTypeDecReader = decReader.next()) != 1) {
        }
        this.fDecryptedDepth = 1;
        eventTypeDecReader = decReader.next();
        this.fOriginalReader = this.reader;
        this.reader = decReader;
        int eventType = eventTypeDecReader;
        return eventType;
    }

    private InputStream wrapEisByDummyElement(InputStream eis) throws XMLStreamException {
        String nsUri;
        String prefix;
        OMElement omElement;
        OMContainer parent;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapEisByDummyElement()");
        }
        OMNode last = this.builder.getLastNode();
        if (this.fWithEmptyEncryptedDataMode) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fWithEmptyEncryptedDataMode is true");
            }
            parent = last.getParent();
        } else if (this.fWithEmptyCipherValueMode) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fWithEmptyCipherValueMode is true");
                Tr.debug(tc, "last is " + last.getClass().getName());
            }
            parent = last.getParent();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent is " + parent.getClass().getName());
            }
            if (parent instanceof OMElement) {
                omElement = (OMElement)parent;
                parent = omElement.getParent();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "grandparent is " + parent.getClass().getName());
                }
                if (parent instanceof OMElement) {
                    omElement = (OMElement)parent;
                    parent = omElement.getParent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "greatgrandparent is " + parent.getClass().getName());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "grandparent was not OMElement");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent was not OMElement");
            }
        } else if (last instanceof OMContainer && !last.isComplete()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "last node is OMContainer, but parsing is not complete");
            }
            parent = (OMContainer)((Object)last);
        } else {
            parent = last.getParent();
        }
        while (parent instanceof OMElement) {
            omElement = (OMElement)parent;
            Iterator<Map.Entry<String, String>> ite = omElement.getAllDeclaredNamespaces();
            while (ite.hasNext()) {
                OMNamespace omn = (OMNamespace)ite.next();
                prefix = omn.getPrefix();
                nsUri = omn.getNamespaceURI();
                if (this.fParentDecls.containsKey(prefix)) continue;
                this.fParentDecls.put(prefix, nsUri);
            }
            parent = omElement.getParent();
        }
        StringBuffer dummyStart = new StringBuffer();
        dummyStart.append("<dummy");
        for (Map.Entry<String, String> entry : this.fParentDecls.entrySet()) {
            prefix = entry.getKey();
            nsUri = entry.getValue();
            if ("".equals(prefix)) {
                dummyStart.append(" xmlns=\"");
            } else {
                dummyStart.append(" xmlns:");
                dummyStart.append(prefix);
                dummyStart.append("=\"");
            }
            dummyStart.append(nsUri);
            dummyStart.append("\"");
        }
        dummyStart.append(">");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dummy start element = " + dummyStart);
        }
        InputStream[] inputStreams = new InputStream[3];
        try {
            inputStreams[0] = new ByteArrayInputStream(dummyStart.toString().getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
        inputStreams[1] = eis;
        inputStreams[2] = new ByteArrayInputStream(DUMMY_END_TAG);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapEisByDummyElement()");
        }
        return new MultipleInputStream(inputStreams);
    }

    private int checkEndElementOfDummy(int eventType) throws XMLStreamException {
        switch (eventType) {
            case 1: {
                ++this.fDecryptedDepth;
                break;
            }
            case 2: {
                --this.fDecryptedDepth;
                if (this.fDecryptedDepth != -1) break;
                this.reader.close();
                try {
                    this.fInputStreamToBeClosed.close();
                    this.fInputStreamToBeClosed = null;
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
                super.setReader(this.fOriginalReader);
                do {
                    if ((eventType = this.skipEventsTo(2)) == 2) continue;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "WARNING: Likely hit end of document without finding end tag of EncryptedData");
                    break;
                } while (!"EncryptedData".equals(super.getLocalName()) || !Constants.NS_ENC.equals(super.getNamespaceURI()));
                eventType = super.next();
                this.remove();
                break;
            }
        }
        return eventType;
    }

    public static final class EncryptedData {
        protected String id = null;
        protected String type = null;
        protected String mimeType = null;
        protected String encoding = null;
        protected String encryptionMethod = null;
        protected String keySize = null;
        protected String oaepParamDigestMethodAlgorithm = null;
        protected AlgorithmParameterSpec spec = null;
        protected CommonContentConsumer.ResolvedKeyInfo kinfo = null;
        protected Object encryptionProperties = null;

        public void reset() {
            this.id = null;
            this.type = null;
            this.mimeType = null;
            this.encoding = null;
            this.encryptionMethod = null;
            this.keySize = null;
            this.oaepParamDigestMethodAlgorithm = null;
            this.spec = null;
            this.kinfo = null;
            this.encryptionProperties = null;
        }

        public final String getId() {
            return this.id;
        }

        public final String getType() {
            return this.type;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncryptedDataAttributeValues(String id, String type, String mimeType, String encoding) {
            this.id = id;
            this.type = type;
            this.mimeType = mimeType;
            this.encoding = encoding;
        }

        public final String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        public final String getKeySize() {
            return this.keySize;
        }

        public final String getOaepParamDigestMethodAlgorithm() {
            return this.oaepParamDigestMethodAlgorithm;
        }

        public final AlgorithmParameterSpec getSpec() {
            return this.spec;
        }

        public final void setEncryptionMethod(String encryptionMethod, String keySize, String oaepParamDigestMethodAlgorithm, AlgorithmParameterSpec spec) {
            this.encryptionMethod = encryptionMethod;
            this.keySize = keySize;
            this.oaepParamDigestMethodAlgorithm = oaepParamDigestMethodAlgorithm;
            this.spec = spec;
        }

        public final CommonContentConsumer.ResolvedKeyInfo getKinfo() {
            return this.kinfo;
        }

        public final void setKinfo(CommonContentConsumer.ResolvedKeyInfo kinfo) {
            this.kinfo = kinfo;
        }

        public final Object getEncryptionProperties() {
            return this.encryptionProperties;
        }

        public final void setEncryptionProperties(Object encryptionProperties) {
            this.encryptionProperties = encryptionProperties;
        }
    }
}

