/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import com.ibm.ws.wssecurity.filter.C14NWriterFilter;
import com.ibm.ws.wssecurity.filter.C14NWriterFilterForSOAPBodyFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

public class C14NWriterFilterForSOAPBody
extends C14NWriterFilter {
    private static final TraceComponent tc = Tr.register(C14NWriterFilterForSOAPBody.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String SOAP_BODY_C14N_DIGEST = (C14NWriterFilterForSOAPBody.class.getName() + "SOAP_BODY_C14N_DIGEST").intern();
    public static final String SOAP_BODY_CANONICAL_FORM = (C14NWriterFilterForSOAPBody.class.getName() + "SOAP_BODY_CANONICAL_FORM").intern();
    protected String bodyPrefix = null;
    protected String bodyLocalName = null;
    protected boolean bodyMode = false;

    @Override
    public void reset() {
        super.reset();
        this.bodyMode = false;
        this.bodyPrefix = null;
        this.bodyLocalName = null;
    }

    @Override
    public void release() {
        C14NWriterFilterForSOAPBodyFactory.getInstance().releaseObject(this);
    }

    public void writeSOAPBodyStartTag(OMElement bodyElem) throws XMLStreamException, IOException {
        int i;
        String bodyNsUri;
        ++this.c14nDepth;
        this.bodyMode = true;
        OMNamespace bodyNS = bodyElem.getNamespace();
        this.bodyPrefix = bodyNS.getPrefix();
        if (this.bodyPrefix == null) {
            this.bodyPrefix = DEFAULT_NAMESPACE_PREFIX;
        }
        if ((bodyNsUri = bodyNS.getNamespaceURI()) == null) {
            bodyNsUri = EMPTY_NAMESPACE_URI;
        }
        this.bodyLocalName = bodyElem.getLocalName();
        this.c14nWriter.writeStartTagOpen(this.bodyPrefix, this.bodyLocalName);
        this.tobeRenderedSet.add(this.bodyPrefix, bodyNsUri);
        int attrCount = 0;
        Iterator bodyAttrs = bodyElem.getAllAttributes();
        while (bodyAttrs.hasNext()) {
            OMAttribute tmpAttr = (OMAttribute)bodyAttrs.next();
            String attrLocal = tmpAttr.getLocalName();
            OMNamespace attrNs = tmpAttr.getNamespace();
            String attrValue = tmpAttr.getAttributeValue();
            String attrPrefix = DEFAULT_NAMESPACE_PREFIX;
            String attrNsUri = EMPTY_NAMESPACE_URI;
            if (attrNs != null) {
                attrPrefix = attrNs.getPrefix();
                if (attrPrefix == null) {
                    attrPrefix = DEFAULT_NAMESPACE_PREFIX;
                }
                if ((attrNsUri = attrNs.getNamespaceURI()) == null) {
                    attrNsUri = EMPTY_NAMESPACE_URI;
                }
            }
            this.attrSortedSet.add(attrCount, attrNsUri, attrLocal, attrPrefix, attrValue);
            this.tobeRenderedSet.add(attrPrefix, attrNsUri);
            ++attrCount;
        }
        bodyAttrs = null;
        if (this.inclNsMode == 1) {
            OMElement envElem = (OMElement)bodyElem.getParent();
            Iterator envNsIte = envElem.getAllDeclaredNamespaces();
            while (envNsIte.hasNext()) {
                OMNamespace tmpNs = (OMNamespace)envNsIte.next();
                String tmpPrefix = DEFAULT_NAMESPACE_PREFIX;
                String tmpNsUri = EMPTY_NAMESPACE_URI;
                if (tmpNs != null) {
                    tmpPrefix = tmpNs.getPrefix();
                    if (tmpPrefix == null) {
                        tmpPrefix = DEFAULT_NAMESPACE_PREFIX;
                    }
                    if ((tmpNsUri = tmpNs.getNamespaceURI()) == null) {
                        tmpNsUri = EMPTY_NAMESPACE_URI;
                    }
                }
                this.tobeRenderedSet.add(tmpPrefix, tmpNsUri);
                this.inclusiveNamespacesPrefixList.add(tmpPrefix);
            }
            Iterator bodyNsIte = bodyElem.getAllDeclaredNamespaces();
            while (bodyNsIte.hasNext()) {
                OMNamespace tmpNs = (OMNamespace)bodyNsIte.next();
                String tmpPrefix = DEFAULT_NAMESPACE_PREFIX;
                String tmpNsUri = EMPTY_NAMESPACE_URI;
                if (tmpNs != null) {
                    tmpPrefix = tmpNs.getPrefix();
                    if (tmpPrefix == null) {
                        tmpPrefix = DEFAULT_NAMESPACE_PREFIX;
                    }
                    if ((tmpNsUri = tmpNs.getNamespaceURI()) == null) {
                        tmpNsUri = EMPTY_NAMESPACE_URI;
                    }
                }
                this.tobeRenderedSet.add(tmpPrefix, tmpNsUri);
                this.inclusiveNamespacesPrefixList.add(tmpPrefix);
            }
        }
        int tobeRenderedSize = this.tobeRenderedSet.getSize();
        for (i = 0; i < tobeRenderedSize; ++i) {
            String toBeRenderedPrefix = this.tobeRenderedSet.getPrefix(i);
            String toBeRenderedUri = this.tobeRenderedSet.getNsUri(i);
            this.c14nWriter.writeNamespaceDeclaration(toBeRenderedPrefix, toBeRenderedUri);
            this.nsRendered.declarePrefix(toBeRenderedPrefix, toBeRenderedUri);
        }
        this.tobeRenderedSet.reset();
        for (i = 0; i < attrCount; ++i) {
            String attrPrefix = this.attrSortedSet.getPrefix(i);
            this.c14nWriter.writeAttribute(attrPrefix, this.attrSortedSet.getLocal(i), this.attrSortedSet.getValue(i));
        }
        this.c14nWriter.writeStartTagClose();
    }

    public void writeSOAPBodyEndTag() throws IOException {
        this.c14nWriter.writeEndTag(this.bodyPrefix, this.bodyLocalName);
        --this.c14nDepth;
        this.setResult();
        if (this.context != null) {
            if (this.c14nWriter.getMode()) {
                this.context.put(SOAP_BODY_C14N_DIGEST, this.getDigestValue());
            } else {
                this.context.put(SOAP_BODY_CANONICAL_FORM, this.getCanonicalForm());
            }
        }
    }
}

