/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.filter.XMLStreamReaderFilterImpl;
import com.ibm.ws.wssecurity.filter.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.filter.util.C14NFilterResultSet;
import com.ibm.ws.wssecurity.filter.util.C14NWriter;
import com.ibm.ws.wssecurity.filter.util.NamespaceStack;
import com.ibm.ws.wssecurity.filter.util.StringSequentialSortedSet;
import com.ibm.ws.wssecurity.filter.util.StringTokenizer;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class C14NFilter
extends XMLStreamReaderFilterImpl {
    private static final TraceComponent tc = Tr.register(C14NFilter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String DEFAULT_NAMESPACE_PREFIX_INDICATOR = "#default".intern();
    public static final String DEFAULT_NAMESPACE_PREFIX = "".intern();
    public static final String EMPTY_NAMESPACE_URI = "".intern();
    public static final String[] ZERO_ARRAY = new String[0];
    protected String targetWSUID = null;
    protected String[] inclusiveNamespacesPrefixList = ZERO_ARRAY;
    protected int inclusiveNamespacesPrefixListSize = 0;
    protected boolean inC14N = false;
    protected int c14nDepth = 0;
    protected C14NWriter c14nWriter = new C14NWriter();
    protected NamespaceStack nsRendered = new NamespaceStack();
    protected AttributeSortedSet attrSortedSet = new AttributeSortedSet();
    protected StringSequentialSortedSet tobeRenderedSet = new StringSequentialSortedSet();
    protected boolean finished;

    public C14NFilter() {
    }

    public C14NFilter(XMLStreamReader reader) {
        this();
        this.reader = reader;
    }

    @Override
    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        super.reset();
        this.targetWSUID = null;
        this.inclusiveNamespacesPrefixList = ZERO_ARRAY;
        this.inclusiveNamespacesPrefixListSize = 0;
        this.inC14N = false;
        this.c14nDepth = 0;
        this.c14nWriter.reset();
        this.nsRendered.reset();
        this.attrSortedSet.reset(0);
        this.tobeRenderedSet.reset();
        this.finished = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void setMode(boolean mode) {
        this.c14nWriter.setMode(mode);
    }

    public void setTargetWSUID(String targetWSUID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetWSUID", new Object[]{targetWSUID, this});
        }
        this.targetWSUID = targetWSUID;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargetWSUID");
        }
    }

    public void setInclusiveNamespacesString(String list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInclusiveNamespacesString", new Object[]{list, this});
        }
        if (list == null) {
            this.setInclusiveNamespaces(null);
            return;
        }
        String[] incList = StringTokenizer.parsePrefixList(list);
        this.setInclusiveNamespaces(incList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInclusiveNamespacesString");
        }
    }

    protected void setInclusiveNamespaces(String[] list) {
        int i;
        if (list == null) {
            this.inclusiveNamespacesPrefixList = ZERO_ARRAY;
            this.inclusiveNamespacesPrefixListSize = 0;
            return;
        }
        for (i = 0; i < list.length && list[i] != null; ++i) {
            if (!DEFAULT_NAMESPACE_PREFIX_INDICATOR.equals(list[i])) continue;
            list[i] = DEFAULT_NAMESPACE_PREFIX;
        }
        this.inclusiveNamespacesPrefixList = list;
        this.inclusiveNamespacesPrefixListSize = i;
    }

    @Override
    public int next() throws XMLStreamException {
        int eventType = this.reader.next();
        if (this.finished) {
            return eventType;
        }
        if (!this.inC14N) {
            if (eventType != 1) {
                return eventType;
            }
            String id = this.reader.getAttributeValue(Constants.NS_WSU, LocalNameConstants.LocalNamesWSU.LN_ID);
            if (id == null || !this.targetWSUID.equals(id)) {
                return eventType;
            }
            this.findTarget();
        }
        try {
            this.c14n(eventType);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return eventType;
    }

    private void findTarget() {
        this.inC14N = true;
        if (this.inclusiveNamespacesPrefixListSize > 0) {
            for (int i = 0; i < this.inclusiveNamespacesPrefixListSize; ++i) {
                String nsUri = this.reader.getNamespaceURI(this.inclusiveNamespacesPrefixList[i]);
                if (nsUri == null) continue;
                this.tobeRenderedSet.add(this.inclusiveNamespacesPrefixList[i], nsUri);
            }
        }
    }

    public void findTargetWithC14N() throws IOException {
        this.findTarget();
        this.c14n(this.getEventType());
    }

    private boolean isInInclusiveNameSpacesPrefixList(String str) {
        for (int i = 0; i < this.inclusiveNamespacesPrefixListSize; ++i) {
            if (!this.inclusiveNamespacesPrefixList[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    private void c14n(int ret) throws IOException {
        switch (ret) {
            case 1: {
                ++this.c14nDepth;
                this.nsRendered.pushContext();
                this.c14nStartElement();
                break;
            }
            case 2: {
                this.c14nEndElement();
                this.nsRendered.popContext();
                --this.c14nDepth;
                if (this.c14nDepth != 0) break;
                this.setResult();
                this.inC14N = false;
                this.finished = true;
                this.remove();
                break;
            }
            case 3: {
                this.c14nWriter.writePI(this.reader.getPITarget(), this.reader.getPIData());
                break;
            }
            case 4: {
                this.c14nWriter.writeText(this.reader.getText());
                break;
            }
            case 12: {
                this.c14nWriter.writeText(this.reader.getText());
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                break;
            }
            case 6: {
                this.c14nWriter.writeText(this.reader.getText());
            }
        }
    }

    private void c14nStartElement() throws IOException {
        int tobeRenderedSize;
        String attrValue;
        String attrPrefix;
        int attrCount;
        String elemPrefix = this.reader.getPrefix();
        if (elemPrefix == null) {
            elemPrefix = DEFAULT_NAMESPACE_PREFIX;
        }
        this.c14nWriter.writeStartTagOpen(elemPrefix, this.reader.getLocalName());
        if (this.inclusiveNamespacesPrefixListSize == 0 || !this.isInInclusiveNameSpacesPrefixList(elemPrefix)) {
            String renderedNsUri;
            String elemNsUri = this.reader.getNamespaceURI();
            if (elemNsUri == null) {
                elemNsUri = EMPTY_NAMESPACE_URI;
            }
            if ((renderedNsUri = this.nsRendered.getURI(elemPrefix)) == null) {
                this.tobeRenderedSet.add(elemPrefix, elemNsUri);
            } else if (!renderedNsUri.equals(elemNsUri)) {
                this.tobeRenderedSet.add(elemPrefix, elemNsUri);
            }
        }
        if ((attrCount = this.reader.getAttributeCount()) > 0) {
            this.attrSortedSet.reset(attrCount);
            for (int i = 0; i < attrCount; ++i) {
                String attrLocal = this.reader.getAttributeLocalName(i);
                attrPrefix = this.reader.getAttributePrefix(i);
                String attrNsUri = this.reader.getAttributeNamespace(i);
                if (attrNsUri == null) {
                    attrNsUri = EMPTY_NAMESPACE_URI;
                }
                attrValue = this.reader.getAttributeValue(i);
                this.attrSortedSet.add(i, attrNsUri, attrLocal, attrPrefix, attrValue);
                if (attrPrefix == null || this.inclusiveNamespacesPrefixListSize != 0 && this.isInInclusiveNameSpacesPrefixList(attrPrefix)) continue;
                String renderedNsUri = this.nsRendered.getURI(attrPrefix);
                if (renderedNsUri == null) {
                    this.tobeRenderedSet.add(attrPrefix, attrNsUri);
                    continue;
                }
                if (renderedNsUri.equals(attrNsUri)) continue;
                this.tobeRenderedSet.add(attrPrefix, attrNsUri);
            }
        }
        if (this.inclusiveNamespacesPrefixListSize > 0) {
            int nsDeclCount = this.reader.getNamespaceCount();
            for (int i = 0; i < nsDeclCount; ++i) {
                String renderedNsUri;
                String nsDeclPrefix = this.reader.getNamespacePrefix(i);
                if (nsDeclPrefix == null) {
                    nsDeclPrefix = DEFAULT_NAMESPACE_PREFIX;
                }
                if (!this.isInInclusiveNameSpacesPrefixList(nsDeclPrefix)) continue;
                String nsDeclUri = this.reader.getNamespaceURI(i);
                if (nsDeclUri == null) {
                    nsDeclUri = EMPTY_NAMESPACE_URI;
                }
                if ((renderedNsUri = this.nsRendered.getURI(nsDeclPrefix)) == null) {
                    this.tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
                    continue;
                }
                if (renderedNsUri.equals(nsDeclUri)) continue;
                this.tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
            }
        }
        if ((tobeRenderedSize = this.tobeRenderedSet.getSize()) > 0) {
            for (int i = 0; i < tobeRenderedSize; ++i) {
                String toBeRenderedPrefix = this.tobeRenderedSet.getPrefix(i);
                String toBeRenderedUri = this.tobeRenderedSet.getNsUri(i);
                this.c14nWriter.writeNamespaceDeclaration(toBeRenderedPrefix, toBeRenderedUri);
                this.nsRendered.declarePrefix(toBeRenderedPrefix, toBeRenderedUri);
            }
            this.tobeRenderedSet.reset();
        }
        if (attrCount > 0) {
            for (int i = 0; i < attrCount; ++i) {
                attrPrefix = this.attrSortedSet.getPrefix(i);
                String attrLocalName = this.attrSortedSet.getLocal(i);
                attrValue = this.attrSortedSet.getValue(i);
                this.c14nWriter.writeAttribute(attrPrefix, attrLocalName, attrValue);
            }
        }
        this.c14nWriter.writeStartTagClose();
    }

    private void c14nEndElement() throws IOException {
        boolean success = this.c14nWriter.writeEndTagByUsingCache();
        if (!success) {
            String elemPrefixEnd = this.reader.getPrefix();
            if (elemPrefixEnd == null) {
                elemPrefixEnd = DEFAULT_NAMESPACE_PREFIX;
            }
            this.c14nWriter.writeEndTag(elemPrefixEnd, this.reader.getLocalName());
        }
    }

    public byte[] getCanonicalForm() {
        return this.c14nWriter.toByteArray();
    }

    public byte[] getDigestValue() {
        return this.c14nWriter.toDigestByteArray();
    }

    private void setResult() {
        int type;
        if (this.messageContext == null) {
            return;
        }
        C14NFilterResultSet c14nFilterResultSet = (C14NFilterResultSet)this.messageContext.getProperty(C14NFilterResultSet.class.getName());
        if (c14nFilterResultSet == null) {
            c14nFilterResultSet = new C14NFilterResultSet();
            this.messageContext.setProperty(C14NFilterResultSet.class.getName(), c14nFilterResultSet);
        }
        byte[] bytearray = null;
        if (!this.c14nWriter.getMode()) {
            bytearray = this.getCanonicalForm();
            type = 2;
        } else {
            bytearray = this.getDigestValue();
            type = 1;
        }
        C14NFilterResultSet.C14NFilterResult result = new C14NFilterResultSet.C14NFilterResult(this.targetWSUID, "http://www.w3.org/2001/10/xml-exc-c14n#", this.inclusiveNamespacesPrefixList, "http://www.w3.org/2000/09/xmldsig#sha1", type, bytearray);
        c14nFilterResultSet.addC14NResultById(result);
    }
}

