/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.ResultMessagePool;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.enc.DecryptionResult;
import com.ibm.ws.wssecurity.filter.C14NFilter;
import com.ibm.ws.wssecurity.filter.C14NFilterFactory;
import com.ibm.ws.wssecurity.filter.DecryptionFilter;
import com.ibm.ws.wssecurity.filter.DecryptionFilterFactory;
import com.ibm.ws.wssecurity.filter.OMtoXMLStreamReader;
import com.ibm.ws.wssecurity.filter.UnmarshallFilter;
import com.ibm.ws.wssecurity.filter.XMLStreamReaderFilter;
import com.ibm.ws.wssecurity.filter.util.DecryptionFilterResultSet;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.JAXWSUtil;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.io.AsciiStringInputStream;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedData;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceType;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.xml.xlxp2.api.stax.XMLStreamReaderProxy;
import com.ibm.xml.xlxp2.api.util.ParsedEntityStream;
import com.ibm.xml.xlxp2.api.wssec.WSInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;

public class EncryptionConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(EncryptionConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionConsumer.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private static final QName PREFIX_LIST_Q = new QName(LocalNameConstants.LocalNameAttrDefaultNS.LN_PREFIX_LIST);
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMNode target[" + DOMUtils.getDisplayName(target) + "]," + "Map context)");
        }
        int hash = 0;
        OMElement xenc2 = null;
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s13");
        }
        if (target.getType() == 1) {
            xenc2 = (OMElement)target;
            String ns = xenc2.getNamespace() == null ? null : xenc2.getNamespace().getNamespaceURI();
            String ln = xenc2.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if (target.getType() != 1 || (hash += ln == null ? 0 : ln.hashCode()) != Constants.HASH_ENC_ENCRYPTEDKEY && hash != Constants.HASH_ENC_REFERENCELIST) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(target));
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(target));
        }
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        EncryptionConsumerConfig config2 = (EncryptionConsumerConfig)context.remove("com.ibm.ws.wssecurity.impl.config.encryptionConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionConsumerConfig [" + config2 + "].");
        }
        if (EncryptedKey.isOfType(xenc2)) {
            EncryptionConsumer.checkEncryptedKey(xenc2, config2);
        } else {
            EncryptionConsumer.checkReferenceList(xenc2, config2);
        }
        HashMap<Object, Object> type = new HashMap<Object, Object>(2);
        OMDocument doc = DOMUtil.getOwnerDocument(xenc2);
        String dataEncMethod = null;
        dataEncMethod = config2.getDataEncryptionMethod().getAlgorithm();
        context.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", dataEncMethod);
        IDResolver resolver2 = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        DecryptionResult dresult = EncryptionConsumer.decrypt(xenc2, config2, resolver2, doc, gconfig, type, this._selectors, nsWsse, nsWsu, context);
        EncryptionConsumer.setDecryptionResult(dresult, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode target, Map context)");
        }
    }

    private static void checkEncryptedKey(OMElement enckey, EncryptionConsumerConfig config2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptedKey(OMElement enckey[" + DOMUtils.getDisplayName(enckey) + "]," + "EncryptionConsumerConfig config)");
        }
        int hash = 0;
        OMElement el = DOMUtils.getFirstElement(enckey);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String algorithm = el.getAttributeValue(ALGORITHM_Q);
                if (config2.getKeyEncryptionMethod() == null || !config2.getKeyEncryptionMethod().getAlgorithm().equals(algorithm)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s15", algorithm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm + "] is OK.");
                }
            } else if (hash == Constants.HASH_ENC_REFERENCELIST) {
                EncryptionConsumer.checkReferenceList(el, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_ENC_CIPHERDATA) {
                EncryptionConsumer.checkCipherData(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_DS_KEYINFO) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_ENC_CARRIEDKEYNAME || hash == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(enckey)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptedKey(OMElement enckey, EncryptionConsumerConfig config)");
        }
    }

    private static void checkReferenceList(OMElement reflist, EncryptionConsumerConfig config2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReferenceList(OMElement reflist[" + DOMUtils.getDisplayName(reflist) + "]," + "EncryptionConsumerConfig config)");
        }
        if (config2 != null && config2.getKeyEncryptionMethod() != null && config2.getKeyEncryptionMethod().getAlgorithm().length() > 0) {
            throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.EncryptionConsumer.s12", config2.getKeyEncryptionMethod().getAlgorithm());
        }
        int hash = 0;
        OMElement el = DOMUtils.getFirstElement(reflist);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_DATAREFERENCE || hash == Constants.HASH_ENC_KEYREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(reflist)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReferenceList(OMElement reflist, EncryptionConsumerConfig config)");
        }
    }

    private static void checkEncryptedData(OMElement encdata, EncryptionConsumerConfig config2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptedKey(OMElement encdata[" + DOMUtils.getDisplayName(encdata) + "]," + "EncryptionConsumerConfig config)");
        }
        int hash = 0;
        OMElement startingElement = null;
        String ns = encdata.getNamespace() == null ? null : encdata.getNamespace().getNamespaceURI();
        String ln = encdata.getLocalName();
        hash = ns == null ? 0 : ns.hashCode() * 31;
        if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_WSSE11_ENCRYPTEDHEADER) {
            startingElement = encdata.getFirstElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "element was EncryptedHeader...so retrieved EncryptedData from it before checking EncryptedData");
            }
        } else {
            startingElement = encdata;
        }
        OMElement el = DOMUtils.getFirstElement(startingElement);
        while (el != null) {
            ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String algorithm = el.getAttributeValue(ALGORITHM_Q);
                if (!config2.getDataEncryptionMethod().getAlgorithm().equals(algorithm)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s14", algorithm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm + "] is OK.");
                }
            } else if (hash == Constants.HASH_ENC_CIPHERDATA) {
                EncryptionConsumer.checkCipherData(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_DS_KEYINFO) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK. But this consumer igonores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(encdata)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptedData(OMElement encdata, EncryptionConsumerConfig config)");
        }
    }

    private static void checkCipherData(OMElement cipdata) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCipherData(OMElement cipdata[" + DOMUtils.getDisplayName(cipdata) + "])");
        }
        int hash = 0;
        OMElement el = DOMUtils.getFirstElement(cipdata);
        while (el != null) {
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_CIPHERVALUE || hash == Constants.HASH_ENC_CIPHERREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(cipdata)});
            }
            el = DOMUtils.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCipherData(OMElement cipdata)");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static DecryptionResult decrypt(OMElement target, EncryptionConsumerConfig config, IDResolver idResolver, OMDocument doc, WSSConsumerConfig gconfig, Map<Object, Object> type, Map<Object, Object> properties, String nsWsse, String nsWsu, Map<Object, Object> context) throws SoapSecurityException {
        if (EncryptionConsumer.tc.isEntryEnabled()) {
            Tr.entry(EncryptionConsumer.tc, "decrypt(OMElement target[" + DOMUtils.getDisplayName(target) + "]," + "EncryptionConsumerConfig config," + "IDResolver idResolver[" + idResolver + "]," + "OMDocument doc[" + DOMUtils.getDisplayName(doc.getOMDocumentElement()) + "]," + "WSSConsumerConfig gconfig," + "Map type," + "Map properties," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)");
        }
        parts = new ArrayList<DecryptionResult.DecryptedPart>();
        dcontext = new DecryptionContext();
        dcontext.setIdResolver(idResolver);
        dcontext.setContext(context);
        afactory = gconfig.getAlgorithmFactory();
        dcontext.setAlgorithmFactory(afactory);
        if (EncryptionConsumer.tc.isDebugEnabled()) {
            dcontext.setResourceShower(ShowerImpl.access$000());
        }
        encAlgorithm = null;
        encMethod = config.getKeyEncryptionMethod();
        if (encMethod != null) {
            encAlgorithm = encMethod.getAlgorithm();
        }
        dcontext.setEncAlgorithm(encAlgorithm);
        dcontext.setOffload(Boolean.TRUE);
        if (EncryptionConsumer.tc.isDebugEnabled()) {
            Tr.debug(EncryptionConsumer.tc, "Encryption Algorithm is : " + encAlgorithm);
        }
        dcontext.initHWConfig(gconfig, context);
        ids = EncryptionConsumer.getIds(target);
        kek = null;
        dek = null;
        tokenWrapper = null;
        idsSize = ids.size();
        lastNotBodyIndex = idsSize - 1;
        for (i = 0; i < idsSize; ++i) {
            block36: {
                block37: {
                    id = ids.get(i);
                    if (EncryptionConsumer.tc.isDebugEnabled()) {
                        Tr.debug(EncryptionConsumer.tc, "decrypt, start id=" + id);
                    }
                    if ((el = idResolver.resolveID(doc, id)) == null) break block36;
                    if (el.getParent() instanceof SOAPBody && i < lastNotBodyIndex) {
                        ids.remove(i);
                        ids.add(id);
                        --lastNotBodyIndex;
                        --i;
                        continue;
                    }
                    if (!com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData.isOfType(el) && !EncryptedHeader.isOfType(el)) break block37;
                    try {
                        block38: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    if (com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData.isOfType(el) && (parent = el.getParent()) instanceof OMElement && EncryptedHeader.isOfType(omeParent = (OMElement)parent)) {
                                                        el = omeParent;
                                                        if (EncryptionConsumer.tc.isDebugEnabled()) {
                                                            Tr.debug(EncryptionConsumer.tc, " in decrypt loop: EncryptedData replaced by parent:");
                                                            CommonLogUtils.logDebug(omeParent, EncryptionConsumer.tc);
                                                        }
                                                    }
                                                    if (!WSSConsumer.useInboundBodyOptimization || !gconfig.bodyMustBeSignedAndEncrypted() || !(el.getParent() instanceof SOAPBody)) break block38;
                                                    soapBody = (SOAPBody)el.getParent();
                                                    inboundBodyOpt = EncryptionConsumer.checkGoldenPath(context, doc, el, target, soapBody);
                                                    if (inboundBodyOpt != null) break block39;
                                                    if (EncryptionConsumer.tc.isDebugEnabled()) {
                                                        Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer: Since incoming message does not meet golden path conditions, start normal processing instead of inbound body optimization.Go back to the normal processing from inbound body optimization condition checking.");
                                                    }
                                                    break block38;
                                                }
                                                keyInfoElem = EncryptionConsumer.readEncryptedData(inboundBodyOpt, soapBody, dcontext, el, id);
                                                if (keyInfoElem != null) break block40;
                                                if (EncryptionConsumer.tc.isDebugEnabled()) {
                                                    Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer: Since incoming message does not have key info elem, start normal processing instead of inbound body optimization.Go back to the normal processing from inbound body optimization condition checking.");
                                                }
                                                break block38;
                                            }
                                            tmpOMElem = DOMUtils.getNextElement(keyInfoElem);
                                            cipherValue = null;
                                            if (tmpOMElem != null && LocalNameConstants.LocalNamesXENC.LN_CIPHER_DATA.equals(tmpOMElem.getLocalName()) && Constants.NS_ENC.equals(tmpOMElem.getNamespace().getNamespaceURI())) break block41;
                                            if (EncryptionConsumer.tc.isDebugEnabled()) {
                                                Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, no cipher data while checking inbound body optimization.Go back to the normal processing from inbound body optimization condition checking.");
                                            }
                                            break block38;
                                        }
                                        cipherData = tmpOMElem;
                                        cipherValue = cipherData.getFirstElement();
                                        if (cipherValue != null && LocalNameConstants.LocalNamesXENC.LN_CIPHER_VALUE.equals(cipherValue.getLocalName()) && Constants.NS_ENC.equals(cipherValue.getNamespace().getNamespaceURI())) break block42;
                                        if (EncryptionConsumer.tc.isDebugEnabled()) {
                                            Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, no cipher value while checking inbound body optimization.Go back to the normal processing from inbound body optimization condition checking.");
                                        }
                                        break block38;
                                    }
                                    localName = inboundBodyOpt.readerProxy.getLocalName();
                                    if (LocalNameConstants.LocalNamesXENC.LN_CIPHER_VALUE.equals(localName)) break block43;
                                    if (EncryptionConsumer.tc.isDebugEnabled()) {
                                        Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, cursor position is not cipher value. Go back to the normal processing from inbound body optimization condition checking.");
                                    }
                                    break block38;
                                }
                                dek = SignatureConsumer.callKeyInfoConsumer(config.getEncryptionKeyInfo(), "DecryptingKey", type, properties, keyInfoElem, context);
                                if (dek != null) break block44;
                                if (EncryptionConsumer.tc.isDebugEnabled()) {
                                    Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, can not get decryption key. Go back to the normal processing from inbound body optimization condition checking.");
                                }
                                break block38;
                            }
                            attachments = inboundBodyOpt.messageContext.getAttachmentMap();
                            if (attachments == null || attachments.getAllContentIDs() == null || attachments.getAllContentIDs().length <= 0) ** GOTO lbl-1000
                            attachmentType = attachments.getAttachmentSpecType();
                            if (EncryptionConsumer.tc.isDebugEnabled()) {
                                Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, attachment type = " + (attachmentType == null ? "<null>" : attachmentType));
                            }
                            if ("application/xop+xml".equalsIgnoreCase(attachmentType)) {
                                if (EncryptionConsumer.tc.isDebugEnabled()) {
                                    Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, MTOM detected. Go back to the normal processing from inbound body optimization condition checking.");
                                }
                            } else lbl-1000:
                            // 2 sources

                            {
                                if (EncryptionConsumer.tc.isDebugEnabled()) {
                                    Tr.debug(EncryptionConsumer.tc, "EncryptionConsumer.decrypt, start inbound body optimization!");
                                }
                                if ((cipherValueInputStream = (InputStream)inboundBodyOpt.builder.getReaderProperty(ParsedEntityStream.class.getName())) == null && (str = cipherValue.getText()) != null && str.length() > 0) {
                                    cipherValueInputStream = new AsciiStringInputStream(str);
                                }
                                inboundBodyOpt.cipherValueInputStream = cipherValueInputStream;
                                if (cipherValueInputStream == null) {
                                    throw new SoapSecurityException("EncryptionConsumer.decrypt, inbound body optimization can not get inputstream for <xxx:CipherValue> from incoming message");
                                }
                                dcontext.setHWAcceleration();
                                try {
                                    eomn = EncryptionConsumer.doInboundBodyOptimization(inboundBodyOpt, soapBody, el, id, dcontext, dek);
                                }
                                catch (XMLStreamException e) {
                                    throw new SoapSecurityException(e);
                                }
                                decryptionFilterResultSet = (DecryptionFilterResultSet)inboundBodyOpt.messageContext.getProperty(DecryptionFilterResultSet.class.getName());
                                decryptionFilterResult = decryptionFilterResultSet.getDecryptionFilterResult(id);
                                etype = decryptionFilterResult.getEncryptedData().getType();
                                eid = id;
                                noncefirst = false;
                                dpart = null;
                                if ("http://www.w3.org/2001/04/xmlenc#Element".equals(etype)) {
                                    elem = eomn;
                                    timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                                    nonce = NonceUtil.getNonce(elem, nsWsse);
                                    noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                                    dpart = new DecryptionResult.DecryptedPart(etype, eid, elem, nonce, timestamp, noncefirst);
                                    parts.add(dpart);
                                    dcontext.releaseHWAcceleration();
                                    continue;
                                }
                                if ("http://www.w3.org/2001/04/xmlenc#Content".equals(etype) && (parent = eomn.getParent()) != null && parent instanceof OMElement) {
                                    elem = (OMElement)parent;
                                    timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                                    nonce = NonceUtil.getNonce(elem, nsWsse);
                                    noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                                    dpart = new DecryptionResult.DecryptedPart(etype, eid, elem, nonce, timestamp, noncefirst);
                                    parts.add(dpart);
                                    dcontext.releaseHWAcceleration();
                                    continue;
                                }
                            }
                        }
                        EncryptionConsumer.checkEncryptedData(el, config);
                        if (EncryptedKey.isOfType(target)) {
                            if (kek == null) {
                                kek = SignatureConsumer.callKeyInfoConsumer(config.getEncryptionKeyInfo(), "DecryptingKey", type, properties, KeyInfo.searchForKeyInfo(target), context);
                                dcontext.setHWAcceleration();
                            }
                            if (dek == null) {
                                dek = EncryptionConsumer.decryptEncryptedKey(target, dcontext, kek, el);
                            }
                        } else {
                            keyInfoElem = null;
                            keyInfoElem = EncryptedHeader.isOfType(el) != false ? KeyInfo.searchForKeyInfo(el.getFirstElement()) : KeyInfo.searchForKeyInfo(el);
                            if (EncryptionConsumer.tc.isDebugEnabled()) {
                                Tr.debug(EncryptionConsumer.tc, "KeyInfo element = " + DOMUtils.toString(keyInfoElem));
                            }
                            dek = SignatureConsumer.callKeyInfoConsumer(config.getEncryptionKeyInfo(), "DecryptingKey", type, properties, keyInfoElem, context);
                            dcontext.setHWAcceleration();
                        }
                        dpart = EncryptionConsumer.decryptEncryptedData(el, dcontext, dek, nsWsse, nsWsu, context);
                        parts.add(dpart);
                    }
                    catch (SoapSecurityException e) {
                        if (EncryptedHeader.isOfType(el)) {
                            Tr.processException(e, EncryptionConsumer.clsName + ".decrypt", "820");
                            Tr.error(EncryptionConsumer.tc, "security.wssecurity.EncryptionConsumer.s11", e);
                            throw e;
                        }
                        Tr.processException(e, EncryptionConsumer.clsName + ".decrypt", "824");
                        Tr.error(EncryptionConsumer.tc, "security.wssecurity.EncryptionConsumer.s11", e);
                        throw e;
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.EncryptionReceiver.enc13", el.getLocalName());
            }
            dcontext.releaseHWAcceleration();
        }
        dcontext.finalizeHWConfig();
        dcontext.clearLocalProviderMap();
        dresult = new DecryptionResult(config, parts);
        if (tokenWrapper == null) {
            tokenWrapper = EncryptionConsumer.getTokenWrapper(dresult, config, context);
        }
        dresult._tokenWrapper = tokenWrapper;
        if (EncryptionConsumer.tc.isEntryEnabled()) {
            Tr.exit(EncryptionConsumer.tc, "decrypt(OMElement target,EncryptionConsumerConfig config,IDResolver idResolver,OMDocument doc,WSSConsumerConfig gconfig,Map type,Map properties,String nsWsse,String nsWsu,Map context) returns DecryptionResult[" + dresult + "]");
        }
        return dresult;
    }

    private static List<String> getIds(OMElement target) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIds(Element target[" + DOMUtils.getDisplayName(target) + "])");
        }
        OMElement refList = null;
        if (EncryptedKey.isOfType(target)) {
            refList = DOMUtils.getChildElement(target, Constants.NS_ENC, "ReferenceList");
        } else if (ReferenceList.isOfType(target)) {
            refList = target;
        }
        ArrayList<String> ids = new ArrayList<String>();
        if (refList != null) {
            ReferenceList refList2 = new ReferenceList(refList);
            for (ReferenceType refType : refList2.getReferences()) {
                if (refType instanceof DataReference) {
                    String uri = ((DataReference)refType).getURI();
                    if (uri == null) {
                        throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s01");
                    }
                    if (uri.length() <= 1 || uri.charAt(0) != '#') continue;
                    ids.add(uri.substring(1));
                    continue;
                }
                if (!(refType instanceof KeyReference)) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIds(OMElement target) returns List[" + ids + "]");
        }
        return ids;
    }

    private static Key decryptEncryptedKey(OMElement enckey, DecryptionContext dcontext, Key kek, OMElement encdata) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedKey(OMElement enckey[" + DOMUtils.getDisplayName(enckey) + "]," + "DecryptionContext dcontext[" + dcontext + "]," + "Key kek[" + kek + "]," + "OMElement encData[" + DOMUtils.getDisplayName(encdata) + "])");
        }
        Key dek = null;
        try {
            dcontext.setEncryptedType(enckey, null, null, null);
            OMElement encMethod = null;
            if (EncryptedHeader.isOfType(encdata)) {
                OMElement child = encdata.getFirstElement();
                encMethod = DOMUtils.getChildElement(child, Constants.NS_ENC, "EncryptionMethod");
            } else {
                encMethod = DOMUtils.getChildElement(encdata, Constants.NS_ENC, "EncryptionMethod");
            }
            dcontext.setEncryptionMethod(encMethod);
            if (dcontext.isHWAccelerationProvider()) {
                dcontext.setHWKey(kek);
            } else {
                dcontext.setKey(kek);
            }
            dcontext.decrypt();
            dek = (Key)dcontext.getData();
            dcontext.setEncryptionMethod((OMElement)null);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception from decrypting the key: ", e);
            }
            Tr.processException(e, clsName + ".decryptEncryptedKey", "955");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedKey(OMElement enckey,DecryptionContext dcontext,Key kek,OMElement encdata) returns Key[" + dek + "]");
        }
        return dek;
    }

    private static DecryptionResult.DecryptedPart decryptEncryptedData(OMElement encdata, DecryptionContext dcontext, Key dek, String nsWsse, String nsWsu, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedData(OMElement encdata[" + DOMUtils.getDisplayName(encdata) + "]," + "DecryptionContext dcontext[" + dcontext + "]," + "Key kek[" + dek + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)");
        }
        DecryptionResult.DecryptedPart dpart = null;
        try {
            OMContainer parent = encdata.getParent();
            dcontext.setEncryptedType(encdata, null, null, null);
            dcontext.setKey(dek);
            dcontext.decrypt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " in decryptEncryptedData: encdata contents follow:");
                CommonLogUtils.logDebug(encdata, tc);
                if (parent instanceof OMElement) {
                    Tr.debug(tc, " in decryptEncryptedData: encdata parent:");
                    CommonLogUtils.logDebug((OMElement)parent, tc);
                } else {
                    Tr.debug(tc, " in decryptEncryptedData: encdata parent=" + parent);
                }
            }
            dcontext.replace();
            dpart = EncryptionConsumer.createDecryptedPart(encdata, dcontext, nsWsse, nsWsu, context, parent);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".decryptEncryptedData", "1006");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedData(OMElement encdata,DecryptionContext dcontext,Key dek,String nsWsse,String nsWsu,Map context) returns DecryptedPart[" + dpart + "]");
        }
        return dpart;
    }

    private static DecryptionResult.DecryptedPart createDecryptedPart(OMElement encdata, DecryptionContext dcontext, String nsWsse, String nsWsu, Map<Object, Object> context, OMContainer parentNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptedPart(OMElement encdata[" + DOMUtils.getDisplayName(encdata) + "]," + "DecryptionContext dcontext[" + dcontext + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "Map context," + "OMContainer parentNode)");
        }
        boolean noncefirst = false;
        String type = dcontext.getType();
        DecryptionResult.DecryptedPart dpart = null;
        Iterator list = dcontext.getDataAsNodeList();
        if (list.hasNext()) {
            OMNode node = (OMNode)list.next();
            if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                if (tc.isDebugEnabled()) {
                    OMContainer parent = node.getParent();
                    if (parent instanceof OMElement) {
                        Tr.debug(tc, " in createDecryptedPart [ELEMENT parent:");
                        CommonLogUtils.logDebug((OMElement)parent, tc);
                    } else {
                        Tr.debug(tc, " in createDecryptedPart [ELEMENT parent=" + parent + "].");
                    }
                }
                OMElement elem = (OMElement)node;
                String id = IdUtils.getInstance().getId(elem);
                OMElement timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                OMElement nonce = NonceUtil.getNonce(elem, nsWsse);
                noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                dpart = new DecryptionResult.DecryptedPart(type, id, elem, nonce, timestamp, noncefirst);
                ResultMessagePool.addElement(context, encdata, elem);
            } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                OMContainer parent = node.getParent();
                if (tc.isDebugEnabled()) {
                    if (parent instanceof OMElement) {
                        Tr.debug(tc, " in createDecryptedPart [CONTENT parent:");
                        CommonLogUtils.logDebug((OMElement)parent, tc);
                    } else {
                        Tr.debug(tc, " in createDecryptedPart [CONTENT parent=" + parent + "].");
                    }
                }
                if (parent != null && parent instanceof OMElement) {
                    OMElement elem = (OMElement)parent;
                    String id = IdUtils.getInstance().getId(elem);
                    OMElement timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                    OMElement nonce = NonceUtil.getNonce(elem, nsWsse);
                    noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                    dpart = new DecryptionResult.DecryptedPart(type, id, elem, nonce, timestamp, noncefirst);
                }
            }
        } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            if (tc.isDebugEnabled()) {
                if (parentNode instanceof OMElement) {
                    Tr.debug(tc, " in createDecryptedPart for element with no children [CONTENT parent:");
                    CommonLogUtils.logDebug((OMElement)parentNode, tc);
                } else {
                    Tr.debug(tc, " in createDecryptedPart for element with no children [CONTENT parent=" + parentNode + "].");
                }
            }
            if (parentNode != null && parentNode instanceof OMElement) {
                OMElement elem = (OMElement)parentNode;
                String id = IdUtils.getInstance().getId(elem);
                OMElement timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                OMElement nonce = NonceUtil.getNonce(elem, nsWsse);
                noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                dpart = new DecryptionResult.DecryptedPart(type, id, elem, nonce, timestamp, noncefirst);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptedPart(OMElement encdata,DecryptionContext dcontext,String nsWsse,String nsWsu,Map context,OMContainer parentNode) returns DecryptedPart[" + dpart + "]");
        }
        return dpart;
    }

    private static void setDecryptionResult(DecryptionResult dresult, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDecryptionResult(DecryptionResult dresult[" + dresult + "]," + "Map context)");
        }
        for (DecryptionResult.DecryptedPart part : dresult._decryptedParts) {
            SignatureConsumer.removeNode(part._timestamp, "weenc");
            SignatureConsumer.removeNode(part._nonce, "weenc");
        }
        ResultPool.add(context, dresult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDecryptionResult(DecryptionResult dresult, Map context)");
        }
    }

    private static KeyInfoResult[] getKeyInfoResults(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] kresults = null;
        Result[] results = ResultPool.get(context, KeyInfoResult.class);
        if (results != null) {
            kresults = new KeyInfoResult[results.length];
            for (int i = 0; i < results.length; ++i) {
                kresults[i] = (KeyInfoResult)results[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoResults(Map context) returns KeyInfoResult[][" + kresults + "]");
        }
        return kresults;
    }

    private static KeyInfoResult getProcessedResult(DecryptionResult dresult, KeyInfoResult[] results, List kclist) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(DecryptionResult dresult,KeyInfoResult[] results,List kclist)");
        }
        KeyInfoResult result = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                if (result == null && kclist.contains(r.getKeyInfoContentConsumer()) && r.getError() == null) {
                    result = r;
                    continue;
                }
                dresult._kresults.put(r.getKeyInfoContentConsumer(), r);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(DecryptionResult dresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + result + "]");
        }
        return result;
    }

    private static SecurityTokenWrapper getTokenWrapper(DecryptionResult dresult, EncryptionConsumerConfig econfig, Map<Object, Object> context) throws SoapSecurityException {
        List<EncryptionConsumerConfig> vlist;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenWrapper(DecryptionResult dresult[" + dresult + "]," + "EncryptionConsumerConfig econfig," + "Map context)");
        }
        SecurityTokenWrapper stw = null;
        Collection<SecurityTokenWrapper> tokenWrappers = null;
        KeyInfoResult[] results = EncryptionConsumer.getKeyInfoResults(context);
        KeyInfoResult kresult = EncryptionConsumer.getProcessedResult(dresult, results, econfig.getEncryptionKeyInfo().getContentConsumers());
        if (kresult != null) {
            SecurityToken token;
            String id = kresult.getIdInSubject();
            SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            final SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token = securityTokenManager.getToken(kresult.getKeyInfoContentConsumer().getTokenConsumer(), id));
            if (tokenWrapper != null) {
                if (tokenWrapper.getError() != null) {
                    throw tokenWrapper.getError();
                }
                stw = AccessController.doPrivileged(new PrivilegedAction<SecurityTokenWrapper>(){

                    @Override
                    public SecurityTokenWrapper run() {
                        tokenWrapper.setReferenced(true);
                        SecurityTokenWrapper stw = new SecurityTokenWrapper(tokenWrapper.getSecurityToken(), tokenWrapper.getWssapiCallbackHandler(), tokenWrapper.getWssapiLoginConfigName());
                        stw.setKeyInfoType(tokenWrapper.getKeyInfoType());
                        stw.setProcessed(tokenWrapper.isProcessed());
                        if (tokenWrapper.isReadOnly()) {
                            stw.setReadOnly();
                        }
                        stw.setReferenced(tokenWrapper.isReferenced());
                        stw.setUsedTokenConsumer(tokenWrapper.getUsedTokenConsumerHash(), tokenWrapper.getUsedTokenConsumerClass());
                        stw.setUsedTokenGenerator(tokenWrapper.getUsedTokenGeneratorHash());
                        stw.setUsedToLogin(tokenWrapper.isUsedToLogin());
                        stw.setWssapiReferenceType(tokenWrapper.getWssapiReferenceType());
                        return stw;
                    }
                });
            }
            Collection<SecurityToken> tokens = securityTokenManager.getTokens(id);
            tokenWrappers = securityTokenManager.getTokenWrappers(tokens);
        }
        if ((vlist = econfig.getIdentityList()) != null && vlist.size() > 0) {
            for (EncryptionConsumerConfig config2 : vlist) {
                block1: for (KeyInfoContentConsumerConfig kiconfig : config2.getEncryptionKeyInfo().getContentConsumers()) {
                    for (int k = 0; k < results.length; ++k) {
                        if (!kiconfig.equals(results[k].getKeyInfoContentConsumer())) continue;
                        dresult._identities.put(config2, results[k]);
                        continue block1;
                    }
                }
            }
        }
        if (tokenWrappers != null && tokenWrappers.size() > 0) {
            block3: for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                TokenConsumerConfig tconfig = r.getKeyInfoContentConsumer().getTokenConsumer();
                if (tconfig == null) continue;
                for (SecurityTokenWrapper tw : tokenWrappers) {
                    if (tconfig.hashCode() != tw.getUsedTokenConsumerHash()) continue;
                    dresult._kresults.put(r, tw);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenWrapper(DecryptionResult dresult,EncryptionConsumerConfig econfig,Map context) returns SecurityTokenWrapper[" + stw + "]");
        }
        return stw;
    }

    public static InboundBodyOptimization checkGoldenPath(Map<Object, Object> context, OMDocument doc, OMElement el, OMElement target, SOAPBody soapBody) {
        InboundBodyOptimization ibo = new InboundBodyOptimization();
        ibo.messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (ibo.messageContext == null) {
            return null;
        }
        ibo.jaxbBlockContext = JAXWSUtil.getJaxbBlockContext(ibo.messageContext);
        if (ibo.jaxbBlockContext == null) {
            return null;
        }
        OMXMLParserWrapper wrapper = doc.getOMDocumentElement().getBuilder();
        if (wrapper instanceof StAXBuilder) {
            ibo.builder = (StAXBuilder)wrapper;
            ibo.readerProxy = (XMLStreamReaderProxy)ibo.builder.getReaderProperty(XMLStreamReaderProxy.class.getName());
            if (ibo.readerProxy != null) {
                ibo.wsinfo = (WSInfo)ibo.readerProxy.getProperty(WSInfo.class.getName());
                if (ibo.wsinfo != null) {
                    String attrNamespaceUri;
                    int i;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), finds wsinfo");
                    }
                    for (i = 0; i < ibo.wsinfo.getBodyIdSize(); ++i) {
                        attrNamespaceUri = ibo.wsinfo.getBodyIdQName(i).getNamespaceURI();
                        if (attrNamespaceUri == null || !Constants.NS_WSU.equals(attrNamespaceUri)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), finds bodyId from wsinfo " + ibo.wsinfo.getBodyIdQName(i) + "=" + ibo.wsinfo.getBodyIdValue(i));
                        }
                        ibo.bodyId = ibo.wsinfo.getBodyIdValue(i);
                        break;
                    }
                    for (i = 0; i < ibo.wsinfo.getFirstSOAPBodyChildIdSize(); ++i) {
                        attrNamespaceUri = ibo.wsinfo.getFirstSOAPBodyChildIdQName(i).getNamespaceURI();
                        if (attrNamespaceUri != null && attrNamespaceUri.length() != 0) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), finds bodyContentId from wsinfo " + ibo.wsinfo.getFirstSOAPBodyChildIdQName(i) + "=" + ibo.wsinfo.getFirstSOAPBodyChildIdValue(i));
                        }
                        ibo.bodyContentId = ibo.wsinfo.getFirstSOAPBodyChildIdValue(i);
                        break;
                    }
                }
            }
        }
        if (ibo.messageContext != null && ibo.jaxbBlockContext != null && ibo.builder != null && ibo.readerProxy != null) {
            if (ibo.bodyId == null) {
                Iterator iterator = soapBody.getAllAttributes();
                while (iterator.hasNext()) {
                    OMAttribute omAttr = (OMAttribute)iterator.next();
                    if (!LocalNameConstants.LocalNamesWSU.LN_ID.equals(omAttr.getLocalName()) || !Constants.NS_WSU.equals(omAttr.getNamespace().getNamespaceURI())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), finds bodyContentId from OMElement " + omAttr.getQName() + "=" + omAttr.getAttributeValue());
                    }
                    ibo.bodyId = omAttr.getAttributeValue();
                    break;
                }
            }
            if (ibo.bodyId != null) {
                OMElement dsReferenceTargetingBody = null;
                String bodyURI = "#" + ibo.bodyId;
                OMElement node = DOMUtils.getNextElement(target);
                block3: while (node != null) {
                    OMElement signature = node;
                    if (!LocalNameConstants.LocalNamesDSIG.LN_SIGNATURE.equals(signature.getLocalName()) || !Constants.NS_DSIG.equals(signature.getNamespace().getNamespaceURI())) {
                        node = DOMUtils.getNextElement(node);
                        continue;
                    }
                    OMElement signedInfo = signature.getFirstElement();
                    if (!LocalNameConstants.LocalNamesDSIG.LN_SIGNED_INFO.equals(signedInfo.getLocalName()) || !Constants.NS_DSIG.equals(signedInfo.getNamespace().getNamespaceURI())) {
                        node = DOMUtils.getNextElement(node);
                        continue;
                    }
                    Iterator signedInfoChildren = signedInfo.getChildElements();
                    while (signedInfoChildren.hasNext()) {
                        String value;
                        OMAttribute omAttrURI;
                        OMElement reference = (OMElement)signedInfoChildren.next();
                        if (!LocalNameConstants.LocalNamesDSIG.LN_REFERENCE.equals(reference.getLocalName()) || !Constants.NS_DSIG.equals(reference.getNamespace().getNamespaceURI()) || (omAttrURI = reference.getAttribute(Constants.URI_Q)) == null || !bodyURI.equals(value = omAttrURI.getAttributeValue())) continue;
                        dsReferenceTargetingBody = reference;
                        break block3;
                    }
                }
                int numTransform = 0;
                String transformAlgorithm = null;
                if (dsReferenceTargetingBody != null) {
                    Iterator referenceChildren = dsReferenceTargetingBody.getChildElements();
                    while (referenceChildren.hasNext()) {
                        OMElement omElement = (OMElement)referenceChildren.next();
                        if (LocalNameConstants.LocalNamesDSIG.LN_TRANSFORM_S.equals(omElement.getLocalName()) && Constants.NS_DSIG.equals(omElement.getNamespace().getNamespaceURI())) {
                            Iterator transformsChildren = omElement.getChildElements();
                            while (transformsChildren.hasNext()) {
                                OMElement transform = (OMElement)transformsChildren.next();
                                if (!LocalNameConstants.LocalNamesDSIG.LN_TRANSFORM.equals(transform.getLocalName()) || !Constants.NS_DSIG.equals(transform.getNamespace().getNamespaceURI()) || ++numTransform != 1) continue;
                                OMAttribute omAttrAlgorithm = transform.getAttribute(ALGORITHM_Q);
                                if (omAttrAlgorithm != null) {
                                    transformAlgorithm = omAttrAlgorithm.getAttributeValue();
                                }
                                Iterator transformChildren = transform.getChildElements();
                                while (transformChildren.hasNext()) {
                                    OMAttribute omAttrPrefixList;
                                    OMElement inclusiveNamespaces = (OMElement)transformChildren.next();
                                    if (!LocalNameConstants.LocalNamesXC14N.LN_INCLUSIVE_NAMESPACES.equals(inclusiveNamespaces.getLocalName()) || !"http://www.w3.org/2001/10/xml-exc-c14n#".equals(inclusiveNamespaces.getNamespace().getNamespaceURI()) || (omAttrPrefixList = inclusiveNamespaces.getAttribute(PREFIX_LIST_Q)) == null) continue;
                                    ibo.prefixList = omAttrPrefixList.getAttributeValue();
                                }
                            }
                            continue;
                        }
                        if (!LocalNameConstants.LocalNamesDSIG.LN_DIGEST_METHOD.equals(omElement.getLocalName()) || !Constants.NS_DSIG.equals(omElement.getNamespace().getNamespaceURI())) continue;
                        OMAttribute omAttrAlrogithm = omElement.getAttribute(ALGORITHM_Q);
                        if (omAttrAlrogithm == null) break;
                        ibo.digestMethodAlgorithm = omAttrAlrogithm.getAttributeValue();
                        break;
                    }
                }
                if (numTransform != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), number of <xxx:Transform> " + numTransform + " is not one.");
                    }
                    return null;
                }
                if (ibo.digestMethodAlgorithm == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), there is no Algorithm attribute in <xxx:DigestMethod>.");
                    }
                    return null;
                }
                if (!"http://www.w3.org/2000/09/xmldsig#sha1".equals(ibo.digestMethodAlgorithm)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), the Algorithm attribute in <xxx:DigestMethod> " + ibo.digestMethodAlgorithm + " is not " + "http://www.w3.org/2000/09/xmldsig#sha1");
                    }
                    return null;
                }
                if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(transformAlgorithm)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EncryptionConsumer.checkGoldenPath(), the Algorithm attribute in <xxx:Transform> " + transformAlgorithm + " is not" + "http://www.w3.org/2001/10/xml-exc-c14n#");
                    }
                    return null;
                }
                return ibo;
            }
        }
        return null;
    }

    public static OMElement readEncryptedData(InboundBodyOptimization inboundBodyOpt, SOAPBody soapBody, DecryptionContext dcontext, OMElement el, String id) throws SoapSecurityException {
        AlgorithmParameterSpec spec;
        String oaepParamDigestMethodAlgorithm;
        String keySize;
        String encryptionMethodAlgorithm;
        OMElement encryptionMethod = null;
        OMElement keyInfoElem = null;
        OMElement tmpOMElem = el.getFirstElement();
        inboundBodyOpt.encryptedData = new DecryptionFilter.EncryptedData();
        Iterator iterator = el.getAllAttributes();
        String type2 = null;
        String mimeType = null;
        String encoding = null;
        while (iterator.hasNext()) {
            OMAttribute oma = (OMAttribute)iterator.next();
            String ln = oma.getLocalName();
            if (LocalNameConstants.LocalNameAttrDefaultNS.LN_TYPE.equals(ln)) {
                type2 = oma.getAttributeValue();
                continue;
            }
            if (LocalNameConstants.LocalNameAttrDefaultNS.LN_MIME_TYPE.equals(ln)) {
                mimeType = oma.getAttributeValue();
                continue;
            }
            if (!LocalNameConstants.LocalNameAttrDefaultNS.LN_ENCODING.equals(ln)) continue;
            encoding = oma.getAttributeValue();
        }
        inboundBodyOpt.encryptedData.setEncryptedDataAttributeValues(id, type2, mimeType, encoding);
        if (tmpOMElem != null && LocalNameConstants.LocalNamesXENC.LN_ENCRYPTION_METHOD.equals(tmpOMElem.getLocalName()) && Constants.NS_ENC.equals(tmpOMElem.getNamespace().getNamespaceURI())) {
            encryptionMethod = tmpOMElem;
            tmpOMElem = DOMUtils.getNextElement(tmpOMElem);
            encryptionMethodAlgorithm = encryptionMethod.getAttributeValue(ALGORITHM_Q);
            keySize = null;
            String oaepParams = null;
            oaepParamDigestMethodAlgorithm = null;
            spec = null;
            Iterator childrenIterator = encryptionMethod.getChildElements();
            while (childrenIterator.hasNext()) {
                OMElement child = (OMElement)childrenIterator.next();
                if (LocalNameConstants.LocalNamesXENC.LN_KEY_SIZE.equals(child.getLocalName()) && Constants.NS_ENC.equals(child.getNamespace().getNamespaceURI())) {
                    keySize = child.getText();
                    continue;
                }
                if (LocalNameConstants.LocalNamesXENC.LN_OAEP_PARAMS.equals(child.getLocalName()) && Constants.NS_ENC.equals(child.getNamespace().getNamespaceURI())) {
                    oaepParams = child.getText();
                    continue;
                }
                if (!LocalNameConstants.LocalNamesDSIG.LN_DIGEST_METHOD.equals(child.getLocalName()) || !"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespace().getNamespaceURI())) continue;
                oaepParamDigestMethodAlgorithm = child.getAttributeValue(ALGORITHM_Q);
            }
            if (oaepParams != null && oaepParamDigestMethodAlgorithm != null) {
                byte[] paramBytes = Base64Table.decode(oaepParams, 0, oaepParams.length());
                try {
                    spec = dcontext.getAlgorithmFactory().getOAEPParameterSpec(oaepParamDigestMethodAlgorithm, paramBytes);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new SoapSecurityException(e);
                }
            }
        } else {
            return null;
        }
        inboundBodyOpt.encryptedData.setEncryptionMethod(encryptionMethodAlgorithm, keySize, oaepParamDigestMethodAlgorithm, spec);
        if (tmpOMElem == null || !LocalNameConstants.LocalNamesDSIG.LN_KEY_INFO.equals(tmpOMElem.getLocalName()) || !Constants.NS_DSIG.equals(tmpOMElem.getNamespace().getNamespaceURI())) {
            return null;
        }
        keyInfoElem = tmpOMElem;
        return keyInfoElem;
    }

    public static OMElement doInboundBodyOptimization(InboundBodyOptimization inboundBodyOpt, SOAPBody soapBody, OMElement el, String id, DecryptionContext dcontext, Key dek) throws XMLStreamException, SoapSecurityException {
        OMtoXMLStreamReader wrapper = new OMtoXMLStreamReader(soapBody, el);
        C14NFilter c14nFilter = (C14NFilter)C14NFilterFactory.getInstance().getObject();
        c14nFilter.init((XMLStreamReader)wrapper, inboundBodyOpt.messageContext, (XMLStreamReaderFilter)null);
        c14nFilter.setBuilder(inboundBodyOpt.builder);
        c14nFilter.setMode(true);
        c14nFilter.setTargetWSUID(inboundBodyOpt.bodyId);
        c14nFilter.setInclusiveNamespacesString(inboundBodyOpt.prefixList);
        while (c14nFilter.hasNext()) {
            int eventType = c14nFilter.next();
        }
        DecryptionFilter decryptionFilter = (DecryptionFilter)DecryptionFilterFactory.getInstance().getObject();
        decryptionFilter.init(inboundBodyOpt.readerProxy.getReader(), inboundBodyOpt.messageContext, inboundBodyOpt.readerProxy);
        inboundBodyOpt.readerProxy.setReader(decryptionFilter);
        decryptionFilter.setBuilder(inboundBodyOpt.builder);
        decryptionFilter.setTargetId(id);
        decryptionFilter.setDecryptionInfo(dcontext.getAlgorithmFactory(), null, null, null, dek);
        InputStream cipherValueInputStream = inboundBodyOpt.cipherValueInputStream;
        if (cipherValueInputStream == null) {
            throw new SoapSecurityException("no parsed entity stream");
        }
        decryptionFilter.processCipherValueWithCreatingEmptyCipherValue(inboundBodyOpt.encryptedData, dek, cipherValueInputStream);
        inboundBodyOpt.builder.next();
        inboundBodyOpt.builder.next();
        inboundBodyOpt.builder.next();
        c14nFilter.init(inboundBodyOpt.readerProxy.getReader(), inboundBodyOpt.messageContext, inboundBodyOpt.readerProxy);
        inboundBodyOpt.readerProxy.setReader(c14nFilter);
        UnmarshallFilter unmarshallFilter = new UnmarshallFilter();
        unmarshallFilter.setJAXBBlockContext(inboundBodyOpt.jaxbBlockContext);
        unmarshallFilter.setStateInTarget();
        unmarshallFilter.init(inboundBodyOpt.readerProxy.getReader(), inboundBodyOpt.messageContext, inboundBodyOpt.readerProxy);
        inboundBodyOpt.readerProxy.setReader(unmarshallFilter);
        inboundBodyOpt.builder.getDocumentElement().build();
        Object obj = unmarshallFilter.getJAXBObject();
        QName qname = unmarshallFilter.getJAXBElementQName();
        JAXBDataSource ds2 = new JAXBDataSource(obj, inboundBodyOpt.jaxbBlockContext);
        OMSourcedElement omse = el.getOMFactory().createOMElement(ds2, qname.getLocalPart(), new OMNamespaceImpl(qname.getNamespaceURI(), qname.getPrefix()));
        el.insertSiblingAfter(omse);
        el.detach();
        return omse;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        @Override
        public void showEncryptedResource(byte[] content, Object data, OMElement encType) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData.isOfType(encType) || EncryptedHeader.isOfType(encType)) {
                Tr.debug(tc, "ResourceShower logs decrypt-" + encType.getAttributeValue(new QName("", "Id")) + ": ");
                CommonLogUtils.logDebug(in, "UTF-8", tc);
            } else {
                Tr.debug(tc, "ResourceShower logs decrypt-EncryptedKey: ");
                CommonLogUtils.logDebugEncode64(content, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        @Override
        public void showEncryptedResource(byte[] content, Object data, WSSObjectElement encType) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (encType instanceof EncryptedData || encType instanceof com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader) {
                String id = WSSObjectUtils.getIdAttributeValue(encType);
                Tr.debug(tc, "ResourceShower logs decrypt-" + id + ": ");
                CommonLogUtils.logDebug(in, "UTF-8", tc);
            } else {
                Tr.debug(tc, "ResourceShower logs decrypt-EncryptedKey: ");
                CommonLogUtils.logDebugEncode64(content, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        static /* synthetic */ ShowerImpl access$000() {
            return ShowerImpl.getInstance();
        }
    }

    public static class InboundBodyOptimization {
        MessageContext messageContext = null;
        JAXBDSContext jaxbBlockContext = null;
        StAXBuilder builder = null;
        XMLStreamReaderProxy readerProxy = null;
        WSInfo wsinfo = null;
        String bodyId = null;
        String bodyContentId = null;
        boolean readyToProcessBody = false;
        String prefixList = null;
        String digestMethodAlgorithm = null;
        InputStream cipherValueInputStream = null;
        DecryptionFilter.EncryptedData encryptedData = null;
    }
}

