/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.DecryptionResult;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class DecryptedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(DecryptedPartChecker.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invoke(");
            buf.append("OMNode target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "soapenv:Envelope");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        Map verifiedNonceMap = (Map)context.get("com.ibm.ws.wssecurity.constants.verifiedNonceMap");
        IDResolver resolver2 = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
        OMDocument doc = null;
        doc = DOMUtil.getOwnerDocument(target);
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        NonceManager nmanager = gconfig.getNonceManager();
        Set<RequiredParts> requiredParts = DecryptedPartChecker.preprocess(doc, gconfig, this._selectors, context, resolver2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing the decrypted results...");
        }
        Result[] results = ResultPool.get(context, DecryptionResult.class);
        HashSet<ReferencePartConfig> rset = new HashSet<ReferencePartConfig>();
        if (results != null && results.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, results.length + " decrypted results found.");
            }
            for (int i = 0; i < results.length; ++i) {
                DecryptionResult result = (DecryptionResult)results[i];
                rset.clear();
                for (DecryptionResult.DecryptedPart dpart : result._decryptedParts) {
                    RequiredPart rpart = DecryptedPartChecker.getRelatedPart(result, dpart, requiredParts);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DecryptedPart [" + dpart + "], RequiredPart [" + rpart + "]");
                    }
                    if (rpart == null) continue;
                    if (rpart._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required nonce...");
                        }
                        if (dpart._nonce == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", rpart._pconfig.getKeyword());
                        }
                        boolean skipNonceCheck = false;
                        String value = DOMUtil.getStringValue(dpart._nonce);
                        if (value != null && value.length() > 0) {
                            OMElement el = null;
                            if (verifiedNonceMap != null) {
                                el = (OMElement)verifiedNonceMap.get(value);
                            }
                            if (el != null && el == dpart._object) {
                                skipNonceCheck = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Already verified nonce value of " + value + " for element " + dpart._object + " in VerifiedPartChecker");
                                }
                            }
                        }
                        if (!skipNonceCheck) {
                            NonceUtil.checkNonce(dpart._nonce, nsWsse, nmanager);
                        }
                    }
                    if (rpart._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required timestamp...");
                        }
                        if (dpart._timestamp == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", rpart._pconfig.getKeyword());
                        }
                        NonceUtil.checkTimestamp(dpart._timestamp, nsWsu, gconfig.getTimestampMaxAge(), gconfig.getTimestampClockSkew(), false);
                    }
                    rpart._processed = true;
                    rpart._tokenWrappers.add(result._tokenWrapper);
                    rset.add(rpart._rconfig);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking whether all required confidentiality is processed...");
        }
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] rpart = rparts._parts;
            boolean bContent = "http://www.w3.org/2001/04/xmlenc#Content".equals(rparts._type);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Content type = " + rparts._type);
            }
            for (int j = 0; j < rpart.length; ++j) {
                boolean bHasContent = true;
                boolean bEnforceDecryptionCheck = true;
                if (bContent) {
                    boolean bl = bHasContent = rpart[j]._element.getFirstOMChild() != null;
                    if (bHasContent) {
                        bEnforceDecryptionCheck = true;
                    } else if (Constants.DIALECT_WAS.equals(rpart[j]._pconfig.getDialect()) && ConfidentialDialectElementSelector.WASDIALECTS[0].equals(rpart[j]._pconfig.getKeyword()) && gconfig.bodyMustBeSignedAndEncrypted()) {
                        bEnforceDecryptionCheck = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No body content present; configuration specifies Body is signed and content encrypted.");
                        }
                    } else {
                        bEnforceDecryptionCheck = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No element content present:");
                            Tr.debug(tc, "    Dialect = " + rpart[j]._pconfig.getDialect());
                            if (Constants.DIALECT_WAS.equals(rpart[j]._pconfig.getDialect())) {
                                Tr.debug(tc, "    Keyword = " + rpart[j]._pconfig.getKeyword());
                            }
                            Tr.debug(tc, "    BodyMustBeSignedAndEncrypted = " + gconfig.bodyMustBeSignedAndEncrypted());
                        }
                    }
                } else {
                    bEnforceDecryptionCheck = bHasContent = rpart[j]._element != null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rpart[" + j + "]._element = ");
                    CommonLogUtils.logDebug(rpart[j]._element, tc);
                    Tr.debug(tc, "rpart[" + j + "]._element.hasChildNodes() = " + (rpart[j]._element.getFirstOMChild() != null));
                    Tr.debug(tc, "bHasContent = " + bHasContent);
                    Tr.debug(tc, "bEnforceDecryptionCheck = " + bEnforceDecryptionCheck);
                }
                if (bEnforceDecryptionCheck) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security constraint is enforced!");
                    }
                    if (rpart[j]._processed) continue;
                    String keyword = rpart[j]._pconfig.getKeyword();
                    if (keyword == null) {
                        String headerName = rpart[j]._pconfig.getHeaderName();
                        keyword = headerName != null ? rpart[j]._pconfig.getHeaderNamespace() + ":" + headerName : rpart[j]._pconfig.getHeaderNamespace();
                    }
                    throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.DecryptedPartChecker.s01", keyword);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Encrypted target(s) is/are *not* present and security constraint is *not* enforced!");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode, Map)");
        }
    }

    private static Set<RequiredParts> preprocess(OMDocument doc, WSSConsumerConfig gconfig, Map<Object, Object> selectors, Map<Object, Object> context, IDResolver idResolver) throws SoapSecurityException {
        RequiredPart rpart;
        int k;
        OMElement el;
        int j;
        String keyword;
        String dialect;
        Map<Object, Object> cpSelectorMap;
        ReferencePartConfig rconfig;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("preprocess(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("WSSConsumerConfig gconfig, Map selectors, Map context, IDResolver idResolver)");
            Tr.entry(tc, buf.toString());
        }
        Set<ReferencePartConfig> requiredConfidentiality = gconfig.getRequiredConfidentialParts();
        HashSet<RequiredParts> requiredParts = new HashSet<RequiredParts>();
        HashSet<ReferencePartConfig.PartConfig> nonces = null;
        HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>> nonces2 = null;
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> nonces3 = null;
        PartList parts = null;
        Iterator<ReferencePartConfig> i1 = requiredConfidentiality.iterator();
        while (i1.hasNext()) {
            rconfig = i1.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing ReferencePartConfig [" + rconfig + "]...");
            }
            cpSelectorMap = new HashMap<Object, Object>(context);
            cpSelectorMap.put(NonceManager.class, gconfig.getNonceManager());
            cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", idResolver);
            cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.config", gconfig.getTokenConsumers());
            for (ReferencePartConfig.PartConfig pconfig : rconfig.getParts()) {
                if (pconfig.isTimestamp() || pconfig.isNonce()) {
                    if (nonces == null) {
                        nonces = new HashSet<ReferencePartConfig.PartConfig>();
                        nonces2 = new HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>>();
                        nonces3 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
                    }
                    nonces.add(pconfig);
                    nonces2.put(pconfig, cpSelectorMap);
                    nonces3.put(pconfig, rconfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing PartConfig [" + pconfig + "]...");
                }
                dialect = pconfig.getDialect();
                keyword = pconfig.getKeyword();
                Class elemSelector = ConfidentialDialectElementSelector.class;
                if (dialect.equals(Constants.DIALECT_HEADER)) {
                    cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headername", pconfig.getHeaderName());
                    cpSelectorMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", pconfig.getHeaderNamespace());
                    elemSelector = QNameHeaderSelector.class;
                }
                if ((parts = (PartList)SignatureGenerator.getMessagePart(doc, dialect, keyword, "decryption_mode", selectors, elemSelector, cpSelectorMap)) == null || parts.getLength() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, parts.getLength() + " parts found.");
                }
                boolean found = false;
                for (j = 0; j < parts.getLength(); ++j) {
                    RequiredParts rparts2;
                    el = (OMElement)parts.item(j);
                    block3: for (RequiredParts rparts2 : requiredParts) {
                        for (k = 0; k < rparts2._parts.length; ++k) {
                            rpart = rparts2._parts[k];
                            if (!DOMUtils.equals(el, rpart._element)) continue;
                            found = true;
                            continue block3;
                        }
                    }
                    if (found) continue;
                    RequiredPart[] rpartList = new RequiredPart[]{new RequiredPart(rconfig, pconfig, el)};
                    rparts2 = new RequiredParts(rpartList, parts.getType());
                    requiredParts.add(rparts2);
                }
            }
        }
        if (nonces != null) {
            i1 = nonces.iterator();
        }
        while (nonces != null && i1.hasNext()) {
            ReferencePartConfig.PartConfig pconfig;
            pconfig = (ReferencePartConfig.PartConfig)((Object)i1.next());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing PartConfig [" + pconfig + "]...");
            }
            cpSelectorMap = (Map)nonces2.get(pconfig);
            rconfig = (ReferencePartConfig)nonces3.get(pconfig);
            if (!pconfig.isTimestamp() && !pconfig.isNonce()) continue;
            dialect = pconfig.getDialect();
            keyword = pconfig.getKeyword();
            parts = (PartList)SignatureGenerator.getNoncePart(doc, null, pconfig, "decryption_mode", selectors, ConfidentialDialectElementSelector.class, cpSelectorMap);
            if (parts == null || parts.getLength() <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, parts.getLength() + " parts found.");
            }
            for (j = 0; j < parts.getLength(); ++j) {
                el = (OMElement)parts.item(j);
                block7: for (RequiredParts rparts2 : requiredParts) {
                    for (k = 0; k < rparts2._parts.length; ++k) {
                        rpart = rparts2._parts[k];
                        if (!DOMUtils.equals(el, rpart._element)) continue;
                        if (pconfig.isTimestamp()) {
                            rpart._requiredTimestamp = pconfig.isTimestamp();
                        }
                        if (!pconfig.isNonce()) continue block7;
                        rpart._requiredNonce = pconfig.isNonce();
                        continue block7;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("preprocess(");
            buf.append("OMDocument, Set, Map, Map)");
            buf.append(" returns Set [").append(requiredParts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return requiredParts;
    }

    private static RequiredPart getRelatedPart(DecryptionResult dresult, DecryptionResult.DecryptedPart dpart, Set<RequiredParts> requiredParts) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getRelatedPart(");
            buf.append("DecryptionResult dresult, ");
            buf.append("DecryptedPart dpart[").append(dpart).append("], ");
            buf.append("Set requiredParts)");
            Tr.entry(tc, buf.toString());
        }
        SoapSecurityException lastException = null;
        RequiredPart rpart = null;
        for (RequiredParts rparts : requiredParts) {
            RequiredPart[] part = rparts._parts;
            for (int j = 0; j < part.length; ++j) {
                if (part[j]._processed) continue;
                SoapSecurityException sse = DecryptedPartChecker.checkBinding(part[j]._rconfig.getBindings(), dresult);
                if (sse == null) {
                    if (!DecryptedPartChecker.hasSameUri(part[j]._element, dpart._object) && !DOMUtils.equals(part[j]._element, dpart._object)) continue;
                    rpart = part[j];
                    break;
                }
                lastException = sse;
            }
            if (rpart == null) continue;
            lastException = null;
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getRelatedPart(");
            buf.append("DecryptionResult, DecryptedPart, Set)");
            buf.append(" returns RequiredPart [").append(rpart).append("]");
            Tr.exit(tc, buf.toString());
        }
        return rpart;
    }

    private static boolean hasSameUri(OMElement rpart, OMElement dpart) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("hasSameUri(");
            buf.append("OMElement rpart[").append(DOMUtils.getDisplayName(rpart)).append("], ");
            buf.append("OMElement dpart[").append(DOMUtils.getDisplayName(dpart)).append("])");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        String ruri = IdUtils.getInstance().getId(rpart);
        String duri = IdUtils.getInstance().getId(dpart);
        if (ruri != null && ruri.length() > 0 && duri != null && duri.length() > 0 && ruri.equals(duri)) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("hasSameUri(OMElement, OMElement)");
            buf.append(" returns boolean [").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    private static SoapSecurityException checkBinding(Set<Object> bindings, DecryptionResult dresult) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkBinding(");
            buf.append("Set bindings, DecryptionResult dresult)");
            Tr.entry(tc, buf.toString());
        }
        Throwable lastException = null;
        boolean ret = bindings.contains(dresult._config);
        if (ret) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of encryption consumer used for decryption was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of encryption consumer used for decryption was NOT found in the bindings.");
            }
            Iterator<Object> i = bindings.iterator();
            while (!ret && i.hasNext()) {
                EncryptionConsumerConfig config2 = (EncryptionConsumerConfig)i.next();
                KeyInfoResult r = dresult._identities.get(config2);
                if (r == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "There is no keyinfo result corresponding to the EncryptionConsumerConfig.");
                    continue;
                }
                Exception e = r.getError();
                if (e == null) {
                    SecurityTokenWrapper tokenWrapper;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The keyinfo result has no exception.");
                    }
                    if ((tokenWrapper = (SecurityTokenWrapper)dresult._kresults.get(r)) == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "There is no token corresponding to the keyinfo result.");
                        continue;
                    }
                    if (tokenWrapper.getError() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The token [" + tokenWrapper + "] has no exception.");
                        }
                        ret = true;
                        break;
                    }
                    lastException = tokenWrapper.getError();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The token [" + tokenWrapper + "] has the exception [" + lastException + "].");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The keyinfo result has the exception [" + e.getMessage() + "].");
                }
                if (e instanceof SoapSecurityException) {
                    lastException = (SoapSecurityException)e;
                    continue;
                }
                lastException = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", new String[]{e.getMessage()}, (Throwable)e);
            }
            if (ret) {
                lastException = null;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkBinding(");
            buf.append("Set, DecryptionResult)");
            buf.append(" returns SoapSecurityException [");
            buf.append(lastException == null ? "null" : lastException.toString());
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return lastException;
    }

    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private OMElement _element;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private Set<SecurityTokenWrapper> _tokenWrappers;
        private boolean _processed;

        RequiredPart(ReferencePartConfig rconfig, ReferencePartConfig.PartConfig pconfig, OMElement element) {
            this._rconfig = rconfig;
            this._pconfig = pconfig;
            this._element = element;
            this._tokenWrappers = new HashSet<SecurityTokenWrapper>();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;
        private String _type;

        RequiredParts(RequiredPart[] parts, String type) {
            this._parts = parts;
            this._type = type;
        }
    }
}

